/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.EventKind;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.WritablePacket;
import com.oracle.svm.jdwp.server.ClassUtils;
import com.oracle.svm.jdwp.server.api.BreakpointInfo;
import com.oracle.svm.jdwp.server.api.VMEventListener;
import com.oracle.svm.jdwp.server.impl.ClassPrepareRequest;
import com.oracle.svm.jdwp.server.impl.DebuggerController;
import com.oracle.svm.jdwp.server.impl.JDWPContext;
import com.oracle.svm.jdwp.server.impl.LineBreakpointInfo;
import com.oracle.svm.jdwp.server.impl.MethodBreakpointInfo;
import com.oracle.svm.jdwp.server.impl.RequestFilter;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import com.oracle.svm.jdwp.server.impl.StepInfo;
import com.oracle.svm.jdwp.server.impl.SteppingInfo;
import com.oracle.svm.jdwp.server.impl.SuspendedInfo;
import com.oracle.svm.jdwp.server.impl.ThreadRef;
import com.oracle.svm.jdwp.server.impl.UnknownLocationException;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class RequestedJDWPEvents {
    private final VMEventListener eventListener;
    private final DebuggerController controller;
    private int lastRequestId = 0;

    RequestedJDWPEvents(DebuggerController controller) {
        this.controller = controller;
        this.eventListener = controller.getEventListener();
    }

    public Packet registerRequest(Packet packet) {
        Packet.Reader input = packet.newDataReader();
        JDWPContext context = this.controller.getContext();
        byte eventKindId = (byte)input.readByte();
        byte suspendPolicy = (byte)input.readByte();
        int modifiers = input.readInt();
        EventKind eventKind = EventKind.of((byte)eventKindId);
        if (eventKind == null) {
            ServerJDWP.LOGGER.log(() -> "Unknown event request ID = " + eventKindId);
            throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
        }
        int requestId = ++this.lastRequestId;
        RequestFilter filter = new RequestFilter(requestId, eventKind);
        ServerJDWP.LOGGER.log(() -> "New event request with ID: " + requestId + " with kind: " + String.valueOf(eventKind) + ", suspendPolicy=" + suspendPolicy + " and modifiers: " + modifiers);
        for (int i = 0; i < modifiers; ++i) {
            byte modKind = (byte)input.readByte();
            ServerJDWP.LOGGER.log(() -> "Handling modKind: " + modKind);
            this.handleModKind(filter, input, eventKind, modKind, context);
        }
        switch (eventKind) {
            case SINGLE_STEP: {
                StepInfo stepInfo = filter.getStepInfo();
                long threadId = stepInfo.threadId();
                this.eventListener.addStepRequest(requestId, threadId, new SteppingInfo(requestId, stepInfo, suspendPolicy, false, false));
                ServerJDWP.BRIDGE.setSteppingFromLocation(threadId, stepInfo.getInterpreterDepth(), stepInfo.getInterpreterSize(), stepInfo.startLocation().getMethodId(), stepInfo.startLocation().getBci(), -2);
                ServerJDWP.BRIDGE.setEventEnabled(threadId, EventKind.SINGLE_STEP.ordinal(), true);
                break;
            }
            case METHOD_ENTRY: 
            case METHOD_EXIT: 
            case METHOD_EXIT_WITH_RETURN_VALUE: {
                this.addMethodBreakRequest(filter, suspendPolicy, context);
                break;
            }
            case BREAKPOINT: {
                List<BreakpointInfo> infos = filter.getBreakpointInfos();
                if (infos == null) {
                    throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_LOCATION);
                }
                for (BreakpointInfo info : infos) {
                    info.addSuspendPolicy(suspendPolicy);
                }
                this.eventListener.addBreakpointRequest(requestId, infos);
                try {
                    context.getBreakpoints().addLines(infos);
                    break;
                }
                catch (UnknownLocationException ex) {
                    throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_LOCATION);
                }
            }
            case EXCEPTION: {
                ServerJDWP.LOGGER.log(() -> "Submitting new exception breakpoint");
                break;
            }
            case CLASS_PREPARE: {
                this.eventListener.addClassPrepareRequest(new ClassPrepareRequest(filter));
                ServerJDWP.LOGGER.log(() -> "Class prepare request received");
                break;
            }
            case FIELD_ACCESS: 
            case FIELD_MODIFICATION: {
                WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
                reply.errorCode(ErrorCode.NOT_IMPLEMENTED);
                return reply;
            }
            case THREAD_START: {
                this.eventListener.addThreadStartedRequestId(requestId, suspendPolicy);
                ServerJDWP.BRIDGE.setThreadRequest(true, true);
                break;
            }
            case THREAD_DEATH: {
                this.eventListener.addThreadDiedRequestId(requestId, suspendPolicy);
                ServerJDWP.BRIDGE.setThreadRequest(false, true);
                break;
            }
            case CLASS_UNLOAD: {
                this.eventListener.addClassUnloadRequestId(requestId);
                break;
            }
            case VM_START: {
                this.eventListener.addVMStartRequest(requestId);
                break;
            }
            case VM_DEATH: {
                this.eventListener.addVMDeathRequest(requestId, suspendPolicy);
                break;
            }
            case MONITOR_CONTENDED_ENTER: 
            case MONITOR_CONTENDED_ENTERED: 
            case MONITOR_WAIT: 
            case MONITOR_WAITED: {
                break;
            }
            default: {
                ServerJDWP.LOGGER.log(() -> "unhandled event kind " + String.valueOf(eventKind));
                WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
                reply.errorCode(ErrorCode.INVALID_EVENT_TYPE);
                return reply;
            }
        }
        this.controller.getEventFilters().addFilter(filter);
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeInt(requestId);
        return reply;
    }

    private void handleModKind(RequestFilter filter, Packet.Reader input, EventKind eventKind, byte modKind, JDWPContext context) {
        switch (modKind) {
            case 1: {
                int count = input.readInt();
                ServerJDWP.LOGGER.log(() -> "adding count limit: " + count + " to filter");
                if (count <= 0) {
                    throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_COUNT);
                }
                filter.addCount(count);
                break;
            }
            case 2: {
                ServerJDWP.LOGGER.log(() -> "unhandled modKind 2");
                throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
            }
            case 3: {
                long threadId = input.readLong();
                filter.addThread(threadId);
                ServerJDWP.LOGGER.log(() -> "limiting to thread ID: " + threadId);
                break;
            }
            case 4: {
                long refTypeId = input.readLong();
                ResolvedJavaType type = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(refTypeId);
                filter.addClassOnly(type);
                ServerJDWP.LOGGER.log(() -> "RefType is: " + String.valueOf(type));
                break;
            }
            case 5: {
                String classPattern = input.readString();
                filter.addClassNameMatch(classPattern);
                ServerJDWP.LOGGER.log(() -> "adding class name match pattern: " + classPattern);
                break;
            }
            case 6: {
                String classPattern = input.readString();
                filter.addClassNameExclude(classPattern);
                ServerJDWP.LOGGER.log(() -> "adding class name exclude pattern: " + classPattern);
                break;
            }
            case 7: {
                byte typeTag = (byte)input.readByte();
                long classId = input.readLong();
                long methodId = input.readLong();
                long bci = input.readLong();
                if (EventKind.BREAKPOINT == eventKind) {
                    LineBreakpointInfo info = new LineBreakpointInfo(filter, context.getBreakpoints(), typeTag, classId, methodId, bci);
                    filter.addBreakpointInfo(info);
                } else {
                    filter.addLocation(classId, methodId, bci);
                }
                ServerJDWP.LOGGER.log(() -> "Adding breakpoint info for location method = " + methodId + ", bci = " + bci);
                break;
            }
            case 8: {
                boolean caught = input.readBoolean();
                boolean unCaught = input.readBoolean();
                ServerJDWP.LOGGER.log(() -> "adding exception filter: caught=" + caught + ", uncaught=" + unCaught);
                break;
            }
            case 9: {
                long refTypeId = input.readLong();
                long fieldId = input.readLong();
                ServerJDWP.LOGGER.log(() -> "limiting to field: fieldId=" + fieldId + ", refTypeId=" + refTypeId);
                throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
            }
            case 10: {
                SuspendedInfo suspendedInfo;
                long threadId = input.readLong();
                int size = input.readInt();
                int depth = input.readInt();
                long startMethodId = 0L;
                int startBci = -1;
                ThreadRef threadRef = context.getThreadRefIfExists(threadId);
                SuspendedInfo suspendedInfo2 = suspendedInfo = threadRef != null ? threadRef.getSuspendedInfo() : null;
                if (suspendedInfo != null) {
                    startMethodId = suspendedInfo.methodId();
                    startBci = (int)suspendedInfo.bci();
                }
                StepInfo.Location startLocation = new StepInfo.Location(startMethodId, startBci, size == 1);
                StepInfo stepInfo = new StepInfo(filter, size, depth, threadId, startLocation);
                filter.setStepInfo(stepInfo);
                ServerJDWP.LOGGER.log(() -> "Step command: size= " + size + ", depth=" + depth);
                break;
            }
            case 11: {
                long thisId = input.readLong();
                ServerJDWP.LOGGER.log(() -> "adding instance filter for object ID: " + thisId);
                filter.addThis(thisId);
                break;
            }
            case 12: {
                ServerJDWP.LOGGER.log(() -> "unhandled modKind 12");
                throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
            }
            case 13: {
                ServerJDWP.LOGGER.log(() -> "Adding filter for platform threads");
                filter.addPlatformThreadsOnly();
                break;
            }
            default: {
                ServerJDWP.LOGGER.log(() -> "unhandled modKind " + modKind);
            }
        }
    }

    private void addMethodBreakRequest(RequestFilter filter, byte suspendPolicy, JDWPContext context) {
        ArrayList<BreakpointInfo> infos = new ArrayList<BreakpointInfo>();
        for (ResolvedJavaType type : ClassUtils.UNIVERSE.getTypes()) {
            if (!filter.matchesType(type)) continue;
            int typeRefIndex = ClassUtils.UNIVERSE.getTypeIndexFor(type).orElseThrow(IllegalArgumentException::new);
            long classId = ServerJDWP.BRIDGE.typeRefIndexToId(typeRefIndex);
            MethodBreakpointInfo methodInfo = new MethodBreakpointInfo(filter, context.getBreakpoints(), classId);
            methodInfo.addSuspendPolicy(suspendPolicy);
            infos.add(methodInfo);
        }
        context.getBreakpoints().addMethods(infos);
        this.eventListener.addBreakpointRequest(filter.getRequestId(), infos);
    }

    public Packet clearRequest(Packet packet) {
        Packet.Reader input = packet.newDataReader();
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        byte eventKindId = (byte)input.readByte();
        int requestId = input.readInt();
        EventKind eventKind = EventKind.of((byte)eventKindId);
        if (eventKind == null) {
            ServerJDWP.LOGGER.log(() -> "Unknown event request ID = " + eventKindId);
            throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
        }
        RequestFilter requestFilter = this.controller.getEventFilters().getRequestFilter(requestId);
        if (requestFilter != null) {
            EventKind kind = requestFilter.getEventKind();
            if (kind == eventKind) {
                switch (eventKind) {
                    case SINGLE_STEP: {
                        ServerJDWP.LOGGER.log(() -> "Clearing step command: " + requestId);
                        this.eventListener.removeStepRequest(requestId);
                        break;
                    }
                    case METHOD_ENTRY: 
                    case METHOD_EXIT: 
                    case METHOD_EXIT_WITH_RETURN_VALUE: 
                    case BREAKPOINT: 
                    case EXCEPTION: {
                        this.eventListener.removeBreakpointRequest(requestFilter.getRequestId());
                        break;
                    }
                    case FIELD_ACCESS: 
                    case FIELD_MODIFICATION: 
                    case MONITOR_CONTENDED_ENTER: 
                    case MONITOR_CONTENDED_ENTERED: 
                    case MONITOR_WAIT: 
                    case MONITOR_WAITED: {
                        break;
                    }
                    case CLASS_PREPARE: {
                        this.eventListener.removeClassPrepareRequest(requestFilter.getRequestId());
                        break;
                    }
                    case THREAD_START: {
                        this.eventListener.removeThreadStartedRequestId();
                        break;
                    }
                    case THREAD_DEATH: {
                        this.eventListener.removeThreadDiedRequestId();
                        break;
                    }
                    case CLASS_UNLOAD: {
                        this.eventListener.addClassUnloadRequestId(packet.id());
                        break;
                    }
                    default: {
                        ServerJDWP.LOGGER.log(() -> "unhandled event clear kind " + String.valueOf(eventKind));
                        break;
                    }
                }
            } else {
                reply.errorCode(ErrorCode.INVALID_EVENT_TYPE);
            }
        } else {
            reply.errorCode(ErrorCode.INVALID_EVENT_TYPE);
        }
        return reply;
    }

    public Packet clearAllBreakpoints(Packet packet) {
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        this.eventListener.clearAllBreakpointRequests();
        this.controller.clearBreakpoints();
        return reply;
    }
}

