/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.options.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jdk.graal.compiler.processor.AbstractProcessor;

@SupportedAnnotationTypes(value={"jdk.graal.compiler.options.Option"})
public class OptionProcessor
extends AbstractProcessor {
    private static final String OPTION_CLASS_NAME = "jdk.graal.compiler.options.Option";
    private static final String OPTION_KEY_CLASS_NAME = "jdk.graal.compiler.options.OptionKey";
    private static final String OPTION_TYPE_CLASS_NAME = "jdk.graal.compiler.options.OptionType";
    private static final String OPTION_STABILITY_CLASS_NAME = "jdk.graal.compiler.options.OptionStability";
    private static final String OPTION_DESCRIPTOR_CLASS_NAME = "jdk.graal.compiler.options.OptionDescriptor";
    private static final String OPTION_DESCRIPTORS_CLASS_NAME = "jdk.graal.compiler.options.OptionDescriptors";
    private static final String OPTIONS_CONTAINER_CLASS_NAME = "jdk.graal.compiler.options.OptionsContainer";
    private final Set<Element> processed = new HashSet<Element>();
    private TypeMirror optionTypeMirror;
    private TypeMirror optionKeyTypeMirror;

    private void processElement(Element element, OptionsDeclarer optionsDeclarer) {
        String stability;
        String briefHelp;
        List<String> helpLines;
        Object declaringClass;
        String optionType;
        String optionName;
        String fieldName;
        AnnotationMirror annotation;
        block40: {
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field must be static", element);
                return;
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field cannot be private", element);
                return;
            }
            annotation = this.getAnnotation(element, this.optionTypeMirror);
            assert (annotation != null);
            assert (element instanceof VariableElement);
            assert (element.getKind() == ElementKind.FIELD);
            VariableElement field = (VariableElement)element;
            fieldName = field.getSimpleName().toString();
            Types types = this.processingEnv.getTypeUtils();
            TypeMirror fieldType = field.asType();
            if (fieldType.getKind() != TypeKind.DECLARED) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field must be of type jdk.graal.compiler.options.OptionKey", element);
                return;
            }
            DeclaredType declaredFieldType = (DeclaredType)fieldType;
            if (!types.isSubtype(fieldType, types.erasure(this.optionKeyTypeMirror))) {
                String msg = String.format("Option field type %s is not a subclass of %s", fieldType, this.optionKeyTypeMirror);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
                return;
            }
            if (!field.getModifiers().contains((Object)Modifier.STATIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field must be static", element);
                return;
            }
            if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field cannot be private", element);
                return;
            }
            optionName = OptionProcessor.getAnnotationValue(annotation, "name", String.class);
            if (optionName.isEmpty()) {
                optionName = fieldName;
            }
            if (!Character.isUpperCase(optionName.charAt(0))) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option name must start with an upper case letter", element);
                return;
            }
            DeclaredType declaredOptionKeyType = declaredFieldType;
            while (!types.isSameType(types.erasure(declaredOptionKeyType), types.erasure(this.optionKeyTypeMirror))) {
                List<? extends TypeMirror> directSupertypes = types.directSupertypes(declaredFieldType);
                assert (!directSupertypes.isEmpty());
                declaredOptionKeyType = (DeclaredType)directSupertypes.getFirst();
            }
            assert (!declaredOptionKeyType.getTypeArguments().isEmpty());
            optionType = declaredOptionKeyType.getTypeArguments().getFirst().toString();
            if (optionType.startsWith("java.lang.")) {
                optionType = optionType.substring("java.lang.".length());
            }
            if (optionType.contains("<")) {
                optionType = optionType.substring(0, optionType.indexOf("<"));
            }
            declaringClass = "";
            String separator = "";
            Set<Element> originatingElements = optionsDeclarer.originatingElements;
            originatingElements.add(field);
            PackageElement enclosingPackage = null;
            for (Element enclosing = element.getEnclosingElement(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
                if (enclosing.getKind() == ElementKind.CLASS || enclosing.getKind() == ElementKind.INTERFACE || enclosing.getKind() == ElementKind.ENUM) {
                    if (enclosing.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        String msg = String.format("Option field cannot be declared in a private %s %s", enclosing.getKind().name().toLowerCase(), enclosing);
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
                        return;
                    }
                } else {
                    if (enclosing.getKind() == ElementKind.PACKAGE) {
                        enclosingPackage = (PackageElement)enclosing;
                        break;
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unexpected enclosing element kind: " + String.valueOf((Object)enclosing.getKind()), element);
                    return;
                }
                originatingElements.add(enclosing);
                declaringClass = String.valueOf(enclosing.getSimpleName()) + separator + (String)declaringClass;
                separator = ".";
            }
            if (enclosingPackage == null || enclosingPackage.isUnnamed()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field cannot be declared in the unnamed package", element);
                return;
            }
            String help = OptionProcessor.getAnnotationValue(annotation, "help", String.class);
            if (help.startsWith("file:")) {
                String path = help.substring("file:".length());
                Filer filer = this.processingEnv.getFiler();
                try {
                    FileObject file;
                    try {
                        file = filer.getResource(StandardLocation.SOURCE_PATH, enclosingPackage.getQualifiedName(), path);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        file = filer.getResource(StandardLocation.CLASS_OUTPUT, enclosingPackage.getQualifiedName(), path);
                    }
                    try (InputStream in = file.openInputStream();){
                        help = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                        helpLines = List.of(help.split("\\r?\\n"));
                        break block40;
                    }
                }
                catch (IOException e) {
                    String msg = String.format("Error reading %s containing the help text for option field: %s", path, e);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
                    return;
                }
            }
            helpLines = List.of(help.split("\\n"));
        }
        if ((briefHelp = helpLines.getFirst()).isEmpty()) {
            if (helpLines.size() > 1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "First line of multi-line help text cannot be empty", element);
                return;
            }
        } else {
            if (helpLines.size() > 1 && briefHelp.charAt(briefHelp.length() - 1) != '.' && !helpLines.get(1).isBlank()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "First line of multi-line help text must end with a period or be followed by a blank line", element);
                return;
            }
            char firstChar = briefHelp.charAt(0);
            if (!Character.isUpperCase(firstChar)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option help text must start with an upper case letter", element);
                return;
            }
        }
        if ((stability = OptionProcessor.getAnnotationValue(annotation, "stability", VariableElement.class).getSimpleName().toString()).equals("STABLE") && briefHelp.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "A stable option must have non-empty help text", element);
            return;
        }
        String optionTypeName = OptionProcessor.getAnnotationValue(annotation, "type", VariableElement.class).getSimpleName().toString();
        if (!optionTypeName.equals("Debug") && briefHelp.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Non debug options must always have a option help text " + optionName);
        }
        boolean deprecated = OptionProcessor.getAnnotationValue(annotation, "deprecated", Boolean.class);
        String deprecationMessage = OptionProcessor.getAnnotationValue(annotation, "deprecationMessage", String.class);
        OptionInfo info = new OptionInfo(optionName, optionTypeName, String.join((CharSequence)"\n", helpLines), optionType, (String)declaringClass, fieldName, stability, deprecated, deprecationMessage);
        optionsDeclarer.options.add(info);
    }

    private static String literal(String help) {
        String quoted = help.replace("\\", "\\\\").replace("\"", "\\\"");
        if (help.indexOf(10) != -1) {
            return "\"\"\"\n" + quoted + "\"\"\"";
        }
        return "\"" + quoted + "\"";
    }

    static void createOptionsDescriptorsFile(ProcessingEnvironment processingEnv, OptionsDeclarer optionsDeclarer) {
        Element[] originatingElements = optionsDeclarer.originatingElements.toArray(new Element[0]);
        String optionsDescriptorsClassName = optionsDeclarer.getOptionDescriptorsClassName();
        Filer filer = processingEnv.getFiler();
        try (PrintWriter out = OptionProcessor.createSourceFile(optionsDeclarer.packageName, optionsDescriptorsClassName, filer, originatingElements);){
            out.println("// CheckStyle: stop header check");
            out.println("// CheckStyle: stop line length check");
            out.println("// GENERATED CONTENT - DO NOT EDIT");
            out.println("// Source: " + optionsDeclarer.classNameWithoutPackage + ".java");
            out.println("package " + optionsDeclarer.packageName + ";");
            out.println("");
            out.println("import java.util.*;");
            out.println("import " + OptionProcessor.getPackageName(OPTION_DESCRIPTORS_CLASS_NAME) + ".*;");
            out.println("import jdk.graal.compiler.options.OptionType;");
            out.println("import jdk.graal.compiler.options.OptionStability;");
            out.println("");
            String implementsClause = " implements " + OptionProcessor.getSimpleName(OPTION_DESCRIPTORS_CLASS_NAME);
            out.println("public class " + optionsDescriptorsClassName + implementsClause + " {");
            String desc = OptionProcessor.getSimpleName(OPTION_DESCRIPTOR_CLASS_NAME);
            out.println("    private OptionsContainer cachedContainer;");
            out.println("    @Override");
            out.println("    public OptionsContainer getContainer() {");
            out.println("        if (cachedContainer == null) {");
            if (optionsDeclarer.implementsOptionsContainer) {
                out.printf("            cachedContainer = new %s();%n", optionsDeclarer.classNameWithoutPackage);
            } else {
                out.printf("            cachedContainer = new OptionsContainer.Default(%s.class);%n", optionsDeclarer.classNameWithoutPackage);
            }
            out.println("        }");
            out.println("        return cachedContainer;");
            out.println("    }");
            out.println();
            Collections.sort(optionsDeclarer.options);
            out.println("    @Override");
            out.println("    public OptionDescriptor get(String value) {");
            out.println("        switch (getContainer().unprefixed(value)) {");
            out.println("        // CheckStyle: stop line length check");
            for (OptionInfo option : optionsDeclarer.options) {
                String name = option.name;
                String optionField = option.declaringClass + "." + option.field;
                out.println("        case \"" + name + "\": {");
                String optionType = option.optionType;
                String type = option.type;
                String help = option.help;
                String fieldName = option.field;
                String stability = option.stability;
                boolean deprecated = option.deprecated;
                String deprecationMessage = option.deprecationMessage;
                out.printf("            return " + desc + ".create(\n", new Object[0]);
                out.printf("                /*name*/ \"%s\",\n", name);
                out.printf("                /*optionType*/ %s.%s,\n", OptionProcessor.getSimpleName(OPTION_TYPE_CLASS_NAME), optionType);
                out.printf("                /*optionValueType*/ %s.class,\n", type);
                out.printf("                /*help*/ %s,\n", OptionProcessor.literal(help));
                out.printf("                /*container*/ getContainer(),\n", new Object[0]);
                out.printf("                /*option*/ %s,\n", optionField);
                out.printf("                /*fieldName*/ \"%s\",\n", fieldName);
                out.printf("                /*stability*/ %s.%s,\n", OptionProcessor.getSimpleName(OPTION_STABILITY_CLASS_NAME), stability);
                out.printf("                /*deprecated*/ %b,\n", deprecated);
                out.printf("                /*deprecationMessage*/ \"%s\");\n", deprecationMessage);
                out.println("        }");
            }
            out.println("        // CheckStyle: resume line length check");
            out.println("        }");
            out.println("        return null;");
            out.println("    }");
            out.println();
            out.println("    @Override");
            out.println("    public Iterator<" + desc + "> iterator() {");
            out.println("        return new Iterator<" + (processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_8) <= 0 ? desc : "") + ">() {");
            out.println("            int i = 0;");
            out.println("            @Override");
            out.println("            public boolean hasNext() {");
            out.println("                return i < " + optionsDeclarer.options.size() + ";");
            out.println("            }");
            out.println("            @Override");
            out.println("            public OptionDescriptor next() {");
            out.println("                switch (i++) {");
            for (int i = 0; i < optionsDeclarer.options.size(); ++i) {
                OptionInfo option;
                option = optionsDeclarer.options.get(i);
                out.println("                    case " + i + ": return get(\"" + option.name + "\");");
            }
            out.println("                }");
            out.println("                throw new NoSuchElementException();");
            out.println("            }");
            out.println("        };");
            out.println("    }");
            out.println("}");
        }
    }

    @Override
    public boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        TypeElement optionTypeElement = this.getTypeElement(OPTION_CLASS_NAME);
        TypeElement optionsContainerTypeElement = this.getTypeElement(OPTIONS_CONTAINER_CLASS_NAME);
        this.optionTypeMirror = optionTypeElement.asType();
        this.optionKeyTypeMirror = this.getTypeElement(OPTION_KEY_CLASS_NAME).asType();
        boolean ok = true;
        HashMap<Element, OptionsDeclarer> map = new HashMap<Element, OptionsDeclarer>();
        for (Element element : roundEnv.getElementsAnnotatedWith(optionTypeElement)) {
            if (this.processed.contains(element)) continue;
            this.processed.add(element);
            Element enclosingElement = element.getEnclosingElement();
            OptionsDeclarer optionsDeclarer = (OptionsDeclarer)map.get(enclosingElement);
            if (optionsDeclarer == null) {
                boolean implementsOptionsContainer = this.processingEnv.getTypeUtils().isAssignable(enclosingElement.asType(), optionsContainerTypeElement.asType());
                optionsDeclarer = OptionsDeclarer.create(this.processingEnv, enclosingElement, implementsOptionsContainer);
                map.put(enclosingElement, optionsDeclarer);
            }
            if (!element.getEnclosingElement().getSimpleName().toString().endsWith("Options")) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option declaring classes must have a name that ends with 'Options'", element.getEnclosingElement());
            }
            if (optionsDeclarer != OptionsDeclarer.ERROR) {
                this.processElement(element, optionsDeclarer);
                continue;
            }
            ok = false;
        }
        if (ok) {
            for (OptionsDeclarer optionsDeclarer : map.values()) {
                OptionProcessor.createOptionsDescriptorsFile(this.processingEnv, optionsDeclarer);
            }
        }
        return true;
    }

    record OptionsDeclarer(Element element, String classNameWithoutPackage, String packageName, boolean implementsOptionsContainer, List<OptionInfo> options, Set<Element> originatingElements) {
        static OptionsDeclarer ERROR = new OptionsDeclarer(null, null, null, false, null, null);

        static OptionsDeclarer create(ProcessingEnvironment env, Element optionsDeclarerElement, boolean implementsOptionsContainer) {
            Element e = optionsDeclarerElement;
            ArrayList<String> simpleNames = new ArrayList<String>();
            while (e.getKind() != ElementKind.PACKAGE) {
                if (!e.getKind().isDeclaredType()) {
                    String message = String.format("Options enclosing element %s is not a declared type (%s)", new Object[]{e, e.getKind()});
                    env.getMessager().printMessage(Diagnostic.Kind.ERROR, message, optionsDeclarerElement);
                    return ERROR;
                }
                String simpleName = e.getSimpleName().toString();
                if (simpleName.indexOf(95) != -1) {
                    String message = String.format("Options enclosing element %s cannot have '_' in its name", e);
                    env.getMessager().printMessage(Diagnostic.Kind.ERROR, message, optionsDeclarerElement);
                    return ERROR;
                }
                simpleNames.add(simpleName);
                e = e.getEnclosingElement();
            }
            String className = String.join((CharSequence)".", simpleNames.reversed());
            String packageName = ((PackageElement)e).getQualifiedName().toString();
            return new OptionsDeclarer(optionsDeclarerElement, className, packageName, implementsOptionsContainer, new ArrayList<OptionInfo>(), new HashSet<Element>());
        }

        String getOptionDescriptorsClassName() {
            return this.classNameWithoutPackage.replace('.', '_') + "_" + AbstractProcessor.getSimpleName(OptionProcessor.OPTION_DESCRIPTORS_CLASS_NAME);
        }
    }

    record OptionInfo(String name, String optionType, String help, String type, String declaringClass, String field, String stability, boolean deprecated, String deprecationMessage) implements Comparable<OptionInfo>
    {
        @Override
        public int compareTo(OptionInfo other) {
            return this.name.compareTo(other.name);
        }

        @Override
        public String toString() {
            return this.declaringClass + "." + this.field;
        }
    }
}

