/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.processor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class APHotSpotSignature {
    private final List<String> arguments = new ArrayList<String>();
    private final String returnType;
    private final String originalString;
    private TypeMirror[] argumentTypes;
    private TypeMirror returnTypeCache;

    APHotSpotSignature(String signature) {
        assert (signature.length() > 0);
        this.originalString = signature;
        if (signature.charAt(0) == '(') {
            int nextCur;
            int cur = 1;
            while (cur < signature.length() && signature.charAt(cur) != ')') {
                nextCur = APHotSpotSignature.parseSignature(signature, cur);
                this.arguments.add(signature.substring(cur, nextCur));
                cur = nextCur;
            }
            nextCur = APHotSpotSignature.parseSignature(signature, ++cur);
            this.returnType = signature.substring(cur, nextCur);
            if (nextCur != signature.length()) {
                throw new RuntimeException("Invalid trailing characters.");
            }
        } else {
            this.returnType = null;
        }
    }

    private static int parseSignature(String signature, int start) {
        char first;
        int cur = start;
        while ((first = signature.charAt(cur++)) == '[') {
        }
        switch (first) {
            case 'L': {
                while (signature.charAt(cur) != ';') {
                    ++cur;
                }
                ++cur;
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                break;
            }
            default: {
                throw new RuntimeException("Invalid character at index " + cur + " in signature: " + signature);
            }
        }
        return cur;
    }

    public int getParameterCount(boolean withReceiver) {
        return this.arguments.size() + (withReceiver ? 1 : 0);
    }

    public TypeMirror getParameterType(ProcessingEnvironment env, int index) {
        if (this.argumentTypes == null) {
            this.argumentTypes = new TypeMirror[this.arguments.size()];
        }
        TypeMirror type = this.argumentTypes[index];
        if (this.arguments.get(index) == null) {
            throw new RuntimeException(String.format("Invalid argument at index %s.", index));
        }
        if (type == null) {
            this.argumentTypes[index] = APHotSpotSignature.lookupType(env, this.arguments.get(index));
        }
        return this.argumentTypes[index];
    }

    private static TypeMirror lookupType(ProcessingEnvironment env, String binaryName) {
        String canonicalName;
        if (binaryName.length() == 1) {
            TypeKind kind = APHotSpotSignature.fromPrimitiveOrVoidTypeChar(binaryName.charAt(0));
            if (kind.isPrimitive()) {
                return env.getTypeUtils().getPrimitiveType(kind);
            }
            if (kind == TypeKind.VOID) {
                return env.getTypeUtils().getNoType(kind);
            }
        }
        if ((canonicalName = binaryName).startsWith("L") && canonicalName.endsWith(";")) {
            canonicalName = canonicalName.substring(1, canonicalName.length() - 1);
        }
        env.getMessager().printMessage(Diagnostic.Kind.ERROR, canonicalName);
        int arrayDims = 0;
        while (canonicalName.startsWith("[")) {
            canonicalName = canonicalName.substring(1, canonicalName.length());
            ++arrayDims;
        }
        canonicalName = canonicalName.replaceAll("/", ".");
        TypeElement typeElement = env.getElementUtils().getTypeElement(canonicalName);
        if (typeElement == null) {
            throw new RuntimeException(String.format("Type with name %s not found.", canonicalName));
        }
        TypeMirror mirror = typeElement.asType();
        for (int i = 0; i < arrayDims; ++i) {
            mirror = env.getTypeUtils().getArrayType(mirror);
        }
        return mirror;
    }

    public static TypeKind fromPrimitiveOrVoidTypeChar(char ch) {
        switch (ch) {
            case 'Z': {
                return TypeKind.BOOLEAN;
            }
            case 'C': {
                return TypeKind.CHAR;
            }
            case 'F': {
                return TypeKind.FLOAT;
            }
            case 'D': {
                return TypeKind.DOUBLE;
            }
            case 'B': {
                return TypeKind.BYTE;
            }
            case 'S': {
                return TypeKind.SHORT;
            }
            case 'I': {
                return TypeKind.INT;
            }
            case 'J': {
                return TypeKind.LONG;
            }
            case 'V': {
                return TypeKind.VOID;
            }
        }
        throw new IllegalArgumentException("unknown primitive or void type character: " + ch);
    }

    public TypeMirror getReturnType(ProcessingEnvironment env) {
        if (this.returnTypeCache == null) {
            if (this.returnType == null) {
                throw new RuntimeException("Invalid return type.");
            }
            this.returnTypeCache = APHotSpotSignature.lookupType(env, this.returnType);
        }
        return this.returnTypeCache;
    }

    public String toString() {
        return "Signature<" + this.originalString + ">";
    }
}

