/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.processor;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import jdk.graal.compiler.processor.AbstractProcessor;
import jdk.graal.compiler.replacements.processor.AnnotationHandler;
import jdk.graal.compiler.replacements.processor.GeneratedNodeIntrinsicPlugin;
import jdk.graal.compiler.replacements.processor.PluginGenerator;

public final class NodeIntrinsicHandler
extends AnnotationHandler {
    static final String CONSTANT_NODE_PARAMETER_CLASS_NAME = "jdk.graal.compiler.graph.Node.ConstantNodeParameter";
    static final String MARKER_TYPE_CLASS_NAME = "jdk.graal.compiler.nodeinfo.StructuralInput.MarkerType";
    static final String GRAPH_BUILDER_CONTEXT_CLASS_NAME = "jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext";
    static final String STRUCTURAL_INPUT_CLASS_NAME = "jdk.graal.compiler.nodeinfo.StructuralInput";
    static final String RESOLVED_JAVA_TYPE_CLASS_NAME = "jdk.vm.ci.meta.ResolvedJavaType";
    static final String VALUE_NODE_CLASS_NAME = "jdk.graal.compiler.nodes.ValueNode";
    static final String NODE_CLASS_NAME = "jdk.graal.compiler.graph.Node";
    static final String NODE_INFO_CLASS_NAME = "jdk.graal.compiler.nodeinfo.NodeInfo";
    static final String NODE_INTRINSIC_CLASS_NAME = "jdk.graal.compiler.graph.Node.NodeIntrinsic";
    static final String NODE_INTRINSIC_FACTORY_CLASS_NAME = "jdk.graal.compiler.graph.Node.NodeIntrinsicFactory";
    static final String INJECTED_NODE_PARAMETER_CLASS_NAME = "jdk.graal.compiler.graph.Node.InjectedNodeParameter";
    static final String FOREIGN_CALL_DESCRIPTOR_CLASS_NAME = "jdk.graal.compiler.core.common.spi.ForeignCallDescriptor";

    public NodeIntrinsicHandler(AbstractProcessor processor) {
        super(processor, NODE_INTRINSIC_CLASS_NAME);
    }

    @Override
    public void process(Element element, AnnotationMirror annotation, PluginGenerator generator) {
        boolean isFactory;
        TypeMirror returnType;
        if (element.getKind() != ElementKind.METHOD) {
            assert (false) : "Element is guaranteed to be a method.";
            return;
        }
        ExecutableElement intrinsicMethod = (ExecutableElement)element;
        Messager messager = this.processor.env().getMessager();
        if (!intrinsicMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must be static.", AbstractProcessor.getSimpleName(NODE_INTRINSIC_CLASS_NAME)), element, annotation);
        }
        if (!intrinsicMethod.getModifiers().contains((Object)Modifier.NATIVE)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must be native.", AbstractProcessor.getSimpleName(NODE_INTRINSIC_CLASS_NAME)), element, annotation);
        }
        TypeMirror nodeClassMirror = AbstractProcessor.getAnnotationValue(annotation, "value", TypeMirror.class);
        TypeElement nodeClass = this.processor.asTypeElement(nodeClassMirror);
        if (this.processor.env().getTypeUtils().isSameType(nodeClassMirror, annotation.getAnnotationType())) {
            Element enclosingElement;
            for (enclosingElement = intrinsicMethod.getEnclosingElement(); enclosingElement != null && enclosingElement.getKind() != ElementKind.CLASS; enclosingElement = enclosingElement.getEnclosingElement()) {
            }
            if (enclosingElement != null) {
                nodeClass = (TypeElement)enclosingElement;
            } else {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Cannot find a class enclosing @%s method.", AbstractProcessor.getSimpleName(NODE_INTRINSIC_CLASS_NAME)), element, annotation);
            }
        }
        if ((returnType = intrinsicMethod.getReturnType()) instanceof TypeVariable) {
            messager.printMessage(Diagnostic.Kind.ERROR, "@NodeIntrinsic cannot have a generic return type.", element, annotation);
        }
        boolean bl = isFactory = this.processor.getAnnotation(nodeClass, this.processor.getType(NODE_INTRINSIC_FACTORY_CLASS_NAME)) != null;
        if (returnType.getKind() == TypeKind.VOID) {
            for (VariableElement variableElement : intrinsicMethod.getParameters()) {
                if (this.processor.getAnnotation(variableElement, this.processor.getType(INJECTED_NODE_PARAMETER_CLASS_NAME)) == null) continue;
                messager.printMessage(Diagnostic.Kind.ERROR, "@NodeIntrinsic with an injected Stamp parameter cannot have a void return type.", element, annotation);
                break;
            }
        }
        Formatter msg = new Formatter();
        List<ExecutableElement> list = NodeIntrinsicHandler.findIntrinsifyFactoryMethods(nodeClass);
        if (list.size() > 0) {
            boolean hadError = false;
            if (isFactory) {
                for (ExecutableElement candidate : list) {
                    String error = this.checkIntrinsifyFactorySignature(candidate);
                    if (error == null) continue;
                    messager.printMessage(Diagnostic.Kind.ERROR, msg.format("intrinsify method has invalid signature: %s%n%s", error, candidate).toString(), candidate);
                    hadError = true;
                }
            } else {
                for (ExecutableElement candidate : list) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Found intrinsify methods in %s which is not a NodeIntrinsicFactory", nodeClass), candidate);
                    hadError = true;
                }
            }
            if (hadError) {
                return;
            }
        }
        TypeMirror[] constructorSignature = this.constructorSignature(intrinsicMethod);
        HashMap<ExecutableElement, String> nonMatches = new HashMap<ExecutableElement, String>();
        if (isFactory) {
            List<ExecutableElement> candidates = this.findIntrinsifyFactoryMethods(list, constructorSignature, nonMatches);
            if (NodeIntrinsicHandler.checkTooManyElements(annotation, intrinsicMethod, messager, nodeClass, "factories", candidates, msg)) {
                return;
            }
            if (candidates.size() == 1) {
                generator.addPlugin(new GeneratedNodeIntrinsicPlugin.CustomFactoryPlugin(intrinsicMethod, candidates.get(0), constructorSignature));
                return;
            }
        } else {
            List<ExecutableElement> constructors;
            if (nodeClass.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Cannot make a node intrinsic for abstract class %s.", nodeClass.getSimpleName()), element, annotation);
                return;
            }
            if (!this.isNodeType(nodeClass)) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s is not a subclass of %s.", nodeClass.getSimpleName(), this.processor.getType(NODE_CLASS_NAME)), element, annotation);
                return;
            }
            if (this.processor.env().getTypeUtils().isAssignable(returnType, this.processor.getType(STRUCTURAL_INPUT_CLASS_NAME))) {
                this.checkInputType(nodeClass, returnType, element, annotation);
            }
            if (NodeIntrinsicHandler.checkTooManyElements(annotation, intrinsicMethod, messager, nodeClass, "constructors", constructors = this.findConstructors(nodeClass, constructorSignature, nonMatches), msg)) {
                return;
            }
            if (constructors.size() == 1) {
                generator.addPlugin(new GeneratedNodeIntrinsicPlugin.ConstructorPlugin(intrinsicMethod, constructors.get(0), constructorSignature));
                return;
            }
        }
        String label = isFactory ? "factories" : "constructors";
        msg.format("Could not find any %s in %s matching node intrinsic", label, nodeClass);
        if (!nonMatches.isEmpty()) {
            msg.format("%nThese %s failed to match:", label);
            for (Map.Entry e : nonMatches.entrySet()) {
                msg.format("%n  %s: %s", e.getKey(), e.getValue());
            }
        }
        messager.printMessage(Diagnostic.Kind.ERROR, msg.toString(), intrinsicMethod, annotation);
    }

    private static boolean checkTooManyElements(AnnotationMirror annotation, ExecutableElement intrinsicMethod, Messager messager, TypeElement nodeClass, String kind, List<ExecutableElement> elements, Formatter msg) {
        if (elements.size() > 1) {
            msg.format("Found more than one %s in %s matching node intrinsic:", kind, nodeClass);
            for (ExecutableElement candidate : elements) {
                msg.format("%n  %s", candidate);
            }
            messager.printMessage(Diagnostic.Kind.ERROR, msg.toString(), intrinsicMethod, annotation);
            return true;
        }
        return false;
    }

    private void checkInputType(TypeElement nodeClass, TypeMirror returnType, Element element, AnnotationMirror annotation) {
        String inputType = this.getInputType(returnType, element, annotation);
        if (!inputType.equals("Value")) {
            boolean allowed = false;
            List<VariableElement> allowedTypes = AbstractProcessor.getAnnotationValueList(this.processor.getAnnotation(nodeClass, this.processor.getType(NODE_INFO_CLASS_NAME)), "allowedUsageTypes", VariableElement.class);
            for (VariableElement allowedType : allowedTypes) {
                if (!allowedType.getSimpleName().contentEquals(inputType)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                this.processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("@NodeIntrinsic returns input type %s, but only %s is allowed.", inputType, allowedTypes), element, annotation);
            }
        }
    }

    private String getInputType(TypeMirror type, Element element, AnnotationMirror annotation) {
        TypeElement current = this.processor.asTypeElement(type);
        while (current != null) {
            AnnotationMirror markerType = this.processor.getAnnotation(current, this.processor.getType(MARKER_TYPE_CLASS_NAME));
            if (markerType != null) {
                return AbstractProcessor.getAnnotationValue(markerType, "value", VariableElement.class).getSimpleName().toString();
            }
            current = this.processor.asTypeElement(current.getSuperclass());
        }
        this.processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("The class %s is a subclass of StructuralInput, but isn't annotated with @MarkerType. %s", type, element.getAnnotationMirrors()), element, annotation);
        return "Value";
    }

    private boolean isNodeType(TypeElement nodeClass) {
        return this.processor.env().getTypeUtils().isSubtype(nodeClass.asType(), this.processor.getType(NODE_CLASS_NAME));
    }

    private TypeMirror[] constructorSignature(ExecutableElement method) {
        TypeMirror[] parameters = new TypeMirror[method.getParameters().size()];
        for (int i = 0; i < method.getParameters().size(); ++i) {
            VariableElement parameter = method.getParameters().get(i);
            if (this.processor.getAnnotation(parameter, this.processor.getType(CONSTANT_NODE_PARAMETER_CLASS_NAME)) == null) {
                parameters[i] = this.processor.getType(VALUE_NODE_CLASS_NAME);
                continue;
            }
            TypeMirror type = parameter.asType();
            if (this.isTypeCompatible(type, this.processor.getType("java.lang.Class"))) {
                type = this.processor.getType(RESOLVED_JAVA_TYPE_CLASS_NAME);
            }
            parameters[i] = type;
        }
        return parameters;
    }

    private List<ExecutableElement> findConstructors(TypeElement nodeClass, TypeMirror[] signature, Map<ExecutableElement, String> nonMatches) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(nodeClass.getEnclosedElements());
        ArrayList<ExecutableElement> found = new ArrayList<ExecutableElement>(constructors.size());
        for (ExecutableElement constructor : constructors) {
            if (!this.matchSignature(0, constructor, signature, nonMatches)) continue;
            found.add(constructor);
        }
        return found;
    }

    private String checkIntrinsifyFactorySignature(ExecutableElement method) {
        if (method.getParameters().size() < 1) {
            return "Too few arguments";
        }
        VariableElement firstArg = method.getParameters().get(0);
        if (!this.isTypeCompatible(firstArg.asType(), this.processor.getType(GRAPH_BUILDER_CONTEXT_CLASS_NAME))) {
            return "First argument isn't of type GraphBuilderContext";
        }
        if (method.getReturnType().getKind() != TypeKind.BOOLEAN) {
            return "Doesn't return boolean";
        }
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            return "Method is non-static";
        }
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "Method is non-public";
        }
        return null;
    }

    private static List<ExecutableElement> findIntrinsifyFactoryMethods(TypeElement nodeClass) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(nodeClass.getEnclosedElements());
        ArrayList<ExecutableElement> found = new ArrayList<ExecutableElement>(1);
        for (ExecutableElement method : methods) {
            if (!method.getSimpleName().toString().equals("intrinsify")) continue;
            found.add(method);
        }
        return found;
    }

    private List<ExecutableElement> findIntrinsifyFactoryMethods(List<ExecutableElement> intrinsifyFactoryMethods, TypeMirror[] signature, Map<ExecutableElement, String> nonMatches) {
        ArrayList<ExecutableElement> found = new ArrayList<ExecutableElement>(1);
        for (ExecutableElement method : intrinsifyFactoryMethods) {
            if (!this.matchSignature(1, method, signature, nonMatches)) continue;
            found.add(method);
        }
        return found;
    }

    private boolean matchSignature(int numSkippedParameters, ExecutableElement method, TypeMirror[] signature, Map<ExecutableElement, String> nonMatches) {
        int sIdx = 0;
        int cIdx = numSkippedParameters;
        while (cIdx < method.getParameters().size()) {
            TypeMirror varargsType;
            VariableElement parameter = method.getParameters().get(cIdx++);
            TypeMirror paramType = parameter.asType();
            if (this.processor.getAnnotation(parameter, this.processor.getType(INJECTED_NODE_PARAMETER_CLASS_NAME)) != null) continue;
            if (cIdx == method.getParameters().size() && paramType.getKind() == TypeKind.ARRAY && !(varargsType = ((ArrayType)paramType).getComponentType()).getKind().isPrimitive()) {
                while (sIdx < signature.length) {
                    if (this.isTypeCompatible(varargsType, signature[sIdx++])) continue;
                    nonMatches.put(method, String.format("the types of argument %d are incompatible: %s != %s", sIdx, varargsType, signature[sIdx - 1]));
                    return false;
                }
                continue;
            }
            if (sIdx >= signature.length) {
                nonMatches.put(method, "too many arguments");
                return false;
            }
            if (this.isTypeCompatible(paramType, signature[sIdx++])) continue;
            nonMatches.put(method, String.format("the type of argument %d is incompatible: %s != %s", sIdx, paramType, signature[sIdx - 1]));
            return false;
        }
        if (sIdx != signature.length) {
            nonMatches.put(method, "not enough arguments");
            return false;
        }
        return true;
    }

    private boolean isTypeCompatible(TypeMirror originalType, TypeMirror substitutionType) {
        TypeMirror original = originalType;
        TypeMirror substitution = substitutionType;
        if (NodeIntrinsicHandler.needsErasure(original)) {
            original = this.processor.env().getTypeUtils().erasure(original);
        }
        if (NodeIntrinsicHandler.needsErasure(substitution)) {
            substitution = this.processor.env().getTypeUtils().erasure(substitution);
        }
        return this.processor.env().getTypeUtils().isSameType(original, substitution);
    }

    private static boolean needsErasure(TypeMirror typeMirror) {
        return typeMirror.getKind() != TypeKind.NONE && typeMirror.getKind() != TypeKind.VOID && !typeMirror.getKind().isPrimitive() && typeMirror.getKind() != TypeKind.OTHER && typeMirror.getKind() != TypeKind.NULL;
    }
}

