/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import com.oracle.svm.jvmtiagentbase.Support;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.word.ComparableWord;

public final class ForeignUtil
extends JNIHandleSet {
    private static final ArrayElementFunction<MemoryLayoutTraverseException> MEMORY_LAYOUT_TO_STRING = new ArrayElementFunction<MemoryLayoutTraverseException>(){

        @Override
        public String apply(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle element) throws MemoryLayoutTraverseException {
            return ForeignUtil.visitMemoryLayout(env, handles, element);
        }

        @Override
        public String handleException(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle arrayHandle, int index) throws MemoryLayoutTraverseException {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
    };
    private static final ArrayElementFunction<RuntimeException> ARRAY_ELEMENT_TO_STRING = (env, handles, option) -> {
        JNIObjectHandle optionString = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)option, (JNIMethodId)handles.javaLangObjectToString);
        if (!Support.clearException((JNIEnvironment)env)) {
            return Support.fromJniString((JNIEnvironment)env, (JNIObjectHandle)optionString);
        }
        return Tracer.UNKNOWN_VALUE;
    };
    private static int javaLangInvokeMethodHandleInfoREFInvokeStatic = -1;

    public ForeignUtil(JNIEnvironment env) {
        super(env);
    }

    public static String getOptionalReturnLayoutString(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle optionalReturnLayout) {
        assert (ForeignUtil.isOptional(env, handles, optionalReturnLayout));
        boolean isEmpty = ForeignUtil.callOptionalIsEmpty(env, handles, optionalReturnLayout);
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        if (isEmpty) {
            return "void";
        }
        JNIObjectHandle returnLayout = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)optionalReturnLayout, (JNIMethodId)handles.getJavaUtilOptionalGet(env));
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        return ForeignUtil.getLayoutString(env, handles, returnLayout);
    }

    public static String getLayoutString(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) {
        try {
            return ForeignUtil.visitMemoryLayout(env, handles, layout);
        }
        catch (MemoryLayoutTraverseException e) {
            return Tracer.UNKNOWN_VALUE;
        }
    }

    private static String visitMemoryLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        String layoutString;
        if (ForeignUtil.isValueLayout(env, handles, layout)) {
            layoutString = ForeignUtil.visitValueLayout(env, handles, layout);
        } else if (ForeignUtil.isStructLayout(env, handles, layout)) {
            layoutString = ForeignUtil.visitStructLayout(env, handles, layout);
        } else if (ForeignUtil.isUnionLayout(env, handles, layout)) {
            layoutString = ForeignUtil.visitUnionLayout(env, handles, layout);
        } else if (ForeignUtil.isPaddingLayout(env, handles, layout)) {
            layoutString = ForeignUtil.visitPaddingLayout(env, handles, layout);
        } else if (ForeignUtil.isSequenceLayout(env, handles, layout)) {
            layoutString = ForeignUtil.visitSequenceLayout(env, handles, layout);
        } else {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        return ForeignUtil.decorateWithAlignmentIfNecessary(env, handles, layout, layoutString);
    }

    private static String visitStructLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        CharSequence[] members = ForeignUtil.getMemberLayouts(env, handles, layout);
        return "struct(" + String.join((CharSequence)",", members) + ")";
    }

    private static String visitUnionLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        CharSequence[] members = ForeignUtil.getMemberLayouts(env, handles, layout);
        return "union(" + String.join((CharSequence)",", members) + ")";
    }

    private static String[] getMemberLayouts(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        JNIObjectHandle memberLayoutsList = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)layout, (JNIMethodId)handles.getJavaLangForeignGroupLayoutMemberLayouts(env));
        if (Support.clearException((JNIEnvironment)env)) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        JNIObjectHandle memberLayoutsArray = ForeignUtil.callListToArray(env, handles, memberLayoutsList);
        if (Support.clearException((JNIEnvironment)env)) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        List<String> list = ForeignUtil.mapArrayElements(env, handles, memberLayoutsArray, MEMORY_LAYOUT_TO_STRING);
        if (list == null) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        return list.toArray(new String[0]);
    }

    private static String visitSequenceLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        long elementCount = Support.callLongMethod((JNIEnvironment)env, (JNIObjectHandle)layout, (JNIMethodId)handles.getJavaLangForeignSequenceLayoutElementCount(env));
        if (Support.clearException((JNIEnvironment)env)) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        JNIObjectHandle elementLayout = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)layout, (JNIMethodId)handles.getJavaLangForeignSequenceLayoutElementLayout(env));
        if (Support.clearException((JNIEnvironment)env)) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        return "sequence(" + elementCount + ", " + ForeignUtil.visitMemoryLayout(env, handles, elementLayout) + ")";
    }

    private static String visitValueLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        JNIObjectHandle carrier = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)layout, (JNIMethodId)handles.getJavaLangForeignValueLayoutCarrier(env));
        if (Support.clearException((JNIEnvironment)env)) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        if (Support.jniFunctions().getIsSameObject().invoke(env, handles.getJavaLangForeignMemorySegment(env), carrier)) {
            return "void*";
        }
        String classNameOrNull = Support.getClassNameOrNull((JNIEnvironment)env, (JNIObjectHandle)carrier);
        if (classNameOrNull == null) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        assert (ForeignUtil.isValidCarrierClass(classNameOrNull));
        return "j" + classNameOrNull;
    }

    private static boolean isValidCarrierClass(String carrierClassName) {
        return switch (carrierClassName) {
            case "boolean", "byte", "short", "char", "int", "long", "float", "double" -> true;
            default -> false;
        };
    }

    private static String visitPaddingLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        long byteSize = Support.callLongMethod((JNIEnvironment)env, (JNIObjectHandle)layout, (JNIMethodId)handles.getJavaLangForeignMemoryLayoutByteSize(env));
        if (Support.clearException((JNIEnvironment)env)) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        return "padding(" + byteSize + ")";
    }

    private static String decorateWithAlignmentIfNecessary(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout, String layoutString) throws MemoryLayoutTraverseException {
        if (!ForeignUtil.hasNaturalAlignment(env, handles, layout)) {
            long byteAlignment = Support.callLongMethod((JNIEnvironment)env, (JNIObjectHandle)layout, (JNIMethodId)handles.getJdkInternalForeignLayoutAbstractLayoutByteAlignment(env));
            if (Support.clearException((JNIEnvironment)env)) {
                throw MemoryLayoutTraverseException.INSTANCE;
            }
            return "align(" + byteAlignment + ", " + layoutString + ")";
        }
        return layoutString;
    }

    private static boolean isPaddingLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) {
        return Support.jniFunctions().getIsInstanceOf().invoke(env, layout, handles.getJavaLangForeignPaddingLayout(env));
    }

    private static boolean isUnionLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) {
        return Support.jniFunctions().getIsInstanceOf().invoke(env, layout, handles.getJavaLangForeignUnionLayout(env));
    }

    private static boolean isStructLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) {
        return Support.jniFunctions().getIsInstanceOf().invoke(env, layout, handles.getJavaLangForeignStructLayout(env));
    }

    private static boolean isSequenceLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) {
        return Support.jniFunctions().getIsInstanceOf().invoke(env, layout, handles.getJavaLangForeignSequenceLayout(env));
    }

    private static boolean isValueLayout(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) {
        return Support.jniFunctions().getIsInstanceOf().invoke(env, layout, handles.getJavaLangForeignValueLayout(env));
    }

    private static boolean isOptional(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) {
        return Support.jniFunctions().getIsInstanceOf().invoke(env, layout, handles.getJavaUtilOptional(env));
    }

    private static boolean callOptionalIsEmpty(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle optionalReturnLayout) {
        return Support.callBooleanMethod((JNIEnvironment)env, (JNIObjectHandle)optionalReturnLayout, (JNIMethodId)handles.getJavaUtilOptionalIsEmpty(env));
    }

    private static boolean hasNaturalAlignment(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle layout) throws MemoryLayoutTraverseException {
        boolean hasNaturalAlignment = Support.callBooleanMethod((JNIEnvironment)env, (JNIObjectHandle)layout, (JNIMethodId)handles.getJdkInternalForeignLayoutAbstractLayoutHasNaturalAlignment(env));
        if (Support.clearException((JNIEnvironment)env)) {
            throw MemoryLayoutTraverseException.INSTANCE;
        }
        return hasNaturalAlignment;
    }

    static JNIObjectHandle callListToArray(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle listHandle) {
        return Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)listHandle, (JNIMethodId)handles.getJavaUtilListToArray(env));
    }

    static <E extends Exception> List<String> mapArrayElements(JNIEnvironment jni, NativeImageAgentJNIHandleSet handles, JNIObjectHandle arrayHandle, ArrayElementFunction<E> op) throws E {
        int length = Support.jniFunctions().getGetArrayLength().invoke(jni, arrayHandle);
        if (!Support.clearException((JNIEnvironment)jni) && length >= 0) {
            ArrayList<String> result = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                JNIObjectHandle element = Support.jniFunctions().getGetObjectArrayElement().invoke(jni, arrayHandle, i);
                String elementString = Support.clearException((JNIEnvironment)jni) ? op.handleException(jni, handles, arrayHandle, i) : op.apply(jni, handles, element);
                result.add(elementString);
            }
            return result;
        }
        return null;
    }

    static Object getOptionsStrings(JNIEnvironment jni, NativeImageAgentJNIHandleSet handles, JNIObjectHandle options) {
        Object optionStrings = Tracer.EXPLICIT_NULL;
        if (options.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            optionStrings = ForeignUtil.mapArrayElements(jni, handles, options, ARRAY_ELEMENT_TO_STRING);
        }
        return optionStrings;
    }

    static Object getArgumentLayoutStrings(JNIEnvironment jni, NativeImageAgentJNIHandleSet handles, JNIObjectHandle function) {
        JNIObjectHandle argumentLayoutsList = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)function, (JNIMethodId)handles.getJavaLangForeignFunctionDescriptorArgumentLayouts(jni));
        if (Support.clearException((JNIEnvironment)jni)) {
            return Tracer.EXPLICIT_NULL;
        }
        JNIObjectHandle argumentLayoutsArray = ForeignUtil.callListToArray(jni, handles, argumentLayoutsList);
        if (Support.clearException((JNIEnvironment)jni)) {
            return Tracer.EXPLICIT_NULL;
        }
        return ForeignUtil.mapArrayElements(jni, handles, argumentLayoutsArray, ForeignUtil::getLayoutString);
    }

    static String getReturnLayoutString(JNIEnvironment jni, NativeImageAgentJNIHandleSet handles, JNIObjectHandle function) {
        JNIObjectHandle returnLayout = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)function, (JNIMethodId)handles.getJavaLangForeignFunctionDescriptorReturnLayout(jni));
        String returnLayoutString = Tracer.UNKNOWN_VALUE;
        if (!Support.clearException((JNIEnvironment)jni)) {
            returnLayoutString = ForeignUtil.getOptionalReturnLayoutString(jni, handles, returnLayout);
        }
        return returnLayoutString;
    }

    private static int getJavaLangInvokeMethodHandleInfoREFInvokeStatic(JNIEnvironment env, NativeImageAgentJNIHandleSet handles) {
        if (javaLangInvokeMethodHandleInfoREFInvokeStatic == -1) {
            JNIObjectHandle javaLangInvokeMethodHandleInfo = handles.findClass(env, "java/lang/invoke/MethodHandleInfo");
            JNIFieldId fieldId = handles.getFieldId(env, javaLangInvokeMethodHandleInfo, "REF_invokeStatic", "I", true);
            javaLangInvokeMethodHandleInfoREFInvokeStatic = Support.jniFunctions().getGetStaticIntField().invoke(env, javaLangInvokeMethodHandleInfo, fieldId);
        }
        return javaLangInvokeMethodHandleInfoREFInvokeStatic;
    }

    public static String getTargetString(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle target) {
        JNIObjectHandle methodHandleDescOptional = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)target, (JNIMethodId)handles.getJavaLangInvokeMethodHandleDescribeConstable(env));
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        boolean isEmpty = ForeignUtil.callOptionalIsEmpty(env, handles, methodHandleDescOptional);
        if (Support.clearException((JNIEnvironment)env) || isEmpty) {
            return Tracer.UNKNOWN_VALUE;
        }
        JNIObjectHandle methodHandleDesc = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)methodHandleDescOptional, (JNIMethodId)handles.getJavaUtilOptionalGet(env));
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        if (!Support.jniFunctions().getIsInstanceOf().invoke(env, methodHandleDesc, handles.getJavaLangConstantDirectMethodHandleDesc(env))) {
            return Tracer.UNKNOWN_VALUE;
        }
        int refKind = Support.callIntMethod((JNIEnvironment)env, (JNIObjectHandle)methodHandleDesc, (JNIMethodId)handles.getJavaLangConstantDirectMethodHandleDescRefKind(env));
        if (Support.clearException((JNIEnvironment)env) || refKind != ForeignUtil.getJavaLangInvokeMethodHandleInfoREFInvokeStatic(env, handles)) {
            return Tracer.UNKNOWN_VALUE;
        }
        JNIObjectHandle owner = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)methodHandleDesc, (JNIMethodId)handles.getJavaLangConstantDirectMethodHandleDescOwner(env));
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        JNIObjectHandle descriptorString = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)owner, (JNIMethodId)handles.getJavaLangConstantClassDescDescriptorString(env));
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        JNIObjectHandle methodName = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)methodHandleDesc, (JNIMethodId)handles.getJavaLangConstantDirectMethodHandleDescMethodName(env));
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        return Support.fromJniString((JNIEnvironment)env, (JNIObjectHandle)descriptorString) + "::" + Support.fromJniString((JNIEnvironment)env, (JNIObjectHandle)methodName);
    }

    private static final class MemoryLayoutTraverseException
    extends Exception {
        private static final MemoryLayoutTraverseException INSTANCE = new MemoryLayoutTraverseException();

        private MemoryLayoutTraverseException() {
        }
    }

    static interface ArrayElementFunction<E extends Exception> {
        public String apply(JNIEnvironment var1, NativeImageAgentJNIHandleSet var2, JNIObjectHandle var3) throws E;

        default public String handleException(JNIEnvironment env, NativeImageAgentJNIHandleSet handles, JNIObjectHandle arrayHandle, int index) throws E {
            return Tracer.UNKNOWN_VALUE;
        }
    }
}

