/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.BreakpointInterceptor;
import com.oracle.svm.agent.JniCallInterceptor;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.conditionalconfig.ConditionalConfigurationPartialRunWriter;
import com.oracle.svm.agent.conditionalconfig.ConditionalConfigurationWriter;
import com.oracle.svm.agent.configwithorigins.ConfigurationWithOriginsTracer;
import com.oracle.svm.agent.configwithorigins.ConfigurationWithOriginsWriter;
import com.oracle.svm.agent.configwithorigins.MethodInfoRecordKeeper;
import com.oracle.svm.agent.ignoredconfig.AgentMetaInfProcessor;
import com.oracle.svm.agent.stackaccess.EagerlyLoadedJavaStackAccess;
import com.oracle.svm.agent.stackaccess.InterceptedState;
import com.oracle.svm.agent.stackaccess.OnDemandJavaStackAccess;
import com.oracle.svm.agent.tracing.ConfigurationResultWriter;
import com.oracle.svm.agent.tracing.TraceFileWriter;
import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.PredefinedClassesConfigurationParser;
import com.oracle.svm.configure.config.ConfigurationFileCollection;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationPredicate;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIJavaVM;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.driver.metainf.NativeImageMetaInfResourceProcessor;
import com.oracle.svm.driver.metainf.NativeImageMetaInfWalker;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import com.oracle.svm.jvmtiagentbase.JvmtiAgentBase;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jdk.graal.compiler.phases.common.LazyValue;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.hosted.Feature;

public final class NativeImageAgent
extends JvmtiAgentBase<NativeImageAgentJNIHandleSet> {
    private static final String AGENT_NAME = "native-image-agent";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private ScheduledThreadPoolExecutor periodicConfigWriterExecutor = null;
    private Tracer tracer;
    private TracingResultWriter tracingResultWriter;
    private Path configOutputDirPath;
    private Path configOutputLockFilePath;
    private FileTime expectedConfigModifiedBefore;
    Set<String> classPathEntries;
    private static final int MAX_WARNINGS_FOR_WRITING_CONFIGS_FAILURES = 5;
    private static int currentFailuresWritingConfigs = 0;
    private static int currentFailuresModifiedTargetDirectory = 0;
    private static final int MAX_FAILURES_ATOMIC_MOVE = 20;
    private static int currentFailuresAtomicMove = 0;

    private static String getTokenValue(String token) {
        return token.substring(token.indexOf(61) + 1);
    }

    private static boolean getBooleanTokenValue(String token) {
        int equalsIndex = token.indexOf(61);
        if (equalsIndex == -1) {
            return true;
        }
        return Boolean.parseBoolean(token.substring(equalsIndex + 1));
    }

    private static boolean isBooleanOption(String token, String option) {
        return token.equals(option) || token.startsWith(option + "=");
    }

    protected int getRequiredJvmtiVersion() {
        return 805372416;
    }

    protected JNIHandleSet constructJavaHandles(JNIEnvironment env) {
        return new NativeImageAgentJNIHandleSet(env);
    }

    protected int onLoadCallback(JNIJavaVM vm, JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, String options) {
        Supplier<InterceptedState> interceptedStateSupplier;
        String[] tokens;
        String traceOutputFile = null;
        String configOutputDir = null;
        String ignoredEntriesFile = null;
        ConfigurationFileCollection mergeConfigs = new ConfigurationFileCollection();
        ConfigurationFileCollection omittedConfigs = new ConfigurationFileCollection();
        boolean builtinCallerFilter = true;
        boolean builtinHeuristicFilter = true;
        ArrayList<String> callerFilterFiles = new ArrayList<String>();
        ArrayList<String> accessFilterFiles = new ArrayList<String>();
        boolean experimentalClassLoaderSupport = true;
        boolean experimentalClassDefineSupport = false;
        boolean experimentalUnsafeAllocationSupport = false;
        boolean experimentalOmitClasspathConfig = false;
        boolean configurationWithOrigins = false;
        ArrayList<String> conditionalConfigUserPackageFilterFiles = new ArrayList<String>();
        ArrayList<String> conditionalConfigClassNameFilterFiles = new ArrayList<String>();
        boolean conditionalConfigPartialRun = false;
        int configWritePeriod = -1;
        int configWritePeriodInitialDelay = 1;
        boolean trackReflectionMetadata = true;
        for (String token : tokens = !options.isEmpty() ? options.split(",") : new String[]{}) {
            if (token.startsWith("trace-output=")) {
                if (traceOutputFile != null) {
                    return NativeImageAgent.usage("cannot specify trace-output= more than once.");
                }
                traceOutputFile = NativeImageAgent.getTokenValue(token);
                continue;
            }
            if (token.startsWith("config-output-dir=") || token.startsWith("config-merge-dir=")) {
                if (configOutputDir != null) {
                    return NativeImageAgent.usage("cannot specify more than one of config-output-dir= or config-merge-dir=.");
                }
                configOutputDir = NativeImageAgent.transformPath(NativeImageAgent.getTokenValue(token));
                if (!token.startsWith("config-merge-dir=")) continue;
                mergeConfigs.addDirectory(Paths.get(configOutputDir, new String[0]));
                continue;
            }
            if (token.startsWith("experimental-ignored-entries-output=")) {
                if (ignoredEntriesFile != null) {
                    return NativeImageAgent.usage("cannot specify ignored-entries-output= more than once.");
                }
                NativeImageAgent.warn("Ignored entries logging (enabled by the \"experimental-ignored-entries-output\" argument) is experimental and will be removed in the future. Do not rely on this feature.");
                ignoredEntriesFile = NativeImageAgent.getTokenValue(token);
                continue;
            }
            if (token.startsWith("config-to-omit=")) {
                String omittedConfigDir = NativeImageAgent.getTokenValue(token);
                omittedConfigDir = NativeImageAgent.transformPath(omittedConfigDir);
                omittedConfigs.addDirectory(Paths.get(omittedConfigDir, new String[0]));
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "experimental-omit-config-from-classpath")) {
                experimentalOmitClasspathConfig = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (token.startsWith("restrict-all-dir") || token.equals("restrict") || token.startsWith("restrict=")) {
                NativeImageAgent.warn("restrict mode is no longer supported, ignoring option: " + token);
                continue;
            }
            if (token.equals("no-builtin-caller-filter")) {
                builtinCallerFilter = false;
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "builtin-caller-filter")) {
                builtinCallerFilter = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (token.equals("no-builtin-heuristic-filter")) {
                builtinHeuristicFilter = false;
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "builtin-heuristic-filter")) {
                builtinHeuristicFilter = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "no-filter")) {
                builtinHeuristicFilter = builtinCallerFilter = !NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (token.startsWith("caller-filter-file=")) {
                callerFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("access-filter-file=")) {
                accessFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "experimental-class-loader-support")) {
                experimentalClassLoaderSupport = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "experimental-class-define-support")) {
                experimentalClassDefineSupport = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "experimental-unsafe-allocation-support")) {
                experimentalUnsafeAllocationSupport = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (token.startsWith("config-write-period-secs=")) {
                configWritePeriod = NativeImageAgent.parseIntegerOrNegative(NativeImageAgent.getTokenValue(token));
                if (configWritePeriod > 0) continue;
                return NativeImageAgent.usage("config-write-period-secs must be an integer greater than 0");
            }
            if (token.startsWith("config-write-initial-delay-secs=")) {
                configWritePeriodInitialDelay = NativeImageAgent.parseIntegerOrNegative(NativeImageAgent.getTokenValue(token));
                if (configWritePeriodInitialDelay >= 0) continue;
                return NativeImageAgent.usage("config-write-initial-delay-secs must be an integer greater or equal to 0");
            }
            if (NativeImageAgent.isBooleanOption(token, "experimental-configuration-with-origins")) {
                configurationWithOrigins = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (token.startsWith("experimental-conditional-config-filter-file=")) {
                conditionalConfigUserPackageFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("conditional-config-class-filter-file=")) {
                conditionalConfigClassNameFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "experimental-conditional-config-part")) {
                conditionalConfigPartialRun = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            if (NativeImageAgent.isBooleanOption(token, "track-reflection-metadata")) {
                trackReflectionMetadata = NativeImageAgent.getBooleanTokenValue(token);
                continue;
            }
            return NativeImageAgent.usage("unknown option: '" + token + "'.");
        }
        if (!NativeImageAgent.checkJVMVersion(jvmti)) {
            return 1;
        }
        if (traceOutputFile == null && configOutputDir == null) {
            configOutputDir = NativeImageAgent.transformPath("native-image-agent_config-pid{pid}-{datetime}/");
            NativeImageAgent.inform("no output options provided, tracking dynamic accesses and writing configuration to directory: " + configOutputDir);
        }
        if (configurationWithOrigins && !conditionalConfigUserPackageFilterFiles.isEmpty()) {
            return NativeImageAgent.error(1, "The agent can only be used in either the configuration with origins mode or the predefined classes mode.");
        }
        if (configurationWithOrigins && !mergeConfigs.isEmpty()) {
            configurationWithOrigins = false;
            NativeImageAgent.inform("using configuration with origins with configuration merging is currently unsupported. Disabling configuration with origins mode.");
        }
        if (configurationWithOrigins) {
            NativeImageAgent.warn("using experimental configuration with origins mode. Note that native-image cannot process these files, and this flag may change or be removed without a warning!");
        }
        ComplexFilter callerFilter = null;
        HierarchyFilterNode callerFilterHierarchyFilterNode = null;
        if (!builtinCallerFilter) {
            callerFilterHierarchyFilterNode = HierarchyFilterNode.createInclusiveRoot();
            callerFilter = new ComplexFilter(callerFilterHierarchyFilterNode);
        }
        if (!callerFilterFiles.isEmpty()) {
            if (callerFilterHierarchyFilterNode == null) {
                callerFilterHierarchyFilterNode = AccessAdvisor.copyBuiltinCallerFilterTree();
                callerFilter = new ComplexFilter(callerFilterHierarchyFilterNode);
            }
            if (!NativeImageAgent.parseFilterFiles(callerFilter, callerFilterFiles)) {
                return 2;
            }
        }
        ComplexFilter accessFilter = null;
        if (!accessFilterFiles.isEmpty() && !NativeImageAgent.parseFilterFiles(accessFilter = new ComplexFilter(AccessAdvisor.copyBuiltinAccessFilterTree()), accessFilterFiles)) {
            return 2;
        }
        if (!conditionalConfigUserPackageFilterFiles.isEmpty() && conditionalConfigPartialRun) {
            return NativeImageAgent.error(1, "The agent can generate conditional configuration either for the current run or in the partial mode but not both at the same time.");
        }
        this.classPathEntries = new HashSet<String>(Arrays.asList(NativeImageAgent.getClasspathEntries(jvmti)));
        boolean isConditionalConfigurationRun = !conditionalConfigUserPackageFilterFiles.isEmpty() || conditionalConfigPartialRun;
        boolean shouldTraceOriginInformation = configurationWithOrigins || isConditionalConfigurationRun;
        MethodInfoRecordKeeper recordKeeper = new MethodInfoRecordKeeper(shouldTraceOriginInformation);
        Supplier<InterceptedState> supplier = interceptedStateSupplier = shouldTraceOriginInformation ? EagerlyLoadedJavaStackAccess.stackAccessSupplier() : OnDemandJavaStackAccess.stackAccessSupplier();
        if (configOutputDir != null) {
            if (traceOutputFile != null) {
                return NativeImageAgent.usage("can only once specify exactly one of trace-output=, config-output-dir= or config-merge-dir=.");
            }
            try {
                this.configOutputDirPath = Files.createDirectories(Path.of(configOutputDir, new String[0]), new FileAttribute[0]);
                this.configOutputLockFilePath = this.configOutputDirPath.resolve(".lock");
                try {
                    Files.writeString(this.configOutputLockFilePath, (CharSequence)Long.toString(ProcessProperties.getProcessID()), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                catch (FileAlreadyExistsException e2) {
                    String process;
                    try {
                        process = Files.readString(this.configOutputLockFilePath).stripTrailing();
                    }
                    catch (Exception ignored) {
                        process = "(unknown)";
                    }
                    return NativeImageAgent.error(3, "Output directory '" + String.valueOf(this.configOutputDirPath) + "' is locked by process " + process + ", which means another agent instance is already writing to this directory. Only one agent instance can safely write to a specific target directory at the same time. Unless file '.lock' is a leftover from an earlier process that terminated abruptly, it is unsafe to delete it. For running multiple processes with agents at the same time to create a single configuration, read AutomaticMetadataCollection.md or https://www.graalvm.org/dev/reference-manual/native-image/metadata/AutomaticMetadataCollection/ on how to use the native-image-configure tool.");
                }
                if (experimentalOmitClasspathConfig) {
                    NativeImageAgent.ignoreConfigFromClasspath(jvmti, omittedConfigs);
                }
                AccessAdvisor advisor = new AccessAdvisor(builtinHeuristicFilter, (ConfigurationFilter)callerFilter, (ConfigurationFilter)accessFilter, ignoredEntriesFile);
                TraceProcessor processor = new TraceProcessor(advisor);
                ConfigurationSet omittedConfiguration = new ConfigurationSet();
                Predicate<String> shouldExcludeClassesWithHash = null;
                if (!omittedConfigs.isEmpty()) {
                    Function<IOException, Exception> ignore = e -> {
                        NativeImageAgent.warn("Failed to load omitted config: " + String.valueOf(e));
                        return null;
                    };
                    omittedConfiguration = omittedConfigs.loadConfigurationSet(ignore, null, null);
                    shouldExcludeClassesWithHash = arg_0 -> ((PredefinedClassesConfiguration)omittedConfiguration.getPredefinedClassesConfiguration()).containsClassWithHash(arg_0);
                }
                if (shouldTraceOriginInformation) {
                    ConfigurationWithOriginsTracer configWithOriginsTracer = new ConfigurationWithOriginsTracer(processor, recordKeeper);
                    this.tracer = configWithOriginsTracer;
                    if (isConditionalConfigurationRun) {
                        if (conditionalConfigPartialRun) {
                            this.tracingResultWriter = new ConditionalConfigurationPartialRunWriter(configWithOriginsTracer);
                        } else {
                            ComplexFilter classNameFilter;
                            ComplexFilter userCodeFilter = new ComplexFilter(HierarchyFilterNode.createRoot());
                            if (!NativeImageAgent.parseFilterFiles(userCodeFilter, conditionalConfigUserPackageFilterFiles)) {
                                return 2;
                            }
                            if (!conditionalConfigClassNameFilterFiles.isEmpty()) {
                                classNameFilter = new ComplexFilter(HierarchyFilterNode.createRoot());
                                if (!NativeImageAgent.parseFilterFiles(classNameFilter, conditionalConfigClassNameFilterFiles)) {
                                    return 2;
                                }
                            } else {
                                classNameFilter = new ComplexFilter(HierarchyFilterNode.createInclusiveRoot());
                            }
                            ConditionalConfigurationPredicate predicate = new ConditionalConfigurationPredicate(classNameFilter);
                            this.tracingResultWriter = new ConditionalConfigurationWriter(configWithOriginsTracer, userCodeFilter, predicate);
                        }
                    } else {
                        this.tracingResultWriter = new ConfigurationWithOriginsWriter(configWithOriginsTracer);
                    }
                } else {
                    List<LazyValue> predefinedClassDestDirs = List.of(PredefinedClassesConfigurationParser.directorySupplier((Path)this.configOutputDirPath));
                    Function<IOException, Exception> handler = e -> {
                        if (e instanceof NoSuchFileException) {
                            NativeImageAgent.warn("file " + ((NoSuchFileException)e).getFile() + " for merging could not be found, skipping");
                            return null;
                        }
                        if (e instanceof FileNotFoundException) {
                            NativeImageAgent.warn("could not open configuration file: " + String.valueOf(e));
                            return null;
                        }
                        return e;
                    };
                    ConfigurationSet configuration = mergeConfigs.loadConfigurationSet(handler, predefinedClassDestDirs, shouldExcludeClassesWithHash);
                    ConfigurationResultWriter writer = new ConfigurationResultWriter(processor, configuration, omittedConfiguration);
                    this.tracer = writer;
                    this.tracingResultWriter = writer;
                }
                this.expectedConfigModifiedBefore = NativeImageAgent.getMostRecentlyModified(this.configOutputDirPath, NativeImageAgent.getMostRecentlyModified(this.configOutputLockFilePath, null));
            }
            catch (Throwable t) {
                return NativeImageAgent.error(3, t.toString());
            }
        }
        try {
            Path path = Paths.get(NativeImageAgent.transformPath(traceOutputFile), new String[0]);
            TraceFileWriter writer = new TraceFileWriter(path);
            this.tracer = writer;
            this.tracingResultWriter = writer;
        }
        catch (Throwable t) {
            return NativeImageAgent.error(3, t.toString());
        }
        if (this.tracer != null) {
            this.tracer.traceTrackReflectionMetadata(trackReflectionMetadata);
        }
        try {
            BreakpointInterceptor.onLoad(jvmti, callbacks, this.tracer, this, interceptedStateSupplier, experimentalClassLoaderSupport, experimentalClassDefineSupport, experimentalUnsafeAllocationSupport, trackReflectionMetadata);
        }
        catch (Throwable t) {
            return NativeImageAgent.error(3, t.toString());
        }
        try {
            JniCallInterceptor.onLoad(this.tracer, this, interceptedStateSupplier);
        }
        catch (Throwable t) {
            return NativeImageAgent.error(3, t.toString());
        }
        this.setupExecutorServiceForPeriodicConfigurationCapture(configWritePeriod, configWritePeriodInitialDelay);
        return 0;
    }

    private static void inform(String message) {
        System.err.println("native-image-agent: " + message);
    }

    private static void warn(String message) {
        NativeImageAgent.inform("Warning: " + message);
    }

    private static <T> T error(T result, String message) {
        NativeImageAgent.inform("Error: " + message);
        return result;
    }

    private static int usage(String message) {
        NativeImageAgent.inform(message);
        NativeImageAgent.inform("Example usage: -agentlib:native-image-agent=config-output-dir=/path/to/config-dir/");
        NativeImageAgent.inform("For details, please read AutomaticMetadataCollection.md or https://www.graalvm.org/dev/reference-manual/native-image/metadata/AutomaticMetadataCollection/");
        return 1;
    }

    private static boolean checkJVMVersion(JvmtiEnv jvmti) {
        String agentVersion = System.getProperty("java.vm.version");
        int agentMajorVersion = Runtime.version().feature();
        String vmVersion = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.vm.version");
        if (vmVersion == null) {
            NativeImageAgent.warn(String.format("Unable to determine the \"java.vm.version\" of the running JVM. Note that the JVM should have major version %d, otherwise metadata may be incorrect.", agentMajorVersion));
            return true;
        }
        String[] parts = vmVersion.split("\\D");
        if (parts.length == 0 || Integer.parseInt(parts[0]) != agentMajorVersion) {
            return NativeImageAgent.error(false, String.format("The current VM (%s) is incompatible with the agent, which was built for a JVM with major version %d. To resolve this issue, run the agent using a JVM with major version %d.", vmVersion, agentMajorVersion, agentMajorVersion));
        }
        if (!vmVersion.startsWith(agentVersion)) {
            NativeImageAgent.warn(String.format("The running JVM (%s) is different from the JVM used to build the agent (%s). If the generated metadata is incorrect or incomplete, consider running the agent using the same JVM that built it.", vmVersion, agentVersion));
        }
        return true;
    }

    private static int parseIntegerOrNegative(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static boolean parseFilterFiles(ComplexFilter filter, List<String> filterFiles) {
        for (String path : filterFiles) {
            try {
                new FilterConfigurationParser((ConfigurationFilter)filter).parseAndRegister(Paths.get(path, new String[0]).toUri());
            }
            catch (Exception e) {
                return NativeImageAgent.error(false, "cannot parse filter file " + path + ": " + String.valueOf(e));
            }
        }
        filter.getHierarchyFilterNode().removeRedundantNodes();
        return true;
    }

    private void setupExecutorServiceForPeriodicConfigurationCapture(int writePeriod, int initialDelay) {
        if (this.tracingResultWriter == null || this.configOutputDirPath == null || !this.tracingResultWriter.supportsPeriodicTraceWriting()) {
            return;
        }
        if (writePeriod == -1) {
            return;
        }
        this.periodicConfigWriterExecutor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread workerThread = new Thread(r);
            workerThread.setDaemon(true);
            workerThread.setName("AgentConfigurationsPeriodicWriter");
            return workerThread;
        });
        this.periodicConfigWriterExecutor.setRemoveOnCancelPolicy(true);
        this.periodicConfigWriterExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.periodicConfigWriterExecutor.scheduleAtFixedRate(this::writeConfigurationFiles, initialDelay, writePeriod, TimeUnit.SECONDS);
    }

    private static String[] getClasspathEntries(JvmtiEnv jvmti) {
        String classpath = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.class.path");
        String sep = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"path.separator");
        if (sep == null) {
            if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
                sep = ":";
            } else if (Platform.includedIn(Platform.WINDOWS.class)) {
                sep = "[:;]";
            } else {
                NativeImageAgent.warn("Running on unknown platform. Could not process classpath.");
                return new String[0];
            }
        }
        String[] entries = classpath.split(sep);
        for (int i = 0; i < entries.length; ++i) {
            try {
                entries[i] = new File(entries[i]).getCanonicalPath();
                continue;
            }
            catch (IOException ex) {
                NativeImageAgent.warn("Could not normalize classpath entry %s. Agent output may be incorrect.".formatted(entries[i]));
            }
        }
        return entries;
    }

    private static void ignoreConfigFromClasspath(JvmtiEnv jvmti, ConfigurationFileCollection ignoredConfigCollection) {
        String[] entries = NativeImageAgent.getClasspathEntries(jvmti);
        AgentMetaInfProcessor processor = new AgentMetaInfProcessor(ignoredConfigCollection);
        for (String cpEntry : entries) {
            try {
                NativeImageMetaInfWalker.walkMetaInfForCPEntry((Path)Paths.get(cpEntry, new String[0]), (NativeImageMetaInfResourceProcessor)processor);
            }
            catch (NativeImageMetaInfWalker.MetaInfWalkException e) {
                NativeImageAgent.warn("Failed to walk the classpath entry: " + cpEntry + " Reason: " + String.valueOf((Object)e));
            }
        }
    }

    private static String transformPath(String path) {
        String result = path;
        if (result.contains("{pid}")) {
            result = result.replace("{pid}", Long.toString(ProcessProperties.getProcessID()));
        }
        if (result.contains("{datetime}")) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            fmt.setTimeZone(UTC_TIMEZONE);
            result = result.replace("{datetime}", fmt.format(new Date()));
        }
        return result;
    }

    protected void onVMInitCallback(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
        BreakpointInterceptor.onVMInit(jvmti, jni);
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("live");
        }
    }

    protected void onVMStartCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
        JniCallInterceptor.onVMStart(jvmti);
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("start");
        }
    }

    protected void onVMDeathCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("dead");
        }
    }

    private void writeConfigurationFiles() {
        Path tempDirectory = null;
        try {
            int i;
            FileTime mostRecent = NativeImageAgent.getMostRecentlyModified(this.configOutputDirPath, this.expectedConfigModifiedBefore);
            tempDirectory = Files.createTempDirectory(this.configOutputDirPath, NativeImageAgent.transformPath("agent-pid{pid}-{datetime}.tmp"), new FileAttribute[0]);
            List<Path> tempFilePaths = this.tracingResultWriter.writeToDirectory(tempDirectory);
            if (!Files.exists(this.configOutputLockFilePath, new LinkOption[0])) {
                throw NativeImageAgent.unexpectedlyModified(this.configOutputLockFilePath);
            }
            this.expectUnmodified(this.configOutputLockFilePath);
            Path[] targetFilePaths = new Path[tempFilePaths.size()];
            for (i = 0; i < tempFilePaths.size(); ++i) {
                Path fileName = tempDirectory.relativize(tempFilePaths.get(i));
                targetFilePaths[i] = this.configOutputDirPath.resolve(fileName);
                this.expectUnmodified(targetFilePaths[i]);
            }
            for (i = 0; i < tempFilePaths.size(); ++i) {
                NativeImageAgent.tryAtomicMove(tempFilePaths.get(i), targetFilePaths[i]);
                mostRecent = NativeImageAgent.getMostRecentlyModified(targetFilePaths[i], mostRecent);
            }
            this.expectedConfigModifiedBefore = mostRecent = NativeImageAgent.getMostRecentlyModified(this.configOutputDirPath, mostRecent);
            NativeImageAgent.compulsoryDelete(tempDirectory);
        }
        catch (IOException e) {
            NativeImageAgent.warnUpToLimit(currentFailuresWritingConfigs++, 5, "Error when writing configuration files: " + String.valueOf(e));
        }
        catch (ConcurrentModificationException e) {
            NativeImageAgent.warnUpToLimit(currentFailuresModifiedTargetDirectory++, 5, "file or directory '" + e.getMessage() + "' has been modified by another process. All output files remain in the temporary directory '" + String.valueOf(this.configOutputDirPath.resolve("..").relativize(tempDirectory)) + "'. Ensure that only one agent instance and no other processes are writing to the output directory '" + String.valueOf(this.configOutputDirPath) + "' at the same time. For running multiple processes with agents at the same time to create a single configuration, read AutomaticMetadataCollection.md or https://www.graalvm.org/dev/reference-manual/native-image/metadata/AutomaticMetadataCollection/ on how to use the native-image-configure tool.");
        }
    }

    private void expectUnmodified(Path path) {
        try {
            if (Files.getLastModifiedTime(path, new LinkOption[0]).compareTo(this.expectedConfigModifiedBefore) > 0) {
                throw NativeImageAgent.unexpectedlyModified(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static ConcurrentModificationException unexpectedlyModified(Path path) {
        throw new ConcurrentModificationException(path.getFileName().toString());
    }

    private static FileTime getMostRecentlyModified(Path path, FileTime other) {
        FileTime modified;
        try {
            modified = Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException ignored) {
            return other;
        }
        return other == null || other.compareTo(modified) < 0 ? modified : other;
    }

    private static void compulsoryDelete(Path pathToDelete) {
        int maxRetries = 3;
        for (int retries = 0; pathToDelete.toFile().exists() && !pathToDelete.toFile().delete() && retries < 3; ++retries) {
            try {
                Thread.sleep((long)(100.0 + Math.random() * 500.0));
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void warnUpToLimit(int currentCount, int limit, String message) {
        if (currentCount < limit) {
            NativeImageAgent.warn(message);
            return;
        }
        if (currentCount == limit) {
            NativeImageAgent.warn(message);
            NativeImageAgent.warn("The above warning will no longer be reported.");
        }
    }

    private static void tryAtomicMove(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            NativeImageAgent.warnUpToLimit(currentFailuresAtomicMove++, 20, String.format("Could not move temporary configuration profile from '%s' to '%s' atomically. This might result in inconsistencies.", source.toAbsolutePath(), target.toAbsolutePath()));
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected int onUnloadCallback(JNIJavaVM vm) {
        if (this.periodicConfigWriterExecutor != null) {
            this.periodicConfigWriterExecutor.shutdown();
            try {
                this.periodicConfigWriterExecutor.awaitTermination(300L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                this.periodicConfigWriterExecutor.shutdownNow();
            }
        }
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("unload");
        }
        if (this.tracingResultWriter != null) {
            this.tracingResultWriter.close();
            if (this.tracingResultWriter.supportsOnUnloadTraceWriting() && this.configOutputDirPath != null) {
                this.writeConfigurationFiles();
                NativeImageAgent.compulsoryDelete(this.configOutputLockFilePath);
                this.configOutputLockFilePath = null;
                this.configOutputDirPath = null;
            }
        }
        return 0;
    }

    private static void cleanupOnUnload(JNIJavaVM vm) {
        JniCallInterceptor.onUnload();
        BreakpointInterceptor.onUnload();
    }

    static class ExitCodes {
        static final int SUCCESS = 0;
        static final int USAGE_ERROR = 1;
        static final int PARSE_ERROR = 2;
        static final int AGENT_ERROR = 3;

        ExitCodes() {
        }
    }

    public static class RegistrationFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            NativeImageAgent.registerAgent((JvmtiAgentBase)new NativeImageAgent());
        }
    }
}

