/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.tracing;

import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.JsonFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.graalvm.collections.EconomicMap;

public class TraceFileWriter
extends Tracer
implements TracingResultWriter {
    private final JsonFileWriter jsonFileWriter;

    public TraceFileWriter(Path path) throws IOException {
        this.jsonFileWriter = new JsonFileWriter(path);
        this.traceInitialization();
    }

    @Override
    protected void traceEntry(EconomicMap<String, Object> entry) {
        this.jsonFileWriter.printObject(entry);
    }

    @Override
    public boolean supportsOnUnloadTraceWriting() {
        return false;
    }

    @Override
    public boolean supportsPeriodicTraceWriting() {
        return false;
    }

    @Override
    public void close() {
        this.jsonFileWriter.close();
    }
}

