/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import java.io.IOException;
import java.util.Objects;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;

public class SerializationConfigurationType
implements JsonPrintable,
Comparable<SerializationConfigurationType> {
    private final UnresolvedConfigurationCondition condition;
    private final String qualifiedJavaName;

    public SerializationConfigurationType(UnresolvedConfigurationCondition condition, String qualifiedJavaName) {
        assert (qualifiedJavaName.indexOf(47) == -1) : "Requires qualified Java name, not the internal representation";
        assert (!qualifiedJavaName.startsWith("[")) : "Requires Java source array syntax, for example java.lang.String[]";
        Objects.requireNonNull(condition);
        this.condition = condition;
        Objects.requireNonNull(qualifiedJavaName);
        this.qualifiedJavaName = qualifiedJavaName;
    }

    public String getQualifiedJavaName() {
        return this.qualifiedJavaName;
    }

    public UnresolvedConfigurationCondition getCondition() {
        return this.condition;
    }

    public void printJson(JsonWriter writer) throws IOException {
        this.printJson(writer, true);
    }

    public void printLegacyJson(JsonWriter writer) throws IOException {
        this.printJson(writer, false);
    }

    private void printJson(JsonWriter writer, boolean combinedFile) throws IOException {
        writer.appendObjectStart();
        ConfigurationConditionPrintable.printConditionAttribute(this.condition, writer, combinedFile);
        writer.quote(combinedFile ? "type" : "name").appendFieldSeparator().quote(this.qualifiedJavaName);
        writer.appendObjectEnd();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfigurationType that = (SerializationConfigurationType)o;
        return this.condition.equals(that.condition) && this.qualifiedJavaName.equals(that.qualifiedJavaName);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.qualifiedJavaName);
    }

    @Override
    public int compareTo(SerializationConfigurationType other) {
        int compareName = this.qualifiedJavaName.compareTo(other.qualifiedJavaName);
        if (compareName != 0) {
            return compareName;
        }
        return this.condition.compareTo(other.condition);
    }
}

