/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import jdk.vm.ci.code.BytecodePosition;

public abstract class BooleanCheckTypeFlow
extends TypeFlow<BytecodePosition> {
    public BooleanCheckTypeFlow(BytecodePosition position, AnalysisType declaredType) {
        super(position, declaredType);
    }

    protected BooleanCheckTypeFlow(BooleanCheckTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
    }

    protected static TypeState convertToBoolean(PointsToAnalysis bb, boolean canBeTrue, boolean canBeFalse) {
        if (canBeTrue && canBeFalse) {
            return TypeState.anyPrimitiveState();
        }
        if (canBeTrue) {
            return TypeState.forBoolean(bb, true);
        }
        if (canBeFalse) {
            return TypeState.forBoolean(bb, false);
        }
        return TypeState.forEmpty();
    }

    protected static TypeState convertToBoolean(PointsToAnalysis bb, TypeState trueState, TypeState falseState) {
        return BooleanCheckTypeFlow.convertToBoolean(bb, trueState.isNotEmpty(), falseState.isNotEmpty());
    }

    @Override
    public void addPredicated(PointsToAnalysis bb, TypeFlow<?> predicatedFlow) {
        AnalysisError.shouldNotReachHere(String.valueOf(this.getClass()) + " shouldn't act as a predicate.");
    }
}

