/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AlwaysEnabledPredicateFlow;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.flow.AnyPrimitiveSourceTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayCopyTypeFlow;
import com.oracle.graal.pointsto.flow.BooleanInstanceOfCheckTypeFlow;
import com.oracle.graal.pointsto.flow.BooleanNullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.BooleanPrimitiveCheckTypeFlow;
import com.oracle.graal.pointsto.flow.BoxTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.ConditionalFlow;
import com.oracle.graal.pointsto.flow.ConstantPrimitiveSourceTypeFlow;
import com.oracle.graal.pointsto.flow.ConstantTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.LocalAllInstantiatedFlow;
import com.oracle.graal.pointsto.flow.LocalAnchorFlow;
import com.oracle.graal.pointsto.flow.MergeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.PreSaturatedTypeFlow;
import com.oracle.graal.pointsto.flow.PredicateMergeFlow;
import com.oracle.graal.pointsto.flow.PrimitiveComparison;
import com.oracle.graal.pointsto.flow.PrimitiveFilterTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.flow.builder.TypeFlowGraphBuilder;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysis;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.core.common.type.VoidStamp;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnaryOpLogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatEqualsNode;
import jdk.graal.compiler.nodes.calc.FloatLessThanNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerLowerThanNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ClassIsArrayNode;
import jdk.graal.compiler.nodes.extended.FieldOffsetProvider;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewArrayWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewInstanceWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayWithExceptionNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.spi.LimitedValueProxy;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.common.BoxNodeIdentityPhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.IterativeConditionalEliminationPhase;
import jdk.graal.compiler.phases.graph.MergeableState;
import jdk.graal.compiler.phases.graph.PostOrderNodeIterator;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapePhase;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.nativeimage.AnnotationAccess;

public class MethodTypeFlowBuilder {
    protected final PointsToAnalysis bb;
    protected final MethodFlowsGraph flowsGraph;
    protected final PointsToAnalysisMethod method;
    protected StructuredGraph graph;
    private NodeBitMap processedNodes;
    private Map<PhiNode, TypeFlowBuilder<?>> loopPhiFlows;
    private final MethodFlowsGraph.GraphKind graphKind;
    private boolean processed = false;
    private final boolean newFlowsGraph;
    protected final TypeFlowGraphBuilder typeFlowGraphBuilder;
    protected List<TypeFlow<?>> postInitFlows = List.of();
    protected final TypeFlowBuilder<?> alwaysEnabled;
    private final TypeFlowBuilder<AnyPrimitiveSourceTypeFlow> anyPrimitiveSourceTypeFlowBuilder;

    public MethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        this.bb = bb;
        this.method = method;
        this.graphKind = graphKind;
        if (bb.trackPrimitiveValues()) {
            this.alwaysEnabled = bb.usePredicates() ? TypeFlowBuilder.create(bb, method, null, PointsToAnalysis.syntheticSourcePosition(method), AlwaysEnabledPredicateFlow.class, bb::getAlwaysEnabledPredicateFlow) : null;
            this.anyPrimitiveSourceTypeFlowBuilder = TypeFlowBuilder.create(bb, method, this.alwaysEnabled, null, AnyPrimitiveSourceTypeFlow.class, bb::getAnyPrimitiveSourceTypeFlow);
        } else {
            this.alwaysEnabled = null;
            this.anyPrimitiveSourceTypeFlowBuilder = null;
        }
        if (flowsGraph == null) {
            this.flowsGraph = new MethodFlowsGraph(method, graphKind);
            this.newFlowsGraph = true;
        } else {
            this.flowsGraph = flowsGraph;
            this.newFlowsGraph = false;
            assert (graphKind == MethodFlowsGraph.GraphKind.FULL) : graphKind;
        }
        this.typeFlowGraphBuilder = new TypeFlowGraphBuilder(bb);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parse(Object reason, boolean forceReparse) {
        AnalysisParsedGraph analysisParsedGraph;
        AnalysisParsedGraph analysisParsedGraph2 = analysisParsedGraph = forceReparse ? this.method.reparseGraph(this.bb) : this.method.ensureGraphParsed(this.bb);
        if (analysisParsedGraph.isIntrinsic()) {
            this.method.registerAsIntrinsicMethod(reason);
        }
        if (analysisParsedGraph.getEncodedGraph() == null) {
            return false;
        }
        this.graph = InlineBeforeAnalysis.decodeGraph(this.bb, this.method, analysisParsedGraph);
        try (DebugContext.Scope s = this.graph.getDebug().scope((Object)"MethodTypeFlowBuilder", (Object)this.graph);){
            MethodTypeFlowBuilder.optimizeGraphBeforeAnalysis(this.bb, this.method, this.graph);
            if (!this.bb.getUniverse().hostVM().validateGraph(this.bb, this.graph)) {
                this.graph = null;
                boolean bl2 = false;
                return bl2;
            }
            MethodTypeFlowBuilder.registerUsedElements(this.bb, this.graph, this.bb.usePredicates());
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            throw this.graph.getDebug().handle(ex);
        }
    }

    public static void optimizeGraphBeforeAnalysis(AbstractAnalysisEngine bb, AnalysisMethod method, StructuredGraph graph) {
        CanonicalizerPhase canonicalizerPhase = CanonicalizerPhase.create();
        canonicalizerPhase.apply(graph, (Object)bb.getProviders(method));
        if (((Boolean)PointstoOptions.ConditionalEliminationBeforeAnalysis.getValue(bb.getOptions())).booleanValue()) {
            new IterativeConditionalEliminationPhase(canonicalizerPhase, false).apply(graph, (Object)bb.getProviders(method));
        }
        if (((Boolean)PointstoOptions.EscapeAnalysisBeforeAnalysis.getValue(bb.getOptions())).booleanValue() && method.isOriginalMethod()) {
            new BoxNodeIdentityPhase().apply(graph, (Object)bb.getProviders(method));
            new PartialEscapePhase(false, canonicalizerPhase, bb.getOptions()).apply(graph, (Object)bb.getProviders(method));
        }
    }

    public static void registerUsedElements(AbstractAnalysisEngine bb, StructuredGraph graph, boolean usePredicates) {
        AnalysisMethod method = (AnalysisMethod)graph.method();
        HostedProviders providers = bb.getProviders(method);
        for (Node n : graph.getNodes()) {
            AnalysisField field;
            AnalysisType type;
            InstanceOfNode node;
            if (n instanceof InstanceOfNode) {
                node = (InstanceOfNode)n;
                type = (AnalysisType)node.type().getType();
                if (MethodTypeFlowBuilder.ignoreInstanceOfType(bb, type)) continue;
                type.registerAsReachable(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewInstanceNode) {
                node = (NewInstanceNode)n;
                type = (AnalysisType)node.instanceClass();
                if (usePredicates) continue;
                type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                for (ResolvedJavaField f : type.getInstanceFields(true)) {
                    AnalysisField field2 = (AnalysisField)f;
                    PointsToAnalysis pta = (PointsToAnalysis)bb;
                    field2.getInitialFlow().addState(pta, TypeState.defaultValueForKind(pta, field2.getStorageKind()));
                }
                continue;
            }
            if (n instanceof NewInstanceWithExceptionNode) {
                node = (NewInstanceWithExceptionNode)n;
                type = (AnalysisType)node.instanceClass();
                type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof VirtualObjectNode) {
                node = (VirtualObjectNode)n;
                type = (AnalysisType)node.type();
                type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewArrayNode) {
                node = (NewArrayNode)n;
                type = ((AnalysisType)node.elementType()).getArrayClass();
                type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewArrayWithExceptionNode) {
                node = (NewArrayWithExceptionNode)n;
                type = ((AnalysisType)node.elementType()).getArrayClass();
                type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewMultiArrayNode) {
                node = (NewMultiArrayNode)n;
                type = (AnalysisType)node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof NewMultiArrayWithExceptionNode) {
                node = (NewMultiArrayWithExceptionNode)n;
                type = (AnalysisType)node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof BoxNode) {
                node = (BoxNode)n;
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)bb.getMetaAccess());
                type.registerAsInstantiated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof LoadFieldNode) {
                node = (LoadFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsRead(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof StoreFieldNode) {
                node = (StoreFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsWritten(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof ConstantNode) {
                ConstantNode cn = (ConstantNode)n;
                JavaConstant root = cn.asJavaConstant();
                if (!cn.hasUsages() || !cn.isJavaConstant() || root.getJavaKind() != JavaKind.Object || !root.isNonNull()) continue;
                assert (StampTool.isExactType((ValueNode)cn)) : cn;
                if (MethodTypeFlowBuilder.ignoreConstant(bb, cn)) continue;
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)cn, (MetaAccessProvider)bb.getMetaAccess());
                type.registerAsInstantiated(new ObjectScanner.EmbeddedRootScan(AbstractAnalysisEngine.sourcePosition((ValueNode)cn), root));
                MethodTypeFlowBuilder.registerEmbeddedRoot(bb, cn);
                continue;
            }
            if (n instanceof FieldOffsetProvider) {
                FieldOffsetProvider node2 = (FieldOffsetProvider)n;
                if (!MethodTypeFlowBuilder.needsUnsafeRegistration(node2)) continue;
                ((AnalysisField)node2.getField()).registerAsUnsafeAccessed(AbstractAnalysisEngine.sourcePosition(node2.asNode()));
                continue;
            }
            if (n instanceof FrameState) {
                node = (FrameState)n;
                AnalysisMethod frameStateMethod = (AnalysisMethod)node.getMethod();
                if (frameStateMethod == null) continue;
                frameStateMethod.getDeclaringClass().registerAsReachable(AbstractAnalysisEngine.syntheticSourcePosition((Node)node, method));
                continue;
            }
            if (n instanceof ForeignCall) {
                node = (ForeignCall)n;
                MethodTypeFlowBuilder.registerForeignCall(bb, providers.getForeignCalls(), node.getDescriptor(), graph.method());
                continue;
            }
            if (n instanceof UnaryMathIntrinsicNode) {
                node = (UnaryMathIntrinsicNode)n;
                MethodTypeFlowBuilder.registerForeignCall(bb, providers.getForeignCalls(), providers.getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature), graph.method());
                continue;
            }
            if (!(n instanceof BinaryMathIntrinsicNode)) continue;
            node = (BinaryMathIntrinsicNode)n;
            MethodTypeFlowBuilder.registerForeignCall(bb, providers.getForeignCalls(), providers.getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature), graph.method());
        }
    }

    protected static boolean ignoreConstant(AbstractAnalysisEngine bb, ConstantNode node) {
        for (Node u : node.usages()) {
            if (u instanceof ClassIsAssignableFromNode) {
                ClassIsAssignableFromNode usage = (ClassIsAssignableFromNode)u;
                if (bb.getHostVM().isClosedTypeWorld() && usage.getOtherClass() != node && usage.getThisClass() == node) continue;
                return false;
            }
            if (u instanceof BytecodeExceptionNode) {
                BytecodeExceptionNode usage = (BytecodeExceptionNode)u;
                if (usage.getExceptionKind() == BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST && usage.getArguments().size() == 2 && usage.getArguments().get(0) != node && usage.getArguments().get(1) == node) continue;
                return false;
            }
            if (u instanceof FrameState) continue;
            return false;
        }
        return true;
    }

    protected static boolean needsUnsafeRegistration(FieldOffsetProvider node) {
        for (Node usage : node.asNode().usages()) {
            if (usage instanceof RawLoadNode || usage instanceof RawStoreNode || usage instanceof UnsafeCompareAndSwapNode || usage instanceof UnsafeCompareAndExchangeNode || usage instanceof AtomicReadAndWriteNode || usage instanceof AtomicReadAndAddNode || usage instanceof FrameState) continue;
            return true;
        }
        return false;
    }

    protected static boolean ignoreInstanceOfType(AbstractAnalysisEngine bb, AnalysisType type) {
        if (bb.getHostVM().ignoreInstanceOfTypeDisallowed()) {
            return false;
        }
        if (!bb.getHostVM().isClosedTypeWorld()) {
            return false;
        }
        if (type == null) {
            return false;
        }
        return !type.isArray();
    }

    private static void registerEmbeddedRoot(AbstractAnalysisEngine bb, ConstantNode cn) {
        bb.getUniverse().registerEmbeddedRoot(cn.asJavaConstant(), AbstractAnalysisEngine.sourcePosition((ValueNode)cn));
    }

    private static void registerForeignCall(AbstractAnalysisEngine bb, ForeignCallsProvider foreignCallsProvider, ForeignCallDescriptor foreignCallDescriptor, ResolvedJavaMethod from) {
        Optional<AnalysisMethod> targetMethod = bb.getHostVM().handleForeignCall(foreignCallDescriptor, foreignCallsProvider);
        targetMethod.ifPresent(analysisMethod -> bb.addRootMethod((AnalysisMethod)analysisMethod, true, (Object)from, new MultiMethod.MultiMethodKey[0]));
    }

    private boolean handleNodeIntrinsic() {
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)this.method, Node.NodeIntrinsic.class)) {
            this.graph.getDebug().log("apply MethodTypeFlow on node intrinsic %s", (Object)this.method);
            AnalysisType returnType = (AnalysisType)this.method.getSignature().getReturnType();
            if (this.bb.isSupportedJavaKind(returnType.getJavaKind())) {
                TypeFlow<?> returnTypeFlow = this.flowsGraph.getReturnFlow().getDeclaredType().getTypeFlow(this.bb, true);
                BytecodePosition source = new BytecodePosition(null, (ResolvedJavaMethod)this.method, 0);
                returnTypeFlow = this.bb.analysisPolicy().proxy(source, returnTypeFlow);
                FormalReturnTypeFlow resultFlow = new FormalReturnTypeFlow(source, returnType);
                resultFlow.enableFlow(this.bb);
                this.bb.analysisPolicy().addOriginalUse(this.bb, returnTypeFlow, resultFlow);
                this.flowsGraph.addMiscEntryFlow(returnTypeFlow);
                this.flowsGraph.setReturnFlow(resultFlow);
            }
            return true;
        }
        return false;
    }

    private void handleOpaqueReturn() {
        AnalysisError.guarantee(this.flowsGraph.getReturnFlow() == null, "Expected null return flow", new Object[0]);
        AnalysisType returnType = TypeFlow.filterUncheckedInterface((AnalysisType)this.method.getSignature().getReturnType());
        BytecodePosition position = AbstractAnalysisEngine.syntheticSourcePosition(null, this.method);
        FormalReturnTypeFlow returnFlow = new FormalReturnTypeFlow(position, returnType);
        returnFlow.enableFlow(this.bb);
        this.flowsGraph.setReturnFlow(returnFlow);
        assert (returnType.equals(returnFlow.getDeclaredType())) : String.valueOf(returnType) + " != " + String.valueOf(returnFlow.getDeclaredType());
        returnType.getTypeFlow(this.bb, true).addUse(this.bb, returnFlow);
    }

    private void insertPlaceholderParamAndReturnFlows() {
        AnalysisType returnType;
        List<AnalysisType> paramTypes = this.method.toParameterList();
        BytecodePosition position = AbstractAnalysisEngine.syntheticSourcePosition(null, this.method);
        for (int index = 0; index < paramTypes.size(); ++index) {
            FormalParamTypeFlow parameter;
            if (this.flowsGraph.getParameter(index) != null || !this.bb.isSupportedJavaKind(paramTypes.get(index).getJavaKind())) continue;
            AnalysisType paramType = paramTypes.get(index);
            if (index == 0 && !this.method.isStatic()) {
                assert (paramType.equals(this.method.getDeclaringClass())) : String.valueOf(paramType) + ", " + String.valueOf(this.method);
                parameter = new FormalReceiverTypeFlow(position, paramType);
            } else {
                parameter = new FormalParamTypeFlow(position, paramType, index);
            }
            parameter.enableFlow(this.bb);
            this.flowsGraph.setParameter(index, parameter);
        }
        if (this.flowsGraph.getReturnFlow() == null && (this.bb.isSupportedJavaKind((returnType = (AnalysisType)this.method.getSignature().getReturnType()).getJavaKind()) || this.bb.usePredicates() && returnType.getJavaKind() == JavaKind.Void)) {
            FormalReturnTypeFlow returnFlow = new FormalReturnTypeFlow(position, returnType);
            returnFlow.enableFlow(this.bb);
            this.flowsGraph.setReturnFlow(returnFlow);
        }
    }

    private void createTypeFlow() {
        this.processedNodes = new NodeBitMap((Graph)this.graph);
        TypeFlowsOfNodes typeFlows = this.bb.usePredicates() ? new TypeFlowsOfNodesWithPredicates() : new TypeFlowsOfNodes();
        typeFlows.setPredicate(this.alwaysEnabled);
        for (Node n : this.graph.getNodes()) {
            if (n instanceof ParameterNode) {
                node = (ParameterNode)n;
                if (this.bb.isSupportedJavaKind(node.getStackKind())) {
                    TypeFlowBuilder<FormalParamTypeFlow> paramBuilder = TypeFlowBuilder.create(this.bb, this.method, typeFlows.getPredicate(), node, FormalParamTypeFlow.class, () -> {
                        boolean isStatic = Modifier.isStatic(this.method.getModifiers());
                        int index = node.index();
                        FormalParamTypeFlow parameter = this.flowsGraph.getParameter(index);
                        if (parameter != null) {
                            parameter.updateSource(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                        } else {
                            assert (this.newFlowsGraph) : "missing flow from original graph " + String.valueOf(parameter);
                            if (!isStatic && index == 0) {
                                AnalysisType paramType = this.method.getDeclaringClass();
                                parameter = new FormalReceiverTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), paramType);
                            } else {
                                int offset = isStatic ? 0 : 1;
                                AnalysisType paramType = (AnalysisType)this.method.getSignature().getParameterType(index - offset);
                                parameter = new FormalParamTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), paramType, index);
                            }
                            this.flowsGraph.setParameter(index, parameter);
                        }
                        return parameter;
                    });
                    this.typeFlowGraphBuilder.checkFormalParameterBuilder(paramBuilder);
                    typeFlows.add((ValueNode)node, paramBuilder);
                    this.typeFlowGraphBuilder.registerSinkBuilder(paramBuilder);
                }
            } else if (n instanceof BoxNode && !typeFlows.usePredicates()) {
                node = (BoxNode)n;
                AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)this.bb.getMetaAccess());
                TypeFlowBuilder<BoxTypeFlow> boxBuilder = TypeFlowBuilder.create(this.bb, this.method, typeFlows.getPredicate(), node, BoxTypeFlow.class, () -> this.lambda$createTypeFlow$1((BoxNode)node, type));
                typeFlows.add((ValueNode)node, boxBuilder);
            }
            for (Node input : n.inputs()) {
                TypeFlowBuilder<ConstantTypeFlow> sourceBuilder;
                if (!(input instanceof ConstantNode) || typeFlows.contains((ValueNode)((ConstantNode)input))) continue;
                ConstantNode node = (ConstantNode)input;
                Constant constant = node.getValue();
                if (node.asJavaConstant() == null && (constant instanceof VMConstant || constant instanceof CStringConstant)) continue;
                if (node.asJavaConstant().isNull()) {
                    if (typeFlows.usePredicates()) continue;
                    sourceBuilder = TypeFlowBuilder.create(this.bb, this.method, typeFlows.getPredicate(), node, ConstantTypeFlow.class, () -> {
                        ConstantTypeFlow constantSource = new ConstantTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), null, TypeState.forNull());
                        this.flowsGraph.addMiscEntryFlow(constantSource);
                        return constantSource;
                    });
                    typeFlows.add((ValueNode)node, sourceBuilder);
                    continue;
                }
                if (node.asJavaConstant().getJavaKind() != JavaKind.Object || typeFlows.usePredicates()) continue;
                assert (StampTool.isExactType((ValueNode)node)) : node;
                sourceBuilder = TypeFlowBuilder.create(this.bb, this.method, typeFlows.getPredicate(), node, ConstantTypeFlow.class, () -> {
                    AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)this.bb.getMetaAccess());
                    assert (type.isInstantiated()) : type;
                    JavaConstant constantValue = node.asJavaConstant();
                    BytecodePosition position = AbstractAnalysisEngine.sourcePosition((ValueNode)node);
                    ImageHeapConstant heapConstant = this.bb.getUniverse().getHeapScanner().toImageHeapObject(constantValue, new ObjectScanner.EmbeddedRootScan(position, constantValue));
                    ConstantTypeFlow constantSource = new ConstantTypeFlow(position, type, TypeState.forConstant(this.bb, heapConstant, type));
                    this.flowsGraph.addMiscEntryFlow(constantSource);
                    return constantSource;
                });
                typeFlows.add((ValueNode)node, sourceBuilder);
            }
        }
        new NodeIterator((FixedNode)this.graph.start(), typeFlows).apply();
        this.postInitFlows = this.typeFlowGraphBuilder.build();
    }

    protected ValueNode typeFlowUnproxify(ValueNode value) {
        ValueNode result = value;
        while (result instanceof LimitedValueProxy) {
            result = ((LimitedValueProxy)result).getOriginalNode();
        }
        return result;
    }

    protected void apply(boolean forceReparse, Object reason) {
        assert (!this.processed) : "can only call apply once per MethodTypeFlowBuilder";
        this.processed = true;
        this.method.setReachableInCurrentLayer();
        if (this.method.analyzedInPriorLayer()) {
            this.handleOpaqueReturn();
            this.insertPlaceholderParamAndReturnFlows();
            return;
        }
        if (this.handleNodeIntrinsic()) {
            assert (!this.method.hasOpaqueReturn()) : this.method;
            return;
        }
        if (this.method.hasOpaqueReturn()) {
            this.handleOpaqueReturn();
        }
        boolean insertPlaceholderFlows = this.bb.getHostVM().getMultiMethodAnalysisPolicy().insertPlaceholderParamAndReturnFlows(this.method.getMultiMethodKey());
        if (this.graphKind == MethodFlowsGraph.GraphKind.STUB) {
            AnalysisError.guarantee(insertPlaceholderFlows, "placeholder flows must be enabled for STUB graphkinds.", new Object[0]);
            this.insertPlaceholderParamAndReturnFlows();
            return;
        }
        if (!this.parse(reason, forceReparse)) {
            return;
        }
        this.bb.getHostVM().methodBeforeTypeFlowCreationHook(this.bb, this.method, this.graph);
        this.createTypeFlow();
        if (insertPlaceholderFlows) {
            this.insertPlaceholderParamAndReturnFlows();
        }
        this.method.setAnalyzedGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)this.graph, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE, (Iterable)this.flowsGraph.getNodeFlows().getKeys()));
    }

    protected TypeFlow<?> maybePatchAllInstantiated(TypeFlow<?> flow, BytecodePosition position, AnalysisType declaredType, Object predicate) {
        if (this.bb.usePredicates() && flow instanceof AllInstantiatedTypeFlow && predicate != this.alwaysEnabled) {
            LocalAllInstantiatedFlow localFlow = new LocalAllInstantiatedFlow(position, declaredType);
            this.flowsGraph.addMiscEntryFlow(localFlow);
            flow.addUse(this.bb, localFlow);
            return localFlow;
        }
        return flow;
    }

    private AnalysisType getNodeType(ValueNode node) {
        return (AnalysisType)node.stamp(NodeView.DEFAULT).javaType((MetaAccessProvider)this.bb.getMetaAccess());
    }

    protected boolean delegateNodeProcessing(FixedNode n, TypeFlowsOfNodes state) {
        return false;
    }

    protected void processMacroInvokable(TypeFlowsOfNodes state, MacroInvokable macro, boolean installResult) {
        ValueNode macroNode = macro.asNode();
        BytecodePosition invokePosition = this.getInvokePosition(macro, macroNode);
        this.processMethodInvocation(state, macroNode, macro.getInvokeKind(), (PointsToAnalysisMethod)macro.getTargetMethod(), (NodeInputList<ValueNode>)macro.getArguments(), installResult, invokePosition, false);
    }

    private BytecodePosition getInvokePosition(MacroInvokable macro, ValueNode macroNode) {
        NodeSourcePosition invokePosition = null;
        NodeSourcePosition position = macroNode.getNodeSourcePosition();
        if (position != null) {
            assert (position.getMethod().equals((Object)macro.getTargetMethod())) : "Unexpected macro node source position: " + String.valueOf(macro) + " at " + String.valueOf(position);
            invokePosition = position.getCaller();
        }
        if (invokePosition == null) {
            invokePosition = AbstractAnalysisEngine.syntheticSourcePosition((Node)macroNode, this.method);
        }
        return invokePosition;
    }

    protected void processMethodInvocation(TypeFlowsOfNodes state, Invoke invoke, CallTargetNode.InvokeKind invokeKind, PointsToAnalysisMethod targetMethod, NodeInputList<ValueNode> arguments) {
        FixedNode invokeNode = invoke.asFixedNode();
        BytecodePosition invokePosition = this.getInvokePosition(invokeNode);
        this.processMethodInvocation(state, (ValueNode)invokeNode, invokeKind, targetMethod, arguments, true, invokePosition, false);
    }

    protected BytecodePosition getInvokePosition(FixedNode invokeNode) {
        NodeSourcePosition invokePosition;
        for (invokePosition = invokeNode.getNodeSourcePosition(); invokePosition != null && invokePosition.getCaller() != null; invokePosition = invokePosition.getCaller()) {
        }
        if (invokePosition == null) {
            invokePosition = AbstractAnalysisEngine.syntheticSourcePosition((Node)invokeNode, this.method);
        }
        return invokePosition;
    }

    protected void processMethodInvocation(TypeFlowsOfNodes state, ValueNode invoke, CallTargetNode.InvokeKind invokeKind, PointsToAnalysisMethod targetMethod, NodeInputList<ValueNode> arguments, boolean installResult, BytecodePosition invokeLocation, boolean createDeoptInvokeTypeFlow) {
        this.bb.isCallAllowed(this.bb, this.method, targetMethod, invokeLocation);
        TypeFlowBuilder[] actualParametersBuilders = new TypeFlowBuilder[arguments.size()];
        for (int i = 0; i < actualParametersBuilders.length; ++i) {
            TypeFlowBuilder<?> paramBuilder;
            ValueNode actualParam = (ValueNode)arguments.get(i);
            if (!this.bb.isSupportedJavaKind(actualParam.getStackKind())) continue;
            actualParametersBuilders[i] = paramBuilder = state.lookup(actualParam);
            paramBuilder.markAsBuildingAnActualParameter();
            this.typeFlowGraphBuilder.registerSinkBuilder(paramBuilder);
        }
        TypeFlowBuilder<InvokeTypeFlow> invokeBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), invoke, InvokeTypeFlow.class, () -> {
            InvokeTypeFlow invokeFlow;
            TypeFlow[] actualParameters = new TypeFlow[actualParametersBuilders.length];
            for (int i = 0; i < actualParameters.length; ++i) {
                actualParameters[i] = actualParametersBuilders[i] != null ? actualParametersBuilders[i].get() : null;
            }
            ActualReturnTypeFlow actualReturn = null;
            AnalysisType receiverType = null;
            if (invokeKind.hasReceiver()) {
                receiverType = targetMethod.getDeclaringClass();
                AnalysisType receiverArgType = (AnalysisType)StampTool.typeOrNull((ValueNode)((ValueNode)arguments.get(0)));
                if (receiverArgType != null && receiverType.isAssignableFrom(receiverArgType)) {
                    receiverType = receiverArgType;
                }
            }
            MultiMethod.MultiMethodKey multiMethodKey = this.method.getMultiMethodKey();
            if (createDeoptInvokeTypeFlow) {
                invokeFlow = this.bb.analysisPolicy().createDeoptInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
            } else {
                switch (invokeKind) {
                    case Static: {
                        invokeFlow = this.bb.analysisPolicy().createStaticInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
                        break;
                    }
                    case Special: {
                        invokeFlow = this.bb.analysisPolicy().createSpecialInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
                        break;
                    }
                    case Virtual: 
                    case Interface: {
                        invokeFlow = this.bb.analysisPolicy().createVirtualInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
                        break;
                    }
                    default: {
                        throw JVMCIError.shouldNotReachHere();
                    }
                }
            }
            this.flowsGraph.addInvoke(invokeFlow);
            this.flowsGraph.addNodeFlow((Node)invoke, invokeFlow);
            if (invokeKind == CallTargetNode.InvokeKind.Special || invokeKind == CallTargetNode.InvokeKind.Virtual || invokeKind == CallTargetNode.InvokeKind.Interface) {
                this.bb.analysisPolicy().addOriginalObserver(this.bb, actualParameters[0], invokeFlow);
            }
            return invokeFlow;
        });
        state.addInvoke(invoke, invokeBuilder);
        JavaKind stackKind = invoke.asNode().getStackKind();
        if (!createDeoptInvokeTypeFlow && (this.bb.isSupportedJavaKind(stackKind) || state.usePredicates() && stackKind == JavaKind.Void)) {
            AnalysisType returnType = (AnalysisType)targetMethod.getSignature().getReturnType();
            TypeFlowBuilder<TypeFlow> actualReturnBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), invoke.asNode(), ActualReturnTypeFlow.class, () -> {
                InvokeTypeFlow invokeFlow = (InvokeTypeFlow)invokeBuilder.get();
                ActualReturnTypeFlow actualReturn = new ActualReturnTypeFlow((BytecodePosition)invokeFlow.source, returnType);
                this.flowsGraph.addMiscEntryFlow(actualReturn);
                invokeFlow.setActualReturn(this.bb, targetMethod.isStatic(), actualReturn);
                actualReturn.setInvokeFlow(invokeFlow);
                return actualReturn;
            });
            state.setPredicate(actualReturnBuilder);
            Stamp stamp = invoke.stamp(NodeView.DEFAULT);
            if (stamp instanceof ObjectStamp) {
                ObjectStamp stamp2 = (ObjectStamp)stamp;
                AnalysisType stampType = (AnalysisType)StampTool.typeOrNull((Stamp)stamp2, (MetaAccessProvider)this.bb.getMetaAccess());
                if (stamp2.nonNull() && !returnType.equals(stampType) && returnType.isAssignableFrom(stampType)) {
                    TypeFlowBuilder<FilterTypeFlow> filterBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), invoke, FilterTypeFlow.class, () -> {
                        FilterTypeFlow filterFlow = new FilterTypeFlow(invokeLocation, stampType, stamp2.isExactType(), true, true);
                        this.flowsGraph.addMiscEntryFlow(filterFlow);
                        return filterFlow;
                    });
                    filterBuilder.addUseDependency(actualReturnBuilder);
                    actualReturnBuilder = filterBuilder;
                    state.setPredicate(actualReturnBuilder);
                }
            }
            this.typeFlowGraphBuilder.registerSinkBuilder(actualReturnBuilder);
            if (installResult) {
                state.add(invoke.asNode(), actualReturnBuilder);
            }
        }
        this.typeFlowGraphBuilder.registerSinkBuilder(invokeBuilder);
    }

    protected void processCommitAllocation(CommitAllocationNode commitAllocationNode, TypeFlowsOfNodes state) {
        HashMap<VirtualObjectNode, AllocatedObjectNode> allocatedObjects = new HashMap<VirtualObjectNode, AllocatedObjectNode>();
        for (AllocatedObjectNode allocatedObjectNode : commitAllocationNode.usages().filter(AllocatedObjectNode.class)) {
            AnalysisType type = (AnalysisType)allocatedObjectNode.getVirtualObject().type();
            this.processNewInstance((ValueNode)allocatedObjectNode, type, state, false);
            allocatedObjects.put(allocatedObjectNode.getVirtualObject(), allocatedObjectNode);
        }
        List values = commitAllocationNode.getValues();
        int objectStartIndex = 0;
        for (VirtualObjectNode virtualObject : commitAllocationNode.getVirtualObjects()) {
            AnalysisType type = (AnalysisType)virtualObject.type();
            ValueNode object = (ValueNode)allocatedObjects.get(virtualObject);
            if (object == null) {
                object = virtualObject;
            }
            for (int i = 0; i < virtualObject.entryCount(); ++i) {
                AnalysisField field;
                ValueNode value = (ValueNode)values.get(objectStartIndex + i);
                if (!value.isJavaConstant() || !value.asJavaConstant().isDefaultForKind()) {
                    if (type.isArray()) {
                        this.processStoreIndexed((ValueNode)commitAllocationNode, object, value, value.getStackKind(), state);
                        continue;
                    }
                    field = (AnalysisField)((VirtualInstanceNode)virtualObject).field(i);
                    this.processStoreField((ValueNode)commitAllocationNode, field, object, value, value.getStackKind(), state);
                    continue;
                }
                if (type.isArray()) continue;
                field = (AnalysisField)((VirtualInstanceNode)virtualObject).field(i);
                field.getInitialFlow().addState(this.bb, TypeState.defaultValueForKind(this.bb, field.getStorageKind()));
            }
            objectStartIndex += virtualObject.entryCount();
        }
        assert (values.size() == objectStartIndex) : values;
    }

    protected void processNewInstance(NewInstanceNode node, TypeFlowsOfNodes state, boolean insertDefaultFieldValues) {
        this.processNewInstance((ValueNode)node, (AnalysisType)node.instanceClass(), state, insertDefaultFieldValues);
    }

    protected void processNewArray(NewArrayNode node, TypeFlowsOfNodes state) {
        this.processNewInstance((ValueNode)node, ((AnalysisType)node.elementType()).getArrayClass(), state, false);
    }

    protected void processNewInstance(ValueNode node, AnalysisType type, TypeFlowsOfNodes state, boolean insertDefaultFieldValues) {
        TypeFlowBuilder<NewInstanceTypeFlow> newInstanceBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, NewInstanceTypeFlow.class, () -> {
            NewInstanceTypeFlow newInstance = new NewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type, insertDefaultFieldValues);
            this.flowsGraph.addMiscEntryFlow(newInstance);
            return newInstance;
        });
        state.add(node, newInstanceBuilder);
    }

    protected void processLoadField(ValueNode node, AnalysisField field, ValueNode object, TypeFlowsOfNodes state) {
        field.registerAsRead(AbstractAnalysisEngine.sourcePosition(node));
        if (this.bb.isSupportedJavaKind(node.getStackKind())) {
            TypeFlowBuilder<LoadFieldTypeFlow> loadFieldBuilder;
            if (field.isStatic()) {
                loadFieldBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, LoadFieldTypeFlow.LoadStaticFieldTypeFlow.class, () -> {
                    FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                    LoadFieldTypeFlow.LoadStaticFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadStaticFieldTypeFlow(AbstractAnalysisEngine.sourcePosition(node), field, fieldFlow);
                    this.flowsGraph.addNodeFlow((Node)node, loadFieldFLow);
                    return loadFieldFLow;
                });
            } else {
                TypeFlowBuilder<?> objectBuilder = state.lookup(object);
                loadFieldBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, LoadFieldTypeFlow.LoadInstanceFieldTypeFlow.class, () -> {
                    LoadFieldTypeFlow.LoadInstanceFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadInstanceFieldTypeFlow(AbstractAnalysisEngine.sourcePosition(node), field, (TypeFlow<?>)objectBuilder.get());
                    this.flowsGraph.addNodeFlow((Node)node, loadFieldFLow);
                    return loadFieldFLow;
                });
                loadFieldBuilder.addObserverDependency(objectBuilder);
            }
            this.typeFlowGraphBuilder.registerSinkBuilder(loadFieldBuilder);
            state.add(node, loadFieldBuilder);
        }
    }

    protected void processStoreField(ValueNode node, AnalysisField field, ValueNode object, ValueNode newValue, JavaKind newValueKind, TypeFlowsOfNodes state) {
        field.registerAsWritten(AbstractAnalysisEngine.sourcePosition(node));
        if (this.bb.isSupportedJavaKind(newValueKind)) {
            TypeFlowBuilder<StoreFieldTypeFlow> storeFieldBuilder;
            TypeFlowBuilder<?> valueBuilder = state.lookupOrAny(newValue, newValueKind);
            if (field.isStatic()) {
                storeFieldBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, StoreFieldTypeFlow.StoreStaticFieldTypeFlow.class, () -> {
                    FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                    StoreFieldTypeFlow.StoreStaticFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreStaticFieldTypeFlow(AbstractAnalysisEngine.sourcePosition(node), field, (TypeFlow<?>)valueBuilder.get(), fieldFlow);
                    this.flowsGraph.addMiscEntryFlow(storeFieldFlow);
                    return storeFieldFlow;
                });
            } else {
                TypeFlowBuilder<?> objectBuilder = state.lookup(object);
                storeFieldBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, StoreFieldTypeFlow.StoreInstanceFieldTypeFlow.class, () -> {
                    StoreFieldTypeFlow.StoreInstanceFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreInstanceFieldTypeFlow(AbstractAnalysisEngine.sourcePosition(node), field, (TypeFlow<?>)valueBuilder.get(), (TypeFlow<?>)objectBuilder.get());
                    this.flowsGraph.addMiscEntryFlow(storeFieldFlow);
                    return storeFieldFlow;
                });
                storeFieldBuilder.addObserverDependency(objectBuilder);
            }
            storeFieldBuilder.addUseDependency(valueBuilder);
            this.typeFlowGraphBuilder.registerSinkBuilder(storeFieldBuilder);
        }
    }

    protected void processLoadIndexed(ValueNode node, ValueNode array, TypeFlowsOfNodes state) {
        if (node.getStackKind() == JavaKind.Object) {
            TypeFlowBuilder<?> arrayBuilder = state.lookup(array);
            AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)array, (MetaAccessProvider)this.bb.getMetaAccess());
            AnalysisType arrayType = type.isArray() ? type : this.bb.getObjectArrayType();
            TypeFlowBuilder<OffsetLoadTypeFlow.LoadIndexedTypeFlow> loadIndexedBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                OffsetLoadTypeFlow.LoadIndexedTypeFlow loadIndexedFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow(AbstractAnalysisEngine.sourcePosition(node), arrayType, (TypeFlow<?>)arrayBuilder.get());
                this.flowsGraph.addNodeFlow((Node)node, loadIndexedFlow);
                return loadIndexedFlow;
            });
            this.typeFlowGraphBuilder.registerSinkBuilder(loadIndexedBuilder);
            loadIndexedBuilder.addObserverDependency(arrayBuilder);
            state.add(node, loadIndexedBuilder);
        }
    }

    protected void processStoreIndexed(ValueNode node, ValueNode array, ValueNode newValue, JavaKind newValueKind, TypeFlowsOfNodes state) {
        if (newValueKind == JavaKind.Object) {
            AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)array, (MetaAccessProvider)this.bb.getMetaAccess());
            AnalysisType arrayType = type.isArray() ? type : this.bb.getObjectArrayType();
            TypeFlowBuilder<?> arrayBuilder = state.lookup(array);
            TypeFlowBuilder<?> valueBuilder = state.lookupOrAny(newValue, newValueKind);
            TypeFlowBuilder<OffsetStoreTypeFlow.StoreIndexedTypeFlow> storeIndexedBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                OffsetStoreTypeFlow.StoreIndexedTypeFlow storeIndexedFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow(AbstractAnalysisEngine.sourcePosition(node), arrayType, (TypeFlow<?>)arrayBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                this.flowsGraph.addMiscEntryFlow(storeIndexedFlow);
                return storeIndexedFlow;
            });
            storeIndexedBuilder.addUseDependency(valueBuilder);
            storeIndexedBuilder.addObserverDependency(arrayBuilder);
            this.typeFlowGraphBuilder.registerSinkBuilder(storeIndexedBuilder);
        }
    }

    protected void processUnsafeLoad(ValueNode node, ValueNode object, TypeFlowsOfNodes state) {
        if (node.getStackKind() == JavaKind.Object) {
            TypeFlowBuilder<?> objectBuilder = state.lookup(object);
            TypeFlowBuilder<TypeFlow> loadBuilder = this.bb.analysisPolicy().useConservativeUnsafeAccess() ? TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, PreSaturatedTypeFlow.class, () -> {
                PreSaturatedTypeFlow preSaturated = new PreSaturatedTypeFlow(AbstractAnalysisEngine.sourcePosition(node));
                this.flowsGraph.addMiscEntryFlow(preSaturated);
                return preSaturated;
            }) : TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class, () -> {
                OffsetLoadTypeFlow.UnsafeLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafeLoadTypeFlow(AbstractAnalysisEngine.sourcePosition(node), this.bb.getObjectType(), this.bb.getObjectType(), (TypeFlow<?>)objectBuilder.get());
                this.flowsGraph.addMiscEntryFlow(loadTypeFlow);
                return loadTypeFlow;
            });
            loadBuilder.addObserverDependency(objectBuilder);
            state.add(node, loadBuilder);
        }
    }

    protected void processUnsafeStore(ValueNode node, ValueNode object, ValueNode newValue, JavaKind newValueKind, TypeFlowsOfNodes state) {
        if (this.bb.analysisPolicy().useConservativeUnsafeAccess()) {
            return;
        }
        if (newValueKind == JavaKind.Object) {
            TypeFlowBuilder<?> objectBuilder = state.lookup(object);
            TypeFlowBuilder<?> newValueBuilder = state.lookupOrAny(newValue, newValueKind);
            TypeFlowBuilder<OffsetStoreTypeFlow.UnsafeStoreTypeFlow> storeBuilder = TypeFlowBuilder.create(this.bb, this.method, state.getPredicate(), node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow(AbstractAnalysisEngine.sourcePosition(node), this.bb.getObjectType(), this.bb.getObjectType(), (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                return storeTypeFlow;
            });
            storeBuilder.addUseDependency(newValueBuilder);
            storeBuilder.addObserverDependency(objectBuilder);
            this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
        }
    }

    protected void checkUnsafeOffset(ValueNode base, ValueNode offset) {
    }

    private void processImplicitNonNull(ValueNode node, TypeFlowsOfNodes state) {
        this.processImplicitNonNull(node, node, state);
    }

    protected void processImplicitNonNull(ValueNode node, ValueNode source, TypeFlowsOfNodes state) {
        assert (node.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp) : node;
        if (!StampTool.isPointerNonNull((ValueNode)node)) {
            TypeFlowBuilder<?> inputBuilder = state.lookup(node);
            TypeFlowBuilder<?> predicate = state.getPredicate();
            TypeFlowBuilder<NullCheckTypeFlow> nullCheckBuilder = TypeFlowBuilder.create(this.bb, this.method, predicate, source, NullCheckTypeFlow.class, () -> {
                NullCheckTypeFlow nullCheck;
                Object inputFlow = inputBuilder.get();
                if (inputFlow instanceof NullCheckTypeFlow && (nullCheck = (NullCheckTypeFlow)inputFlow).isBlockingNull() && inputBuilder.getPredicate() == predicate) {
                    return nullCheck;
                }
                NullCheckTypeFlow nullCheckFlow = new NullCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(source), ((TypeFlow)inputFlow).getDeclaredType(), true);
                this.flowsGraph.addMiscEntryFlow(nullCheckFlow);
                return nullCheckFlow;
            });
            nullCheckBuilder.addUseDependency(inputBuilder);
            state.update(node, nullCheckBuilder);
        }
    }

    private /* synthetic */ BoxTypeFlow lambda$createTypeFlow$1(BoxNode node, AnalysisType type) {
        BoxTypeFlow boxFlow = new BoxTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), type);
        this.flowsGraph.addMiscEntryFlow(boxFlow);
        return boxFlow;
    }

    private class TypeFlowsOfNodesWithPredicates
    extends TypeFlowsOfNodes
    implements Cloneable {
        private TypeFlowBuilder<?> predicate;
        private final Map<ValueNode, TypeFlowBuilder<InvokeTypeFlow>> invokes;

        protected TypeFlowsOfNodesWithPredicates() {
            this.invokes = new HashMap<ValueNode, TypeFlowBuilder<InvokeTypeFlow>>();
        }

        protected TypeFlowsOfNodesWithPredicates(TypeFlowsOfNodesWithPredicates copyFrom) {
            super(copyFrom);
            this.predicate = copyFrom.predicate;
            this.invokes = new HashMap<ValueNode, TypeFlowBuilder<InvokeTypeFlow>>(copyFrom.invokes);
        }

        @Override
        public TypeFlowBuilder<?> lookup(ValueNode n) {
            ValueNode node = MethodTypeFlowBuilder.this.typeFlowUnproxify(n);
            TypeFlowBuilder<Object> result = (TypeFlowBuilder<?>)this.flows.get(node);
            if (result != null && result.getPredicate() != this.getPredicate() && n instanceof ParameterNode) {
                TypeFlowBuilder<?> resultBuilder = result;
                TypeFlowBuilder<LocalAnchorFlow> anchorFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), result.getSource(), LocalAnchorFlow.class, () -> {
                    LocalAnchorFlow flow = new LocalAnchorFlow(AbstractAnalysisEngine.syntheticSourcePosition(MethodTypeFlowBuilder.this.method), ((TypeFlow)resultBuilder.get()).declaredType);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                    return flow;
                });
                anchorFlow.addUseDependency(result);
                this.flows.put(node, anchorFlow);
                return anchorFlow;
            }
            if (result == null) {
                Stamp s = n.stamp(NodeView.DEFAULT);
                if (node instanceof ConditionalNode) {
                    ConditionalNode conditionalNode = (ConditionalNode)node;
                    TypeFlowBuilder<?> condition = this.lookup((ValueNode)conditionalNode.condition());
                    TypeFlowBuilder<?> trueValue = this.lookup(conditionalNode.trueValue());
                    TypeFlowBuilder<?> falseValue = this.lookup(conditionalNode.falseValue());
                    AnalysisType declaredType = (AnalysisType)s.javaType((MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, ConditionalFlow.class, () -> {
                        ConditionalFlow flow = new ConditionalFlow(AbstractAnalysisEngine.sourcePosition(node), declaredType, (TypeFlow<?>)condition.get(), (TypeFlow<?>)trueValue.get(), (TypeFlow<?>)falseValue.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    });
                    result.addObserverDependency(condition);
                    result.addUseDependency(trueValue);
                    result.addUseDependency(falseValue);
                } else if (node instanceof IntegerEqualsNode) {
                    IntegerEqualsNode equalsNode = (IntegerEqualsNode)node;
                    TypeFlowBuilder<?> x = this.lookup(equalsNode.getX());
                    TypeFlowBuilder<?> y = this.lookup(equalsNode.getY());
                    AnalysisType type = MethodTypeFlowBuilder.this.getNodeType((ValueNode)equalsNode);
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, BooleanPrimitiveCheckTypeFlow.class, () -> {
                        BooleanPrimitiveCheckTypeFlow flow = new BooleanPrimitiveCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type, (TypeFlow<?>)x.get(), (TypeFlow<?>)y.get(), PrimitiveComparison.EQ, false);
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    });
                    result.addUseDependency(x);
                    result.addUseDependency(y);
                } else if (node instanceof IntegerLowerThanNode) {
                    IntegerLowerThanNode lowerThan = (IntegerLowerThanNode)node;
                    TypeFlowBuilder<?> x = this.lookup(lowerThan.getX());
                    TypeFlowBuilder<?> y = this.lookup(lowerThan.getY());
                    boolean isUnsigned = lowerThan instanceof IntegerBelowNode;
                    AnalysisType type = MethodTypeFlowBuilder.this.getNodeType((ValueNode)lowerThan);
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, BooleanPrimitiveCheckTypeFlow.class, () -> {
                        BooleanPrimitiveCheckTypeFlow flow = new BooleanPrimitiveCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type, (TypeFlow<?>)x.get(), (TypeFlow<?>)y.get(), PrimitiveComparison.LT, isUnsigned);
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    });
                    result.addUseDependency(x);
                    result.addUseDependency(y);
                } else if (node instanceof IsNullNode) {
                    IsNullNode isNull = (IsNullNode)node;
                    ValueNode object = isNull.getValue();
                    TypeFlowBuilder<?> inputBuilder = this.lookup(object);
                    AnalysisType type = MethodTypeFlowBuilder.this.getNodeType((ValueNode)isNull);
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, BooleanNullCheckTypeFlow.class, () -> {
                        BooleanNullCheckTypeFlow flow = new BooleanNullCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type);
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    });
                    result.addUseDependency(inputBuilder);
                } else if (node instanceof InstanceOfNode) {
                    InstanceOfNode instanceOf = (InstanceOfNode)node;
                    ValueNode object = instanceOf.getValue();
                    TypeReference typeReference = instanceOf.type();
                    AnalysisType type = (AnalysisType)instanceOf.type().getType();
                    TypeFlowBuilder<?> objectBuilder = this.lookup(object);
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, BooleanInstanceOfCheckTypeFlow.class, () -> {
                        BooleanInstanceOfCheckTypeFlow flow = new BooleanInstanceOfCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type, typeReference.isExact(), instanceOf.allowsNull(), MethodTypeFlowBuilder.this.bb.getLongType());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    });
                    result.addUseDependency(objectBuilder);
                } else if (node instanceof ConstantNode && node.asJavaConstant().isNull()) {
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, ConstantTypeFlow.class, () -> {
                        ConstantTypeFlow constantSource = new ConstantTypeFlow(AbstractAnalysisEngine.sourcePosition(node), null, TypeState.forNull());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(constantSource);
                        return constantSource;
                    });
                } else if (node instanceof ConstantNode && node.asJavaConstant().getJavaKind() == JavaKind.Object) {
                    assert (StampTool.isExactType((ValueNode)node)) : node;
                    AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, ConstantTypeFlow.class, () -> {
                        JavaConstant constantValue = node.asJavaConstant();
                        BytecodePosition position = AbstractAnalysisEngine.sourcePosition(node);
                        ImageHeapConstant heapConstant = MethodTypeFlowBuilder.this.bb.getUniverse().getHeapScanner().toImageHeapObject(constantValue, new ObjectScanner.EmbeddedRootScan(position, constantValue));
                        ConstantTypeFlow constantSource = new ConstantTypeFlow(position, type, TypeState.forConstant(MethodTypeFlowBuilder.this.bb, heapConstant, type));
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(constantSource);
                        return constantSource;
                    });
                } else if (s instanceof IntegerStamp) {
                    IntegerStamp stamp = (IntegerStamp)s;
                    result = this.handleIntegerStamp(stamp, node);
                } else if (s instanceof ObjectStamp) {
                    ObjectStamp stamp = (ObjectStamp)s;
                    result = this.handleObjectStamp(stamp, node);
                } else {
                    assert (s instanceof VoidStamp) : "The only remaining case should be a void stamp: " + String.valueOf(s);
                    assert (node instanceof ClassIsArrayNode || node instanceof ClassIsAssignableFromNode || node instanceof ShortCircuitOrNode || node instanceof ObjectEqualsNode || node instanceof FloatEqualsNode || node instanceof FloatLessThanNode || node instanceof IntegerTestNode || node instanceof InstanceOfDynamicNode || node instanceof ObjectIsArrayNode) : "Unsupported combination of stamp " + String.valueOf(s) + ", node " + String.valueOf(node) + ", class " + node.getClass().getName();
                    AnalysisType type = MethodTypeFlowBuilder.this.getNodeType(node);
                    result = this.getPredicate() != null ? TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, AnyPrimitiveSourceTypeFlow.class, () -> {
                        AnyPrimitiveSourceTypeFlow flow = new AnyPrimitiveSourceTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type);
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    }) : MethodTypeFlowBuilder.this.anyPrimitiveSourceTypeFlowBuilder;
                }
                this.flows.put(node, result);
            }
            return result;
        }

        @Override
        public void addInvoke(ValueNode invoke, TypeFlowBuilder<InvokeTypeFlow> invokeBuilder) {
            this.invokes.put(invoke, invokeBuilder);
        }

        @Override
        public TypeFlowBuilder<InvokeTypeFlow> getInvoke(ValueNode invoke) {
            return this.invokes.get(invoke);
        }

        @Override
        public boolean merge(AbstractMergeNode merge, List<TypeFlowsOfNodes> withStates) {
            for (AbstractEndNode end : merge.forwardEnds()) {
                if (MethodTypeFlowBuilder.this.processedNodes.contains((Node)end)) continue;
                return false;
            }
            TypeFlowBuilder<?> oldPredicate = this.getPredicate();
            if (!withStates.isEmpty()) {
                ArrayList predicates = new ArrayList();
                predicates.add(this.getPredicate());
                for (TypeFlowsOfNodes other : withStates) {
                    if (other.getPredicate() == null) break;
                    predicates.add(other.getPredicate());
                }
                if (predicates.size() == withStates.size() + 1) {
                    assert (predicates.size() > 1) : "PredMerge with 1 input is not necessary, just reuse the input.";
                    TypeFlowBuilder<PredicateMergeFlow> predicateMergeFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, predicates, merge, PredicateMergeFlow.class, () -> {
                        PredicateMergeFlow flow = new PredicateMergeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)merge));
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    });
                    this.setPredicate(predicateMergeFlow);
                } else {
                    this.setPredicate(MethodTypeFlowBuilder.this.alwaysEnabled);
                }
            }
            assert (this.getPredicate() != null) : "Each merge should have a predicate.";
            Iterator iterator = this.flows.entrySet().iterator();
            block2: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Node node = (Node)entry.getKey();
                TypeFlowBuilder<?> oldFlow = (TypeFlowBuilder<?>)entry.getValue();
                if (this.shouldAddAnchorFlow(oldFlow, oldPredicate)) {
                    oldFlow = this.anchorFlow(merge, oldPredicate, oldFlow);
                }
                TypeFlowBuilder<Object> newFlow = oldFlow;
                for (TypeFlowsOfNodes other : withStates) {
                    TypeFlowBuilder<?> mergeFlow = other.flows.get(node);
                    if (mergeFlow == null) {
                        iterator.remove();
                        continue block2;
                    }
                    if (mergeFlow == newFlow) continue;
                    if (newFlow == oldFlow) {
                        TypeFlowBuilder<?> m = mergeFlow;
                        newFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), merge, MergeTypeFlow.class, () -> {
                            MergeTypeFlow newMergeFlow = new MergeTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)merge), ((TypeFlow)m.get()).getDeclaredType());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newMergeFlow);
                            return newMergeFlow;
                        });
                        newFlow.addUseDependency(oldFlow);
                        entry.setValue(newFlow);
                    }
                    if (this.shouldAddAnchorFlow(mergeFlow, other.getPredicate())) {
                        mergeFlow = this.anchorFlow(merge, other.getPredicate(), mergeFlow);
                    }
                    newFlow.addUseDependency(mergeFlow);
                }
            }
            return true;
        }

        private boolean shouldAddAnchorFlow(TypeFlowBuilder<?> flow, TypeFlowBuilder<?> branchPredicate) {
            if (!(branchPredicate.getFlowClass() != PredicateMergeFlow.class && branchPredicate.getFlowClass() != ActualReturnTypeFlow.class || flow.getFlowClass() != FilterTypeFlow.class && flow.getFlowClass() != NullCheckTypeFlow.class && flow.getFlowClass() != PrimitiveFilterTypeFlow.class)) {
                return flow.getPredicate() != branchPredicate;
            }
            return false;
        }

        private TypeFlowBuilder<?> anchorFlow(AbstractMergeNode merge, TypeFlowBuilder<?> currentPredicate, TypeFlowBuilder<?> oldFlow) {
            TypeFlowBuilder<LocalAnchorFlow> anchorFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, currentPredicate, merge, LocalAnchorFlow.class, () -> {
                LocalAnchorFlow flow = new LocalAnchorFlow(AbstractAnalysisEngine.syntheticSourcePosition((Node)merge, MethodTypeFlowBuilder.this.method), ((TypeFlow)oldFlow.get()).declaredType);
                MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                return flow;
            });
            anchorFlow.addUseDependency(oldFlow);
            return anchorFlow;
        }

        public void loopEnds(LoopBeginNode loopBegin, List<TypeFlowsOfNodes> loopEndStates) {
            for (ValuePhiNode phi : loopBegin.valuePhis()) {
                if (!MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(phi.getStackKind())) continue;
                TypeFlowBuilder<?> mergeFlow = MethodTypeFlowBuilder.this.loopPhiFlows.get(phi);
                for (int i = 0; i < loopEndStates.size(); ++i) {
                    ValueNode valueNode = phi.valueAt(i + 1);
                    TypeFlowBuilder<?> x = loopEndStates.get(i).lookup(valueNode);
                    mergeFlow.addUseDependency(x);
                }
                this.update((ValueNode)phi, mergeFlow);
            }
        }

        @Override
        @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="TypeFlowsOfNodes uses the clone method in a non-standard way.")
        public TypeFlowsOfNodes clone() {
            return new TypeFlowsOfNodesWithPredicates(this);
        }

        @Override
        public void setPredicate(TypeFlowBuilder<?> predicate) {
            this.predicate = predicate;
        }

        @Override
        public TypeFlowBuilder<?> getPredicate() {
            return this.predicate;
        }

        @Override
        public boolean usePredicates() {
            return true;
        }
    }

    protected class TypeFlowsOfNodes
    extends MergeableState<TypeFlowsOfNodes>
    implements Cloneable {
        protected final Map<Node, TypeFlowBuilder<?>> flows;

        TypeFlowsOfNodes() {
            this.flows = new HashMap();
        }

        protected TypeFlowsOfNodes(TypeFlowsOfNodes copyFrom) {
            this.flows = new HashMap(copyFrom.flows);
        }

        public boolean contains(ValueNode node) {
            return this.flows.containsKey(MethodTypeFlowBuilder.this.typeFlowUnproxify(node));
        }

        public TypeFlowBuilder<?> lookupOrAny(ValueNode n, JavaKind kind) {
            if (n != null) {
                return this.lookup(n);
            }
            if (kind == JavaKind.Int || kind == JavaKind.Long) {
                return MethodTypeFlowBuilder.this.anyPrimitiveSourceTypeFlowBuilder;
            }
            throw AnalysisError.shouldNotReachHere("Unimplemented kind: " + String.valueOf(kind));
        }

        public TypeFlowBuilder<?> lookup(ValueNode n) {
            ValueNode node = MethodTypeFlowBuilder.this.typeFlowUnproxify(n);
            TypeFlowBuilder<?> result = this.flows.get(node);
            if (result == null) {
                Stamp s = n.stamp(NodeView.DEFAULT);
                if (s instanceof IntegerStamp) {
                    IntegerStamp stamp = (IntegerStamp)s;
                    result = this.handleIntegerStamp(stamp, node);
                } else if (s instanceof ObjectStamp) {
                    ObjectStamp stamp = (ObjectStamp)s;
                    result = this.handleObjectStamp(stamp, node);
                } else {
                    AnalysisError.shouldNotReachHere("Unsupported stamp " + String.valueOf(s) + ", node " + String.valueOf(node) + ", class " + node.getClass().getName());
                }
                this.flows.put((Node)node, result);
            }
            return result;
        }

        protected TypeFlowBuilder<?> handleObjectStamp(ObjectStamp stamp, ValueNode node) {
            if (stamp.isEmpty()) {
                throw AnalysisError.shouldNotReachHere("Stamp for node " + String.valueOf(node) + " is empty.");
            }
            AnalysisType stampType = (AnalysisType)StampTool.typeOrNull((Stamp)stamp, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
            BytecodePosition position = AbstractAnalysisEngine.sourcePosition(node);
            if (stamp.isExactType()) {
                return TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, SourceTypeFlow.class, () -> {
                    SourceTypeFlow src = new SourceTypeFlow(position, stampType, !stamp.nonNull());
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(src);
                    return src;
                });
            }
            TypeFlowBuilder<?> predicate = this.getPredicate();
            return TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, predicate, node, TypeFlow.class, () -> {
                TypeFlow<?> proxy = MethodTypeFlowBuilder.this.bb.analysisPolicy().proxy(position, stampType.getTypeFlow(MethodTypeFlowBuilder.this.bb, true));
                MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(proxy);
                return MethodTypeFlowBuilder.this.maybePatchAllInstantiated(proxy, position, stampType, predicate);
            });
        }

        protected TypeFlowBuilder<?> handleIntegerStamp(IntegerStamp stamp, ValueNode node) {
            long hi;
            AnalysisType type = MethodTypeFlowBuilder.this.getNodeType(node);
            long lo = stamp.lowerBound();
            if (lo == (hi = stamp.upperBound())) {
                return TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, ConstantPrimitiveSourceTypeFlow.class, () -> {
                    ConstantPrimitiveSourceTypeFlow flow = new ConstantPrimitiveSourceTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type, TypeState.forPrimitiveConstant(MethodTypeFlowBuilder.this.bb, lo));
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                    return flow;
                });
            }
            if (this.getPredicate() != MethodTypeFlowBuilder.this.alwaysEnabled) {
                return TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, this.getPredicate(), node, AnyPrimitiveSourceTypeFlow.class, () -> {
                    AnyPrimitiveSourceTypeFlow flow = new AnyPrimitiveSourceTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                    return flow;
                });
            }
            return MethodTypeFlowBuilder.this.anyPrimitiveSourceTypeFlowBuilder;
        }

        public void add(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (!this.contains(node)) : node;
            this.flows.put((Node)MethodTypeFlowBuilder.this.typeFlowUnproxify(node), flow);
        }

        public void update(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (this.contains(node)) : node;
            this.flows.put((Node)MethodTypeFlowBuilder.this.typeFlowUnproxify(node), flow);
        }

        public boolean merge(AbstractMergeNode merge, List<TypeFlowsOfNodes> withStates) {
            for (AbstractEndNode end : merge.forwardEnds()) {
                if (MethodTypeFlowBuilder.this.processedNodes.contains((Node)end)) continue;
                return false;
            }
            Iterator<Map.Entry<Node, TypeFlowBuilder<?>>> iterator = this.flows.entrySet().iterator();
            block1: while (iterator.hasNext()) {
                Map.Entry<Node, TypeFlowBuilder<?>> entry = iterator.next();
                Node node = entry.getKey();
                TypeFlowBuilder<?> oldFlow = entry.getValue();
                TypeFlowBuilder<Object> newFlow = oldFlow;
                for (TypeFlowsOfNodes other : withStates) {
                    TypeFlowBuilder<?> mergeFlow = other.flows.get(node);
                    if (mergeFlow == null) {
                        iterator.remove();
                        continue block1;
                    }
                    if (mergeFlow == newFlow) continue;
                    if (newFlow == oldFlow) {
                        newFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, null, merge, MergeTypeFlow.class, () -> {
                            MergeTypeFlow newMergeFlow = new MergeTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)merge), ((TypeFlow)mergeFlow.get()).getDeclaredType());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newMergeFlow);
                            return newMergeFlow;
                        });
                        newFlow.addUseDependency(oldFlow);
                        entry.setValue(newFlow);
                    }
                    newFlow.addUseDependency(mergeFlow);
                }
            }
            return true;
        }

        @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="TypeFlowsOfNodes uses the clone method in a non-standard way.")
        public TypeFlowsOfNodes clone() {
            return new TypeFlowsOfNodes(this);
        }

        public void setPredicate(TypeFlowBuilder<?> predicate) {
        }

        public TypeFlowBuilder<?> getPredicate() {
            return null;
        }

        public boolean usePredicates() {
            return false;
        }

        public void addInvoke(ValueNode invoke, TypeFlowBuilder<InvokeTypeFlow> invokeBuilder) {
        }

        public TypeFlowBuilder<InvokeTypeFlow> getInvoke(ValueNode invoke) {
            return null;
        }
    }

    class NodeIterator
    extends PostOrderNodeIterator<TypeFlowsOfNodes> {
        private TypeFlowBuilder<?> returnBuilder;

        NodeIterator(FixedNode start, TypeFlowsOfNodes typeFlows) {
            super(start, (MergeableState)typeFlows);
            this.returnBuilder = null;
        }

        private TypeFlowBuilder<?> uniqueReturnFlowBuilder(ReturnNode node) {
            AnalysisType returnType;
            if (this.returnBuilder == null && (MethodTypeFlowBuilder.this.bb.isSupportedJavaKind((returnType = (AnalysisType)MethodTypeFlowBuilder.this.method.getSignature().getReturnType()).getJavaKind()) || ((TypeFlowsOfNodes)this.state).usePredicates() && returnType.getJavaKind() == JavaKind.Void)) {
                this.returnBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, MethodTypeFlowBuilder.this.alwaysEnabled, node, FormalReturnTypeFlow.class, () -> {
                    FormalReturnTypeFlow returnFlow = MethodTypeFlowBuilder.this.flowsGraph.getReturnFlow();
                    if (returnFlow != null) {
                        returnFlow.updateSource(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                    } else {
                        assert (MethodTypeFlowBuilder.this.newFlowsGraph) : "missing flow from original graph " + String.valueOf(returnFlow);
                        returnFlow = new FormalReturnTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), returnType);
                        MethodTypeFlowBuilder.this.flowsGraph.setReturnFlow(returnFlow);
                    }
                    return returnFlow;
                });
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(this.returnBuilder);
            }
            return this.returnBuilder;
        }

        private void handleCompareNode(ValueNode source, CompareNode condition, PrimitiveComparison comparison, boolean isUnsigned) {
            PrimitiveComparison maybeFlipped;
            ValueNode xNode = MethodTypeFlowBuilder.this.typeFlowUnproxify(condition.getX());
            ValueNode yNode = MethodTypeFlowBuilder.this.typeFlowUnproxify(condition.getY());
            if (xNode.isConstant() && !yNode.isConstant()) {
                ValueNode tmp = xNode;
                xNode = yNode;
                yNode = tmp;
                maybeFlipped = comparison.flip();
            } else {
                maybeFlipped = comparison;
            }
            TypeFlowBuilder<?> xFlow = ((TypeFlowsOfNodes)this.state).lookup(xNode);
            if (yNode.isConstant()) {
                TypeState rightState = TypeState.forPrimitiveConstant(MethodTypeFlowBuilder.this.bb, yNode.asJavaConstant().asLong());
                TypeFlowBuilder<PrimitiveFilterTypeFlow> builder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), source, PrimitiveFilterTypeFlow.class, () -> {
                    PrimitiveFilterTypeFlow.ConstantFilter flow = new PrimitiveFilterTypeFlow.ConstantFilter(AbstractAnalysisEngine.sourcePosition(source), ((TypeFlow)xFlow.get()).declaredType, (TypeFlow<?>)xFlow.get(), rightState, maybeFlipped, isUnsigned);
                    MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)source, flow);
                    return flow;
                });
                builder.addUseDependency(xFlow);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(builder);
                ((TypeFlowsOfNodes)this.state).update(xNode, builder);
                ((TypeFlowsOfNodes)this.state).setPredicate(builder);
            } else {
                TypeFlowBuilder<?> yFlow = ((TypeFlowsOfNodes)this.state).lookup(yNode);
                TypeFlowBuilder<PrimitiveFilterTypeFlow> leftFlowBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), source, PrimitiveFilterTypeFlow.class, () -> {
                    PrimitiveFilterTypeFlow.VariableFilter flow = new PrimitiveFilterTypeFlow.VariableFilter(AbstractAnalysisEngine.sourcePosition(source), ((TypeFlow)xFlow.get()).declaredType, (TypeFlow<?>)xFlow.get(), (TypeFlow<?>)yFlow.get(), maybeFlipped, isUnsigned);
                    MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)source, flow);
                    return flow;
                });
                leftFlowBuilder.addUseDependency(xFlow);
                leftFlowBuilder.addUseDependency(yFlow);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(leftFlowBuilder);
                ((TypeFlowsOfNodes)this.state).update(xNode, leftFlowBuilder);
                ((TypeFlowsOfNodes)this.state).setPredicate(leftFlowBuilder);
                TypeFlowBuilder<PrimitiveFilterTypeFlow> rightFlowBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), source, PrimitiveFilterTypeFlow.class, () -> {
                    PrimitiveFilterTypeFlow.VariableFilter flow = new PrimitiveFilterTypeFlow.VariableFilter(AbstractAnalysisEngine.sourcePosition(source), ((TypeFlow)yFlow.get()).declaredType, (TypeFlow<?>)yFlow.get(), (TypeFlow<?>)xFlow.get(), maybeFlipped.flip(), isUnsigned);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                    return flow;
                });
                rightFlowBuilder.addUseDependency(yFlow);
                rightFlowBuilder.addUseDependency(xFlow);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(rightFlowBuilder);
                ((TypeFlowsOfNodes)this.state).update(yNode, rightFlowBuilder);
                ((TypeFlowsOfNodes)this.state).setPredicate(rightFlowBuilder);
            }
        }

        private void handleUnaryOpLogicNode(UnaryOpLogicNode condition, TypeFlowBuilder<?> builder) {
            ValueNode object = condition.getValue();
            TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
            builder.addUseDependency(inputBuilder);
            MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(builder);
            ((TypeFlowsOfNodes)this.state).update(object, builder);
            ((TypeFlowsOfNodes)this.state).setPredicate(builder);
        }

        private void handleCondition(ValueNode source, LogicNode condition, boolean isTrue) {
            if (((TypeFlowsOfNodes)this.state).usePredicates()) {
                if (condition instanceof IntegerLowerThanNode) {
                    IntegerLowerThanNode lowerThan = (IntegerLowerThanNode)condition;
                    boolean isUnsigned = lowerThan instanceof IntegerBelowNode;
                    this.handleCompareNode(source, (CompareNode)lowerThan, isTrue ? PrimitiveComparison.LT : PrimitiveComparison.GE, isUnsigned);
                } else if (condition instanceof IntegerEqualsNode) {
                    IntegerEqualsNode equalsNode = (IntegerEqualsNode)condition;
                    this.handleCompareNode(source, (CompareNode)equalsNode, isTrue ? PrimitiveComparison.EQ : PrimitiveComparison.NEQ, false);
                }
            }
            if (condition instanceof IsNullNode) {
                IsNullNode nullCheck = (IsNullNode)condition;
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(nullCheck.getValue());
                TypeFlowBuilder<NullCheckTypeFlow> nullCheckBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), source, NullCheckTypeFlow.class, () -> {
                    NullCheckTypeFlow nullCheckFlow = new NullCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(source), ((TypeFlow)inputBuilder.get()).getDeclaredType(), !isTrue);
                    MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)source, nullCheckFlow);
                    return nullCheckFlow;
                });
                this.handleUnaryOpLogicNode((UnaryOpLogicNode)nullCheck, nullCheckBuilder);
            } else if (condition instanceof InstanceOfNode) {
                InstanceOfNode instanceOf = (InstanceOfNode)condition;
                TypeReference typeReference = instanceOf.type();
                AnalysisType type = (AnalysisType)instanceOf.type().getType();
                TypeFlowBuilder<FilterTypeFlow> filterBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), source, FilterTypeFlow.class, () -> {
                    FilterTypeFlow filterFlow = new FilterTypeFlow(AbstractAnalysisEngine.sourcePosition(source), type, typeReference.isExact(), isTrue, !isTrue ^ instanceOf.allowsNull());
                    MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)source, filterFlow);
                    return filterFlow;
                });
                this.handleUnaryOpLogicNode((UnaryOpLogicNode)instanceOf, filterBuilder);
            }
        }

        protected void node(FixedNode n) {
            MethodTypeFlowBuilder.this.processedNodes.mark((Node)n);
            if (MethodTypeFlowBuilder.this.delegateNodeProcessing(n, (TypeFlowsOfNodes)this.state)) {
                return;
            }
            if (n instanceof LoopEndNode) {
                LoopEndNode end = (LoopEndNode)n;
                LoopBeginNode merge = end.loopBegin();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (!MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(phi.getStackKind())) continue;
                    MethodTypeFlowBuilder.this.loopPhiFlows.get(phi).addUseDependency(((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof LoopBeginNode) {
                LoopBeginNode merge = (LoopBeginNode)n;
                for (PhiNode phi : merge.phis()) {
                    if (!MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(phi.getStackKind())) continue;
                    TypeFlowBuilder<MergeTypeFlow> newFlowBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), merge, MergeTypeFlow.class, () -> {
                        MergeTypeFlow newFlow = new MergeTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)merge), MethodTypeFlowBuilder.this.getNodeType((ValueNode)phi));
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newFlow);
                        return newFlow;
                    });
                    newFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup((ValueNode)phi));
                    ((TypeFlowsOfNodes)this.state).update((ValueNode)phi, newFlowBuilder);
                    if (MethodTypeFlowBuilder.this.loopPhiFlows == null) {
                        MethodTypeFlowBuilder.this.loopPhiFlows = new HashMap();
                    }
                    MethodTypeFlowBuilder.this.loopPhiFlows.put(phi, newFlowBuilder);
                }
            } else if (n instanceof EndNode) {
                EndNode end = (EndNode)n;
                AbstractMergeNode merge = end.merge();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (!MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(phi.getStackKind())) continue;
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)phi, ((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof ExceptionObjectNode) {
                ExceptionObjectNode node = (ExceptionObjectNode)n;
                Node predIdx = n.predecessor();
                if (predIdx instanceof Invoke) {
                    Invoke invoke = (Invoke)predIdx;
                    TypeFlowBuilder<InvokeTypeFlow> invokeBuilder = ((TypeFlowsOfNodes)this.state).getInvoke((ValueNode)invoke.asFixedNode());
                    ((TypeFlowsOfNodes)this.state).setPredicate(invokeBuilder != null ? (TypeFlowBuilder<?>)invokeBuilder.getPredicate() : MethodTypeFlowBuilder.this.alwaysEnabled);
                } else {
                    ((TypeFlowsOfNodes)this.state).setPredicate(MethodTypeFlowBuilder.this.alwaysEnabled);
                }
                TypeFlowBuilder<?> predicate = ((TypeFlowsOfNodes)this.state).getPredicate();
                TypeFlowBuilder<TypeFlow> exceptionObjectBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, predicate, node, TypeFlow.class, () -> {
                    AnalysisType analysisType = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    TypeFlow<?> input = analysisType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false);
                    BytecodePosition position = AbstractAnalysisEngine.sourcePosition((ValueNode)node);
                    TypeFlow<?> exceptionObjectFlow = MethodTypeFlowBuilder.this.bb.analysisPolicy().proxy(position, input);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(exceptionObjectFlow);
                    return MethodTypeFlowBuilder.this.maybePatchAllInstantiated(exceptionObjectFlow, position, analysisType, predicate);
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, exceptionObjectBuilder);
            } else if (n instanceof AbstractBeginNode) {
                AbstractBeginNode node = (AbstractBeginNode)n;
                Node exceptionObjectBuilder = node.predecessor();
                if (exceptionObjectBuilder instanceof IfNode) {
                    IfNode ifNode = (IfNode)exceptionObjectBuilder;
                    this.handleCondition((ValueNode)node, ifNode.condition(), node == ifNode.trueSuccessor());
                }
            } else if (n instanceof FixedGuardNode) {
                FixedGuardNode node = (FixedGuardNode)n;
                this.handleCondition((ValueNode)node, node.condition(), !node.isNegated());
            } else if (n instanceof ReturnNode) {
                ReturnNode node = (ReturnNode)n;
                if (!MethodTypeFlowBuilder.this.method.hasOpaqueReturn()) {
                    if (node.result() != null && MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(node.result().getStackKind())) {
                        TypeFlowBuilder<?> returnFlowBuilder = this.uniqueReturnFlowBuilder(node);
                        returnFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup(node.result()));
                    } else if (((TypeFlowsOfNodes)this.state).usePredicates() && ((AnalysisType)MethodTypeFlowBuilder.this.method.getSignature().getReturnType()).getJavaKind() == JavaKind.Void) {
                        TypeFlowBuilder<?> returnFlowBuilder = this.uniqueReturnFlowBuilder(node);
                        returnFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).getPredicate());
                    }
                }
            } else if (n instanceof CommitAllocationNode) {
                MethodTypeFlowBuilder.this.processCommitAllocation((CommitAllocationNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof NewInstanceNode) {
                MethodTypeFlowBuilder.this.processNewInstance((NewInstanceNode)n, (TypeFlowsOfNodes)this.state, true);
            } else if (n instanceof DynamicNewInstanceNode) {
                TypeFlowBuilder<Object> instanceTypeBuilder;
                AnalysisType instanceType;
                DynamicNewInstanceNode node = (DynamicNewInstanceNode)n;
                ValueNode instanceTypeNode = node.getInstanceType();
                if (instanceTypeNode instanceof GetClassNode) {
                    GetClassNode getClassNode = (GetClassNode)instanceTypeNode;
                    ValueNode getClassReceiver = getClassNode.getObject();
                    instanceType = (AnalysisType)StampTool.typeOrNull((ValueNode)getClassReceiver, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    instanceTypeBuilder = ((TypeFlowsOfNodes)this.state).lookup(getClassReceiver);
                } else {
                    instanceType = MethodTypeFlowBuilder.this.bb.getObjectType();
                    TypeFlowBuilder<?> predicate = ((TypeFlowsOfNodes)this.state).getPredicate();
                    instanceTypeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, predicate, instanceType, TypeFlow.class, () -> MethodTypeFlowBuilder.this.maybePatchAllInstantiated(instanceType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false), AbstractAnalysisEngine.sourcePosition((ValueNode)node), instanceType, predicate));
                }
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewInstanceBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newInstanceTypeFlow = new DynamicNewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), (TypeFlow<?>)instanceTypeBuilder.get(), instanceType);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newInstanceTypeFlow);
                    return newInstanceTypeFlow;
                });
                dynamicNewInstanceBuilder.addObserverDependency(instanceTypeBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewInstanceBuilder);
            } else if (n instanceof NewArrayNode) {
                MethodTypeFlowBuilder.this.processNewArray((NewArrayNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof DynamicNewArrayNode) {
                DynamicNewArrayNode node = (DynamicNewArrayNode)n;
                AnalysisType arrayType = MethodTypeFlowBuilder.this.bb.getObjectType();
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newArrayTypeFlow = new DynamicNewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), arrayType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false), arrayType);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newArrayTypeFlow);
                    return newArrayTypeFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewArrayBuilder);
            } else if (n instanceof NewMultiArrayNode) {
                NewMultiArrayNode node = (NewMultiArrayNode)n;
                AnalysisType type = (AnalysisType)node.type();
                assert (type.isInstantiated()) : type;
                TypeFlowBuilder<NewInstanceTypeFlow> newArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), node, NewInstanceTypeFlow.class, () -> {
                    NewInstanceTypeFlow newArray = new NewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), type, true);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newArray);
                    return newArray;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, newArrayBuilder);
            } else if (n instanceof LoadFieldNode) {
                LoadFieldNode node = (LoadFieldNode)n;
                MethodTypeFlowBuilder.this.processLoadField((ValueNode)node, (AnalysisField)node.field(), node.object(), (TypeFlowsOfNodes)this.state);
                if (node.object() != null) {
                    MethodTypeFlowBuilder.this.processImplicitNonNull(node.object(), (TypeFlowsOfNodes)this.state);
                }
            } else if (n instanceof StoreFieldNode) {
                StoreFieldNode node = (StoreFieldNode)n;
                MethodTypeFlowBuilder.this.processStoreField((ValueNode)node, (AnalysisField)node.field(), node.object(), node.value(), node.value().getStackKind(), (TypeFlowsOfNodes)this.state);
                if (node.object() != null) {
                    MethodTypeFlowBuilder.this.processImplicitNonNull(node.object(), (TypeFlowsOfNodes)this.state);
                }
            } else if (n instanceof LoadIndexedNode) {
                LoadIndexedNode node = (LoadIndexedNode)n;
                MethodTypeFlowBuilder.this.processLoadIndexed((ValueNode)node, node.array(), (TypeFlowsOfNodes)this.state);
                MethodTypeFlowBuilder.this.processImplicitNonNull(node.array(), (TypeFlowsOfNodes)this.state);
            } else if (n instanceof StoreIndexedNode) {
                StoreIndexedNode node = (StoreIndexedNode)n;
                MethodTypeFlowBuilder.this.processStoreIndexed((ValueNode)node, node.array(), node.value(), node.value().getStackKind(), (TypeFlowsOfNodes)this.state);
                MethodTypeFlowBuilder.this.processImplicitNonNull(node.array(), (TypeFlowsOfNodes)this.state);
            } else if (n instanceof RawLoadNode) {
                RawLoadNode node = (RawLoadNode)n;
                this.modelUnsafeReadOnlyFlow(node, node.object(), node.offset());
            } else if (n instanceof RawStoreNode) {
                RawStoreNode node = (RawStoreNode)n;
                this.modelUnsafeWriteOnlyFlow((ValueNode)node, node.object(), node.value(), node.value().getStackKind(), node.offset());
            } else if (n instanceof UnsafeCompareAndSwapNode) {
                UnsafeCompareAndSwapNode node = (UnsafeCompareAndSwapNode)n;
                this.modelUnsafeWriteOnlyFlow((ValueNode)node, node.object(), node.newValue(), node.newValue().getStackKind(), node.offset());
            } else if (n instanceof UnsafeCompareAndExchangeNode) {
                UnsafeCompareAndExchangeNode node = (UnsafeCompareAndExchangeNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.newValue().getStackKind(), node.offset());
            } else if (n instanceof AtomicReadAndWriteNode) {
                AtomicReadAndWriteNode node = (AtomicReadAndWriteNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.newValue().getStackKind(), node.offset());
            } else if (n instanceof AtomicReadAndAddNode) {
                AtomicReadAndAddNode node = (AtomicReadAndAddNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), null, node.offset().getStackKind(), node.offset());
            } else if (n instanceof BasicArrayCopyNode) {
                TypeFlowBuilder<?> dstBuilder;
                BasicArrayCopyNode node = (BasicArrayCopyNode)n;
                TypeFlowBuilder<?> srcBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getSource());
                if (srcBuilder != (dstBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getDestination()))) {
                    AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node.asNode(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    TypeFlowBuilder<ArrayCopyTypeFlow> arrayCopyBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), node, ArrayCopyTypeFlow.class, () -> {
                        ArrayCopyTypeFlow arrayCopyFlow = new ArrayCopyTypeFlow(AbstractAnalysisEngine.sourcePosition(node.asNode()), type, (TypeFlow<?>)srcBuilder.get(), (TypeFlow<?>)dstBuilder.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(arrayCopyFlow);
                        return arrayCopyFlow;
                    });
                    arrayCopyBuilder.addObserverDependency(srcBuilder);
                    arrayCopyBuilder.addObserverDependency(dstBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(arrayCopyBuilder);
                }
            } else if (n instanceof InvokeNode || n instanceof InvokeWithExceptionNode) {
                Invoke invoke = (Invoke)n;
                CallTargetNode dstBuilder = invoke.callTarget();
                if (dstBuilder instanceof MethodCallTargetNode) {
                    MethodCallTargetNode target = (MethodCallTargetNode)dstBuilder;
                    NodeInputList arguments = target.arguments();
                    MethodTypeFlowBuilder.this.processMethodInvocation((TypeFlowsOfNodes)this.state, invoke, target.invokeKind(), (PointsToAnalysisMethod)target.targetMethod(), (NodeInputList<ValueNode>)arguments);
                    if (target.invokeKind().hasReceiver()) {
                        MethodTypeFlowBuilder.this.processImplicitNonNull((ValueNode)arguments.get(0), invoke.asNode(), (TypeFlowsOfNodes)this.state);
                    }
                }
            } else if (n instanceof ObjectClone) {
                ObjectClone node = (ObjectClone)n;
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getObject());
                AnalysisType inputType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.getObject(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                TypeFlowBuilder<CloneTypeFlow> cloneBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, MethodTypeFlowBuilder.this.method, ((TypeFlowsOfNodes)this.state).getPredicate(), node, CloneTypeFlow.class, () -> {
                    CloneTypeFlow cloneFlow = new CloneTypeFlow(AbstractAnalysisEngine.sourcePosition(node.asNode()), inputType, (TypeFlow<?>)inputBuilder.get());
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(cloneFlow);
                    return cloneFlow;
                });
                cloneBuilder.addObserverDependency(inputBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node.asFixedNode(), cloneBuilder);
            } else if (n instanceof MacroInvokable) {
                MacroInvokable node = (MacroInvokable)n;
                MethodTypeFlowBuilder.this.processMacroInvokable((TypeFlowsOfNodes)this.state, node, true);
                if (node.getInvokeKind().hasReceiver()) {
                    MethodTypeFlowBuilder.this.processImplicitNonNull(node.getArgument(0), node.asNode(), (TypeFlowsOfNodes)this.state);
                }
            }
        }

        private void modelUnsafeReadOnlyFlow(RawLoadNode node, ValueNode object, ValueNode offset) {
            MethodTypeFlowBuilder.this.checkUnsafeOffset(object, offset);
            if (object.getStackKind() == JavaKind.Object) {
                if (offset instanceof FieldOffsetProvider) {
                    FieldOffsetProvider fieldOffsetProvider = (FieldOffsetProvider)offset;
                    MethodTypeFlowBuilder.this.processLoadField((ValueNode)node, (AnalysisField)fieldOffsetProvider.getField(), object, (TypeFlowsOfNodes)this.state);
                } else if (StampTool.isAlwaysArray((ValueNode)object)) {
                    MethodTypeFlowBuilder.this.processLoadIndexed((ValueNode)node, object, (TypeFlowsOfNodes)this.state);
                } else {
                    MethodTypeFlowBuilder.this.processUnsafeLoad((ValueNode)node, object, (TypeFlowsOfNodes)this.state);
                }
            }
        }

        private void modelUnsafeWriteOnlyFlow(ValueNode node, ValueNode object, ValueNode newValue, JavaKind newValueKind, ValueNode offset) {
            MethodTypeFlowBuilder.this.checkUnsafeOffset(object, offset);
            if (object.getStackKind() == JavaKind.Object) {
                if (offset instanceof FieldOffsetProvider) {
                    FieldOffsetProvider fieldOffsetProvider = (FieldOffsetProvider)offset;
                    MethodTypeFlowBuilder.this.processStoreField(node, (AnalysisField)fieldOffsetProvider.getField(), object, newValue, newValueKind, (TypeFlowsOfNodes)this.state);
                } else if (StampTool.isAlwaysArray((ValueNode)object)) {
                    MethodTypeFlowBuilder.this.processStoreIndexed(node, object, newValue, newValueKind, (TypeFlowsOfNodes)this.state);
                } else {
                    MethodTypeFlowBuilder.this.processUnsafeStore(node, object, newValue, newValueKind, (TypeFlowsOfNodes)this.state);
                }
            }
        }

        private void modelUnsafeReadAndWriteFlow(ValueNode node, ValueNode object, ValueNode newValue, JavaKind newValueKind, ValueNode offset) {
            MethodTypeFlowBuilder.this.checkUnsafeOffset(object, offset);
            if (object.getStackKind() == JavaKind.Object) {
                if (offset instanceof FieldOffsetProvider) {
                    FieldOffsetProvider fieldOffsetProvider = (FieldOffsetProvider)offset;
                    AnalysisField field = (AnalysisField)fieldOffsetProvider.getField();
                    MethodTypeFlowBuilder.this.processStoreField(node, field, object, newValue, newValueKind, (TypeFlowsOfNodes)this.state);
                    MethodTypeFlowBuilder.this.processLoadField(node, field, object, (TypeFlowsOfNodes)this.state);
                } else if (StampTool.isAlwaysArray((ValueNode)object)) {
                    MethodTypeFlowBuilder.this.processStoreIndexed(node, object, newValue, newValueKind, (TypeFlowsOfNodes)this.state);
                    MethodTypeFlowBuilder.this.processLoadIndexed(node, object, (TypeFlowsOfNodes)this.state);
                } else {
                    MethodTypeFlowBuilder.this.processUnsafeStore(node, object, newValue, newValueKind, (TypeFlowsOfNodes)this.state);
                    MethodTypeFlowBuilder.this.processUnsafeLoad(node, object, (TypeFlowsOfNodes)this.state);
                }
            }
        }
    }
}

