/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.PrimitiveComparison;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.AnyPrimitiveTypeState;
import com.oracle.graal.pointsto.typestate.PrimitiveConstantTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.Iterator;
import jdk.graal.compiler.core.common.calc.UnsignedMath;

public abstract sealed class PrimitiveTypeState
extends TypeState
permits PrimitiveConstantTypeState, AnyPrimitiveTypeState {
    protected PrimitiveTypeState() {
    }

    @Override
    public final boolean isPrimitive() {
        return true;
    }

    @Override
    public final boolean canBeNull() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean isAnyPrimitive() {
        return this instanceof AnyPrimitiveTypeState;
    }

    public TypeState forUnion(PrimitiveTypeState right) {
        if (this instanceof AnyPrimitiveTypeState || right instanceof AnyPrimitiveTypeState) {
            return AnyPrimitiveTypeState.SINGLETON;
        }
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState c1 = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState c2 = (PrimitiveConstantTypeState)right;
                if (c1.getValue() == c2.getValue()) {
                    return this;
                }
            }
        }
        return AnyPrimitiveTypeState.SINGLETON;
    }

    public TypeState forEquals(PrimitiveTypeState right) {
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState thisConstant = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
                if (thisConstant.getValue() != rightConstant.getValue()) {
                    return PrimitiveTypeState.forEmpty();
                }
            }
            return this;
        }
        if (this instanceof AnyPrimitiveTypeState) {
            if (right instanceof PrimitiveConstantTypeState) {
                return right;
            }
            return this;
        }
        throw AnalysisError.shouldNotReachHere("Combination not covered, this=" + String.valueOf(this) + ". right=" + String.valueOf(right));
    }

    public TypeState filter(PrimitiveComparison comparison, boolean isUnsigned, PrimitiveTypeState right) {
        PrimitiveConstantTypeState leftConstant;
        block21: {
            block20: {
                if (comparison == PrimitiveComparison.EQ) {
                    return this.forEquals(right);
                }
                PrimitiveTypeState primitiveTypeState = this;
                if (!(primitiveTypeState instanceof PrimitiveConstantTypeState)) break block20;
                leftConstant = (PrimitiveConstantTypeState)primitiveTypeState;
                if (right instanceof PrimitiveConstantTypeState) break block21;
            }
            return this;
        }
        PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
        boolean filterToEmpty = switch (comparison) {
            case PrimitiveComparison.NEQ -> {
                if (leftConstant.getValue() == rightConstant.getValue()) {
                    yield true;
                }
                yield false;
            }
            case PrimitiveComparison.LT -> {
                if (isUnsigned) {
                    yield UnsignedMath.aboveOrEqual((long)leftConstant.getValue(), (long)rightConstant.getValue());
                }
                if (leftConstant.getValue() >= rightConstant.getValue()) {
                    yield true;
                }
                yield false;
            }
            case PrimitiveComparison.GE -> {
                if (isUnsigned) {
                    yield UnsignedMath.belowThan((long)leftConstant.getValue(), (long)rightConstant.getValue());
                }
                if (leftConstant.getValue() < rightConstant.getValue()) {
                    yield true;
                }
                yield false;
            }
            case PrimitiveComparison.GT -> {
                if (isUnsigned) {
                    yield UnsignedMath.belowOrEqual((long)leftConstant.getValue(), (long)rightConstant.getValue());
                }
                if (leftConstant.getValue() <= rightConstant.getValue()) {
                    yield true;
                }
                yield false;
            }
            case PrimitiveComparison.LE -> {
                if (isUnsigned) {
                    yield UnsignedMath.aboveThan((long)leftConstant.getValue(), (long)rightConstant.getValue());
                }
                if (leftConstant.getValue() > rightConstant.getValue()) {
                    yield true;
                }
                yield false;
            }
            default -> throw AnalysisError.shouldNotReachHere("Unreachable case in switch.");
        };
        return filterToEmpty ? PrimitiveTypeState.forEmpty() : this;
    }

    public abstract boolean canBeTrue();

    public abstract boolean canBeFalse();

    public abstract String toString();

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public int typesCount() {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public AnalysisType exactType() {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    protected Iterator<AnalysisType> typesIterator(BigBang bb) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public boolean containsType(AnalysisType exactType) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public int objectsCount() {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(AnalysisType type) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean stateCanBeNull) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    private static RuntimeException shouldNotReachHere() {
        throw AnalysisError.shouldNotReachHere("This method should never be called.");
    }
}

