/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.NativeImageClassLoaderOptions;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class NativeImageClassLoaderOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(NativeImageClassLoaderOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "AddExports": {
                return OptionDescriptor.create((String)"AddExports", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Value <module>/<package>=<target-module>(,<target-module>)* updates <module> to export <package> to <target-module>, regardless of module declaration. <target-module> can be ALL-UNNAMED to export to all unnamed modules.", (Object)this.getContainer(), NativeImageClassLoaderOptions.AddExports, (String)"AddExports", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AddOpens": {
                return OptionDescriptor.create((String)"AddOpens", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Value <module>/<package>=<target-module>(,<target-module>)* updates <module> to open <package> to <target-module>, regardless of module declaration.", (Object)this.getContainer(), NativeImageClassLoaderOptions.AddOpens, (String)"AddOpens", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AddReads": {
                return OptionDescriptor.create((String)"AddReads", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Value <module>=<target-module>(,<target-module>)* updates <module> to read <target-module>, regardless of module declaration. <target-module> can be ALL-UNNAMED to read all unnamed modules.", (Object)this.getContainer(), NativeImageClassLoaderOptions.AddReads, (String)"AddReads", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableNativeAccess": {
                return OptionDescriptor.create((String)"EnableNativeAccess", (OptionType)OptionType.Debug, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"A comma-separated list of modules that are permitted to perform restricted native operations. The module name can also be ALL-UNNAMED.", (Object)this.getContainer(), NativeImageClassLoaderOptions.EnableNativeAccess, (String)"EnableNativeAccess", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ListModules": {
                return OptionDescriptor.create((String)"ListModules", (OptionType)OptionType.Debug, Boolean.class, (String)"List observable modules and exit.", (Object)this.getContainer(), NativeImageClassLoaderOptions.ListModules, (String)"ListModules", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 5;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return NativeImageClassLoaderOptions_OptionDescriptors.this.get("AddExports");
                    }
                    case 1: {
                        return NativeImageClassLoaderOptions_OptionDescriptors.this.get("AddOpens");
                    }
                    case 2: {
                        return NativeImageClassLoaderOptions_OptionDescriptors.this.get("AddReads");
                    }
                    case 3: {
                        return NativeImageClassLoaderOptions_OptionDescriptors.this.get("EnableNativeAccess");
                    }
                    case 4: {
                        return NativeImageClassLoaderOptions_OptionDescriptors.this.get("ListModules");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

