/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GreyObjectsWalker;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.Timers;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.compacting.CompactingVisitor;
import com.oracle.svm.core.genscavenge.compacting.MarkStack;
import com.oracle.svm.core.genscavenge.compacting.ObjectFixupVisitor;
import com.oracle.svm.core.genscavenge.compacting.ObjectMoveInfo;
import com.oracle.svm.core.genscavenge.compacting.ObjectRefFixupVisitor;
import com.oracle.svm.core.genscavenge.compacting.PlanningVisitor;
import com.oracle.svm.core.genscavenge.compacting.RuntimeCodeCacheFixupWalker;
import com.oracle.svm.core.genscavenge.compacting.SweepingVisitor;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalSupport;
import com.oracle.svm.core.util.Timer;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class CompactingOldGeneration
extends OldGeneration {
    private final Space space = new Space("Old", "O", false, HeapParameters.getMaxSurvivorSpaces() + 1);
    private final MarkStack markStack = new MarkStack();
    private final GreyObjectsWalker toGreyObjectsWalker = new GreyObjectsWalker();
    private final PlanningVisitor planningVisitor = new PlanningVisitor();
    private final ObjectRefFixupVisitor refFixupVisitor = new ObjectRefFixupVisitor();
    private final ObjectFixupVisitor fixupVisitor = new ObjectFixupVisitor(this.refFixupVisitor);
    private final CompactingVisitor compactingVisitor = new CompactingVisitor();
    private final SweepingVisitor sweepingVisitor = new SweepingVisitor();
    private final RuntimeCodeCacheFixupWalker runtimeCodeCacheFixupWalker = new RuntimeCodeCacheFixupWalker(this.refFixupVisitor);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    CompactingOldGeneration(String name) {
        super(name);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void beginPromotion(boolean incrementalGc) {
        if (!incrementalGc) {
            this.absorb(HeapImpl.getHeapImpl().getYoungGeneration());
        }
        this.toGreyObjectsWalker.setScanStart(this.space);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void absorb(YoungGeneration youngGen) {
        this.space.absorb(youngGen.getEden());
        for (int i = 0; i < youngGen.getMaxSurvivorSpaces(); ++i) {
            this.space.absorb(youngGen.getSurvivorFromSpaceAt(i));
            this.space.absorb(youngGen.getSurvivorToSpaceAt(i));
        }
    }

    @Override
    void appendChunk(AlignedHeapChunk.AlignedHeader hdr) {
        this.space.appendAlignedHeapChunk(hdr, null);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void blackenDirtyCardRoots(GreyToBlackObjectVisitor visitor, GreyToBlackObjRefVisitor refVisitor) {
        RememberedSet.get().walkDirtyObjects(this.space.getFirstAlignedHeapChunk(), this.space.getFirstUnalignedHeapChunk(), (UnalignedHeapChunk.UnalignedHeader)Word.nullPointer(), visitor, refVisitor, true);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean scanGreyObjects(boolean incrementalGc) {
        if (incrementalGc) {
            if (!this.toGreyObjectsWalker.haveGreyObjects()) {
                return false;
            }
            this.toGreyObjectsWalker.walkGreyObjects();
        } else {
            if (this.markStack.isEmpty()) {
                return false;
            }
            GreyToBlackObjectVisitor visitor = GCImpl.getGCImpl().getGreyToBlackObjectVisitor();
            do {
                visitor.visitObject(this.markStack.pop());
            } while (!this.markStack.isEmpty());
        }
        return true;
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object promoteAlignedObject(Object original, AlignedHeapChunk.AlignedHeader originalChunk, Space originalSpace) {
        if (!GCImpl.getGCImpl().isCompleteCollection()) {
            assert (originalSpace.isFromSpace());
            return this.space.copyAlignedObject(original, originalSpace);
        }
        assert (originalSpace == this.space);
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromObject(original);
        if (ObjectHeaderImpl.isMarkedHeader((UnsignedWord)header)) {
            return original;
        }
        Object result = original;
        if (ObjectHeaderImpl.isIdentityHashFieldOptional() && ObjectHeaderImpl.hasIdentityHashFromAddressInline(header) && !originalChunk.getShouldSweepInsteadOfCompact()) {
            result = this.space.copyAlignedObject(original, originalSpace);
            assert (!ObjectHeaderImpl.hasIdentityHashFromAddressInline(oh.readHeaderFromObject(result)));
        }
        ObjectHeaderImpl.setMarked(result);
        this.markStack.push(result);
        return result;
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Object promoteUnalignedObject(Object original, UnalignedHeapChunk.UnalignedHeader originalChunk, Space originalSpace) {
        if (!GCImpl.getGCImpl().isCompleteCollection()) {
            assert (originalSpace.isFromSpace());
            this.space.promoteUnalignedHeapChunk(originalChunk, originalSpace);
            return original;
        }
        assert (originalSpace == this.space);
        if (!ObjectHeaderImpl.isMarked(original)) {
            ObjectHeaderImpl.setMarked(original);
            this.markStack.push(original);
        }
        return original;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean promotePinnedObject(Object obj, HeapChunk.Header<?> originalChunk, boolean isAligned, Space originalSpace) {
        if (!GCImpl.getGCImpl().isCompleteCollection()) {
            assert (originalSpace != this.space && originalSpace.isFromSpace());
            if (isAligned) {
                this.space.promoteAlignedHeapChunk((AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace);
            } else {
                this.space.promoteUnalignedHeapChunk((UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace);
            }
            return true;
        }
        assert (originalSpace == this.space);
        if (ObjectHeaderImpl.isMarked(obj)) {
            assert (!isAligned || ((AlignedHeapChunk.AlignedHeader)originalChunk).getShouldSweepInsteadOfCompact());
            return true;
        }
        if (isAligned) {
            ((AlignedHeapChunk.AlignedHeader)originalChunk).setShouldSweepInsteadOfCompact(true);
        }
        ObjectHeaderImpl.setMarked(obj);
        this.markStack.push(obj);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sweepAndCompact(Timers timers, GCImpl.ChunkReleaser chunkReleaser) {
        ReferenceObjectProcessing.updateForwardedRefs();
        Timer oldPlanningTimer = timers.oldPlanning.start();
        try {
            this.planCompaction();
        }
        finally {
            oldPlanningTimer.stop();
        }
        Timer oldFixupTimer = timers.oldFixup.start();
        try {
            this.fixupReferencesBeforeCompaction(chunkReleaser, timers);
        }
        finally {
            oldFixupTimer.stop();
        }
        Timer oldCompactionTimer = timers.oldCompaction.start();
        try {
            this.compact(timers);
        }
        finally {
            oldCompactionTimer.stop();
        }
    }

    private void planCompaction() {
        this.planningVisitor.init(this.space);
        this.space.walkAlignedHeapChunks(this.planningVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Avoid unnecessary safepoint checks in GC for performance.")
    private void fixupReferencesBeforeCompaction(GCImpl.ChunkReleaser chunkReleaser, Timers timers) {
        Timer oldFixupAlignedChunksTimer = timers.oldFixupAlignedChunks.start();
        try {
            AlignedHeapChunk.AlignedHeader aChunk = this.space.getFirstAlignedHeapChunk();
            while (aChunk.isNonNull()) {
                ObjectMoveInfo.walkObjectsForFixup(aChunk, this.fixupVisitor);
                aChunk = HeapChunk.getNext(aChunk);
            }
        }
        finally {
            oldFixupAlignedChunksTimer.stop();
        }
        Timer oldFixupImageHeapTimer = timers.oldFixupImageHeap.start();
        try {
            ImageHeapInfo auxImageHeapInfo;
            for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
                this.fixupImageHeapRoots(info);
            }
            if (AuxiliaryImageHeap.isPresent() && (auxImageHeapInfo = AuxiliaryImageHeap.singleton().getImageHeapInfo()) != null) {
                this.fixupImageHeapRoots(auxImageHeapInfo);
            }
        }
        finally {
            oldFixupImageHeapTimer.stop();
        }
        Timer oldFixupThreadLocalsTimer = timers.oldFixupThreadLocals.start();
        try {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                VMThreadLocalSupport.singleton().walk(isolateThread, this.refFixupVisitor);
                isolateThread = VMThreads.nextThread(isolateThread);
            }
        }
        finally {
            oldFixupThreadLocalsTimer.stop();
        }
        Timer oldFixupStackTimer = timers.oldFixupStack.start();
        try {
            this.fixupStackReferences();
        }
        finally {
            oldFixupStackTimer.stop();
        }
        Timer oldFixupUnalignedChunksTimer = timers.oldFixupUnalignedChunks.start();
        try {
            this.fixupUnalignedChunkReferences(chunkReleaser);
        }
        finally {
            oldFixupUnalignedChunksTimer.stop();
        }
        Timer oldFixupRuntimeCodeCacheTimer = timers.oldFixupRuntimeCodeCache.start();
        try {
            if (RuntimeCompilation.isEnabled()) {
                RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheFixupWalker);
            }
        }
        finally {
            oldFixupRuntimeCodeCacheTimer.stop();
        }
    }

    @Uninterruptible(reason="Avoid unnecessary safepoint checks in GC for performance.")
    private void fixupImageHeapRoots(ImageHeapInfo info) {
        if (HeapImpl.usesImageHeapCardMarking()) {
            GCImpl.walkDirtyImageHeapChunkRoots(info, this.fixupVisitor, this.refFixupVisitor, false);
        } else {
            GCImpl.walkImageHeapRoots(info, this.fixupVisitor);
        }
    }

    @Uninterruptible(reason="Avoid unnecessary safepoint checks in GC for performance.")
    private void fixupUnalignedChunkReferences(GCImpl.ChunkReleaser chunkReleaser) {
        UnalignedHeapChunk.UnalignedHeader uChunk = this.space.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = HeapChunk.getNext(uChunk);
            Pointer objPointer = UnalignedHeapChunk.getObjectStart(uChunk);
            Object obj = objPointer.toObjectNonNull();
            if (ObjectHeaderImpl.isMarked(obj)) {
                ObjectHeaderImpl.unsetMarkedAndKeepRememberedSetBit(obj);
                RememberedSet.get().clearRememberedSet(uChunk);
                UnalignedHeapChunk.walkObjectsInline(uChunk, this.fixupVisitor);
            } else {
                this.space.extractUnalignedHeapChunk(uChunk);
                chunkReleaser.add(uChunk);
            }
            uChunk = next;
        }
    }

    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because GC stack frames must not access any objects that are processed by the GC. But we don't store stack frame information for the first frame we would need to process.")
    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.")
    private void fixupStackReferences() {
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        GCImpl.walkStackRoots(this.refFixupVisitor, sp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(Timers timers) {
        AlignedHeapChunk.AlignedHeader chunk = this.space.getFirstAlignedHeapChunk();
        while (chunk.isNonNull()) {
            if (chunk.getShouldSweepInsteadOfCompact()) {
                ObjectMoveInfo.visit(chunk, this.sweepingVisitor);
                chunk.setShouldSweepInsteadOfCompact(false);
            } else {
                this.compactingVisitor.init(chunk);
                ObjectMoveInfo.visit(chunk, this.compactingVisitor);
            }
            chunk = HeapChunk.getNext(chunk);
        }
        Timer oldCompactionRememberedSetsTimer = timers.oldCompactionRememberedSets.start();
        try {
            chunk = this.space.getFirstAlignedHeapChunk();
            while (chunk.isNonNull()) {
                if (!AlignedHeapChunk.isEmpty(chunk)) {
                    RememberedSet.get().clearRememberedSet(chunk);
                }
                chunk = HeapChunk.getNext(chunk);
            }
        }
        finally {
            oldCompactionRememberedSetsTimer.stop();
        }
    }

    @Override
    void releaseSpaces(GCImpl.ChunkReleaser chunkReleaser) {
        AlignedHeapChunk.AlignedHeader aChunk = this.space.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(aChunk);
            if (AlignedHeapChunk.isEmpty(aChunk)) {
                this.space.extractAlignedHeapChunk(aChunk);
                chunkReleaser.add(aChunk);
            }
            aChunk = next;
        }
    }

    @Override
    void swapSpaces() {
    }

    @Override
    boolean isInSpace(Pointer ptr) {
        return this.space.contains(ptr);
    }

    @Override
    boolean printLocationInfo(Log log, Pointer ptr) {
        return this.space.printLocationInfo(log, ptr);
    }

    @Override
    public void walkObjects(ObjectVisitor visitor) {
        this.space.walkObjects(visitor);
    }

    @Override
    public void logUsage(Log log) {
        this.space.logUsage(log, true);
    }

    @Override
    public void logChunks(Log log) {
        this.space.logChunks(log);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getChunkBytes() {
        return this.space.getChunkBytes();
    }

    @Override
    UnsignedWord computeObjectBytes() {
        return this.space.computeObjectBytes();
    }

    @Override
    boolean verifyRememberedSets() {
        return HeapVerifier.verifyRememberedSet(this.space);
    }

    @Override
    boolean verifySpaces() {
        return HeapVerifier.verifySpace(this.space);
    }

    @Override
    void checkSanityBeforeCollection() {
        assert (this.markStack.isEmpty());
    }

    @Override
    void checkSanityAfterCollection() {
        assert (this.markStack.isEmpty());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        this.markStack.tearDown();
        this.space.tearDown();
    }
}

