/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.heap.UninterruptibleObjectVisitor;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class GreyToBlackObjectVisitor
implements UninterruptibleObjectVisitor {
    private final GreyToBlackObjRefVisitor objRefVisitor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GreyToBlackObjectVisitor(GreyToBlackObjRefVisitor greyToBlackObjRefVisitor) {
        this.objRefVisitor = greyToBlackObjRefVisitor;
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).", callerMustBe=true)
    public void visitObject(Object o) {
        ReferenceObjectProcessing.discoverIfReference(o, this.objRefVisitor);
        InteriorObjRefWalker.walkObjectInline(o, this.objRefVisitor);
    }
}

