/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class ReferenceObjectProcessing {
    private static final UninterruptibleUtils.AtomicReference<Reference<?>> rememberedRefsList = new UninterruptibleUtils.AtomicReference();
    private static UnsignedWord maxSoftRefAccessIntervalMs = UnsignedUtils.MAX_VALUE;
    private static boolean softReferencesAreWeak = false;
    private static long initialSoftRefClock = 0L;

    private ReferenceObjectProcessing() {
    }

    public static void setSoftReferencesAreWeak(boolean enabled) {
        assert (VMOperation.isGCInProgress());
        softReferencesAreWeak = enabled;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void discoverIfReference(Object object, ObjectReferenceVisitor refVisitor) {
        assert (object != null);
        DynamicHub hub = KnownIntrinsics.readHub(object);
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)hub.isReferenceInstanceClass())) {
            ReferenceObjectProcessing.discover(object, refVisitor);
        }
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void discover(Object obj, ObjectReferenceVisitor refVisitor) {
        Reference expected;
        Reference dr = (Reference)obj;
        if (ReferenceInternals.getDiscoveredPointer(dr).isNonNull()) {
            return;
        }
        Pointer referentAddr = ReferenceInternals.getReferentPointer(dr);
        if (referentAddr.isNull()) {
            return;
        }
        if (Heap.getHeap().isInImageHeap(referentAddr)) {
            return;
        }
        if (ReferenceObjectProcessing.maybeUpdateForwardedReference(dr, referentAddr)) {
            return;
        }
        Object refObject = referentAddr.toObjectNonNull();
        if (ReferenceObjectProcessing.willSurviveThisCollection(refObject)) {
            RememberedSet.get().dirtyCardIfNecessary(dr, refObject, ReferenceInternals.getReferentFieldAddress(dr));
            return;
        }
        if (!softReferencesAreWeak && dr instanceof SoftReference) {
            UnsignedWord elapsed;
            long clock = ReferenceInternals.getSoftReferenceClock();
            long timestamp = ReferenceInternals.getSoftReferenceTimestamp((SoftReference)dr);
            if (timestamp == 0L) {
                timestamp = initialSoftRefClock;
            }
            if ((elapsed = Word.unsigned((long)(clock - timestamp))).belowThan(maxSoftRefAccessIntervalMs)) {
                int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
                refVisitor.visitObjectReferences(ReferenceInternals.getReferentFieldAddress(dr), true, referenceSize, dr, 1);
                return;
            }
        }
        do {
            ReferenceInternals.setNextDiscovered(dr, (expected = rememberedRefsList.get()) != null ? expected : dr);
        } while (!rememberedRefsList.compareAndSet(expected, dr));
    }

    static Reference<?> processRememberedReferences() {
        Reference<?> pendingHead = null;
        Reference<?> current = rememberedRefsList.getAndSet(null);
        while (current != null) {
            Reference<?> next = ReferenceInternals.getNextDiscovered(current);
            assert (next != null);
            Reference<Object> reference = next = next != current ? next : null;
            if (!ReferenceObjectProcessing.processRememberedRef(current) && ReferenceInternals.hasQueue(current)) {
                ReferenceInternals.setNextDiscovered(current, pendingHead);
                pendingHead = current;
            } else {
                ReferenceInternals.setNextDiscovered(current, null);
            }
            current = next;
        }
        return pendingHead;
    }

    static void afterCollection(UnsignedWord freeBytes) {
        assert (rememberedRefsList.get() == null);
        UnsignedWord unused = freeBytes.unsignedDivide(0x100000);
        maxSoftRefAccessIntervalMs = unused.multiply(SerialGCOptions.SoftRefLRUPolicyMSPerMB.getValue().intValue());
        ReferenceInternals.updateSoftReferenceClock();
        if (initialSoftRefClock == 0L) {
            initialSoftRefClock = ReferenceInternals.getSoftReferenceClock();
        }
    }

    private static boolean processRememberedRef(Reference<?> dr) {
        Pointer refPointer = ReferenceInternals.getReferentPointer(dr);
        assert (!HeapImpl.getHeapImpl().isInImageHeap(refPointer)) : "Image heap referent: should not have been discovered";
        if (SerialGCOptions.useCompactingOldGen() && GCImpl.getGCImpl().isCompleteCollection()) {
            assert (refPointer.isNull() || !ObjectHeaderImpl.isPointerToForwardedObject(refPointer));
            return refPointer.isNonNull();
        }
        assert (refPointer.isNonNull()) : "Referent is null: should not have been discovered";
        if (ReferenceObjectProcessing.maybeUpdateForwardedReference(dr, refPointer)) {
            return true;
        }
        Object refObject = refPointer.toObjectNonNull();
        if (ReferenceObjectProcessing.willSurviveThisCollection(refObject)) {
            RememberedSet.get().dirtyCardIfNecessary(dr, refObject, ReferenceInternals.getReferentFieldAddress(dr));
            return true;
        }
        ReferenceInternals.setReferent(dr, null);
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean maybeUpdateForwardedReference(Reference<?> dr, Pointer referentAddr) {
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        Word header = ohi.readHeaderFromPointer(referentAddr);
        if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header)) {
            Object forwardedObj = ohi.getForwardedObject(referentAddr, (UnsignedWord)header);
            ReferenceInternals.setReferent(dr, forwardedObj);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean willSurviveThisCollection(Object obj) {
        if (SerialGCOptions.useCompactingOldGen() && GCImpl.getGCImpl().isCompleteCollection()) {
            return ObjectHeaderImpl.isMarked(obj);
        }
        HeapChunk.Header<?> chunk = HeapChunk.getEnclosingHeapChunk(obj);
        Space space = HeapChunk.getSpace(chunk);
        return space.isToSpace() || space.isCompactingOldSpace();
    }

    static void updateForwardedRefs() {
        assert (SerialGCOptions.useCompactingOldGen());
        Reference<?> current = rememberedRefsList.getAndSet(null);
        while (current != null) {
            ObjectHeader oh;
            Word header;
            Reference<?> next = ReferenceInternals.getNextDiscovered(current);
            assert (next != null);
            next = next != current ? next : null;
            Pointer refPointer = ReferenceInternals.getReferentPointer(current);
            if (!ReferenceObjectProcessing.maybeUpdateForwardedReference(current, refPointer) && !ObjectHeaderImpl.isMarkedHeader((UnsignedWord)(header = (oh = Heap.getHeap().getObjectHeader()).readHeaderFromPointer(refPointer)))) {
                ReferenceInternals.setReferent(current, null);
            }
            current = next;
        }
    }
}

