/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.vector.architecture.VectorArchitecture;
import jdk.vm.ci.code.Architecture;

public abstract class SubstrateVectorArchitectureFactory {
    private volatile VectorArchitecture vectorArchitecture = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected <VectorArch extends VectorArchitecture, Arch extends Architecture> VectorArchitecture getSingletonVectorArchitecture(VectorArchitectureFactory<VectorArch, Arch> factory, Arch arch, boolean vectorArchEnabled, int referenceSize, boolean haveCompressedReferences, int alignment) {
        VectorArch newVectorArchitecture = factory.create(arch, vectorArchEnabled, referenceSize, haveCompressedReferences, alignment);
        if (this.vectorArchitecture == null) {
            Class<SubstrateVectorArchitectureFactory> clazz = SubstrateVectorArchitectureFactory.class;
            // MONITORENTER : com.oracle.svm.core.graal.code.SubstrateVectorArchitectureFactory.class
            if (this.vectorArchitecture == null) {
                this.vectorArchitecture = newVectorArchitecture;
            }
            // MONITOREXIT : clazz
        }
        VMError.guarantee(this.vectorArchitecture.equals(newVectorArchitecture), "must not build incompatible VectorArchitecture instances; old: %s, new: %s", this.vectorArchitecture, newVectorArchitecture);
        return this.vectorArchitecture;
    }

    @FunctionalInterface
    public static interface VectorArchitectureFactory<VectorArch extends VectorArchitecture, Arch extends Architecture> {
        public VectorArch create(Arch var1, boolean var2, int var3, boolean var4, int var5);
    }
}

