/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.util.VMError;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

public class DeoptTester {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor DEOPTTEST = SnippetRuntime.findForeignCall(DeoptTester.class, "deoptTest", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    private static final Set<Long> handledPCs = new HashSet<Long>();
    private static final FastThreadLocalInt inDeoptTest = FastThreadLocalFactory.createInt("DeoptTester.inDeoptTest");
    private static final StackFrameVisitor collectPcVisitor = new StackFrameVisitor(){

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Only deals with IPs, not Objects.")
        public boolean visitRegularFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo) {
            handledPCs.add(ip.rawValue());
            return true;
        }

        @Override
        protected boolean visitDeoptimizedFrame(Pointer originalSP, CodePointer deoptStubIP, DeoptimizedFrame deoptimizedFrame) {
            return true;
        }
    };

    @Fold
    public static boolean enabled() {
        boolean result = Options.DeoptimizeAll.getValue();
        if (result) {
            VMError.guarantee(DeoptimizationSupport.enabled(), "Enabling DeoptimizeAll also requires enabling deoptimization support");
        }
        return result;
    }

    @NeverInline(value="deoptTest must have a separate stack frame")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Prevent recursion while deoptimization testing is not suspended.", calleeMustBe=false)
    public static void deoptTest() {
        assert (DeoptTester.enabled());
        if (inDeoptTest.get() > 0) {
            return;
        }
        DeoptTester.disableDeoptTesting();
        try {
            if (Heap.getHeap().isAllocationDisallowed() || !CEntryPointSnippets.isIsolateInitialized() || RecurringCallbackSupport.isEnabled() && RecurringCallbackSupport.isCallbackTimerSuspended() || VMOperation.isInProgress() || VMThreads.SafepointBehavior.ignoresSafepoints() || !PlatformThreads.isCurrentAssigned()) {
                return;
            }
            Pointer startSp = KnownIntrinsics.readCallerStackPointer();
            int numHandledPCs = handledPCs.size();
            JavaStackWalker.walkCurrentThread(startSp, collectPcVisitor);
            if (handledPCs.size() > numHandledPCs) {
                Deoptimizer.deoptimizeAll();
            }
        }
        finally {
            DeoptTester.enableDeoptTesting();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void disableDeoptTesting() {
        if (DeoptTester.enabled()) {
            int newValue = inDeoptTest.get() + 1;
            assert (newValue >= 1);
            inDeoptTest.set(newValue);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void enableDeoptTesting() {
        if (DeoptTester.enabled()) {
            int newValue = inDeoptTest.get() - 1;
            assert (newValue >= 0);
            inDeoptTest.set(newValue);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> DeoptimizeAll = new HostedOptionKey<Boolean>(false);
    }
}

