/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.nodes.LoadOpenTypeWorldDispatchTableStartingOffset;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;

public final class OpenTypeWorldDispatchTableSnippets
extends SubstrateTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo loadITableStartingOffset;
    private final SnippetTemplate.SnippetInfo loadDispatchTableStartingOffset;

    @Snippet
    private static long loadITableStartingOffset(@Snippet.NonNullParameter DynamicHub hub, int interfaceTypeID) {
        return OpenTypeWorldDispatchTableSnippets.determineITableStartingOffset(hub, interfaceTypeID);
    }

    @Snippet
    private static long loadDispatchTableStartingOffset(@Snippet.NonNullParameter DynamicHub hub, int interfaceTypeID, @Snippet.ConstantParameter int vtableStartingOffset) {
        if (BranchProbabilityNode.unknownProbability((interfaceTypeID >= 0 ? 1 : 0) != 0)) {
            return OpenTypeWorldDispatchTableSnippets.determineITableStartingOffset(hub, interfaceTypeID);
        }
        return vtableStartingOffset;
    }

    public static long determineITableStartingOffset(DynamicHub checkedHub, int interfaceID) {
        int numClassTypes = checkedHub.getNumClassTypes();
        int numInterfaceTypes = checkedHub.getNumInterfaceTypes();
        int[] checkedTypeIds = checkedHub.getOpenTypeWorldTypeCheckSlots();
        for (int i = 0; i < numInterfaceTypes * 2; i += 2) {
            int offset = (int)((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getArrayElementOffset(JavaKind.Int, numClassTypes + i);
            int checkedInterfaceId = ObjectAccess.readInt((Object)checkedTypeIds, (int)offset, (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
            if (checkedInterfaceId != interfaceID) continue;
            offset = (int)((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getArrayElementOffset(JavaKind.Int, numClassTypes + i + 1);
            long result = ObjectAccess.readInt((Object)checkedTypeIds, (int)offset, (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
            return result;
        }
        throw UnreachableNode.unreachable();
    }

    private OpenTypeWorldDispatchTableSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.loadITableStartingOffset = this.snippet(providers, OpenTypeWorldDispatchTableSnippets.class, "loadITableStartingOffset", OpenTypeWorldDispatchTableSnippets.getKilledLocations());
        this.loadDispatchTableStartingOffset = this.snippet(providers, OpenTypeWorldDispatchTableSnippets.class, "loadDispatchTableStartingOffset", OpenTypeWorldDispatchTableSnippets.getKilledLocations());
        lowerings.put(LoadOpenTypeWorldDispatchTableStartingOffset.class, new DispatchTableStartingOffsetLowering());
    }

    private static LocationIdentity[] getKilledLocations() {
        return new LocationIdentity[0];
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new OpenTypeWorldDispatchTableSnippets(options, providers, lowerings);
    }

    class DispatchTableStartingOffsetLowering
    implements NodeLoweringProvider<LoadOpenTypeWorldDispatchTableStartingOffset> {
        DispatchTableStartingOffsetLowering() {
        }

        @Override
        public void lower(LoadOpenTypeWorldDispatchTableStartingOffset node, LoweringTool tool) {
            SharedMethod target = node.getTarget();
            int vtableStartingOffset = KnownOffsets.singleton().getVTableBaseOffset();
            if (target != null) {
                if (target.getDeclaringClass().isInterface()) {
                    SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(OpenTypeWorldDispatchTableSnippets.this.loadITableStartingOffset, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("hub", (Object)node.getHub());
                    args.add("interfaceTypeID", (Object)((SharedType)target.getDeclaringClass()).getTypeID());
                    OpenTypeWorldDispatchTableSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
                } else {
                    StructuredGraph graph = node.graph();
                    graph.replaceFixedWithFloating((FixedWithNextNode)node, (ValueNode)ConstantNode.forLong((long)vtableStartingOffset, (StructuredGraph)graph));
                }
            } else {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(OpenTypeWorldDispatchTableSnippets.this.loadDispatchTableStartingOffset, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)node.getHub());
                args.add("interfaceTypeID", (Object)node.getInterfaceTypeID());
                args.add("vtableStartingOffset", (Object)vtableStartingOffset);
                OpenTypeWorldDispatchTableSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

