/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.VectorAPIEnabled;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

@TargetClass(className="jdk.incubator.vector.ShortVector", onlyWith={VectorAPIEnabled.class})
final class Target_jdk_incubator_vector_ShortVector {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.ArrayIndexShift, declClass=short[].class, isFinal=true)
    @TargetElement(name="ARRAY_SHIFT")
    private static int arrayShift;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.ArrayBaseOffset, declClass=short[].class, isFinal=true)
    @TargetElement(name="ARRAY_BASE")
    private static long arrayBase;
    @Alias
    @RecomputeFieldValue(isFinal=true, kind=RecomputeFieldValue.Kind.None)
    @TargetElement(name="ELEMENT_LAYOUT")
    static ValueLayout.OfShort elementLayout;

    Target_jdk_incubator_vector_ShortVector() {
    }

    @Substitute
    static void memorySegmentSet(MemorySegment ms, long o, int i, short e) {
        elementLayout.varHandle().set(ms, o + (long)i * 2L, e);
    }

    @Substitute
    static short memorySegmentGet(MemorySegment ms, long o, int i) {
        return elementLayout.varHandle().get(ms, o + (long)i * 2L);
    }
}

