/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.jdk.ClassLoaderValueMapFieldValueTransformer;
import com.oracle.svm.core.jdk.ResourcesHelper;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import com.oracle.svm.core.jdk.Target_java_lang_Package;
import com.oracle.svm.core.jdk.Target_jdk_internal_loader_BuiltinClassLoader;
import com.oracle.svm.core.jdk.Target_jdk_internal_loader_ClassLoaders;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.internal.loader.BootLoader;

@TargetClass(value=BootLoader.class)
final class Target_jdk_internal_loader_BootLoader {
    @Delete
    static String JAVA_HOME;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassLoaderValueMapFieldValueTransformer.class, isFinal=true)
    static ConcurrentHashMap<?, ?> CLASS_LOADER_VALUE_MAP;

    Target_jdk_internal_loader_BootLoader() {
    }

    @Substitute
    static Package getDefinedPackage(String name) {
        if (name != null) {
            Target_java_lang_Package pkg = new Target_java_lang_Package(name, null, null, null, null, null, null, null, null);
            return SubstrateUtil.cast(pkg, Package.class);
        }
        return null;
    }

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    public static Stream<Package> packages() {
        Target_jdk_internal_loader_BuiltinClassLoader bootClassLoader = Target_jdk_internal_loader_ClassLoaders.bootLoader();
        Target_java_lang_ClassLoader systemClassLoader = SubstrateUtil.cast(bootClassLoader, Target_java_lang_ClassLoader.class);
        return systemClassLoader.packages();
    }

    @Delete(value="only used by #packages()")
    @TargetElement(name="getSystemPackageNames", onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static native String[] getSystemPackageNamesDeleted();

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/java.base/share/native/libjava/BootLoader.c#L37-L41"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L3003-L3007"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/classfile/classLoader.cpp#L907-L924")})
    private static String[] getSystemPackageNames() {
        return ClassRegistries.getSystemPackageNames();
    }

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static Class<?> loadClassOrNull(String name) {
        return ClassForNameSupport.forNameOrNull(name, null);
    }

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static Class<?> loadClass(Module module, String name) {
        return ClassForNameSupport.forNameOrNull(name, null);
    }

    @Substitute
    private static void loadLibrary(String name) {
        System.loadLibrary(name);
    }

    @Substitute
    private static boolean hasClassPath() {
        return true;
    }

    @Substitute
    public static URL findResource(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    public static Enumeration<URL> findResources(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }
}

