/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.collections.EnumBitmask;
import com.oracle.svm.core.jfr.JfrMetadataTypeLibrary;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.JavaThreads;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrEvent {
    public static final JfrEvent ThreadStart = JfrEvent.create("jdk.ThreadStart", 4, new JfrEventFlags[0]);
    public static final JfrEvent ThreadEnd = JfrEvent.create("jdk.ThreadEnd", new JfrEventFlags[0]);
    public static final JfrEvent ThreadCPULoad = JfrEvent.create("jdk.ThreadCPULoad", new JfrEventFlags[0]);
    public static final JfrEvent DataLoss = JfrEvent.create("jdk.DataLoss", new JfrEventFlags[0]);
    public static final JfrEvent ClassLoadingStatistics = JfrEvent.create("jdk.ClassLoadingStatistics", new JfrEventFlags[0]);
    public static final JfrEvent InitialEnvironmentVariable = JfrEvent.create("jdk.InitialEnvironmentVariable", new JfrEventFlags[0]);
    public static final JfrEvent InitialSystemProperty = JfrEvent.create("jdk.InitialSystemProperty", new JfrEventFlags[0]);
    public static final JfrEvent JavaThreadStatistics = JfrEvent.create("jdk.JavaThreadStatistics", new JfrEventFlags[0]);
    public static final JfrEvent JVMInformation = JfrEvent.create("jdk.JVMInformation", new JfrEventFlags[0]);
    public static final JfrEvent OSInformation = JfrEvent.create("jdk.OSInformation", new JfrEventFlags[0]);
    public static final JfrEvent PhysicalMemory = JfrEvent.create("jdk.PhysicalMemory", new JfrEventFlags[0]);
    public static final JfrEvent ExecutionSample = JfrEvent.create("jdk.ExecutionSample", new JfrEventFlags[0]);
    public static final JfrEvent NativeMethodSample = JfrEvent.create("jdk.NativeMethodSample", new JfrEventFlags[0]);
    public static final JfrEvent GarbageCollection = JfrEvent.create("jdk.GarbageCollection", JfrEventFlags.HasDuration);
    public static final JfrEvent GCPhasePause = JfrEvent.create("jdk.GCPhasePause", JfrEventFlags.HasDuration);
    public static final JfrEvent GCPhasePauseLevel1 = JfrEvent.create("jdk.GCPhasePauseLevel1", JfrEventFlags.HasDuration);
    public static final JfrEvent GCPhasePauseLevel2 = JfrEvent.create("jdk.GCPhasePauseLevel2", JfrEventFlags.HasDuration);
    public static final JfrEvent GCPhasePauseLevel3 = JfrEvent.create("jdk.GCPhasePauseLevel3", JfrEventFlags.HasDuration);
    public static final JfrEvent GCPhasePauseLevel4 = JfrEvent.create("jdk.GCPhasePauseLevel4", JfrEventFlags.HasDuration);
    public static final JfrEvent SafepointBegin = JfrEvent.create("jdk.SafepointBegin", JfrEventFlags.HasDuration);
    public static final JfrEvent SafepointEnd = JfrEvent.create("jdk.SafepointEnd", JfrEventFlags.HasDuration);
    public static final JfrEvent ExecuteVMOperation = JfrEvent.create("jdk.ExecuteVMOperation", JfrEventFlags.HasDuration);
    public static final JfrEvent JavaMonitorEnter = JfrEvent.create("jdk.JavaMonitorEnter", 5, JfrEventFlags.HasDuration);
    public static final JfrEvent ThreadPark = JfrEvent.create("jdk.ThreadPark", 5, JfrEventFlags.HasDuration);
    public static final JfrEvent JavaMonitorWait = JfrEvent.create("jdk.JavaMonitorWait", 5, JfrEventFlags.HasDuration);
    public static final JfrEvent JavaMonitorInflate = JfrEvent.create("jdk.JavaMonitorInflate", 5, JfrEventFlags.HasDuration);
    public static final JfrEvent ObjectAllocationInNewTLAB = JfrEvent.create("jdk.ObjectAllocationInNewTLAB", 5, new JfrEventFlags[0]);
    public static final JfrEvent ObjectAllocationOutsideTLAB = JfrEvent.create("jdk.ObjectAllocationOutsideTLAB", 5, new JfrEventFlags[0]);
    public static final JfrEvent GCHeapSummary = JfrEvent.create("jdk.GCHeapSummary", new JfrEventFlags[0]);
    public static final JfrEvent ThreadAllocationStatistics = JfrEvent.create("jdk.ThreadAllocationStatistics", new JfrEventFlags[0]);
    public static final JfrEvent SystemGC = JfrEvent.create("jdk.SystemGC", 5, JfrEventFlags.HasDuration);
    public static final JfrEvent AllocationRequiringGC = JfrEvent.create("jdk.AllocationRequiringGC", 5, new JfrEventFlags[0]);
    public static final JfrEvent OldObjectSample = JfrEvent.create("jdk.OldObjectSample", 7, new JfrEventFlags[0]);
    public static final JfrEvent ObjectAllocationSample = JfrEvent.create("jdk.ObjectAllocationSample", 5, JfrEventFlags.SupportsThrottling);
    public static final JfrEvent NativeMemoryUsage = JfrEvent.create("jdk.NativeMemoryUsage", new JfrEventFlags[0]);
    public static final JfrEvent NativeMemoryUsageTotal = JfrEvent.create("jdk.NativeMemoryUsageTotal", new JfrEventFlags[0]);
    private final long id;
    private final String name;
    private final int flags;
    private final int skipCount;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static JfrEvent create(String name, JfrEventFlags ... flags) {
        return new JfrEvent(name, -1, flags);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static JfrEvent create(String name, int skipCount, JfrEventFlags ... flags) {
        return new JfrEvent(name, skipCount, flags);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEvent(String name, int skipCount, JfrEventFlags ... flags) {
        this.id = JfrMetadataTypeLibrary.lookupPlatformEvent(name);
        this.name = name;
        this.flags = EnumBitmask.computeBitmask(flags);
        this.skipCount = skipCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getId() {
        return this.id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSkipCount() {
        assert (this.skipCount >= 0) : "method may only be called for events that need a stack trace";
        return this.skipCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean hasDuration() {
        return EnumBitmask.hasBit(this.flags, JfrEventFlags.HasDuration);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean supportsThrottling() {
        return EnumBitmask.hasBit(this.flags, JfrEventFlags.SupportsThrottling);
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    public boolean shouldEmit() {
        assert (!this.hasDuration());
        return this.shouldEmit0() && !JfrThreadLocal.isThreadExcluded(JavaThreads.getCurrentThreadOrNull());
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    public boolean shouldEmit(Thread thread) {
        assert (!this.hasDuration());
        return this.shouldEmit0() && !JfrThreadLocal.isThreadExcluded(thread);
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    public boolean shouldEmit(long durationTicks) {
        assert (this.hasDuration());
        return this.shouldEmit0() && durationTicks >= SubstrateJVM.get().getThresholdTicks(this) && !JfrThreadLocal.isThreadExcluded(JavaThreads.getCurrentThreadOrNull());
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    private boolean shouldEmit0() {
        return SubstrateJVM.get().isRecording() && SubstrateJVM.get().isEnabled(this) && SubstrateJVM.getEventThrottling().shouldCommit(this);
    }

    private static enum JfrEventFlags {
        HasDuration,
        SupportsThrottling;

    }
}

