/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.core.jni.access.JNIAccessibleField;
import com.oracle.svm.core.jni.access.JNIAccessibleMethod;
import com.oracle.svm.core.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JNIAccessibleClass {
    private final Class<?> classObject;
    private EconomicMap<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methods;
    private EconomicMap<CharSequence, JNIAccessibleField> fields;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JNIAccessibleClass(Class<?> clazz) {
        assert (clazz != null);
        this.classObject = clazz;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JNIAccessibleClass() {
        this.classObject = null;
    }

    public boolean isNegative() {
        return this.classObject == null;
    }

    public Class<?> getClassObject() {
        return this.classObject;
    }

    public UnmodifiableMapCursor<CharSequence, JNIAccessibleField> getFields() {
        return this.fields != null ? this.fields.getEntries() : EconomicMap.emptyCursor();
    }

    public JNIAccessibleField getField(CharSequence name) {
        return this.fields != null ? (JNIAccessibleField)this.fields.get((Object)name) : null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addFieldIfAbsent(String name, Function<String, JNIAccessibleField> mappingFunction) {
        if (this.fields == null) {
            this.fields = ImageHeapMap.createNonLayeredMap(JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE);
        }
        if (!this.fields.containsKey((Object)name)) {
            this.fields.put((Object)name, (Object)mappingFunction.apply(name));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addMethodIfAbsent(JNIAccessibleMethodDescriptor descriptor, Function<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> mappingFunction) {
        if (this.methods == null) {
            this.methods = ImageHeapMap.createNonLayeredMap();
        }
        if (!this.methods.containsKey((Object)descriptor)) {
            this.methods.put((Object)descriptor, (Object)mappingFunction.apply(descriptor));
        }
    }

    public MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> getMethods() {
        return this.methods != null ? this.methods.getEntries() : EconomicMap.emptyCursor();
    }

    public JNIAccessibleMethod getMethod(JNIAccessibleMethodDescriptor descriptor) {
        String signatureWithoutReturnType;
        if (this.methods == null) {
            return null;
        }
        JNIAccessibleMethod method = (JNIAccessibleMethod)this.methods.get((Object)descriptor);
        if (method == null && (signatureWithoutReturnType = descriptor.getSignatureWithoutReturnType()) != null) {
            method = (JNIAccessibleMethod)this.methods.get((Object)new JNIAccessibleMethodDescriptor(descriptor.getNameConvertToString(), signatureWithoutReturnType));
            VMError.guarantee(method == null || method.isNegative(), "Only negative queries should have a signature without return type");
        }
        return method;
    }

    String getJNIName() {
        return ClassNameSupport.reflectionNameToJNIName((String)this.classObject.getName());
    }
}

