/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.memory;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibCSupport;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

class UnmanagedMemorySupportImpl
implements UnmanagedMemorySupport {
    UnmanagedMemorySupportImpl() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T malloc(UnsignedWord size) {
        UnsignedWord allocationSize = UnsignedUtils.max(size, Word.unsigned((int)1));
        return UnmanagedMemorySupportImpl.libc().malloc(allocationSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T calloc(UnsignedWord size) {
        return UnmanagedMemorySupportImpl.libc().calloc(Word.unsigned((int)1), size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T realloc(T ptr, UnsignedWord size) {
        return UnmanagedMemorySupportImpl.libc().realloc(ptr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void free(PointerBase ptr) {
        UnmanagedMemorySupportImpl.libc().free(ptr);
    }

    @Fold
    static LibCSupport libc() {
        return (LibCSupport)ImageSingletons.lookup(LibCSupport.class);
    }
}

