/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Unistd;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public abstract class PosixSystemPropertiesSupport
extends SystemPropertiesSupport {
    @Override
    protected String userNameValue() {
        String name = PosixUtils.getUserName(Unistd.getuid());
        return name == null ? "?" : name;
    }

    @Override
    protected String userHomeValue() {
        String dir = PosixUtils.getUserDir(Unistd.getuid());
        return dir == null ? "?" : dir;
    }

    @Override
    protected String userDirValue() {
        int bufSize = Limits.MAXPATHLEN();
        CCharPointer buf = (CCharPointer)UnsafeStackValue.get(bufSize);
        if (Unistd.getcwd(buf, Word.unsigned((int)bufSize)).isNonNull()) {
            return CTypeConversion.toJavaString((CCharPointer)buf);
        }
        throw new Error("Properties init: Could not determine current working directory.");
    }
}

