/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import jdk.graal.compiler.util.json.JsonPrintable;
import org.graalvm.nativeimage.MissingReflectionRegistrationError;

public final class MissingReflectionRegistrationUtils
extends MissingRegistrationUtils {
    private static final Map<String, Set<String>> reflectionEntryPoints = Map.of(Class.class.getTypeName(), Set.of("forName", "getClasses", "getDeclaredClasses", "getConstructor", "getConstructors", "getDeclaredConstructor", "getDeclaredConstructors", "getField", "getFields", "getDeclaredField", "getDeclaredFields", "getMethod", "getMethods", "getDeclaredMethod", "getDeclaredMethods", "getNestMembers", "getPermittedSubclasses", "getRecordComponents", "getSigners", "arrayType", "newInstance"), Method.class.getTypeName(), Set.of("invoke"), Constructor.class.getTypeName(), Set.of("newInstance"), Proxy.class.getTypeName(), Set.of("getProxyClass", "newProxyInstance"), "java.lang.reflect.ReflectAccess", Set.of("newInstance"), "jdk.internal.access.JavaLangAccess", Set.of("getDeclaredPublicMethods"), "sun.misc.Unsafe", Set.of("allocateInstance"), SubstrateAllocationSnippets.class.getName(), Set.of("slowPathHubOrUnsafeInstantiationError"));

    public static void reportClassAccess(String className) {
        String json = MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)MissingReflectionRegistrationUtils.namedConfigurationType(className));
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("access the class", MissingReflectionRegistrationUtils.quote(className), json), Class.class, null, className, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void reportUnsafeAllocation(Class<?> clazz) {
        ConfigurationType type = MissingReflectionRegistrationUtils.getConfigurationType(clazz);
        type.setUnsafeAllocated();
        String json = MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type);
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("unsafe instantiate", MissingReflectionRegistrationUtils.typeDescriptor(clazz), json), Class.class, null, clazz.getTypeName(), null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void reportFieldQuery(Class<?> declaringClass, String fieldName) {
        ConfigurationType type = MissingReflectionRegistrationUtils.getConfigurationType(declaringClass);
        String json = MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type);
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("access field", MissingReflectionRegistrationUtils.quote(declaringClass.getTypeName() + "#" + fieldName), json), Field.class, declaringClass, fieldName, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static MissingReflectionRegistrationError reportAccessedField(Field field) {
        ConfigurationType type = MissingReflectionRegistrationUtils.getConfigurationType(field.getDeclaringClass());
        MissingReflectionRegistrationUtils.addField(type, field.getName());
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("read or write field", MissingReflectionRegistrationUtils.quote(field.toString()), MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type)), field.getClass(), field.getDeclaringClass(), field.getName(), null);
        MissingReflectionRegistrationUtils.report(exception);
        throw exception;
    }

    public static void reportMethodQuery(Class<?> declaringClass, String methodName, Class<?>[] paramTypes) {
        StringJoiner paramTypeNames = new StringJoiner(", ", "(", ")");
        if (paramTypes != null) {
            for (Class<?> paramType : paramTypes) {
                paramTypeNames.add(paramType.getTypeName());
            }
        }
        ConfigurationType type = MissingReflectionRegistrationUtils.getConfigurationType(declaringClass);
        String json = MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type);
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("access method", MissingReflectionRegistrationUtils.quote(declaringClass.getTypeName() + "#" + methodName + String.valueOf(paramTypeNames)), json), Method.class, declaringClass, methodName, (Class[])paramTypes);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static MissingReflectionRegistrationError reportInvokedExecutable(Executable executable) {
        ConfigurationType type = MissingReflectionRegistrationUtils.getConfigurationType(executable.getDeclaringClass());
        String methodName = executable instanceof Constructor ? "<init>" : executable.getName();
        String executableType = executable instanceof Constructor ? "constructor" : "method";
        MissingReflectionRegistrationUtils.addMethod(type, methodName, executable.getParameterTypes());
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("invoke " + executableType, MissingReflectionRegistrationUtils.quote(executable.toString()), MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type)), executable.getClass(), executable.getDeclaringClass(), executable.getName(), (Class[])executable.getParameterTypes());
        MissingReflectionRegistrationUtils.report(exception);
        return exception;
    }

    public static void reportClassQuery(Class<?> declaringClass, String methodName) {
        ConfigurationType type = MissingReflectionRegistrationUtils.getConfigurationType(declaringClass);
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("access the", MissingReflectionRegistrationUtils.typeDescriptor(declaringClass), MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type)), null, declaringClass, methodName, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static MissingReflectionRegistrationError reportProxyAccess(Class<?> ... interfaces) {
        List<String> interfaceList = Arrays.stream(interfaces).map(Class::getTypeName).toList();
        ConfigurationType type = new ConfigurationType(UnresolvedConfigurationCondition.alwaysTrue(), (ConfigurationTypeDescriptor)new ProxyConfigurationTypeDescriptor(interfaceList), true);
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("access the proxy class inheriting", MissingReflectionRegistrationUtils.interfacesString(interfaces), MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type)), Proxy.class, null, null, (Class[])interfaces);
        MissingReflectionRegistrationUtils.report(exception);
        return exception;
    }

    public static MissingReflectionRegistrationError reportArrayInstantiation(Class<?> elementClass, int dimension) {
        String typeName = elementClass.getTypeName() + "[]".repeat(dimension);
        ConfigurationType type = MissingReflectionRegistrationUtils.namedConfigurationType(typeName);
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.reflectionError("instantiate the array class", MissingReflectionRegistrationUtils.quote(typeName), MissingReflectionRegistrationUtils.elementToJSON((JsonPrintable)type)), null, null, null, null);
        MissingReflectionRegistrationUtils.report(exception);
        return exception;
    }

    private static String reflectionError(String failedAction, String elementDescriptor, String json) {
        return MissingReflectionRegistrationUtils.registrationMessage(failedAction, elementDescriptor, json, "reflectively", "reflection", "reflection");
    }

    private static void report(MissingReflectionRegistrationError exception) {
        StackTraceElement responsibleClass = MissingReflectionRegistrationUtils.getResponsibleClass(exception, reflectionEntryPoints);
        MissingRegistrationUtils.report((Error)((Object)exception), responsibleClass);
    }
}

