/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.util.LayeredImageHeapMapStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class LayeredImageHeapMap<K, V>
implements EconomicMap<K, V> {
    private final Equivalence strategy;
    private final String mapKey;
    private final boolean fromBaseToApp;

    public LayeredImageHeapMap(Equivalence strategy, String mapKey) {
        this(strategy, mapKey, false);
    }

    public LayeredImageHeapMap(Equivalence strategy, String mapKey, boolean fromBaseToApp) {
        this.strategy = strategy;
        this.mapKey = mapKey;
        this.fromBaseToApp = fromBaseToApp;
    }

    public V put(K key, V value) {
        List<LayeredImageHeapMapStore> singletons = Arrays.stream(LayeredImageHeapMapStore.layeredSingletons()).toList();
        boolean first = true;
        for (LayeredImageHeapMapStore singleton : this.fromBaseToApp ? singletons : singletons.reversed()) {
            Object oldValue;
            if (first) {
                oldValue = this.getRuntimeMap(singleton).put(key, value);
                first = false;
            } else {
                oldValue = this.getRuntimeMap(singleton).get(key);
            }
            if (oldValue == null) continue;
            return (V)oldValue;
        }
        return null;
    }

    public void clear() {
        for (LayeredImageHeapMapStore singleton : LayeredImageHeapMapStore.layeredSingletons()) {
            this.getRuntimeMap(singleton).clear();
        }
    }

    public V removeKey(K key) {
        List<LayeredImageHeapMapStore> singletons = Arrays.stream(LayeredImageHeapMapStore.layeredSingletons()).toList();
        Object previousValue = null;
        for (LayeredImageHeapMapStore singleton : this.fromBaseToApp ? singletons : singletons.reversed()) {
            Object oldValue = this.getRuntimeMap(singleton).removeKey(key);
            if (oldValue == null || previousValue != null) continue;
            previousValue = oldValue;
        }
        return (V)previousValue;
    }

    public V get(K key) {
        List<LayeredImageHeapMapStore> singletons = Arrays.stream(LayeredImageHeapMapStore.layeredSingletons()).toList();
        for (LayeredImageHeapMapStore singleton : this.fromBaseToApp ? singletons : singletons.reversed()) {
            EconomicMap<K, V> singletonMap = this.getRuntimeMap(singleton);
            if (!singletonMap.containsKey(key)) continue;
            return (V)singletonMap.get(key);
        }
        return null;
    }

    public boolean containsKey(K key) {
        for (LayeredImageHeapMapStore singleton : LayeredImageHeapMapStore.layeredSingletons()) {
            if (!this.getRuntimeMap(singleton).containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int size = 0;
        for (LayeredImageHeapMapStore singleton : LayeredImageHeapMapStore.layeredSingletons()) {
            size += this.getRuntimeMap(singleton).size();
        }
        return size;
    }

    public boolean isEmpty() {
        for (LayeredImageHeapMapStore singleton : LayeredImageHeapMapStore.layeredSingletons()) {
            if (this.getRuntimeMap(singleton).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterable<V> getValues() {
        return this.getIterator(UnmodifiableMapCursor::getValue);
    }

    public Iterable<K> getKeys() {
        return this.getIterator(UnmodifiableMapCursor::getKey);
    }

    private <E> Iterable<E> getIterator(Function<MapCursor<K, V>, E> getElement) {
        MapCursor<K, V> cursor = this.getEntries();
        ArrayList<E> elements = new ArrayList<E>();
        while (cursor.advance()) {
            elements.add(getElement.apply(cursor));
        }
        return elements;
    }

    public MapCursor<K, V> getEntries() {
        List<LayeredImageHeapMapStore> singletons = Arrays.stream(LayeredImageHeapMapStore.layeredSingletons()).toList();
        singletons = this.fromBaseToApp ? singletons : singletons.reversed();
        final Iterator cursors = singletons.stream().map(singleton -> this.getRuntimeMap((LayeredImageHeapMapStore)singleton).getEntries()).iterator();
        return new MapCursor<K, V>(this){
            private MapCursor<K, V> current;
            private final EconomicSet<K> keys;
            final /* synthetic */ LayeredImageHeapMap this$0;
            {
                this.this$0 = this$0;
                this.current = (MapCursor)cursors.next();
                this.keys = EconomicSet.create((Equivalence)this.this$0.strategy);
            }

            public void remove() {
                this.current.remove();
            }

            public boolean advance() {
                boolean advance = this.current.advance();
                if (!advance && cursors.hasNext()) {
                    this.current = (MapCursor)cursors.next();
                    if (this.keys.add(this.current.getKey())) {
                        return true;
                    }
                }
                return advance;
            }

            public K getKey() {
                return this.current.getKey();
            }

            public V getValue() {
                return this.current.getValue();
            }

            public V setValue(V newValue) {
                return this.current.setValue(newValue);
            }
        };
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        for (LayeredImageHeapMapStore singleton : LayeredImageHeapMapStore.layeredSingletons()) {
            this.getRuntimeMap(singleton).replaceAll(function);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getMapKey() {
        return this.mapKey;
    }

    private EconomicMap<K, V> getRuntimeMap(LayeredImageHeapMapStore singleton) {
        return singleton.getImageHeapMapStore().get(this.mapKey);
    }
}

