/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

public class ByteFormattingUtil {
    private static final double BYTES_TO_KB = 1000.0;
    private static final double BYTES_TO_MB = 1000000.0;
    private static final double BYTES_TO_GB = 1.0E9;

    public static String bytesToHuman(long bytes) {
        assert (bytes >= 0L);
        if ((double)bytes < 1000.0) {
            return ByteFormattingUtil.plainBytes(bytes, "B");
        }
        if ((double)bytes < 1000000.0) {
            return ByteFormattingUtil.toHuman((double)bytes / 1000.0, "kB");
        }
        if ((double)bytes < 1.0E9) {
            return ByteFormattingUtil.toHuman((double)bytes / 1000000.0, "MB");
        }
        return ByteFormattingUtil.bytesToHumanGB(bytes);
    }

    public static String bytesToHumanGB(long bytes) {
        return ByteFormattingUtil.toHuman((double)bytes / 1.0E9, "GB");
    }

    private static String toHuman(double value, String unit) {
        return "%.2f%s".formatted(value, unit);
    }

    private static String plainBytes(long value, String unit) {
        assert (0L <= value && (double)value < 1000.0);
        return "%d%s".formatted(value, unit);
    }
}

