/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.ExplicitCallingConvention;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.pltgot.IdentityMethodAddressResolver;
import com.oracle.svm.core.pltgot.MethodAddressResolver;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.pltgot.GOTEntryAllocator;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.MethodAddressResolutionSupport;
import com.oracle.svm.hosted.pltgot.PLTGOTFeature;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.hosted.Feature;

public class IdentityMethodAddressResolverFeature
implements InternalFeature {
    public static final SectionName SVM_METHODTABLE = new SectionName.ProgbitsSectionName("svm_methodtbl");
    private RelocatableBuffer offsetsSectionBuffer;
    private ObjectFile.ProgbitsSectionImpl offsetsSectionBufferImpl;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(PLTGOTFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        HostedPLTGOTConfiguration.singleton().initializeMethodAddressResolutionSupport(() -> new IdentityMethodAddressResolverSupport());
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        this.prepareOffsetsSection((NativeImage)((FeatureImpl.BeforeImageWriteAccessImpl)access).getImage());
    }

    private void prepareOffsetsSection(NativeImage image) {
        image.markRelocationSitesFromBuffer(this.offsetsSectionBuffer, this.offsetsSectionBufferImpl);
    }

    protected class IdentityMethodAddressResolverSupport
    implements MethodAddressResolutionSupport {
        protected IdentityMethodAddressResolverSupport() {
        }

        private static boolean isAllowed(SharedMethod method) {
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), CEntryPoint.class)) {
                return false;
            }
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), CFunction.class)) {
                return false;
            }
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), StubCallingConvention.class)) {
                return false;
            }
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), Uninterruptible.class)) {
                return false;
            }
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), SubstrateForeignCallTarget.class)) {
                return false;
            }
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)method.getDeclaringClass(), InternalVMMethod.class)) {
                return false;
            }
            return !AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), ExplicitCallingConvention.class) || !((ExplicitCallingConvention)AnnotationAccess.getAnnotation((AnnotatedElement)((Object)method), ExplicitCallingConvention.class)).value().equals((Object)SubstrateCallingConventionKind.ForwardReturnValue);
        }

        @Override
        public boolean shouldCallViaPLTGOT(SharedMethod caller, SharedMethod callee) {
            return IdentityMethodAddressResolverSupport.isAllowed(callee);
        }

        @Override
        public boolean shouldCallViaPLTGOT(SharedMethod callee) {
            return IdentityMethodAddressResolverSupport.isAllowed(callee);
        }

        @Override
        public void augmentImageObjectFile(ObjectFile imageObjectFile) {
            GOTEntryAllocator gotEntryAllocator = HostedPLTGOTConfiguration.singleton().getGOTEntryAllocator();
            SharedMethod[] got = gotEntryAllocator.getGOT();
            long methodCount = got.length;
            int wordSize = ConfigurationValues.getTarget().wordSize;
            long gotSectionSize = methodCount * (long)wordSize;
            IdentityMethodAddressResolverFeature.this.offsetsSectionBuffer = new RelocatableBuffer(gotSectionSize, imageObjectFile.getByteOrder());
            IdentityMethodAddressResolverFeature.this.offsetsSectionBufferImpl = new BasicProgbitsSectionImpl(IdentityMethodAddressResolverFeature.this.offsetsSectionBuffer.getBackingArray());
            String name = SVM_METHODTABLE.getFormatDependentName(imageObjectFile.getFormat());
            ObjectFile.Section offsetsSection = imageObjectFile.newProgbitsSection(name, imageObjectFile.getPageSize(), true, false, IdentityMethodAddressResolverFeature.this.offsetsSectionBufferImpl);
            ObjectFile.RelocationKind relocationKind = ObjectFile.RelocationKind.getDirect((int)wordSize);
            for (int gotEntryNo = 0; gotEntryNo < got.length; ++gotEntryNo) {
                IdentityMethodAddressResolverFeature.this.offsetsSectionBuffer.addRelocationWithoutAddend(gotEntryNo * wordSize, relocationKind, new MethodPointer(got[gotEntryNo], false));
            }
            imageObjectFile.createDefinedSymbol(offsetsSection.getName(), (ObjectFile.Element)offsetsSection, 0L, 0, false, false);
            imageObjectFile.createDefinedSymbol("__svm_methodtable_begin", (ObjectFile.Element)offsetsSection, 0L, wordSize, false, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
            imageObjectFile.createDefinedSymbol("__svm_methodtable_end", (ObjectFile.Element)offsetsSection, gotSectionSize, wordSize, false, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
        }

        @Override
        public MethodAddressResolver createMethodAddressResolver() {
            return new IdentityMethodAddressResolver();
        }
    }
}

