/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.classfile;

import com.oracle.svm.core.util.VMError;
import java.io.UTFDataFormatException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class OutStream {
    private byte[] bytes;
    private int offset;

    OutStream(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
        this.offset = 0;
    }

    OutStream() {
        this(32);
    }

    public void writeByte(byte value) {
        this.ensureCapacity(this.offset + 1);
        this.bytes[this.offset++] = value;
    }

    public void writeU1(int value) {
        VMError.guarantee(0 <= value && value <= 255);
        this.ensureCapacity(this.offset + 1);
        this.bytes[this.offset++] = (byte)value;
    }

    private void ensureCapacity(int capacity) {
        if (this.bytes.length < capacity) {
            int newCapacity = Math.max(capacity, this.bytes.length * 2 + 1);
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
    }

    public void writeShort(short value) {
        this.writeByte((byte)(value >>> 8));
        this.writeByte((byte)value);
    }

    public void writeU2(int value) {
        VMError.guarantee(0 <= value && value <= 65535);
        this.writeByte((byte)(value >>> 8));
        this.writeByte((byte)value);
    }

    public void writeInt(int value) {
        this.writeByte((byte)(value >>> 24));
        this.writeByte((byte)(value >>> 16));
        this.writeByte((byte)(value >>> 8));
        this.writeByte((byte)(value >>> 0));
    }

    public void writeLong(long value) {
        this.writeByte((byte)(value >>> 56));
        this.writeByte((byte)(value >>> 48));
        this.writeByte((byte)(value >>> 40));
        this.writeByte((byte)(value >>> 32));
        this.writeByte((byte)(value >>> 24));
        this.writeByte((byte)(value >>> 16));
        this.writeByte((byte)(value >>> 8));
        this.writeByte((byte)(value >>> 0));
    }

    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public int writeUTF(String str) {
        char c;
        int i;
        int strlen;
        int utflen = strlen = str.length();
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c < '\u0080' && c != '\u0000') continue;
            utflen += c >= '\u0800' ? 2 : 1;
        }
        if (utflen > 65535 || utflen < strlen) {
            throw new UncheckedIOException(new UTFDataFormatException(OutStream.tooLongMsg(str, utflen)));
        }
        this.writeByte((byte)(utflen >>> 8 & 0xFF));
        this.writeByte((byte)(utflen >>> 0 & 0xFF));
        i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) < '\u0080' && c != '\u0000'; ++i) {
            this.writeByte((byte)c);
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c < '\u0080' && c != '\u0000') {
                this.writeByte((byte)c);
            } else if (c >= '\u0800') {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
            } else {
                this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
            }
            ++i;
        }
        return utflen + 2;
    }

    private static String tooLongMsg(String s, int bits32) {
        int slen = s.length();
        String head = s.substring(0, 8);
        String tail = s.substring(slen - 8, slen);
        long actualLength = (long)slen + Integer.toUnsignedLong(bits32 - slen);
        return "encoded string (" + head + "..." + tail + ") too long: " + actualLength + " bytes";
    }

    byte[] toArray() {
        return Arrays.copyOf(this.bytes, this.offset);
    }

    public void writeBytes(byte[] byteArray) {
        for (byte b : byteArray) {
            this.writeByte(b);
        }
    }

    int getOffset() {
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void patchAtOffset(int targetOffset, Runnable action) {
        int oldOffset = this.getOffset();
        try {
            this.offset = targetOffset;
            action.run();
        }
        finally {
            this.offset = oldOffset;
        }
    }
}

