/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.ForeignSupport;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.foreign.ForeignAPIPredicates;
import com.oracle.svm.core.foreign.SubstrateForeignUtil;
import com.oracle.svm.core.foreign.SubstrateMappedMemoryUtils;
import com.oracle.svm.core.foreign.SyncCloseScopeOperation;
import com.oracle.svm.core.foreign.Target_java_nio_MappedMemoryUtils;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_MemorySessionImpl;
import com.oracle.svm.core.foreign.Target_jdk_internal_misc_ScopedMemoryAccess_ScopedAccessError;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.io.FileDescriptor;
import java.lang.ref.Reference;
import jdk.internal.access.foreign.MappedMemoryUtilsProxy;
import jdk.internal.foreign.MemorySessionImpl;

@BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+15/src/java.base/share/classes/jdk/internal/misc/X-ScopedMemoryAccess-bin.java.template"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/misc/X-ScopedMemoryAccess.java.template")})
@TargetClass(className="jdk.internal.misc.ScopedMemoryAccess", onlyWith={ForeignAPIPredicates.Enabled.class})
public final class Target_jdk_internal_misc_ScopedMemoryAccess {
    @Substitute
    static void registerNatives() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+20/src/java.base/share/classes/java/nio/MappedMemoryUtils.java#L50-L77")
    @Substitute
    @TargetElement(onlyWith={ForeignAPIPredicates.SharedArenasEnabled.class})
    @ForeignSupport.Scoped
    @AlwaysInline(value="Safepoints must be visible in caller")
    public void loadInternal(MemorySessionImpl session, MappedMemoryUtilsProxy mappedUtils, long address, boolean isSync, long size) {
        SubstrateForeignUtil.checkIdentity(mappedUtils, Target_java_nio_MappedMemoryUtils.PROXY);
        SubstrateForeignUtil.sessionExceptionHandler(session, null, address);
        try {
            SubstrateForeignUtil.checkSession(session);
            SubstrateMappedMemoryUtils.load(address, isSync, size);
        }
        finally {
            Reference.reachabilityFence(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+14/src/java.base/share/classes/java/nio/MappedMemoryUtils.java#L182-L185")
    @Substitute
    @TargetElement(onlyWith={ForeignAPIPredicates.SharedArenasEnabled.class})
    @ForeignSupport.Scoped
    @AlwaysInline(value="Safepoints must be visible in caller")
    public boolean isLoadedInternal(MemorySessionImpl session, MappedMemoryUtilsProxy mappedUtils, long address, boolean isSync, long size) {
        boolean bl;
        SubstrateForeignUtil.checkIdentity(mappedUtils, Target_java_nio_MappedMemoryUtils.PROXY);
        SubstrateForeignUtil.sessionExceptionHandler(session, null, address);
        try {
            SubstrateForeignUtil.checkSession(session);
            bl = Target_java_nio_MappedMemoryUtils.isLoaded(address, isSync, size);
        }
        catch (Throwable throwable) {
            Reference.reachabilityFence(session);
            throw throwable;
        }
        Reference.reachabilityFence(session);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+14/src/java.base/share/classes/java/nio/MappedMemoryUtils.java#L192-L195")
    @Substitute
    @TargetElement(onlyWith={ForeignAPIPredicates.SharedArenasEnabled.class})
    @ForeignSupport.Scoped
    @AlwaysInline(value="Safepoints must be visible in caller")
    public void unloadInternal(MemorySessionImpl session, MappedMemoryUtilsProxy mappedUtils, long address, boolean isSync, long size) {
        SubstrateForeignUtil.checkIdentity(mappedUtils, Target_java_nio_MappedMemoryUtils.PROXY);
        SubstrateForeignUtil.sessionExceptionHandler(session, null, address);
        try {
            SubstrateForeignUtil.checkSession(session);
            Target_java_nio_MappedMemoryUtils.unload(address, isSync, size);
        }
        finally {
            Reference.reachabilityFence(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+14/src/java.base/share/classes/java/nio/MappedMemoryUtils.java#L197-L200")
    @Substitute
    @TargetElement(onlyWith={ForeignAPIPredicates.SharedArenasEnabled.class})
    @ForeignSupport.Scoped
    @AlwaysInline(value="Safepoints must be visible in caller")
    public void forceInternal(MemorySessionImpl session, MappedMemoryUtilsProxy mappedUtils, FileDescriptor fd, long address, boolean isSync, long index, long length) {
        SubstrateForeignUtil.checkIdentity(mappedUtils, Target_java_nio_MappedMemoryUtils.PROXY);
        SubstrateForeignUtil.sessionExceptionHandler(session, null, address);
        try {
            SubstrateForeignUtil.checkSession(session);
            Target_java_nio_MappedMemoryUtils.force(fd, address, isSync, index, length);
        }
        finally {
            Reference.reachabilityFence(session);
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+20/src/hotspot/share/prims/scopedMemoryAccess.cpp#L215-L218")
    @Substitute
    @TargetElement(onlyWith={ForeignAPIPredicates.SharedArenasEnabled.class})
    void closeScope0(Target_jdk_internal_foreign_MemorySessionImpl session, Target_jdk_internal_misc_ScopedMemoryAccess_ScopedAccessError error) {
        new SyncCloseScopeOperation(session).enqueue();
    }

    @Substitute
    @TargetElement(name="closeScope0", onlyWith={ForeignAPIPredicates.SharedArenasDisabled.class})
    void closeScope0Unsupported(Target_jdk_internal_foreign_MemorySessionImpl session, Target_jdk_internal_misc_ScopedMemoryAccess_ScopedAccessError error) {
        throw ForeignAPIPredicates.SharedArenasDisabled.fail();
    }
}

