/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.foreign.ForeignGraphKit;
import com.oracle.svm.hosted.foreign.HighLevelUpcallStub;
import com.oracle.svm.hosted.foreign.UpcallStub;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

class HighLevelDirectUpcallStub
extends UpcallStub {
    private final MethodHandle target;

    private static MethodType computeType(JavaEntryPointInfo jep, MethodType lowTypeParam) {
        MethodType lowType = lowTypeParam;
        if (jep.buffersReturn()) {
            lowType = lowType.insertParameterTypes(0, Long.TYPE);
        }
        return lowType.insertParameterTypes(0, MethodHandle.class);
    }

    HighLevelDirectUpcallStub(MethodHandle handle, JavaEntryPointInfo jep, AbiUtils.Adapter.Result.TypeAdaptation adapted, MetaAccessProvider metaAccess) {
        super(jep, HighLevelDirectUpcallStub.computeType(jep, adapted.callType()), metaAccess, true, true);
        this.target = handle;
        VMError.guarantee((boolean)handle.type().equals((Object)jep.handleType()));
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        InvokeWithExceptionNode returnValue;
        ForeignGraphKit kit = new ForeignGraphKit(debug, providers, (ResolvedJavaMethod)method);
        FrameStateBuilder frame = kit.getFrameState();
        List<ValueNode> allArguments = new ArrayList<ValueNode>(kit.getInitialArguments());
        JavaConstant targetMethodHandle = kit.getSnippetReflection().forObject((Object)this.target);
        ConstantNode constMH = kit.createConstant((Constant)targetMethodHandle, JavaKind.Object);
        ResolvedJavaMethod resolvedJavaMethod = providers.getConstantReflection().getMethodHandleAccess().resolveInvokeBasicTarget(targetMethodHandle, true);
        if (resolvedJavaMethod != null) {
            allArguments.set(0, (ValueNode)constMH);
            frame.clearLocals();
            CallTargetNode.InvokeKind invokeKind = resolvedJavaMethod.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Virtual;
            returnValue = kit.createJavaCallWithException(invokeKind, resolvedJavaMethod, allArguments.toArray(ValueNode.EMPTY_ARRAY));
        } else {
            allArguments.removeFirst();
            allArguments = kit.boxArguments(allArguments, this.jep.handleType());
            ValueNode arguments = kit.packArguments(allArguments);
            frame.clearLocals();
            AnalysisMetaAccess metaAccess = kit.getMetaAccess();
            returnValue = kit.createJavaCallWithException(CallTargetNode.InvokeKind.Virtual, metaAccess.lookupJavaMethod((Executable)HighLevelUpcallStub.INVOKE), new ValueNode[]{constMH, arguments});
        }
        kit.exceptionPart();
        kit.append((Node)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)kit.exceptionObject()));
        kit.append((Node)new LoweredDeadEndNode());
        kit.endInvokeWithException();
        Object unboxedReturn = resolvedJavaMethod != null ? returnValue : kit.unbox((ValueNode)returnValue, this.jep.cMethodType());
        assert (JavaKind.fromJavaClass((Class)this.jep.cMethodType().returnType()) == unboxedReturn.getStackKind());
        kit.createReturn((ValueNode)unboxedReturn, this.jep.cMethodType());
        return kit.finalizeGraph();
    }
}

