// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: PointstoOptions.java
package com.oracle.graal.pointsto.api;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class PointstoOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(PointstoOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AliasArrayTypeFlows": {
            return OptionDescriptor.create(
                /*name*/ "AliasArrayTypeFlows",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Model all array type flows using a unique elements type flow abstraction.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.AliasArrayTypeFlows,
                /*fieldName*/ "AliasArrayTypeFlows",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocationSiteSensitiveHeap": {
            return OptionDescriptor.create(
                /*name*/ "AllocationSiteSensitiveHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "A context sensitive heap means that each heap allocated object is modeled by using at least the allocation site.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.AllocationSiteSensitiveHeap,
                /*fieldName*/ "AllocationSiteSensitiveHeap",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AnalysisContextSensitivity": {
            return OptionDescriptor.create(
                /*name*/ "AnalysisContextSensitivity",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Controls the static analysis context sensitivity. Available values: insens (context insensitive analysis), allocsens (context insensitive analysis, context insensitive heap, allocation site sensitive heap), _1obj (1 object sensitive analysis with a context insensitive heap), _2obj1h (2 object sensitive with a 1 context sensitive heap)",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.AnalysisContextSensitivity,
                /*fieldName*/ "AnalysisContextSensitivity",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AnalysisSizeCutoff": {
            return OptionDescriptor.create(
                /*name*/ "AnalysisSizeCutoff",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum size of type and method profiles returned by the static analysis. -1 indicates no limitation.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.AnalysisSizeCutoff,
                /*fieldName*/ "AnalysisSizeCutoff",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConditionalEliminationBeforeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "ConditionalEliminationBeforeAnalysis",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Run conditional elimination before static analysis.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.ConditionalEliminationBeforeAnalysis,
                /*fieldName*/ "ConditionalEliminationBeforeAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalysisBeforeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalysisBeforeAnalysis",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Run partial escape analysis on compiler graphs before static analysis.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.EscapeAnalysisBeforeAnalysis,
                /*fieldName*/ "EscapeAnalysisBeforeAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HybridStaticContext": {
            return OptionDescriptor.create(
                /*name*/ "HybridStaticContext",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable hybrid context for static methods, i.e. uses invocation site as context for static methods.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.HybridStaticContext,
                /*fieldName*/ "HybridStaticContext",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InspectServerContentPath": {
            return OptionDescriptor.create(
                /*name*/ "InspectServerContentPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Path to the contents of the Inspect web server.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.InspectServerContentPath,
                /*fieldName*/ "InspectServerContentPath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LimitObjectArrayLength": {
            return OptionDescriptor.create(
                /*name*/ "LimitObjectArrayLength",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable a limit for the number of objects recorded for each type of a type state before disabling heap sensitivity for that type. The analysis must be heap sensitive.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.LimitObjectArrayLength,
                /*fieldName*/ "LimitObjectArrayLength",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxCallingContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MaxCallingContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum length of the methods context chains.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MaxCallingContextDepth,
                /*fieldName*/ "MaxCallingContextDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxCallingContextWidth": {
            return OptionDescriptor.create(
                /*name*/ "MaxCallingContextWidth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of contexts to record for a method. It only affects the analysis when the max and min calling context depth are different.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MaxCallingContextWidth,
                /*fieldName*/ "MaxCallingContextWidth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxConstantObjectsPerType": {
            return OptionDescriptor.create(
                /*name*/ "MaxConstantObjectsPerType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of constant objects recorded for each type before merging the constants into one unique constant object per type. If the value is 0 there is no limit.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MaxConstantObjectsPerType,
                /*fieldName*/ "MaxConstantObjectsPerType",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxHeapContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum length of the context used to model a heap object in addition to the allocation site; used only when ContextSensitiveHeap is enabled.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MaxHeapContextDepth,
                /*fieldName*/ "MaxHeapContextDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxHeapContextWidth": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapContextWidth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of contexts to record for a heap object.  It only affects the analysis when the max and min calling context depth are different.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MaxHeapContextWidth,
                /*fieldName*/ "MaxHeapContextWidth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxObjectSetSize": {
            return OptionDescriptor.create(
                /*name*/ "MaxObjectSetSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of objects recorded for each type of a type state before disabling heap sensitivity for that type. The analysis must be heap sensitive. It has a minimum value of 1.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MaxObjectSetSize,
                /*fieldName*/ "MaxObjectSetSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinCallingContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MinCallingContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The minimum length of the methods context chains.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MinCallingContextDepth,
                /*fieldName*/ "MinCallingContextDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinHeapContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MinHeapContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The minimum length of the context used to model a heap object in addition to the allocation site; used only when ContextSensitiveHeap is enabled.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.MinHeapContextDepth,
                /*fieldName*/ "MinHeapContextDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptimizeReturnedParameter": {
            return OptionDescriptor.create(
                /*name*/ "OptimizeReturnedParameter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Analysis: Detect methods that return one of their parameters and hardwire the parameter straight to the return.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.OptimizeReturnedParameter,
                /*fieldName*/ "OptimizeReturnedParameter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ParsingContextMaxDepth": {
            return OptionDescriptor.create(
                /*name*/ "ParsingContextMaxDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Limit the parsing context depth. Default value is arbitrary set at 100.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.ParsingContextMaxDepth,
                /*fieldName*/ "ParsingContextMaxDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintPointsToStatistics": {
            return OptionDescriptor.create(
                /*name*/ "PrintPointsToStatistics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report analysis statistics.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.PrintPointsToStatistics,
                /*fieldName*/ "PrintPointsToStatistics",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintSynchronizedAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "PrintSynchronizedAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print types used for Java synchronization.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.PrintSynchronizedAnalysis,
                /*fieldName*/ "PrintSynchronizedAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ProfileAnalysisOperations": {
            return OptionDescriptor.create(
                /*name*/ "ProfileAnalysisOperations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the progress of the static analysis.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.ProfileAnalysisOperations,
                /*fieldName*/ "ProfileAnalysisOperations",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ProfileConstantObjects": {
            return OptionDescriptor.create(
                /*name*/ "ProfileConstantObjects",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the creation of constant objects.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.ProfileConstantObjects,
                /*fieldName*/ "ProfileConstantObjects",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RelaxTypeFlowStateConstraints": {
            return OptionDescriptor.create(
                /*name*/ "RelaxTypeFlowStateConstraints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow a type flow state to contain types not compatible with its declared type.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.RelaxTypeFlowStateConstraints,
                /*fieldName*/ "RelaxTypeFlowStateConstraints",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RemoveSaturatedTypeFlows": {
            return OptionDescriptor.create(
                /*name*/ "RemoveSaturatedTypeFlows",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable the type flow saturation analysis performance optimization.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.RemoveSaturatedTypeFlows,
                /*fieldName*/ "RemoveSaturatedTypeFlows",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ScanObjectsParallel": {
            return OptionDescriptor.create(
                /*name*/ "ScanObjectsParallel",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Object scanning in parallel",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.ScanObjectsParallel,
                /*fieldName*/ "ScanObjectsParallel",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackAccessChain": {
            return OptionDescriptor.create(
                /*name*/ "TrackAccessChain",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the callers for methods and accessing methods for fields.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.TrackAccessChain,
                /*fieldName*/ "TrackAccessChain",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackInputFlows": {
            return OptionDescriptor.create(
                /*name*/ "TrackInputFlows",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the input for type flows.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.TrackInputFlows,
                /*fieldName*/ "TrackInputFlows",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackNeverNullInstanceFields": {
            return OptionDescriptor.create(
                /*name*/ "TrackNeverNullInstanceFields",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track in the static analysis whether an instance field is never null.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.TrackNeverNullInstanceFields,
                /*fieldName*/ "TrackNeverNullInstanceFields",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackPrimitiveValues": {
            return OptionDescriptor.create(
                /*name*/ "TrackPrimitiveValues",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track primitive values using the infrastructure of points-to analysis.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.TrackPrimitiveValues,
                /*fieldName*/ "TrackPrimitiveValues",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TypeFlowSaturationCutoff": {
            return OptionDescriptor.create(
                /*name*/ "TypeFlowSaturationCutoff",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of types recorded in a type flow. -1 indicates no limitation.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.TypeFlowSaturationCutoff,
                /*fieldName*/ "TypeFlowSaturationCutoff",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UnresolvedIsError": {
            return OptionDescriptor.create(
                /*name*/ "UnresolvedIsError",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.UnresolvedIsError,
                /*fieldName*/ "UnresolvedIsError",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "UseConservativeUnsafeAccess": {
            return OptionDescriptor.create(
                /*name*/ "UseConservativeUnsafeAccess",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Conservative unsafe access injects all unsafe accessed fields with the instantiated subtypes of their declared type and saturates all unsafe loads.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.UseConservativeUnsafeAccess,
                /*fieldName*/ "UseConservativeUnsafeAccess",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseExperimentalReachabilityAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "UseExperimentalReachabilityAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use experimental Reachability Analysis instead of points-to.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.UseExperimentalReachabilityAnalysis,
                /*fieldName*/ "UseExperimentalReachabilityAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UsePredicates": {
            return OptionDescriptor.create(
                /*name*/ "UsePredicates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use predicates in points-to analysis.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.UsePredicates,
                /*fieldName*/ "UsePredicates",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseReachabilityMethodSummaries": {
            return OptionDescriptor.create(
                /*name*/ "UseReachabilityMethodSummaries",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use method summaries for Reachability Analysis.",
                /*container*/ getContainer(),
                /*option*/ PointstoOptions.UseReachabilityMethodSummaries,
                /*fieldName*/ "UseReachabilityMethodSummaries",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 36;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AliasArrayTypeFlows");
                    case 1: return get("AllocationSiteSensitiveHeap");
                    case 2: return get("AnalysisContextSensitivity");
                    case 3: return get("AnalysisSizeCutoff");
                    case 4: return get("ConditionalEliminationBeforeAnalysis");
                    case 5: return get("EscapeAnalysisBeforeAnalysis");
                    case 6: return get("HybridStaticContext");
                    case 7: return get("InspectServerContentPath");
                    case 8: return get("LimitObjectArrayLength");
                    case 9: return get("MaxCallingContextDepth");
                    case 10: return get("MaxCallingContextWidth");
                    case 11: return get("MaxConstantObjectsPerType");
                    case 12: return get("MaxHeapContextDepth");
                    case 13: return get("MaxHeapContextWidth");
                    case 14: return get("MaxObjectSetSize");
                    case 15: return get("MinCallingContextDepth");
                    case 16: return get("MinHeapContextDepth");
                    case 17: return get("OptimizeReturnedParameter");
                    case 18: return get("ParsingContextMaxDepth");
                    case 19: return get("PrintPointsToStatistics");
                    case 20: return get("PrintSynchronizedAnalysis");
                    case 21: return get("ProfileAnalysisOperations");
                    case 22: return get("ProfileConstantObjects");
                    case 23: return get("RelaxTypeFlowStateConstraints");
                    case 24: return get("RemoveSaturatedTypeFlows");
                    case 25: return get("ScanObjectsParallel");
                    case 26: return get("TrackAccessChain");
                    case 27: return get("TrackInputFlows");
                    case 28: return get("TrackNeverNullInstanceFields");
                    case 29: return get("TrackPrimitiveValues");
                    case 30: return get("TypeFlowSaturationCutoff");
                    case 31: return get("UnresolvedIsError");
                    case 32: return get("UseConservativeUnsafeAccess");
                    case 33: return get("UseExperimentalReachabilityAnalysis");
                    case 34: return get("UsePredicates");
                    case 35: return get("UseReachabilityMethodSummaries");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
