// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: PerfManager.Options.java
package com.oracle.svm.core.jvmstat;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class PerfManager_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(PerfManager.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "PerfDataMemoryMappedFile": {
            return OptionDescriptor.create(
                /*name*/ "PerfDataMemoryMappedFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if the collected performance data should be written to a memory-mapped file so that it can be accessed by external tools.",
                /*container*/ getContainer(),
                /*option*/ PerfManager.Options.PerfDataMemoryMappedFile,
                /*fieldName*/ "PerfDataMemoryMappedFile",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PerfDataMemorySize": {
            return OptionDescriptor.create(
                /*name*/ "PerfDataMemorySize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Size of performance data memory region. Will be rounded up to a multiple of the native os page size.",
                /*container*/ getContainer(),
                /*option*/ PerfManager.Options.PerfDataMemorySize,
                /*fieldName*/ "PerfDataMemorySize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PerfDataSamplingInterval": {
            return OptionDescriptor.create(
                /*name*/ "PerfDataSamplingInterval",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Jvmstat instrumentation sampling interval (in milliseconds)",
                /*container*/ getContainer(),
                /*option*/ PerfManager.Options.PerfDataSamplingInterval,
                /*fieldName*/ "PerfDataSamplingInterval",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PerfMaxStringConstLength": {
            return OptionDescriptor.create(
                /*name*/ "PerfMaxStringConstLength",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum PerfStringConstant string length before truncation",
                /*container*/ getContainer(),
                /*option*/ PerfManager.Options.PerfMaxStringConstLength,
                /*fieldName*/ "PerfMaxStringConstLength",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 4;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("PerfDataMemoryMappedFile");
                    case 1: return get("PerfDataMemorySize");
                    case 2: return get("PerfDataSamplingInterval");
                    case 3: return get("PerfMaxStringConstLength");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
