/*
 * Copyright (c) 2024, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
// @formatter:off
// Checkstyle: stop
// Generated by Cap'n Proto compiler, DO NOT EDIT
// source: SharedLayerSnapshotCapnProtoSchema.capnp

package com.oracle.svm.hosted.imagelayer;

import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

/**
 * This class contains the methods used by the Native Image Layers feature to communicate with the Cap'n Proto Java runtime.
 * The Native Image Layers feature uses Cap'n Proto to serialize and deserialize metadata between layered build processes.
 * This file is generated from the {@code SharedLayerSnapshotCapnProtoSchema.capnp} schema file using {@code mx capnp-compile}
 * and should not be modified manually.
*/
@Platforms(Platform.HOSTED_ONLY.class)
@SuppressWarnings("all")
public final class SharedLayerSnapshotCapnProtoSchemaHolder {
  public static class PersistedAnalysisType {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)4,(short)14);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return PersistedAnalysisType.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getId() {
        return _getIntField(0);
      }
      public final void setId(int value) {
        _setIntField(0, value);
      }

      public final boolean hasDescriptor() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getDescriptor() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setDescriptor(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setDescriptor(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initDescriptor(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasFields() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getFields() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }
      public final void setFields(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initFields(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, size);
      }
      public final int getHubIdentityHashCode() {
        return _getIntField(1);
      }
      public final void setHubIdentityHashCode(int value) {
        _setIntField(1, value);
      }

      public final boolean hasClassJavaName() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassJavaName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }
      public final void setClassJavaName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, value);
      }
      public final void setClassJavaName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassJavaName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, size);
      }
      public final boolean hasClassName() {
        return !_pointerFieldIsNull(3);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 3, null, 0, 0);
      }
      public final void setClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 3, value);
      }
      public final void setClassName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 3, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 3, size);
      }
      public final int getModifiers() {
        return _getIntField(2);
      }
      public final void setModifiers(int value) {
        _setIntField(2, value);
      }

      public final boolean getIsInterface() {
        return _getBooleanField(96);
      }
      public final void setIsInterface(boolean value) {
        _setBooleanField(96, value);
      }

      public final boolean getIsEnum() {
        return _getBooleanField(97);
      }
      public final void setIsEnum(boolean value) {
        _setBooleanField(97, value);
      }

      public final boolean getIsInitialized() {
        return _getBooleanField(98);
      }
      public final void setIsInitialized(boolean value) {
        _setBooleanField(98, value);
      }

      public final boolean getIsFailedInitialization() {
        return _getBooleanField(99);
      }
      public final void setIsFailedInitialization(boolean value) {
        _setBooleanField(99, value);
      }

      public final boolean getIsLinked() {
        return _getBooleanField(100);
      }
      public final void setIsLinked(boolean value) {
        _setBooleanField(100, value);
      }

      public final boolean hasSourceFileName() {
        return !_pointerFieldIsNull(4);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getSourceFileName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 4, null, 0, 0);
      }
      public final void setSourceFileName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 4, value);
      }
      public final void setSourceFileName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 4, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initSourceFileName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 4, size);
      }
      public final int getEnclosingTypeId() {
        return _getIntField(4);
      }
      public final void setEnclosingTypeId(int value) {
        _setIntField(4, value);
      }

      public final int getComponentTypeId() {
        return _getIntField(5);
      }
      public final void setComponentTypeId(int value) {
        _setIntField(5, value);
      }

      public final int getSuperClassTypeId() {
        return _getIntField(6);
      }
      public final void setSuperClassTypeId(int value) {
        _setIntField(6, value);
      }

      public final boolean getIsInstantiated() {
        return _getBooleanField(101);
      }
      public final void setIsInstantiated(boolean value) {
        _setBooleanField(101, value);
      }

      public final boolean getIsUnsafeAllocated() {
        return _getBooleanField(102);
      }
      public final void setIsUnsafeAllocated(boolean value) {
        _setBooleanField(102, value);
      }

      public final boolean getIsReachable() {
        return _getBooleanField(103);
      }
      public final void setIsReachable(boolean value) {
        _setBooleanField(103, value);
      }

      public final boolean hasInterfaces() {
        return !_pointerFieldIsNull(5);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getInterfaces() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 5, null, 0);
      }
      public final void setInterfaces(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 5, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initInterfaces(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 5, size);
      }
      public final boolean hasInstanceFieldIds() {
        return !_pointerFieldIsNull(6);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getInstanceFieldIds() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 6, null, 0);
      }
      public final void setInstanceFieldIds(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 6, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initInstanceFieldIds(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 6, size);
      }
      public final boolean hasInstanceFieldIdsWithSuper() {
        return !_pointerFieldIsNull(7);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getInstanceFieldIdsWithSuper() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 7, null, 0);
      }
      public final void setInstanceFieldIdsWithSuper(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 7, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initInstanceFieldIdsWithSuper(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 7, size);
      }
      public final boolean hasStaticFieldIds() {
        return !_pointerFieldIsNull(8);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getStaticFieldIds() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 8, null, 0);
      }
      public final void setStaticFieldIds(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 8, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initStaticFieldIds(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 8, size);
      }
      public final boolean hasAnnotationList() {
        return !_pointerFieldIsNull(9);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder> getAnnotationList() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 9, null, 0);
      }
      public final void setAnnotationList(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 9, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder> initAnnotationList(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 9, size);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.Builder getClassInitializationInfo() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.factory, 10, null, 0);
      }
      public final void setClassInitializationInfo(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.Reader value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.factory,10, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.Builder initClassInitializationInfo() {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.factory,10, 0);
      }
      public final boolean getHasArrayType() {
        return _getBooleanField(104);
      }
      public final void setHasArrayType(boolean value) {
        _setBooleanField(104, value);
      }

      public final boolean hasSubTypes() {
        return !_pointerFieldIsNull(11);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getSubTypes() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 11, null, 0);
      }
      public final void setSubTypes(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 11, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initSubTypes(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 11, size);
      }
      public final boolean getIsAnySubtypeInstantiated() {
        return _getBooleanField(105);
      }
      public final void setIsAnySubtypeInstantiated(boolean value) {
        _setBooleanField(105, value);
      }

      public final WrappedType.Builder getWrappedType() {
        return new PersistedAnalysisType.WrappedType.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final WrappedType.Builder initWrappedType() {
        _setShortField(7,(short)0);
        _clearPointerField(12);
        _clearPointerField(13);
  return new PersistedAnalysisType.WrappedType.Builder(segment, data, pointers, dataSize, pointerCount);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getId() {
        return _getIntField(0);
      }

      public boolean hasDescriptor() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getDescriptor() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final boolean hasFields() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getFields() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }

      public final int getHubIdentityHashCode() {
        return _getIntField(1);
      }

      public boolean hasClassJavaName() {
        return !_pointerFieldIsNull(2);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassJavaName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }

      public boolean hasClassName() {
        return !_pointerFieldIsNull(3);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 3, null, 0, 0);
      }

      public final int getModifiers() {
        return _getIntField(2);
      }

      public final boolean getIsInterface() {
        return _getBooleanField(96);
      }

      public final boolean getIsEnum() {
        return _getBooleanField(97);
      }

      public final boolean getIsInitialized() {
        return _getBooleanField(98);
      }

      public final boolean getIsFailedInitialization() {
        return _getBooleanField(99);
      }

      public final boolean getIsLinked() {
        return _getBooleanField(100);
      }

      public boolean hasSourceFileName() {
        return !_pointerFieldIsNull(4);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getSourceFileName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 4, null, 0, 0);
      }

      public final int getEnclosingTypeId() {
        return _getIntField(4);
      }

      public final int getComponentTypeId() {
        return _getIntField(5);
      }

      public final int getSuperClassTypeId() {
        return _getIntField(6);
      }

      public final boolean getIsInstantiated() {
        return _getBooleanField(101);
      }

      public final boolean getIsUnsafeAllocated() {
        return _getBooleanField(102);
      }

      public final boolean getIsReachable() {
        return _getBooleanField(103);
      }

      public final boolean hasInterfaces() {
        return !_pointerFieldIsNull(5);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getInterfaces() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 5, null, 0);
      }

      public final boolean hasInstanceFieldIds() {
        return !_pointerFieldIsNull(6);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getInstanceFieldIds() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 6, null, 0);
      }

      public final boolean hasInstanceFieldIdsWithSuper() {
        return !_pointerFieldIsNull(7);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getInstanceFieldIdsWithSuper() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 7, null, 0);
      }

      public final boolean hasStaticFieldIds() {
        return !_pointerFieldIsNull(8);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getStaticFieldIds() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 8, null, 0);
      }

      public final boolean hasAnnotationList() {
        return !_pointerFieldIsNull(9);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader> getAnnotationList() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 9, null, 0);
      }

      public boolean hasClassInitializationInfo() {
        return !_pointerFieldIsNull(10);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.Reader getClassInitializationInfo() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.factory,10,null, 0);
      }

      public final boolean getHasArrayType() {
        return _getBooleanField(104);
      }

      public final boolean hasSubTypes() {
        return !_pointerFieldIsNull(11);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getSubTypes() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 11, null, 0);
      }

      public final boolean getIsAnySubtypeInstantiated() {
        return _getBooleanField(105);
      }

      public WrappedType.Reader getWrappedType() {
        return new PersistedAnalysisType.WrappedType.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

    }

    public static class WrappedType {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)4,(short)14);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return PersistedAnalysisType.WrappedType.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public Which which() {
          switch(_getShortField(7)) {
            case 0 : return Which.NONE;
            case 1 : return Which.SERIALIZATION_GENERATED;
            case 2 : return Which.LAMBDA;
            case 3 : return Which.PROXY_TYPE;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final boolean isNone() {
          return which() == PersistedAnalysisType.WrappedType.Which.NONE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getNone() {
          assert which() == PersistedAnalysisType.WrappedType.Which.NONE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }
        public final void setNone(com.oracle.svm.shaded.org.capnproto.Void value) {
          _setShortField(7, (short)PersistedAnalysisType.WrappedType.Which.NONE.ordinal());
        }

        public final boolean isSerializationGenerated() {
          return which() == PersistedAnalysisType.WrappedType.Which.SERIALIZATION_GENERATED;
        }
        public final SerializationGenerated.Builder getSerializationGenerated() {
          return new PersistedAnalysisType.WrappedType.SerializationGenerated.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final SerializationGenerated.Builder initSerializationGenerated() {
          _setShortField(7, (short)PersistedAnalysisType.WrappedType.Which.SERIALIZATION_GENERATED.ordinal());
          _clearPointerField(12);
          _clearPointerField(13);
  return new PersistedAnalysisType.WrappedType.SerializationGenerated.Builder(segment, data, pointers, dataSize, pointerCount);
        }

        public final boolean isLambda() {
          return which() == PersistedAnalysisType.WrappedType.Which.LAMBDA;
        }
        public final Lambda.Builder getLambda() {
          return new PersistedAnalysisType.WrappedType.Lambda.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final Lambda.Builder initLambda() {
          _setShortField(7, (short)PersistedAnalysisType.WrappedType.Which.LAMBDA.ordinal());
          _clearPointerField(12);
  return new PersistedAnalysisType.WrappedType.Lambda.Builder(segment, data, pointers, dataSize, pointerCount);
        }

        public final boolean isProxyType() {
          return which() == PersistedAnalysisType.WrappedType.Which.PROXY_TYPE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getProxyType() {
          assert which() == PersistedAnalysisType.WrappedType.Which.PROXY_TYPE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }
        public final void setProxyType(com.oracle.svm.shaded.org.capnproto.Void value) {
          _setShortField(7, (short)PersistedAnalysisType.WrappedType.Which.PROXY_TYPE.ordinal());
        }

      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public Which which() {
          switch(_getShortField(7)) {
            case 0 : return Which.NONE;
            case 1 : return Which.SERIALIZATION_GENERATED;
            case 2 : return Which.LAMBDA;
            case 3 : return Which.PROXY_TYPE;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final boolean isNone() {
          return which() == PersistedAnalysisType.WrappedType.Which.NONE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getNone() {
          assert which() == PersistedAnalysisType.WrappedType.Which.NONE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }

        public final boolean isSerializationGenerated() {
          return which() == PersistedAnalysisType.WrappedType.Which.SERIALIZATION_GENERATED;
        }
        public SerializationGenerated.Reader getSerializationGenerated() {
          return new PersistedAnalysisType.WrappedType.SerializationGenerated.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final boolean isLambda() {
          return which() == PersistedAnalysisType.WrappedType.Which.LAMBDA;
        }
        public Lambda.Reader getLambda() {
          return new PersistedAnalysisType.WrappedType.Lambda.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final boolean isProxyType() {
          return which() == PersistedAnalysisType.WrappedType.Which.PROXY_TYPE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getProxyType() {
          assert which() == PersistedAnalysisType.WrappedType.Which.PROXY_TYPE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }

      }

      public enum Which {
        NONE,
        SERIALIZATION_GENERATED,
        LAMBDA,
        PROXY_TYPE,
        _NOT_IN_SCHEMA,
      }
      public static class SerializationGenerated {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)4,(short)14);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedAnalysisType.WrappedType.SerializationGenerated.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final boolean hasRawDeclaringClass() {
            return !_pointerFieldIsNull(12);
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder getRawDeclaringClass() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, null, 0, 0);
          }
          public final void setRawDeclaringClass(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, value);
          }
          public final void setRawDeclaringClass(String value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder initRawDeclaringClass(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, size);
          }
          public final boolean hasRawTargetConstructor() {
            return !_pointerFieldIsNull(13);
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder getRawTargetConstructor() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 13, null, 0, 0);
          }
          public final void setRawTargetConstructor(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 13, value);
          }
          public final void setRawTargetConstructor(String value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 13, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder initRawTargetConstructor(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 13, size);
          }
        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public boolean hasRawDeclaringClass() {
            return !_pointerFieldIsNull(12);
          }
          public com.oracle.svm.shaded.org.capnproto.Text.Reader getRawDeclaringClass() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, null, 0, 0);
          }

          public boolean hasRawTargetConstructor() {
            return !_pointerFieldIsNull(13);
          }
          public com.oracle.svm.shaded.org.capnproto.Text.Reader getRawTargetConstructor() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 13, null, 0, 0);
          }

        }

      }


      public static class Lambda {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)4,(short)14);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedAnalysisType.WrappedType.Lambda.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final boolean hasCapturingClass() {
            return !_pointerFieldIsNull(12);
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder getCapturingClass() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, null, 0, 0);
          }
          public final void setCapturingClass(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, value);
          }
          public final void setCapturingClass(String value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder initCapturingClass(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, size);
          }
        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public boolean hasCapturingClass() {
            return !_pointerFieldIsNull(12);
          }
          public com.oracle.svm.shaded.org.capnproto.Text.Reader getCapturingClass() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, null, 0, 0);
          }

        }

      }


    }


  }


  public static class ClassInitializationInfo {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)0);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return ClassInitializationInfo.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean getIsNoInitializerNoTracking() {
        return _getBooleanField(0);
      }
      public final void setIsNoInitializerNoTracking(boolean value) {
        _setBooleanField(0, value);
      }

      public final boolean getIsInitializedNoTracking() {
        return _getBooleanField(1);
      }
      public final void setIsInitializedNoTracking(boolean value) {
        _setBooleanField(1, value);
      }

      public final boolean getIsFailedNoTracking() {
        return _getBooleanField(2);
      }
      public final void setIsFailedNoTracking(boolean value) {
        _setBooleanField(2, value);
      }

      public final boolean getIsInitialized() {
        return _getBooleanField(3);
      }
      public final void setIsInitialized(boolean value) {
        _setBooleanField(3, value);
      }

      public final boolean getIsInErrorState() {
        return _getBooleanField(4);
      }
      public final void setIsInErrorState(boolean value) {
        _setBooleanField(4, value);
      }

      public final boolean getIsLinked() {
        return _getBooleanField(5);
      }
      public final void setIsLinked(boolean value) {
        _setBooleanField(5, value);
      }

      public final boolean getHasInitializer() {
        return _getBooleanField(6);
      }
      public final void setHasInitializer(boolean value) {
        _setBooleanField(6, value);
      }

      public final boolean getIsBuildTimeInitialized() {
        return _getBooleanField(7);
      }
      public final void setIsBuildTimeInitialized(boolean value) {
        _setBooleanField(7, value);
      }

      public final boolean getIsTracked() {
        return _getBooleanField(8);
      }
      public final void setIsTracked(boolean value) {
        _setBooleanField(8, value);
      }

      public final int getInitializerMethodId() {
        return _getIntField(1);
      }
      public final void setInitializerMethodId(int value) {
        _setIntField(1, value);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean getIsNoInitializerNoTracking() {
        return _getBooleanField(0);
      }

      public final boolean getIsInitializedNoTracking() {
        return _getBooleanField(1);
      }

      public final boolean getIsFailedNoTracking() {
        return _getBooleanField(2);
      }

      public final boolean getIsInitialized() {
        return _getBooleanField(3);
      }

      public final boolean getIsInErrorState() {
        return _getBooleanField(4);
      }

      public final boolean getIsLinked() {
        return _getBooleanField(5);
      }

      public final boolean getHasInitializer() {
        return _getBooleanField(6);
      }

      public final boolean getIsBuildTimeInitialized() {
        return _getBooleanField(7);
      }

      public final boolean getIsTracked() {
        return _getBooleanField(8);
      }

      public final int getInitializerMethodId() {
        return _getIntField(1);
      }

    }

  }


  public static class PersistedAnalysisMethod {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)13);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return PersistedAnalysisMethod.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getId() {
        return _getIntField(0);
      }
      public final void setId(int value) {
        _setIntField(0, value);
      }

      public final boolean hasDescriptor() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getDescriptor() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setDescriptor(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setDescriptor(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initDescriptor(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasName() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }
      public final void setName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
      }
      public final void setName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
      }
      public final boolean hasClassName() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }
      public final void setClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, value);
      }
      public final void setClassName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, size);
      }
      public final int getDeclaringTypeId() {
        return _getIntField(1);
      }
      public final void setDeclaringTypeId(int value) {
        _setIntField(1, value);
      }

      public final boolean hasArgumentClassNames() {
        return !_pointerFieldIsNull(3);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getArgumentClassNames() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 3, null, 0);
      }
      public final void setArgumentClassNames(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 3, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initArgumentClassNames(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 3, size);
      }
      public final boolean hasArgumentTypeIds() {
        return !_pointerFieldIsNull(4);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getArgumentTypeIds() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 4, null, 0);
      }
      public final void setArgumentTypeIds(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 4, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initArgumentTypeIds(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 4, size);
      }
      public final int getReturnTypeId() {
        return _getIntField(2);
      }
      public final void setReturnTypeId(int value) {
        _setIntField(2, value);
      }

      public final int getModifiers() {
        return _getIntField(3);
      }
      public final void setModifiers(int value) {
        _setIntField(3, value);
      }

      public final boolean hasBytecode() {
        return !_pointerFieldIsNull(5);
      }
      public final com.oracle.svm.shaded.org.capnproto.Data.Builder getBytecode() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Data.factory, 5, null, 0, 0);
      }
      public final void setBytecode(com.oracle.svm.shaded.org.capnproto.Data.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Data.factory, 5, value);
      }
      public final void setBytecode(byte [] value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Data.factory, 5, new com.oracle.svm.shaded.org.capnproto.Data.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Data.Builder initBytecode(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Data.factory, 5, size);
      }
      public final int getBytecodeSize() {
        return _getIntField(4);
      }
      public final void setBytecodeSize(int value) {
        _setIntField(4, value);
      }

      public final boolean getIsConstructor() {
        return _getBooleanField(160);
      }
      public final void setIsConstructor(boolean value) {
        _setBooleanField(160, value);
      }

      public final boolean getIsSynthetic() {
        return _getBooleanField(161);
      }
      public final void setIsSynthetic(boolean value) {
        _setBooleanField(161, value);
      }

      public final boolean getCanBeStaticallyBound() {
        return _getBooleanField(162);
      }
      public final void setCanBeStaticallyBound(boolean value) {
        _setBooleanField(162, value);
      }

      public final boolean getIsVirtualRootMethod() {
        return _getBooleanField(163);
      }
      public final void setIsVirtualRootMethod(boolean value) {
        _setBooleanField(163, value);
      }

      public final boolean getIsDirectRootMethod() {
        return _getBooleanField(164);
      }
      public final void setIsDirectRootMethod(boolean value) {
        _setBooleanField(164, value);
      }

      public final boolean getIsInvoked() {
        return _getBooleanField(165);
      }
      public final void setIsInvoked(boolean value) {
        _setBooleanField(165, value);
      }

      public final boolean getIsImplementationInvoked() {
        return _getBooleanField(166);
      }
      public final void setIsImplementationInvoked(boolean value) {
        _setBooleanField(166, value);
      }

      public final boolean getIsIntrinsicMethod() {
        return _getBooleanField(167);
      }
      public final void setIsIntrinsicMethod(boolean value) {
        _setBooleanField(167, value);
      }

      public final boolean hasMethodHandleIntrinsicName() {
        return !_pointerFieldIsNull(6);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getMethodHandleIntrinsicName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 6, null, 0, 0);
      }
      public final void setMethodHandleIntrinsicName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 6, value);
      }
      public final void setMethodHandleIntrinsicName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 6, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initMethodHandleIntrinsicName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 6, size);
      }
      public final boolean hasAnnotationList() {
        return !_pointerFieldIsNull(7);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder> getAnnotationList() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 7, null, 0);
      }
      public final void setAnnotationList(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 7, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder> initAnnotationList(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 7, size);
      }
      public final boolean getIsVarArgs() {
        return _getBooleanField(168);
      }
      public final void setIsVarArgs(boolean value) {
        _setBooleanField(168, value);
      }

      public final boolean getIsBridge() {
        return _getBooleanField(169);
      }
      public final void setIsBridge(boolean value) {
        _setBooleanField(169, value);
      }

      public final boolean hasAnalysisGraphLocation() {
        return !_pointerFieldIsNull(8);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getAnalysisGraphLocation() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 8, null, 0, 0);
      }
      public final void setAnalysisGraphLocation(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 8, value);
      }
      public final void setAnalysisGraphLocation(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 8, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initAnalysisGraphLocation(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 8, size);
      }
      public final boolean getAnalysisGraphIsIntrinsic() {
        return _getBooleanField(170);
      }
      public final void setAnalysisGraphIsIntrinsic(boolean value) {
        _setBooleanField(170, value);
      }

      public final boolean hasStrengthenedGraphLocation() {
        return !_pointerFieldIsNull(9);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getStrengthenedGraphLocation() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 9, null, 0, 0);
      }
      public final void setStrengthenedGraphLocation(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 9, value);
      }
      public final void setStrengthenedGraphLocation(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 9, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initStrengthenedGraphLocation(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 9, size);
      }
      public final int getHostedMethodIndex() {
        return _getIntField(6);
      }
      public final void setHostedMethodIndex(int value) {
        _setIntField(6, value);
      }

      public final WrappedMethod.Builder getWrappedMethod() {
        return new PersistedAnalysisMethod.WrappedMethod.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final WrappedMethod.Builder initWrappedMethod() {
        _setBooleanField(171,false);
        _setShortField(11,(short)0);
        _setIntField(7,0);
        _setIntField(8,0);
        _clearPointerField(10);
        _clearPointerField(11);
        _clearPointerField(12);
  return new PersistedAnalysisMethod.WrappedMethod.Builder(segment, data, pointers, dataSize, pointerCount);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getId() {
        return _getIntField(0);
      }

      public boolean hasDescriptor() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getDescriptor() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public boolean hasName() {
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }

      public boolean hasClassName() {
        return !_pointerFieldIsNull(2);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }

      public final int getDeclaringTypeId() {
        return _getIntField(1);
      }

      public final boolean hasArgumentClassNames() {
        return !_pointerFieldIsNull(3);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getArgumentClassNames() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 3, null, 0);
      }

      public final boolean hasArgumentTypeIds() {
        return !_pointerFieldIsNull(4);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getArgumentTypeIds() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 4, null, 0);
      }

      public final int getReturnTypeId() {
        return _getIntField(2);
      }

      public final int getModifiers() {
        return _getIntField(3);
      }

      public boolean hasBytecode() {
        return !_pointerFieldIsNull(5);
      }
      public com.oracle.svm.shaded.org.capnproto.Data.Reader getBytecode() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Data.factory, 5, null, 0, 0);
      }

      public final int getBytecodeSize() {
        return _getIntField(4);
      }

      public final boolean getIsConstructor() {
        return _getBooleanField(160);
      }

      public final boolean getIsSynthetic() {
        return _getBooleanField(161);
      }

      public final boolean getCanBeStaticallyBound() {
        return _getBooleanField(162);
      }

      public final boolean getIsVirtualRootMethod() {
        return _getBooleanField(163);
      }

      public final boolean getIsDirectRootMethod() {
        return _getBooleanField(164);
      }

      public final boolean getIsInvoked() {
        return _getBooleanField(165);
      }

      public final boolean getIsImplementationInvoked() {
        return _getBooleanField(166);
      }

      public final boolean getIsIntrinsicMethod() {
        return _getBooleanField(167);
      }

      public boolean hasMethodHandleIntrinsicName() {
        return !_pointerFieldIsNull(6);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getMethodHandleIntrinsicName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 6, null, 0, 0);
      }

      public final boolean hasAnnotationList() {
        return !_pointerFieldIsNull(7);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader> getAnnotationList() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 7, null, 0);
      }

      public final boolean getIsVarArgs() {
        return _getBooleanField(168);
      }

      public final boolean getIsBridge() {
        return _getBooleanField(169);
      }

      public boolean hasAnalysisGraphLocation() {
        return !_pointerFieldIsNull(8);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getAnalysisGraphLocation() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 8, null, 0, 0);
      }

      public final boolean getAnalysisGraphIsIntrinsic() {
        return _getBooleanField(170);
      }

      public boolean hasStrengthenedGraphLocation() {
        return !_pointerFieldIsNull(9);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getStrengthenedGraphLocation() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 9, null, 0, 0);
      }

      public final int getHostedMethodIndex() {
        return _getIntField(6);
      }

      public WrappedMethod.Reader getWrappedMethod() {
        return new PersistedAnalysisMethod.WrappedMethod.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

    }

    public static class WrappedMethod {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)13);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return PersistedAnalysisMethod.WrappedMethod.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public Which which() {
          switch(_getShortField(11)) {
            case 0 : return Which.NONE;
            case 1 : return Which.FACTORY_METHOD;
            case 2 : return Which.OUTLINED_S_B;
            case 3 : return Which.C_ENTRY_POINT_CALL_STUB;
            case 4 : return Which.WRAPPED_MEMBER;
            case 5 : return Which.POLYMORPHIC_SIGNATURE;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final boolean isNone() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.NONE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getNone() {
          assert which() == PersistedAnalysisMethod.WrappedMethod.Which.NONE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }
        public final void setNone(com.oracle.svm.shaded.org.capnproto.Void value) {
          _setShortField(11, (short)PersistedAnalysisMethod.WrappedMethod.Which.NONE.ordinal());
        }

        public final boolean isFactoryMethod() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.FACTORY_METHOD;
        }
        public final FactoryMethod.Builder getFactoryMethod() {
          return new PersistedAnalysisMethod.WrappedMethod.FactoryMethod.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final FactoryMethod.Builder initFactoryMethod() {
          _setShortField(11, (short)PersistedAnalysisMethod.WrappedMethod.Which.FACTORY_METHOD.ordinal());
          _setBooleanField(171,false);
          _setIntField(7,0);
          _setIntField(8,0);
  return new PersistedAnalysisMethod.WrappedMethod.FactoryMethod.Builder(segment, data, pointers, dataSize, pointerCount);
        }

        public final boolean isOutlinedSB() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.OUTLINED_S_B;
        }
        public final OutlinedSB.Builder getOutlinedSB() {
          return new PersistedAnalysisMethod.WrappedMethod.OutlinedSB.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final OutlinedSB.Builder initOutlinedSB() {
          _setShortField(11, (short)PersistedAnalysisMethod.WrappedMethod.Which.OUTLINED_S_B.ordinal());
          _clearPointerField(10);
          _clearPointerField(11);
  return new PersistedAnalysisMethod.WrappedMethod.OutlinedSB.Builder(segment, data, pointers, dataSize, pointerCount);
        }

        public final boolean isCEntryPointCallStub() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.C_ENTRY_POINT_CALL_STUB;
        }
        public final CEntryPointCallStub.Builder getCEntryPointCallStub() {
          return new PersistedAnalysisMethod.WrappedMethod.CEntryPointCallStub.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final CEntryPointCallStub.Builder initCEntryPointCallStub() {
          _setShortField(11, (short)PersistedAnalysisMethod.WrappedMethod.Which.C_ENTRY_POINT_CALL_STUB.ordinal());
          _setBooleanField(171,false);
          _setIntField(7,0);
  return new PersistedAnalysisMethod.WrappedMethod.CEntryPointCallStub.Builder(segment, data, pointers, dataSize, pointerCount);
        }

        public final boolean isWrappedMember() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.WRAPPED_MEMBER;
        }
        public final WrappedMember.Builder getWrappedMember() {
          return new PersistedAnalysisMethod.WrappedMethod.WrappedMember.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final WrappedMember.Builder initWrappedMember() {
          _setShortField(11, (short)PersistedAnalysisMethod.WrappedMethod.Which.WRAPPED_MEMBER.ordinal());
          _setShortField(14,(short)0);
          _clearPointerField(10);
          _clearPointerField(11);
          _clearPointerField(12);
  return new PersistedAnalysisMethod.WrappedMethod.WrappedMember.Builder(segment, data, pointers, dataSize, pointerCount);
        }

        public final boolean isPolymorphicSignature() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.POLYMORPHIC_SIGNATURE;
        }
        public final PolymorphicSignature.Builder getPolymorphicSignature() {
          return new PersistedAnalysisMethod.WrappedMethod.PolymorphicSignature.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final PolymorphicSignature.Builder initPolymorphicSignature() {
          _setShortField(11, (short)PersistedAnalysisMethod.WrappedMethod.Which.POLYMORPHIC_SIGNATURE.ordinal());
          _clearPointerField(10);
  return new PersistedAnalysisMethod.WrappedMethod.PolymorphicSignature.Builder(segment, data, pointers, dataSize, pointerCount);
        }

      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public Which which() {
          switch(_getShortField(11)) {
            case 0 : return Which.NONE;
            case 1 : return Which.FACTORY_METHOD;
            case 2 : return Which.OUTLINED_S_B;
            case 3 : return Which.C_ENTRY_POINT_CALL_STUB;
            case 4 : return Which.WRAPPED_MEMBER;
            case 5 : return Which.POLYMORPHIC_SIGNATURE;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final boolean isNone() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.NONE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getNone() {
          assert which() == PersistedAnalysisMethod.WrappedMethod.Which.NONE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }

        public final boolean isFactoryMethod() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.FACTORY_METHOD;
        }
        public FactoryMethod.Reader getFactoryMethod() {
          return new PersistedAnalysisMethod.WrappedMethod.FactoryMethod.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final boolean isOutlinedSB() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.OUTLINED_S_B;
        }
        public OutlinedSB.Reader getOutlinedSB() {
          return new PersistedAnalysisMethod.WrappedMethod.OutlinedSB.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final boolean isCEntryPointCallStub() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.C_ENTRY_POINT_CALL_STUB;
        }
        public CEntryPointCallStub.Reader getCEntryPointCallStub() {
          return new PersistedAnalysisMethod.WrappedMethod.CEntryPointCallStub.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final boolean isWrappedMember() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.WRAPPED_MEMBER;
        }
        public WrappedMember.Reader getWrappedMember() {
          return new PersistedAnalysisMethod.WrappedMethod.WrappedMember.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final boolean isPolymorphicSignature() {
          return which() == PersistedAnalysisMethod.WrappedMethod.Which.POLYMORPHIC_SIGNATURE;
        }
        public PolymorphicSignature.Reader getPolymorphicSignature() {
          return new PersistedAnalysisMethod.WrappedMethod.PolymorphicSignature.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

      }

      public enum Which {
        NONE,
        FACTORY_METHOD,
        OUTLINED_S_B,
        C_ENTRY_POINT_CALL_STUB,
        WRAPPED_MEMBER,
        POLYMORPHIC_SIGNATURE,
        _NOT_IN_SCHEMA,
      }
      public static class FactoryMethod {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)13);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedAnalysisMethod.WrappedMethod.FactoryMethod.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final int getTargetConstructorId() {
            return _getIntField(7);
          }
          public final void setTargetConstructorId(int value) {
            _setIntField(7, value);
          }

          public final boolean getThrowAllocatedObject() {
            return _getBooleanField(171);
          }
          public final void setThrowAllocatedObject(boolean value) {
            _setBooleanField(171, value);
          }

          public final int getInstantiatedTypeId() {
            return _getIntField(8);
          }
          public final void setInstantiatedTypeId(int value) {
            _setIntField(8, value);
          }

        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public final int getTargetConstructorId() {
            return _getIntField(7);
          }

          public final boolean getThrowAllocatedObject() {
            return _getBooleanField(171);
          }

          public final int getInstantiatedTypeId() {
            return _getIntField(8);
          }

        }

      }


      public static class OutlinedSB {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)13);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedAnalysisMethod.WrappedMethod.OutlinedSB.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final boolean hasMethodTypeReturn() {
            return !_pointerFieldIsNull(10);
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder getMethodTypeReturn() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, null, 0, 0);
          }
          public final void setMethodTypeReturn(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, value);
          }
          public final void setMethodTypeReturn(String value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder initMethodTypeReturn(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, size);
          }
          public final boolean hasMethodTypeParameters() {
            return !_pointerFieldIsNull(11);
          }
          public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getMethodTypeParameters() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 11, null, 0);
          }
          public final void setMethodTypeParameters(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 11, value);
          }
          public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initMethodTypeParameters(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 11, size);
          }
        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public boolean hasMethodTypeReturn() {
            return !_pointerFieldIsNull(10);
          }
          public com.oracle.svm.shaded.org.capnproto.Text.Reader getMethodTypeReturn() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, null, 0, 0);
          }

          public final boolean hasMethodTypeParameters() {
            return !_pointerFieldIsNull(11);
          }
          public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getMethodTypeParameters() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 11, null, 0);
          }

        }

      }


      public static class CEntryPointCallStub {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)13);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedAnalysisMethod.WrappedMethod.CEntryPointCallStub.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final int getOriginalMethodId() {
            return _getIntField(7);
          }
          public final void setOriginalMethodId(int value) {
            _setIntField(7, value);
          }

          public final boolean getNotPublished() {
            return _getBooleanField(171);
          }
          public final void setNotPublished(boolean value) {
            _setBooleanField(171, value);
          }

        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public final int getOriginalMethodId() {
            return _getIntField(7);
          }

          public final boolean getNotPublished() {
            return _getBooleanField(171);
          }

        }

      }


      public static class WrappedMember {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)13);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedAnalysisMethod.WrappedMethod.WrappedMember.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public Which which() {
            switch(_getShortField(14)) {
              case 0 : return Which.REFLECTION_EXPAND_SIGNATURE;
              case 1 : return Which.JAVA_CALL_VARIANT_WRAPPER;
              default: return Which._NOT_IN_SCHEMA;
            }
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final boolean isReflectionExpandSignature() {
            return which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.REFLECTION_EXPAND_SIGNATURE;
          }
          public final com.oracle.svm.shaded.org.capnproto.Void getReflectionExpandSignature() {
            assert which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.REFLECTION_EXPAND_SIGNATURE:
                        "Must check which() before get()ing a union member.";
            return com.oracle.svm.shaded.org.capnproto.Void.VOID;
          }
          public final void setReflectionExpandSignature(com.oracle.svm.shaded.org.capnproto.Void value) {
            _setShortField(14, (short)PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.REFLECTION_EXPAND_SIGNATURE.ordinal());
          }

          public final boolean isJavaCallVariantWrapper() {
            return which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.JAVA_CALL_VARIANT_WRAPPER;
          }
          public final com.oracle.svm.shaded.org.capnproto.Void getJavaCallVariantWrapper() {
            assert which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.JAVA_CALL_VARIANT_WRAPPER:
                        "Must check which() before get()ing a union member.";
            return com.oracle.svm.shaded.org.capnproto.Void.VOID;
          }
          public final void setJavaCallVariantWrapper(com.oracle.svm.shaded.org.capnproto.Void value) {
            _setShortField(14, (short)PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.JAVA_CALL_VARIANT_WRAPPER.ordinal());
          }

          public final boolean hasName() {
            return !_pointerFieldIsNull(10);
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder getName() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, null, 0, 0);
          }
          public final void setName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, value);
          }
          public final void setName(String value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder initName(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, size);
          }
          public final boolean hasDeclaringClassName() {
            return !_pointerFieldIsNull(11);
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder getDeclaringClassName() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 11, null, 0, 0);
          }
          public final void setDeclaringClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 11, value);
          }
          public final void setDeclaringClassName(String value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 11, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
          }
          public final com.oracle.svm.shaded.org.capnproto.Text.Builder initDeclaringClassName(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 11, size);
          }
          public final boolean hasArgumentTypeNames() {
            return !_pointerFieldIsNull(12);
          }
          public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getArgumentTypeNames() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 12, null, 0);
          }
          public final void setArgumentTypeNames(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 12, value);
          }
          public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initArgumentTypeNames(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 12, size);
          }
        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public Which which() {
            switch(_getShortField(14)) {
              case 0 : return Which.REFLECTION_EXPAND_SIGNATURE;
              case 1 : return Which.JAVA_CALL_VARIANT_WRAPPER;
              default: return Which._NOT_IN_SCHEMA;
            }
          }
          public final boolean isReflectionExpandSignature() {
            return which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.REFLECTION_EXPAND_SIGNATURE;
          }
          public final com.oracle.svm.shaded.org.capnproto.Void getReflectionExpandSignature() {
            assert which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.REFLECTION_EXPAND_SIGNATURE:
                        "Must check which() before get()ing a union member.";
            return com.oracle.svm.shaded.org.capnproto.Void.VOID;
          }

          public final boolean isJavaCallVariantWrapper() {
            return which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.JAVA_CALL_VARIANT_WRAPPER;
          }
          public final com.oracle.svm.shaded.org.capnproto.Void getJavaCallVariantWrapper() {
            assert which() == PersistedAnalysisMethod.WrappedMethod.WrappedMember.Which.JAVA_CALL_VARIANT_WRAPPER:
                        "Must check which() before get()ing a union member.";
            return com.oracle.svm.shaded.org.capnproto.Void.VOID;
          }

          public boolean hasName() {
            return !_pointerFieldIsNull(10);
          }
          public com.oracle.svm.shaded.org.capnproto.Text.Reader getName() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 10, null, 0, 0);
          }

          public boolean hasDeclaringClassName() {
            return !_pointerFieldIsNull(11);
          }
          public com.oracle.svm.shaded.org.capnproto.Text.Reader getDeclaringClassName() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 11, null, 0, 0);
          }

          public final boolean hasArgumentTypeNames() {
            return !_pointerFieldIsNull(12);
          }
          public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getArgumentTypeNames() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 12, null, 0);
          }

        }

        public enum Which {
          REFLECTION_EXPAND_SIGNATURE,
          JAVA_CALL_VARIANT_WRAPPER,
          _NOT_IN_SCHEMA,
        }
      }


      public static class PolymorphicSignature {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)13);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedAnalysisMethod.WrappedMethod.PolymorphicSignature.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final boolean hasCallers() {
            return !_pointerFieldIsNull(10);
          }
          public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getCallers() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 10, null, 0);
          }
          public final void setCallers(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
            _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 10, value);
          }
          public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initCallers(int size) {
            return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 10, size);
          }
        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public final boolean hasCallers() {
            return !_pointerFieldIsNull(10);
          }
          public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getCallers() {
            return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 10, null, 0);
          }

        }

      }


    }


  }


  public static class PersistedAnalysisField {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)3);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return PersistedAnalysisField.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getId() {
        return _getIntField(0);
      }
      public final void setId(int value) {
        _setIntField(0, value);
      }

      public final boolean hasClassName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setClassName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final int getDeclaringTypeId() {
        return _getIntField(1);
      }
      public final void setDeclaringTypeId(int value) {
        _setIntField(1, value);
      }

      public final int getTypeId() {
        return _getIntField(2);
      }
      public final void setTypeId(int value) {
        _setIntField(2, value);
      }

      public final int getPosition() {
        return _getIntField(3);
      }
      public final void setPosition(int value) {
        _setIntField(3, value);
      }

      public final int getLocation() {
        return _getIntField(4);
      }
      public final void setLocation(int value) {
        _setIntField(4, value);
      }

      public final int getModifiers() {
        return _getIntField(5);
      }
      public final void setModifiers(int value) {
        _setIntField(5, value);
      }

      public final boolean getIsInternal() {
        return _getBooleanField(192);
      }
      public final void setIsInternal(boolean value) {
        _setBooleanField(192, value);
      }

      public final boolean getIsAccessed() {
        return _getBooleanField(193);
      }
      public final void setIsAccessed(boolean value) {
        _setBooleanField(193, value);
      }

      public final boolean getIsRead() {
        return _getBooleanField(194);
      }
      public final void setIsRead(boolean value) {
        _setBooleanField(194, value);
      }

      public final boolean getIsWritten() {
        return _getBooleanField(195);
      }
      public final void setIsWritten(boolean value) {
        _setBooleanField(195, value);
      }

      public final boolean getIsFolded() {
        return _getBooleanField(196);
      }
      public final void setIsFolded(boolean value) {
        _setBooleanField(196, value);
      }

      public final boolean getIsUnsafeAccessed() {
        return _getBooleanField(197);
      }
      public final void setIsUnsafeAccessed(boolean value) {
        _setBooleanField(197, value);
      }

      public final boolean getIsStatic() {
        return _getBooleanField(198);
      }
      public final void setIsStatic(boolean value) {
        _setBooleanField(198, value);
      }

      public final boolean getIsSynthetic() {
        return _getBooleanField(199);
      }
      public final void setIsSynthetic(boolean value) {
        _setBooleanField(199, value);
      }

      public final boolean hasAnnotationList() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder> getAnnotationList() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 1, null, 0);
      }
      public final void setAnnotationList(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder> initAnnotationList(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 1, size);
      }
      public final boolean hasName() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }
      public final void setName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, value);
      }
      public final void setName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, size);
      }
      public final int getPriorInstalledLayerNum() {
        return _getIntField(7);
      }
      public final void setPriorInstalledLayerNum(int value) {
        _setIntField(7, value);
      }

      public final int getAssignmentStatus() {
        return _getIntField(8);
      }
      public final void setAssignmentStatus(int value) {
        _setIntField(8, value);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getId() {
        return _getIntField(0);
      }

      public boolean hasClassName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final int getDeclaringTypeId() {
        return _getIntField(1);
      }

      public final int getTypeId() {
        return _getIntField(2);
      }

      public final int getPosition() {
        return _getIntField(3);
      }

      public final int getLocation() {
        return _getIntField(4);
      }

      public final int getModifiers() {
        return _getIntField(5);
      }

      public final boolean getIsInternal() {
        return _getBooleanField(192);
      }

      public final boolean getIsAccessed() {
        return _getBooleanField(193);
      }

      public final boolean getIsRead() {
        return _getBooleanField(194);
      }

      public final boolean getIsWritten() {
        return _getBooleanField(195);
      }

      public final boolean getIsFolded() {
        return _getBooleanField(196);
      }

      public final boolean getIsUnsafeAccessed() {
        return _getBooleanField(197);
      }

      public final boolean getIsStatic() {
        return _getBooleanField(198);
      }

      public final boolean getIsSynthetic() {
        return _getBooleanField(199);
      }

      public final boolean hasAnnotationList() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader> getAnnotationList() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.listFactory, 1, null, 0);
      }

      public boolean hasName() {
        return !_pointerFieldIsNull(2);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }

      public final int getPriorInstalledLayerNum() {
        return _getIntField(7);
      }

      public final int getAssignmentStatus() {
        return _getIntField(8);
      }

    }

  }


  public static class CEntryPointLiteralReference {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)0,(short)3);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return CEntryPointLiteralReference.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasMethodName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getMethodName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setMethodName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setMethodName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initMethodName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasDefiningClass() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getDefiningClass() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }
      public final void setDefiningClass(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
      }
      public final void setDefiningClass(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initDefiningClass(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
      }
      public final boolean hasParameterNames() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getParameterNames() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 2, null, 0);
      }
      public final void setParameterNames(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 2, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initParameterNames(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 2, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public boolean hasMethodName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getMethodName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public boolean hasDefiningClass() {
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getDefiningClass() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }

      public final boolean hasParameterNames() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getParameterNames() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 2, null, 0);
      }

    }

  }


  public static class ConstantReference {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)1);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return ConstantReference.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public Which which() {
        switch(_getShortField(2)) {
          case 0 : return Which.OBJECT_CONSTANT;
          case 1 : return Which.NULL_POINTER;
          case 2 : return Which.NOT_MATERIALIZED;
          case 3 : return Which.PRIMITIVE_VALUE;
          case 4 : return Which.METHOD_POINTER;
          case 5 : return Which.C_ENTRY_POINT_LITERAL_CODE_POINTER;
          case 6 : return Which.C_GLOBAL_DATA_BASE_POINTER;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean isObjectConstant() {
        return which() == ConstantReference.Which.OBJECT_CONSTANT;
      }
      public final ObjectConstant.Builder getObjectConstant() {
        return new ConstantReference.ObjectConstant.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final ObjectConstant.Builder initObjectConstant() {
        _setShortField(2, (short)ConstantReference.Which.OBJECT_CONSTANT.ordinal());
        _setIntField(0,0);
  return new ConstantReference.ObjectConstant.Builder(segment, data, pointers, dataSize, pointerCount);
      }

      public final boolean isNullPointer() {
        return which() == ConstantReference.Which.NULL_POINTER;
      }
      public final com.oracle.svm.shaded.org.capnproto.Void getNullPointer() {
        assert which() == ConstantReference.Which.NULL_POINTER:
                    "Must check which() before get()ing a union member.";
        return com.oracle.svm.shaded.org.capnproto.Void.VOID;
      }
      public final void setNullPointer(com.oracle.svm.shaded.org.capnproto.Void value) {
        _setShortField(2, (short)ConstantReference.Which.NULL_POINTER.ordinal());
      }

      public final boolean isNotMaterialized() {
        return which() == ConstantReference.Which.NOT_MATERIALIZED;
      }
      public final com.oracle.svm.shaded.org.capnproto.Void getNotMaterialized() {
        assert which() == ConstantReference.Which.NOT_MATERIALIZED:
                    "Must check which() before get()ing a union member.";
        return com.oracle.svm.shaded.org.capnproto.Void.VOID;
      }
      public final void setNotMaterialized(com.oracle.svm.shaded.org.capnproto.Void value) {
        _setShortField(2, (short)ConstantReference.Which.NOT_MATERIALIZED.ordinal());
      }

      public final boolean isPrimitiveValue() {
        return which() == ConstantReference.Which.PRIMITIVE_VALUE;
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Builder getPrimitiveValue() {
        assert which() == ConstantReference.Which.PRIMITIVE_VALUE:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory, 0, null, 0);
      }
      public final void setPrimitiveValue(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Reader value) {
        _setShortField(2, (short)ConstantReference.Which.PRIMITIVE_VALUE.ordinal());
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory,0, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Builder initPrimitiveValue() {
        _setShortField(2, (short)ConstantReference.Which.PRIMITIVE_VALUE.ordinal());
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory,0, 0);
      }
      public final boolean isMethodPointer() {
        return which() == ConstantReference.Which.METHOD_POINTER;
      }
      public final MethodPointer.Builder getMethodPointer() {
        return new ConstantReference.MethodPointer.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final MethodPointer.Builder initMethodPointer() {
        _setShortField(2, (short)ConstantReference.Which.METHOD_POINTER.ordinal());
        _setIntField(0,0);
  return new ConstantReference.MethodPointer.Builder(segment, data, pointers, dataSize, pointerCount);
      }

      public final boolean isCEntryPointLiteralCodePointer() {
        return which() == ConstantReference.Which.C_ENTRY_POINT_LITERAL_CODE_POINTER;
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.Builder getCEntryPointLiteralCodePointer() {
        assert which() == ConstantReference.Which.C_ENTRY_POINT_LITERAL_CODE_POINTER:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.factory, 0, null, 0);
      }
      public final void setCEntryPointLiteralCodePointer(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.Reader value) {
        _setShortField(2, (short)ConstantReference.Which.C_ENTRY_POINT_LITERAL_CODE_POINTER.ordinal());
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.factory,0, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.Builder initCEntryPointLiteralCodePointer() {
        _setShortField(2, (short)ConstantReference.Which.C_ENTRY_POINT_LITERAL_CODE_POINTER.ordinal());
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.factory,0, 0);
      }
      public final boolean isCGlobalDataBasePointer() {
        return which() == ConstantReference.Which.C_GLOBAL_DATA_BASE_POINTER;
      }
      public final com.oracle.svm.shaded.org.capnproto.Void getCGlobalDataBasePointer() {
        assert which() == ConstantReference.Which.C_GLOBAL_DATA_BASE_POINTER:
                    "Must check which() before get()ing a union member.";
        return com.oracle.svm.shaded.org.capnproto.Void.VOID;
      }
      public final void setCGlobalDataBasePointer(com.oracle.svm.shaded.org.capnproto.Void value) {
        _setShortField(2, (short)ConstantReference.Which.C_GLOBAL_DATA_BASE_POINTER.ordinal());
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public Which which() {
        switch(_getShortField(2)) {
          case 0 : return Which.OBJECT_CONSTANT;
          case 1 : return Which.NULL_POINTER;
          case 2 : return Which.NOT_MATERIALIZED;
          case 3 : return Which.PRIMITIVE_VALUE;
          case 4 : return Which.METHOD_POINTER;
          case 5 : return Which.C_ENTRY_POINT_LITERAL_CODE_POINTER;
          case 6 : return Which.C_GLOBAL_DATA_BASE_POINTER;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public final boolean isObjectConstant() {
        return which() == ConstantReference.Which.OBJECT_CONSTANT;
      }
      public ObjectConstant.Reader getObjectConstant() {
        return new ConstantReference.ObjectConstant.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean isNullPointer() {
        return which() == ConstantReference.Which.NULL_POINTER;
      }
      public final com.oracle.svm.shaded.org.capnproto.Void getNullPointer() {
        assert which() == ConstantReference.Which.NULL_POINTER:
                    "Must check which() before get()ing a union member.";
        return com.oracle.svm.shaded.org.capnproto.Void.VOID;
      }

      public final boolean isNotMaterialized() {
        return which() == ConstantReference.Which.NOT_MATERIALIZED;
      }
      public final com.oracle.svm.shaded.org.capnproto.Void getNotMaterialized() {
        assert which() == ConstantReference.Which.NOT_MATERIALIZED:
                    "Must check which() before get()ing a union member.";
        return com.oracle.svm.shaded.org.capnproto.Void.VOID;
      }

      public final boolean isPrimitiveValue() {
        return which() == ConstantReference.Which.PRIMITIVE_VALUE;
      }
      public boolean hasPrimitiveValue() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Reader getPrimitiveValue() {
        assert which() == ConstantReference.Which.PRIMITIVE_VALUE:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory,0,null, 0);
      }

      public final boolean isMethodPointer() {
        return which() == ConstantReference.Which.METHOD_POINTER;
      }
      public MethodPointer.Reader getMethodPointer() {
        return new ConstantReference.MethodPointer.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean isCEntryPointLiteralCodePointer() {
        return which() == ConstantReference.Which.C_ENTRY_POINT_LITERAL_CODE_POINTER;
      }
      public boolean hasCEntryPointLiteralCodePointer() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.Reader getCEntryPointLiteralCodePointer() {
        assert which() == ConstantReference.Which.C_ENTRY_POINT_LITERAL_CODE_POINTER:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.factory,0,null, 0);
      }

      public final boolean isCGlobalDataBasePointer() {
        return which() == ConstantReference.Which.C_GLOBAL_DATA_BASE_POINTER;
      }
      public final com.oracle.svm.shaded.org.capnproto.Void getCGlobalDataBasePointer() {
        assert which() == ConstantReference.Which.C_GLOBAL_DATA_BASE_POINTER:
                    "Must check which() before get()ing a union member.";
        return com.oracle.svm.shaded.org.capnproto.Void.VOID;
      }

    }

    public enum Which {
      OBJECT_CONSTANT,
      NULL_POINTER,
      NOT_MATERIALIZED,
      PRIMITIVE_VALUE,
      METHOD_POINTER,
      C_ENTRY_POINT_LITERAL_CODE_POINTER,
      C_GLOBAL_DATA_BASE_POINTER,
      _NOT_IN_SCHEMA,
    }
    public static class ObjectConstant {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)1);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return ConstantReference.ObjectConstant.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final int getConstantId() {
          return _getIntField(0);
        }
        public final void setConstantId(int value) {
          _setIntField(0, value);
        }

      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final int getConstantId() {
          return _getIntField(0);
        }

      }

    }


    public static class MethodPointer {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)1);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return ConstantReference.MethodPointer.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final int getMethodId() {
          return _getIntField(0);
        }
        public final void setMethodId(int value) {
          _setIntField(0, value);
        }

      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public final int getMethodId() {
          return _getIntField(0);
        }

      }

    }


  }


  public static class PersistedConstant {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return PersistedConstant.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public Which which() {
        switch(_getShortField(16)) {
          case 0 : return Which.OBJECT;
          case 1 : return Which.PRIMITIVE_DATA;
          case 2 : return Which.RELOCATABLE;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getId() {
        return _getIntField(0);
      }
      public final void setId(int value) {
        _setIntField(0, value);
      }

      public final int getTypeId() {
        return _getIntField(1);
      }
      public final void setTypeId(int value) {
        _setIntField(1, value);
      }

      public final int getIdentityHashCode() {
        return _getIntField(2);
      }
      public final void setIdentityHashCode(int value) {
        _setIntField(2, value);
      }

      public final boolean getIsSimulated() {
        return _getBooleanField(96);
      }
      public final void setIsSimulated(boolean value) {
        _setBooleanField(96, value);
      }

      public final long getObjectOffset() {
        return _getLongField(2);
      }
      public final void setObjectOffset(long value) {
        _setLongField(2, value);
      }

      public final boolean isObject() {
        return which() == PersistedConstant.Which.OBJECT;
      }
      public final Object.Builder getObject() {
        return new PersistedConstant.Object.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final Object.Builder initObject() {
        _setShortField(16, (short)PersistedConstant.Which.OBJECT.ordinal());
        _setShortField(7,(short)0);
        _setShortField(12,(short)0);
        _setBooleanField(208,false);
        _setIntField(7,0);
        _clearPointerField(0);
        _clearPointerField(1);
        _clearPointerField(2);
  return new PersistedConstant.Object.Builder(segment, data, pointers, dataSize, pointerCount);
      }

      public final boolean isPrimitiveData() {
        return which() == PersistedConstant.Which.PRIMITIVE_DATA;
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Builder getPrimitiveData() {
        assert which() == PersistedConstant.Which.PRIMITIVE_DATA:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory, 0, null, 0);
      }
      public final void setPrimitiveData(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Reader value) {
        _setShortField(16, (short)PersistedConstant.Which.PRIMITIVE_DATA.ordinal());
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory,0, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Builder initPrimitiveData() {
        _setShortField(16, (short)PersistedConstant.Which.PRIMITIVE_DATA.ordinal());
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory,0, 0);
      }
      public final boolean isRelocatable() {
        return which() == PersistedConstant.Which.RELOCATABLE;
      }
      public final Relocatable.Builder getRelocatable() {
        return new PersistedConstant.Relocatable.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final Relocatable.Builder initRelocatable() {
        _setShortField(16, (short)PersistedConstant.Which.RELOCATABLE.ordinal());
        _clearPointerField(0);
  return new PersistedConstant.Relocatable.Builder(segment, data, pointers, dataSize, pointerCount);
      }

      public final int getParentConstantId() {
        return _getIntField(9);
      }
      public final void setParentConstantId(int value) {
        _setIntField(9, value);
      }

      public final int getParentIndex() {
        return _getIntField(10);
      }
      public final void setParentIndex(int value) {
        _setIntField(10, value);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public Which which() {
        switch(_getShortField(16)) {
          case 0 : return Which.OBJECT;
          case 1 : return Which.PRIMITIVE_DATA;
          case 2 : return Which.RELOCATABLE;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public final int getId() {
        return _getIntField(0);
      }

      public final int getTypeId() {
        return _getIntField(1);
      }

      public final int getIdentityHashCode() {
        return _getIntField(2);
      }

      public final boolean getIsSimulated() {
        return _getBooleanField(96);
      }

      public final long getObjectOffset() {
        return _getLongField(2);
      }

      public final boolean isObject() {
        return which() == PersistedConstant.Which.OBJECT;
      }
      public Object.Reader getObject() {
        return new PersistedConstant.Object.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean isPrimitiveData() {
        return which() == PersistedConstant.Which.PRIMITIVE_DATA;
      }
      public boolean hasPrimitiveData() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Reader getPrimitiveData() {
        assert which() == PersistedConstant.Which.PRIMITIVE_DATA:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory,0,null, 0);
      }

      public final boolean isRelocatable() {
        return which() == PersistedConstant.Which.RELOCATABLE;
      }
      public Relocatable.Reader getRelocatable() {
        return new PersistedConstant.Relocatable.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getParentConstantId() {
        return _getIntField(9);
      }

      public final int getParentIndex() {
        return _getIntField(10);
      }

    }

    public enum Which {
      OBJECT,
      PRIMITIVE_DATA,
      RELOCATABLE,
      _NOT_IN_SCHEMA,
    }
    public static class Object {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return PersistedConstant.Object.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public Which which() {
          switch(_getShortField(7)) {
            case 0 : return Which.INSTANCE;
            case 1 : return Which.OBJECT_ARRAY;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final boolean hasData() {
          return !_pointerFieldIsNull(0);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> getData() {
          return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 0, null, 0);
        }
        public final void setData(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> value) {
          _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 0, value);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> initData(int size) {
          return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 0, size);
        }
        public final boolean isInstance() {
          return which() == PersistedConstant.Object.Which.INSTANCE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getInstance() {
          assert which() == PersistedConstant.Object.Which.INSTANCE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }
        public final void setInstance(com.oracle.svm.shaded.org.capnproto.Void value) {
          _setShortField(7, (short)PersistedConstant.Object.Which.INSTANCE.ordinal());
        }

        public final boolean isObjectArray() {
          return which() == PersistedConstant.Object.Which.OBJECT_ARRAY;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getObjectArray() {
          assert which() == PersistedConstant.Object.Which.OBJECT_ARRAY:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }
        public final void setObjectArray(com.oracle.svm.shaded.org.capnproto.Void value) {
          _setShortField(7, (short)PersistedConstant.Object.Which.OBJECT_ARRAY.ordinal());
        }

        public final Relinking.Builder getRelinking() {
          return new PersistedConstant.Object.Relinking.Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final Relinking.Builder initRelinking() {
          _setShortField(12,(short)0);
          _setBooleanField(208,false);
          _setIntField(7,0);
          _clearPointerField(1);
          _clearPointerField(2);
  return new PersistedConstant.Object.Relinking.Builder(segment, data, pointers, dataSize, pointerCount);
        }

      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public Which which() {
          switch(_getShortField(7)) {
            case 0 : return Which.INSTANCE;
            case 1 : return Which.OBJECT_ARRAY;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final boolean hasData() {
          return !_pointerFieldIsNull(0);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> getData() {
          return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 0, null, 0);
        }

        public final boolean isInstance() {
          return which() == PersistedConstant.Object.Which.INSTANCE;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getInstance() {
          assert which() == PersistedConstant.Object.Which.INSTANCE:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }

        public final boolean isObjectArray() {
          return which() == PersistedConstant.Object.Which.OBJECT_ARRAY;
        }
        public final com.oracle.svm.shaded.org.capnproto.Void getObjectArray() {
          assert which() == PersistedConstant.Object.Which.OBJECT_ARRAY:
                      "Must check which() before get()ing a union member.";
          return com.oracle.svm.shaded.org.capnproto.Void.VOID;
        }

        public Relinking.Reader getRelinking() {
          return new PersistedConstant.Object.Relinking.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

      }

      public enum Which {
        INSTANCE,
        OBJECT_ARRAY,
        _NOT_IN_SCHEMA,
      }
      public static class Relinking {
        public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
        public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
          public Factory() {
          }
          public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
            return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
          }
          public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
            return new Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
            return PersistedConstant.Object.Relinking.STRUCT_SIZE;
          }
          public final Reader asReader(Builder builder) {
            return builder.asReader();
          }
        }
        public static final Factory factory = new Factory();
        public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
          new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
        public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
          Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
            super(segment, data, pointers, dataSize, pointerCount);
          }
          public Which which() {
            switch(_getShortField(12)) {
              case 0 : return Which.NOT_RELINKED;
              case 1 : return Which.STRING_CONSTANT;
              case 2 : return Which.ENUM_CONSTANT;
              case 3 : return Which.CLASS_CONSTANT;
              case 4 : return Which.FIELD_CONSTANT;
              default: return Which._NOT_IN_SCHEMA;
            }
          }
          public final Reader asReader() {
            return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
          }
          public final boolean isNotRelinked() {
            return which() == PersistedConstant.Object.Relinking.Which.NOT_RELINKED;
          }
          public final com.oracle.svm.shaded.org.capnproto.Void getNotRelinked() {
            assert which() == PersistedConstant.Object.Relinking.Which.NOT_RELINKED:
                        "Must check which() before get()ing a union member.";
            return com.oracle.svm.shaded.org.capnproto.Void.VOID;
          }
          public final void setNotRelinked(com.oracle.svm.shaded.org.capnproto.Void value) {
            _setShortField(12, (short)PersistedConstant.Object.Relinking.Which.NOT_RELINKED.ordinal());
          }

          public final boolean isStringConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.STRING_CONSTANT;
          }
          public final StringConstant.Builder getStringConstant() {
            return new PersistedConstant.Object.Relinking.StringConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final StringConstant.Builder initStringConstant() {
            _setShortField(12, (short)PersistedConstant.Object.Relinking.Which.STRING_CONSTANT.ordinal());
            _clearPointerField(1);
  return new PersistedConstant.Object.Relinking.StringConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }

          public final boolean isEnumConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.ENUM_CONSTANT;
          }
          public final EnumConstant.Builder getEnumConstant() {
            return new PersistedConstant.Object.Relinking.EnumConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final EnumConstant.Builder initEnumConstant() {
            _setShortField(12, (short)PersistedConstant.Object.Relinking.Which.ENUM_CONSTANT.ordinal());
            _clearPointerField(1);
            _clearPointerField(2);
  return new PersistedConstant.Object.Relinking.EnumConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }

          public final boolean isClassConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.CLASS_CONSTANT;
          }
          public final ClassConstant.Builder getClassConstant() {
            return new PersistedConstant.Object.Relinking.ClassConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final ClassConstant.Builder initClassConstant() {
            _setShortField(12, (short)PersistedConstant.Object.Relinking.Which.CLASS_CONSTANT.ordinal());
            _setIntField(7,0);
  return new PersistedConstant.Object.Relinking.ClassConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }

          public final boolean isFieldConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.FIELD_CONSTANT;
          }
          public final FieldConstant.Builder getFieldConstant() {
            return new PersistedConstant.Object.Relinking.FieldConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }
          public final FieldConstant.Builder initFieldConstant() {
            _setShortField(12, (short)PersistedConstant.Object.Relinking.Which.FIELD_CONSTANT.ordinal());
            _setBooleanField(208,false);
            _setIntField(7,0);
  return new PersistedConstant.Object.Relinking.FieldConstant.Builder(segment, data, pointers, dataSize, pointerCount);
          }

        }

        public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
          Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
            super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public Which which() {
            switch(_getShortField(12)) {
              case 0 : return Which.NOT_RELINKED;
              case 1 : return Which.STRING_CONSTANT;
              case 2 : return Which.ENUM_CONSTANT;
              case 3 : return Which.CLASS_CONSTANT;
              case 4 : return Which.FIELD_CONSTANT;
              default: return Which._NOT_IN_SCHEMA;
            }
          }
          public final boolean isNotRelinked() {
            return which() == PersistedConstant.Object.Relinking.Which.NOT_RELINKED;
          }
          public final com.oracle.svm.shaded.org.capnproto.Void getNotRelinked() {
            assert which() == PersistedConstant.Object.Relinking.Which.NOT_RELINKED:
                        "Must check which() before get()ing a union member.";
            return com.oracle.svm.shaded.org.capnproto.Void.VOID;
          }

          public final boolean isStringConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.STRING_CONSTANT;
          }
          public StringConstant.Reader getStringConstant() {
            return new PersistedConstant.Object.Relinking.StringConstant.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public final boolean isEnumConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.ENUM_CONSTANT;
          }
          public EnumConstant.Reader getEnumConstant() {
            return new PersistedConstant.Object.Relinking.EnumConstant.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public final boolean isClassConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.CLASS_CONSTANT;
          }
          public ClassConstant.Reader getClassConstant() {
            return new PersistedConstant.Object.Relinking.ClassConstant.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

          public final boolean isFieldConstant() {
            return which() == PersistedConstant.Object.Relinking.Which.FIELD_CONSTANT;
          }
          public FieldConstant.Reader getFieldConstant() {
            return new PersistedConstant.Object.Relinking.FieldConstant.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
          }

        }

        public enum Which {
          NOT_RELINKED,
          STRING_CONSTANT,
          ENUM_CONSTANT,
          CLASS_CONSTANT,
          FIELD_CONSTANT,
          _NOT_IN_SCHEMA,
        }
        public static class StringConstant {
          public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
          public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
            public Factory() {
            }
            public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
              return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
            }
            public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
              return new Builder(segment, data, pointers, dataSize, pointerCount);
            }
            public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
              return PersistedConstant.Object.Relinking.StringConstant.STRUCT_SIZE;
            }
            public final Reader asReader(Builder builder) {
              return builder.asReader();
            }
          }
          public static final Factory factory = new Factory();
          public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
            new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
          public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
            Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
              super(segment, data, pointers, dataSize, pointerCount);
            }
            public final Reader asReader() {
              return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
            }
            public final boolean hasValue() {
              return !_pointerFieldIsNull(1);
            }
            public final com.oracle.svm.shaded.org.capnproto.Text.Builder getValue() {
              return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
            }
            public final void setValue(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
              _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
            }
            public final void setValue(String value) {
              _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
            }
            public final com.oracle.svm.shaded.org.capnproto.Text.Builder initValue(int size) {
              return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
            }
          }

          public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
            Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
              super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
            }

            public boolean hasValue() {
              return !_pointerFieldIsNull(1);
            }
            public com.oracle.svm.shaded.org.capnproto.Text.Reader getValue() {
              return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
            }

          }

        }


        public static class EnumConstant {
          public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
          public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
            public Factory() {
            }
            public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
              return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
            }
            public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
              return new Builder(segment, data, pointers, dataSize, pointerCount);
            }
            public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
              return PersistedConstant.Object.Relinking.EnumConstant.STRUCT_SIZE;
            }
            public final Reader asReader(Builder builder) {
              return builder.asReader();
            }
          }
          public static final Factory factory = new Factory();
          public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
            new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
          public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
            Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
              super(segment, data, pointers, dataSize, pointerCount);
            }
            public final Reader asReader() {
              return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
            }
            public final boolean hasEnumClass() {
              return !_pointerFieldIsNull(1);
            }
            public final com.oracle.svm.shaded.org.capnproto.Text.Builder getEnumClass() {
              return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
            }
            public final void setEnumClass(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
              _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
            }
            public final void setEnumClass(String value) {
              _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
            }
            public final com.oracle.svm.shaded.org.capnproto.Text.Builder initEnumClass(int size) {
              return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
            }
            public final boolean hasEnumName() {
              return !_pointerFieldIsNull(2);
            }
            public final com.oracle.svm.shaded.org.capnproto.Text.Builder getEnumName() {
              return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
            }
            public final void setEnumName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
              _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, value);
            }
            public final void setEnumName(String value) {
              _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
            }
            public final com.oracle.svm.shaded.org.capnproto.Text.Builder initEnumName(int size) {
              return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, size);
            }
          }

          public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
            Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
              super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
            }

            public boolean hasEnumClass() {
              return !_pointerFieldIsNull(1);
            }
            public com.oracle.svm.shaded.org.capnproto.Text.Reader getEnumClass() {
              return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
            }

            public boolean hasEnumName() {
              return !_pointerFieldIsNull(2);
            }
            public com.oracle.svm.shaded.org.capnproto.Text.Reader getEnumName() {
              return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
            }

          }

        }


        public static class ClassConstant {
          public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
          public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
            public Factory() {
            }
            public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
              return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
            }
            public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
              return new Builder(segment, data, pointers, dataSize, pointerCount);
            }
            public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
              return PersistedConstant.Object.Relinking.ClassConstant.STRUCT_SIZE;
            }
            public final Reader asReader(Builder builder) {
              return builder.asReader();
            }
          }
          public static final Factory factory = new Factory();
          public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
            new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
          public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
            Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
              super(segment, data, pointers, dataSize, pointerCount);
            }
            public final Reader asReader() {
              return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
            }
            public final int getTypeId() {
              return _getIntField(7);
            }
            public final void setTypeId(int value) {
              _setIntField(7, value);
            }

          }

          public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
            Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
              super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
            }

            public final int getTypeId() {
              return _getIntField(7);
            }

          }

        }


        public static class FieldConstant {
          public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
          public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
            public Factory() {
            }
            public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
              return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
            }
            public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
              return new Builder(segment, data, pointers, dataSize, pointerCount);
            }
            public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
              return PersistedConstant.Object.Relinking.FieldConstant.STRUCT_SIZE;
            }
            public final Reader asReader(Builder builder) {
              return builder.asReader();
            }
          }
          public static final Factory factory = new Factory();
          public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
            new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
          public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
            Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
              super(segment, data, pointers, dataSize, pointerCount);
            }
            public final Reader asReader() {
              return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
            }
            public final int getOriginFieldId() {
              return _getIntField(7);
            }
            public final void setOriginFieldId(int value) {
              _setIntField(7, value);
            }

            public final boolean getRequiresLateLoading() {
              return _getBooleanField(208);
            }
            public final void setRequiresLateLoading(boolean value) {
              _setBooleanField(208, value);
            }

          }

          public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
            Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
              super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
            }

            public final int getOriginFieldId() {
              return _getIntField(7);
            }

            public final boolean getRequiresLateLoading() {
              return _getBooleanField(208);
            }

          }

        }


      }


    }


    public static class Relocatable {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)6,(short)3);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return PersistedConstant.Relocatable.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final boolean hasKey() {
          return !_pointerFieldIsNull(0);
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder getKey() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
        }
        public final void setKey(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
        }
        public final void setKey(String value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder initKey(int size) {
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
        }
      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public boolean hasKey() {
          return !_pointerFieldIsNull(0);
        }
        public com.oracle.svm.shaded.org.capnproto.Text.Reader getKey() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
        }

      }

    }


  }


  public static class KeyStoreEntry {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)2,(short)2);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return KeyStoreEntry.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasKey() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getKey() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setKey(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setKey(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initKey(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final Value.Builder getValue() {
        return new KeyStoreEntry.Value.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final Value.Builder initValue() {
        _setIntField(0,0);
        _setShortField(2,(short)0);
        _setLongField(1,0L);
        _clearPointerField(1);
  return new KeyStoreEntry.Value.Builder(segment, data, pointers, dataSize, pointerCount);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public boolean hasKey() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getKey() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public Value.Reader getValue() {
        return new KeyStoreEntry.Value.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

    }

    public static class Value {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)2,(short)2);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return KeyStoreEntry.Value.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public Which which() {
          switch(_getShortField(2)) {
            case 0 : return Which.I;
            case 1 : return Which.IL;
            case 2 : return Which.J;
            case 3 : return Which.STR;
            case 4 : return Which.STRL;
            case 5 : return Which.ZL;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final boolean isI() {
          return which() == KeyStoreEntry.Value.Which.I;
        }
        public final int getI() {
          assert which() == KeyStoreEntry.Value.Which.I:
                      "Must check which() before get()ing a union member.";
          return _getIntField(0);
        }
        public final void setI(int value) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.I.ordinal());
          _setIntField(0, value);
        }

        public final boolean isIl() {
          return which() == KeyStoreEntry.Value.Which.IL;
        }
        public final boolean hasIl() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getIl() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
        }
        public final void setIl(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.IL.ordinal());
          _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, value);
        }
        public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initIl(int size) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.IL.ordinal());
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, size);
        }
        public final boolean isJ() {
          return which() == KeyStoreEntry.Value.Which.J;
        }
        public final long getJ() {
          assert which() == KeyStoreEntry.Value.Which.J:
                      "Must check which() before get()ing a union member.";
          return _getLongField(1);
        }
        public final void setJ(long value) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.J.ordinal());
          _setLongField(1, value);
        }

        public final boolean isStr() {
          return which() == KeyStoreEntry.Value.Which.STR;
        }
        public final boolean hasStr() {
          if (which() != KeyStoreEntry.Value.Which.STR) return false;
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder getStr() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
        }
        public final void setStr(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.STR.ordinal());
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
        }
        public final void setStr(String value) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.STR.ordinal());
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder initStr(int size) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.STR.ordinal());
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
        }
        public final boolean isStrl() {
          return which() == KeyStoreEntry.Value.Which.STRL;
        }
        public final boolean hasStrl() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getStrl() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, null, 0);
        }
        public final void setStrl(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.STRL.ordinal());
          _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, value);
        }
        public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initStrl(int size) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.STRL.ordinal());
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, size);
        }
        public final boolean isZl() {
          return which() == KeyStoreEntry.Value.Which.ZL;
        }
        public final boolean hasZl() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Builder getZl() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 1, null, 0);
        }
        public final void setZl(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Reader value) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.ZL.ordinal());
          _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 1, value);
        }
        public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Builder initZl(int size) {
          _setShortField(2, (short)KeyStoreEntry.Value.Which.ZL.ordinal());
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 1, size);
        }
      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public Which which() {
          switch(_getShortField(2)) {
            case 0 : return Which.I;
            case 1 : return Which.IL;
            case 2 : return Which.J;
            case 3 : return Which.STR;
            case 4 : return Which.STRL;
            case 5 : return Which.ZL;
            default: return Which._NOT_IN_SCHEMA;
          }
        }
        public final boolean isI() {
          return which() == KeyStoreEntry.Value.Which.I;
        }
        public final int getI() {
          assert which() == KeyStoreEntry.Value.Which.I:
                      "Must check which() before get()ing a union member.";
          return _getIntField(0);
        }

        public final boolean isIl() {
          return which() == KeyStoreEntry.Value.Which.IL;
        }
        public final boolean hasIl() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getIl() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
        }

        public final boolean isJ() {
          return which() == KeyStoreEntry.Value.Which.J;
        }
        public final long getJ() {
          assert which() == KeyStoreEntry.Value.Which.J:
                      "Must check which() before get()ing a union member.";
          return _getLongField(1);
        }

        public final boolean isStr() {
          return which() == KeyStoreEntry.Value.Which.STR;
        }
        public boolean hasStr() {
          if (which() != KeyStoreEntry.Value.Which.STR) return false;
          return !_pointerFieldIsNull(1);
        }
        public com.oracle.svm.shaded.org.capnproto.Text.Reader getStr() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
        }

        public final boolean isStrl() {
          return which() == KeyStoreEntry.Value.Which.STRL;
        }
        public final boolean hasStrl() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getStrl() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, null, 0);
        }

        public final boolean isZl() {
          return which() == KeyStoreEntry.Value.Which.ZL;
        }
        public final boolean hasZl() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Reader getZl() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 1, null, 0);
        }

      }

      public enum Which {
        I,
        IL,
        J,
        STR,
        STRL,
        ZL,
        _NOT_IN_SCHEMA,
      }
    }


  }


  public static class ImageSingletonKey {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)2,(short)1);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return ImageSingletonKey.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasKeyClassName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getKeyClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setKeyClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setKeyClassName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initKeyClassName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final int getPersistFlag() {
        return _getIntField(0);
      }
      public final void setPersistFlag(int value) {
        _setIntField(0, value);
      }

      public final int getObjectId() {
        return _getIntField(1);
      }
      public final void setObjectId(int value) {
        _setIntField(1, value);
      }

      public final int getConstantId() {
        return _getIntField(2);
      }
      public final void setConstantId(int value) {
        _setIntField(2, value);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public boolean hasKeyClassName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getKeyClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final int getPersistFlag() {
        return _getIntField(0);
      }

      public final int getObjectId() {
        return _getIntField(1);
      }

      public final int getConstantId() {
        return _getIntField(2);
      }

    }

  }


  public static class ImageSingletonObject {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)2);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return ImageSingletonObject.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getId() {
        return _getIntField(0);
      }
      public final void setId(int value) {
        _setIntField(0, value);
      }

      public final boolean hasClassName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setClassName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasStore() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Builder> getStore() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.listFactory, 1, null, 0);
      }
      public final void setStore(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.listFactory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Builder> initStore(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.listFactory, 1, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getId() {
        return _getIntField(0);
      }

      public boolean hasClassName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final boolean hasStore() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Reader> getStore() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.listFactory, 1, null, 0);
      }

    }

  }


  public static class Annotation {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)0,(short)2);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return Annotation.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasTypeName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getTypeName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setTypeName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setTypeName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initTypeName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasValues() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder> getValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 1, null, 0);
      }
      public final void setValues(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder> initValues(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 1, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public boolean hasTypeName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getTypeName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final boolean hasValues() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader> getValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 1, null, 0);
      }

    }

  }


  public static class AnnotationValue {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)3);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return AnnotationValue.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public Which which() {
        switch(_getShortField(0)) {
          case 0 : return Which.STRING;
          case 1 : return Which.PRIMITIVE;
          case 2 : return Which.PRIMITIVE_ARRAY;
          case 3 : return Which.ENUM;
          case 4 : return Which.CLASS_NAME;
          case 5 : return Which.ANNOTATION;
          case 6 : return Which.MEMBERS;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean isString() {
        return which() == AnnotationValue.Which.STRING;
      }
      public final boolean hasString() {
        if (which() != AnnotationValue.Which.STRING) return false;
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getString() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }
      public final void setString(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setShortField(0, (short)AnnotationValue.Which.STRING.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
      }
      public final void setString(String value) {
        _setShortField(0, (short)AnnotationValue.Which.STRING.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initString(int size) {
        _setShortField(0, (short)AnnotationValue.Which.STRING.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
      }
      public final boolean isPrimitive() {
        return which() == AnnotationValue.Which.PRIMITIVE;
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Builder getPrimitive() {
        assert which() == AnnotationValue.Which.PRIMITIVE:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory, 1, null, 0);
      }
      public final void setPrimitive(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Reader value) {
        _setShortField(0, (short)AnnotationValue.Which.PRIMITIVE.ordinal());
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory,1, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Builder initPrimitive() {
        _setShortField(0, (short)AnnotationValue.Which.PRIMITIVE.ordinal());
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory,1, 0);
      }
      public final boolean isPrimitiveArray() {
        return which() == AnnotationValue.Which.PRIMITIVE_ARRAY;
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Builder getPrimitiveArray() {
        assert which() == AnnotationValue.Which.PRIMITIVE_ARRAY:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory, 1, null, 0);
      }
      public final void setPrimitiveArray(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Reader value) {
        _setShortField(0, (short)AnnotationValue.Which.PRIMITIVE_ARRAY.ordinal());
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory,1, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Builder initPrimitiveArray() {
        _setShortField(0, (short)AnnotationValue.Which.PRIMITIVE_ARRAY.ordinal());
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory,1, 0);
      }
      public final boolean isEnum() {
        return which() == AnnotationValue.Which.ENUM;
      }
      public final Enum.Builder getEnum() {
        return new AnnotationValue.Enum.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final Enum.Builder initEnum() {
        _setShortField(0, (short)AnnotationValue.Which.ENUM.ordinal());
        _clearPointerField(1);
        _clearPointerField(2);
  return new AnnotationValue.Enum.Builder(segment, data, pointers, dataSize, pointerCount);
      }

      public final boolean isClassName() {
        return which() == AnnotationValue.Which.CLASS_NAME;
      }
      public final boolean hasClassName() {
        if (which() != AnnotationValue.Which.CLASS_NAME) return false;
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }
      public final void setClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setShortField(0, (short)AnnotationValue.Which.CLASS_NAME.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
      }
      public final void setClassName(String value) {
        _setShortField(0, (short)AnnotationValue.Which.CLASS_NAME.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassName(int size) {
        _setShortField(0, (short)AnnotationValue.Which.CLASS_NAME.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
      }
      public final boolean isAnnotation() {
        return which() == AnnotationValue.Which.ANNOTATION;
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder getAnnotation() {
        assert which() == AnnotationValue.Which.ANNOTATION:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.factory, 1, null, 0);
      }
      public final void setAnnotation(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader value) {
        _setShortField(0, (short)AnnotationValue.Which.ANNOTATION.ordinal());
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.factory,1, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder initAnnotation() {
        _setShortField(0, (short)AnnotationValue.Which.ANNOTATION.ordinal());
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.factory,1, 0);
      }
      public final boolean isMembers() {
        return which() == AnnotationValue.Which.MEMBERS;
      }
      public final Members.Builder getMembers() {
        return new AnnotationValue.Members.Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final Members.Builder initMembers() {
        _setShortField(0, (short)AnnotationValue.Which.MEMBERS.ordinal());
        _clearPointerField(1);
        _clearPointerField(2);
  return new AnnotationValue.Members.Builder(segment, data, pointers, dataSize, pointerCount);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public Which which() {
        switch(_getShortField(0)) {
          case 0 : return Which.STRING;
          case 1 : return Which.PRIMITIVE;
          case 2 : return Which.PRIMITIVE_ARRAY;
          case 3 : return Which.ENUM;
          case 4 : return Which.CLASS_NAME;
          case 5 : return Which.ANNOTATION;
          case 6 : return Which.MEMBERS;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public boolean hasName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final boolean isString() {
        return which() == AnnotationValue.Which.STRING;
      }
      public boolean hasString() {
        if (which() != AnnotationValue.Which.STRING) return false;
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getString() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }

      public final boolean isPrimitive() {
        return which() == AnnotationValue.Which.PRIMITIVE;
      }
      public boolean hasPrimitive() {
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Reader getPrimitive() {
        assert which() == AnnotationValue.Which.PRIMITIVE:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.factory,1,null, 0);
      }

      public final boolean isPrimitiveArray() {
        return which() == AnnotationValue.Which.PRIMITIVE_ARRAY;
      }
      public boolean hasPrimitiveArray() {
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Reader getPrimitiveArray() {
        assert which() == AnnotationValue.Which.PRIMITIVE_ARRAY:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.factory,1,null, 0);
      }

      public final boolean isEnum() {
        return which() == AnnotationValue.Which.ENUM;
      }
      public Enum.Reader getEnum() {
        return new AnnotationValue.Enum.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean isClassName() {
        return which() == AnnotationValue.Which.CLASS_NAME;
      }
      public boolean hasClassName() {
        if (which() != AnnotationValue.Which.CLASS_NAME) return false;
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }

      public final boolean isAnnotation() {
        return which() == AnnotationValue.Which.ANNOTATION;
      }
      public boolean hasAnnotation() {
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader getAnnotation() {
        assert which() == AnnotationValue.Which.ANNOTATION:
                    "Must check which() before get()ing a union member.";
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.factory,1,null, 0);
      }

      public final boolean isMembers() {
        return which() == AnnotationValue.Which.MEMBERS;
      }
      public Members.Reader getMembers() {
        return new AnnotationValue.Members.Reader(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

    }

    public enum Which {
      STRING,
      PRIMITIVE,
      PRIMITIVE_ARRAY,
      ENUM,
      CLASS_NAME,
      ANNOTATION,
      MEMBERS,
      _NOT_IN_SCHEMA,
    }
    public static class Enum {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)3);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return AnnotationValue.Enum.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final boolean hasClassName() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassName() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
        }
        public final void setClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
        }
        public final void setClassName(String value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassName(int size) {
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
        }
        public final boolean hasName() {
          return !_pointerFieldIsNull(2);
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder getName() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
        }
        public final void setName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, value);
        }
        public final void setName(String value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder initName(int size) {
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, size);
        }
      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public boolean hasClassName() {
          return !_pointerFieldIsNull(1);
        }
        public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassName() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
        }

        public boolean hasName() {
          return !_pointerFieldIsNull(2);
        }
        public com.oracle.svm.shaded.org.capnproto.Text.Reader getName() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
        }

      }

    }


    public static class Members {
      public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)3);
      public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
        public Factory() {
        }
        public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
          return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
        }
        public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
          return new Builder(segment, data, pointers, dataSize, pointerCount);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
          return AnnotationValue.Members.STRUCT_SIZE;
        }
        public final Reader asReader(Builder builder) {
          return builder.asReader();
        }
      }
      public static final Factory factory = new Factory();
      public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
        new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
      public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
        Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
          super(segment, data, pointers, dataSize, pointerCount);
        }
        public final Reader asReader() {
          return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
        }
        public final boolean hasClassName() {
          return !_pointerFieldIsNull(1);
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder getClassName() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
        }
        public final void setClassName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
        }
        public final void setClassName(String value) {
          _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
        }
        public final com.oracle.svm.shaded.org.capnproto.Text.Builder initClassName(int size) {
          return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
        }
        public final boolean hasMemberValues() {
          return !_pointerFieldIsNull(2);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder> getMemberValues() {
          return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 2, null, 0);
        }
        public final void setMemberValues(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader> value) {
          _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 2, value);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder> initMemberValues(int size) {
          return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 2, size);
        }
      }

      public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
        Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
          super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
        }

        public boolean hasClassName() {
          return !_pointerFieldIsNull(1);
        }
        public com.oracle.svm.shaded.org.capnproto.Text.Reader getClassName() {
          return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
        }

        public final boolean hasMemberValues() {
          return !_pointerFieldIsNull(2);
        }
        public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader> getMemberValues() {
          return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.listFactory, 2, null, 0);
        }

      }

    }


  }


  public static class SharedLayerSnapshot {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)5,(short)15);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return SharedLayerSnapshot.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getNextTypeId() {
        return _getIntField(0);
      }
      public final void setNextTypeId(int value) {
        _setIntField(0, value);
      }

      public final int getNextMethodId() {
        return _getIntField(1);
      }
      public final void setNextMethodId(int value) {
        _setIntField(1, value);
      }

      public final int getNextFieldId() {
        return _getIntField(2);
      }
      public final void setNextFieldId(int value) {
        _setIntField(2, value);
      }

      public final int getNextConstantId() {
        return _getIntField(3);
      }
      public final void setNextConstantId(int value) {
        _setIntField(3, value);
      }

      public final int getStaticPrimitiveFieldsConstantId() {
        return _getIntField(4);
      }
      public final void setStaticPrimitiveFieldsConstantId(int value) {
        _setIntField(4, value);
      }

      public final int getStaticObjectFieldsConstantId() {
        return _getIntField(5);
      }
      public final void setStaticObjectFieldsConstantId(int value) {
        _setIntField(5, value);
      }

      public final long getImageHeapSize() {
        return _getLongField(3);
      }
      public final void setImageHeapSize(long value) {
        _setLongField(3, value);
      }

      public final boolean hasConstantsToRelink() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getConstantsToRelink() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }
      public final void setConstantsToRelink(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initConstantsToRelink(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, size);
      }
      public final boolean hasTypes() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Builder> getTypes() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.listFactory, 1, null, 0);
      }
      public final void setTypes(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.listFactory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Builder> initTypes(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.listFactory, 1, size);
      }
      public final boolean hasMethods() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Builder> getMethods() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.listFactory, 2, null, 0);
      }
      public final void setMethods(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.listFactory, 2, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Builder> initMethods(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.listFactory, 2, size);
      }
      public final boolean hasConstants() {
        return !_pointerFieldIsNull(3);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Builder> getConstants() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.listFactory, 3, null, 0);
      }
      public final void setConstants(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.listFactory, 3, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Builder> initConstants(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.listFactory, 3, size);
      }
      public final boolean hasSingletonKeys() {
        return !_pointerFieldIsNull(4);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Builder> getSingletonKeys() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.listFactory, 4, null, 0);
      }
      public final void setSingletonKeys(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.listFactory, 4, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Builder> initSingletonKeys(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.listFactory, 4, size);
      }
      public final boolean hasSingletonObjects() {
        return !_pointerFieldIsNull(5);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Builder> getSingletonObjects() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.listFactory, 5, null, 0);
      }
      public final void setSingletonObjects(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.listFactory, 5, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Builder> initSingletonObjects(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.listFactory, 5, size);
      }
      public final boolean hasFields() {
        return !_pointerFieldIsNull(6);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Builder> getFields() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.listFactory, 6, null, 0);
      }
      public final void setFields(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.listFactory, 6, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Builder> initFields(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.listFactory, 6, size);
      }
      public final int getNextLayerNumber() {
        return _getIntField(8);
      }
      public final void setNextLayerNumber(int value) {
        _setIntField(8, value);
      }

      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.Builder getStaticFinalFieldFoldingSingleton() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.factory, 7, null, 0);
      }
      public final void setStaticFinalFieldFoldingSingleton(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.Reader value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.factory,7, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.Builder initStaticFinalFieldFoldingSingleton() {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.factory,7, 0);
      }
      public final boolean hasRegisteredJNILibraries() {
        return !_pointerFieldIsNull(8);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getRegisteredJNILibraries() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 8, null, 0);
      }
      public final void setRegisteredJNILibraries(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 8, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initRegisteredJNILibraries(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 8, size);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.Builder getLayeredRuntimeMetadataSingleton() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.factory, 9, null, 0);
      }
      public final void setLayeredRuntimeMetadataSingleton(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.Reader value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.factory,9, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.Builder initLayeredRuntimeMetadataSingleton() {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.factory,9, 0);
      }
      public final boolean hasDynamicHubInfos() {
        return !_pointerFieldIsNull(10);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Builder> getDynamicHubInfos() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.listFactory, 10, null, 0);
      }
      public final void setDynamicHubInfos(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.listFactory, 10, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Builder> initDynamicHubInfos(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.listFactory, 10, size);
      }
      public final boolean hasHostedMethods() {
        return !_pointerFieldIsNull(11);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Builder> getHostedMethods() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.listFactory, 11, null, 0);
      }
      public final void setHostedMethods(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.listFactory, 11, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Builder> initHostedMethods(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.listFactory, 11, size);
      }
      public final boolean hasNodeClassMapLocation() {
        return !_pointerFieldIsNull(12);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getNodeClassMapLocation() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, null, 0, 0);
      }
      public final void setNodeClassMapLocation(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, value);
      }
      public final void setNodeClassMapLocation(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initNodeClassMapLocation(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, size);
      }
      public final boolean hasSharedLayerBootLayerModules() {
        return !_pointerFieldIsNull(13);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getSharedLayerBootLayerModules() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 13, null, 0);
      }
      public final void setSharedLayerBootLayerModules(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 13, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initSharedLayerBootLayerModules(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 13, size);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.Builder getLayeredModule() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.factory, 14, null, 0);
      }
      public final void setLayeredModule(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.Reader value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.factory,14, value);
      }
      public final com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.Builder initLayeredModule() {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.factory,14, 0);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getNextTypeId() {
        return _getIntField(0);
      }

      public final int getNextMethodId() {
        return _getIntField(1);
      }

      public final int getNextFieldId() {
        return _getIntField(2);
      }

      public final int getNextConstantId() {
        return _getIntField(3);
      }

      public final int getStaticPrimitiveFieldsConstantId() {
        return _getIntField(4);
      }

      public final int getStaticObjectFieldsConstantId() {
        return _getIntField(5);
      }

      public final long getImageHeapSize() {
        return _getLongField(3);
      }

      public final boolean hasConstantsToRelink() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getConstantsToRelink() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }

      public final boolean hasTypes() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader> getTypes() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.listFactory, 1, null, 0);
      }

      public final boolean hasMethods() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader> getMethods() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.listFactory, 2, null, 0);
      }

      public final boolean hasConstants() {
        return !_pointerFieldIsNull(3);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader> getConstants() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.listFactory, 3, null, 0);
      }

      public final boolean hasSingletonKeys() {
        return !_pointerFieldIsNull(4);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Reader> getSingletonKeys() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.listFactory, 4, null, 0);
      }

      public final boolean hasSingletonObjects() {
        return !_pointerFieldIsNull(5);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Reader> getSingletonObjects() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.listFactory, 5, null, 0);
      }

      public final boolean hasFields() {
        return !_pointerFieldIsNull(6);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader> getFields() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.listFactory, 6, null, 0);
      }

      public final int getNextLayerNumber() {
        return _getIntField(8);
      }

      public boolean hasStaticFinalFieldFoldingSingleton() {
        return !_pointerFieldIsNull(7);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.Reader getStaticFinalFieldFoldingSingleton() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.factory,7,null, 0);
      }

      public final boolean hasRegisteredJNILibraries() {
        return !_pointerFieldIsNull(8);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getRegisteredJNILibraries() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 8, null, 0);
      }

      public boolean hasLayeredRuntimeMetadataSingleton() {
        return !_pointerFieldIsNull(9);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.Reader getLayeredRuntimeMetadataSingleton() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.factory,9,null, 0);
      }

      public final boolean hasDynamicHubInfos() {
        return !_pointerFieldIsNull(10);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader> getDynamicHubInfos() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.listFactory, 10, null, 0);
      }

      public final boolean hasHostedMethods() {
        return !_pointerFieldIsNull(11);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader> getHostedMethods() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.listFactory, 11, null, 0);
      }

      public boolean hasNodeClassMapLocation() {
        return !_pointerFieldIsNull(12);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getNodeClassMapLocation() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 12, null, 0, 0);
      }

      public final boolean hasSharedLayerBootLayerModules() {
        return !_pointerFieldIsNull(13);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getSharedLayerBootLayerModules() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 13, null, 0);
      }

      public boolean hasLayeredModule() {
        return !_pointerFieldIsNull(14);
      }
      public com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.Reader getLayeredModule() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.factory,14,null, 0);
      }

    }

  }


  public static class StaticFinalFieldFoldingSingleton {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)0,(short)5);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return StaticFinalFieldFoldingSingleton.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasFields() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getFields() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }
      public final void setFields(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initFields(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, size);
      }
      public final boolean hasFieldCheckIndexes() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getFieldCheckIndexes() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }
      public final void setFieldCheckIndexes(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initFieldCheckIndexes(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, size);
      }
      public final boolean hasFieldInitializationStatusList() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Builder getFieldInitializationStatusList() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 2, null, 0);
      }
      public final void setFieldInitializationStatusList(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 2, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Builder initFieldInitializationStatusList(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 2, size);
      }
      public final boolean hasBytecodeParsedFoldedFieldValues() {
        return !_pointerFieldIsNull(3);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> getBytecodeParsedFoldedFieldValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 3, null, 0);
      }
      public final void setBytecodeParsedFoldedFieldValues(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 3, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> initBytecodeParsedFoldedFieldValues(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 3, size);
      }
      public final boolean hasAfterParsingHooksDoneFoldedFieldValues() {
        return !_pointerFieldIsNull(4);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> getAfterParsingHooksDoneFoldedFieldValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 4, null, 0);
      }
      public final void setAfterParsingHooksDoneFoldedFieldValues(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 4, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> initAfterParsingHooksDoneFoldedFieldValues(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 4, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean hasFields() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getFields() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }

      public final boolean hasFieldCheckIndexes() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getFieldCheckIndexes() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }

      public final boolean hasFieldInitializationStatusList() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Reader getFieldInitializationStatusList() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 2, null, 0);
      }

      public final boolean hasBytecodeParsedFoldedFieldValues() {
        return !_pointerFieldIsNull(3);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> getBytecodeParsedFoldedFieldValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 3, null, 0);
      }

      public final boolean hasAfterParsingHooksDoneFoldedFieldValues() {
        return !_pointerFieldIsNull(4);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> getAfterParsingHooksDoneFoldedFieldValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.listFactory, 4, null, 0);
      }

    }

  }


  public static class LayeredRuntimeMetadataSingleton {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)0,(short)2);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return LayeredRuntimeMetadataSingleton.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasMethods() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getMethods() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }
      public final void setMethods(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initMethods(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, size);
      }
      public final boolean hasFields() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getFields() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }
      public final void setFields(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initFields(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean hasMethods() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getMethods() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }

      public final boolean hasFields() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getFields() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }

    }

  }


  public static class LayeredModule {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)0,(short)2);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return LayeredModule.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasOpenModulePackages() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Builder> getOpenModulePackages() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 0, null, 0);
      }
      public final void setOpenModulePackages(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Builder> initOpenModulePackages(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 0, size);
      }
      public final boolean hasExportedModulePackages() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Builder> getExportedModulePackages() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 1, null, 0);
      }
      public final void setExportedModulePackages(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Builder> initExportedModulePackages(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 1, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final boolean hasOpenModulePackages() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Reader> getOpenModulePackages() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 0, null, 0);
      }

      public final boolean hasExportedModulePackages() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Reader> getExportedModulePackages() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.listFactory, 1, null, 0);
      }

    }

  }


  public static class ModulePackages {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)0,(short)2);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return ModulePackages.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasModuleKey() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getModuleKey() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setModuleKey(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setModuleKey(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initModuleKey(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasPackages() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Builder> getPackages() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.listFactory, 1, null, 0);
      }
      public final void setPackages(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.listFactory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Builder> initPackages(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.listFactory, 1, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public boolean hasModuleKey() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getModuleKey() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final boolean hasPackages() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Reader> getPackages() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.Packages.listFactory, 1, null, 0);
      }

    }

  }


  public static class Packages {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)0,(short)2);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return Packages.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean hasPackageKey() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getPackageKey() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setPackageKey(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setPackageKey(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initPackageKey(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasModules() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder getModules() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, null, 0);
      }
      public final void setModules(com.oracle.svm.shaded.org.capnproto.TextList.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Builder initModules(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public boolean hasPackageKey() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getPackageKey() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public final boolean hasModules() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.TextList.Reader getModules() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.TextList.factory, 1, null, 0);
      }

    }

  }


  public static class PrimitiveValue {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)2,(short)0);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return PrimitiveValue.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final byte getTypeChar() {
        return _getByteField(0);
      }
      public final void setTypeChar(byte value) {
        _setByteField(0, value);
      }

      public final long getRawValue() {
        return _getLongField(1);
      }
      public final void setRawValue(long value) {
        _setLongField(1, value);
      }

    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final byte getTypeChar() {
        return _getByteField(0);
      }

      public final long getRawValue() {
        return _getLongField(1);
      }

    }

  }


  public static class PrimitiveArray {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)1,(short)1);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return PrimitiveArray.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public Which which() {
        switch(_getShortField(0)) {
          case 0 : return Which.Z;
          case 1 : return Which.B;
          case 2 : return Which.S;
          case 3 : return Which.C;
          case 4 : return Which.I;
          case 5 : return Which.F;
          case 6 : return Which.J;
          case 7 : return Which.D;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final boolean isZ() {
        return which() == PrimitiveArray.Which.Z;
      }
      public final boolean hasZ() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Builder getZ() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 0, null, 0);
      }
      public final void setZ(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.Z.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Builder initZ(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.Z.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 0, size);
      }
      public final boolean isB() {
        return which() == PrimitiveArray.Which.B;
      }
      public final boolean hasB() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.Builder getB() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.factory, 0, null, 0);
      }
      public final void setB(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.B.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.Builder initB(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.B.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.factory, 0, size);
      }
      public final boolean isS() {
        return which() == PrimitiveArray.Which.S;
      }
      public final boolean hasS() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Builder getS() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, null, 0);
      }
      public final void setS(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.S.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Builder initS(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.S.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, size);
      }
      public final boolean isC() {
        return which() == PrimitiveArray.Which.C;
      }
      public final boolean hasC() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Builder getC() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, null, 0);
      }
      public final void setC(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.C.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Builder initC(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.C.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, size);
      }
      public final boolean isI() {
        return which() == PrimitiveArray.Which.I;
      }
      public final boolean hasI() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getI() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }
      public final void setI(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.I.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initI(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.I.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, size);
      }
      public final boolean isF() {
        return which() == PrimitiveArray.Which.F;
      }
      public final boolean hasF() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.Builder getF() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.factory, 0, null, 0);
      }
      public final void setF(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.F.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.Builder initF(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.F.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.factory, 0, size);
      }
      public final boolean isJ() {
        return which() == PrimitiveArray.Which.J;
      }
      public final boolean hasJ() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.Builder getJ() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.factory, 0, null, 0);
      }
      public final void setJ(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.J.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.Builder initJ(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.J.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.factory, 0, size);
      }
      public final boolean isD() {
        return which() == PrimitiveArray.Which.D;
      }
      public final boolean hasD() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.Builder getD() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.factory, 0, null, 0);
      }
      public final void setD(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.Reader value) {
        _setShortField(0, (short)PrimitiveArray.Which.D.ordinal());
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.Builder initD(int size) {
        _setShortField(0, (short)PrimitiveArray.Which.D.ordinal());
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.factory, 0, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public Which which() {
        switch(_getShortField(0)) {
          case 0 : return Which.Z;
          case 1 : return Which.B;
          case 2 : return Which.S;
          case 3 : return Which.C;
          case 4 : return Which.I;
          case 5 : return Which.F;
          case 6 : return Which.J;
          case 7 : return Which.D;
          default: return Which._NOT_IN_SCHEMA;
        }
      }
      public final boolean isZ() {
        return which() == PrimitiveArray.Which.Z;
      }
      public final boolean hasZ() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.Reader getZ() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Boolean.factory, 0, null, 0);
      }

      public final boolean isB() {
        return which() == PrimitiveArray.Which.B;
      }
      public final boolean hasB() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.Reader getB() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Byte.factory, 0, null, 0);
      }

      public final boolean isS() {
        return which() == PrimitiveArray.Which.S;
      }
      public final boolean hasS() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Reader getS() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, null, 0);
      }

      public final boolean isC() {
        return which() == PrimitiveArray.Which.C;
      }
      public final boolean hasC() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.Reader getC() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Short.factory, 0, null, 0);
      }

      public final boolean isI() {
        return which() == PrimitiveArray.Which.I;
      }
      public final boolean hasI() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getI() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }

      public final boolean isF() {
        return which() == PrimitiveArray.Which.F;
      }
      public final boolean hasF() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.Reader getF() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Float.factory, 0, null, 0);
      }

      public final boolean isJ() {
        return which() == PrimitiveArray.Which.J;
      }
      public final boolean hasJ() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.Reader getJ() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Long.factory, 0, null, 0);
      }

      public final boolean isD() {
        return which() == PrimitiveArray.Which.D;
      }
      public final boolean hasD() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.Reader getD() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Double.factory, 0, null, 0);
      }

    }

    public enum Which {
      Z,
      B,
      S,
      C,
      I,
      F,
      J,
      D,
      _NOT_IN_SCHEMA,
    }
  }


  public static class DispatchSlotInfo {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)2,(short)1);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return DispatchSlotInfo.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getDeclaredHostedMethodIndex() {
        return _getIntField(0);
      }
      public final void setDeclaredHostedMethodIndex(int value) {
        _setIntField(0, value);
      }

      public final int getResolvedHostedMethodIndex() {
        return _getIntField(1);
      }
      public final void setResolvedHostedMethodIndex(int value) {
        _setIntField(1, value);
      }

      public final int getSlotIndex() {
        return _getIntField(2);
      }
      public final void setSlotIndex(int value) {
        _setIntField(2, value);
      }

      public final int getResolutionStatus() {
        return _getIntField(3);
      }
      public final void setResolutionStatus(int value) {
        _setIntField(3, value);
      }

      public final boolean hasSlotSymbolName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getSlotSymbolName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setSlotSymbolName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setSlotSymbolName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initSlotSymbolName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getDeclaredHostedMethodIndex() {
        return _getIntField(0);
      }

      public final int getResolvedHostedMethodIndex() {
        return _getIntField(1);
      }

      public final int getSlotIndex() {
        return _getIntField(2);
      }

      public final int getResolutionStatus() {
        return _getIntField(3);
      }

      public boolean hasSlotSymbolName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getSlotSymbolName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

    }

  }


  public static class PersistedHostedMethod {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)3,(short)3);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return PersistedHostedMethod.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getIndex() {
        return _getIntField(0);
      }
      public final void setIndex(int value) {
        _setIntField(0, value);
      }

      public final int getMethodId() {
        return _getIntField(1);
      }
      public final void setMethodId(int value) {
        _setIntField(1, value);
      }

      public final int getVTableIndex() {
        return _getIntField(2);
      }
      public final void setVTableIndex(int value) {
        _setIntField(2, value);
      }

      public final int getInstalledOffset() {
        return _getIntField(3);
      }
      public final void setInstalledOffset(int value) {
        _setIntField(3, value);
      }

      public final boolean getIsVirtualCallTarget() {
        return _getBooleanField(128);
      }
      public final void setIsVirtualCallTarget(boolean value) {
        _setBooleanField(128, value);
      }

      public final boolean hasSymbolName() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getSymbolName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }
      public final void setSymbolName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, value);
      }
      public final void setSymbolName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initSymbolName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, size);
      }
      public final boolean hasHostedMethodName() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getHostedMethodName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }
      public final void setHostedMethodName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, value);
      }
      public final void setHostedMethodName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initHostedMethodName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, size);
      }
      public final boolean hasHostedMethodUniqueName() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder getHostedMethodUniqueName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }
      public final void setHostedMethodUniqueName(com.oracle.svm.shaded.org.capnproto.Text.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, value);
      }
      public final void setHostedMethodUniqueName(String value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, new com.oracle.svm.shaded.org.capnproto.Text.Reader(value));
      }
      public final com.oracle.svm.shaded.org.capnproto.Text.Builder initHostedMethodUniqueName(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getIndex() {
        return _getIntField(0);
      }

      public final int getMethodId() {
        return _getIntField(1);
      }

      public final int getVTableIndex() {
        return _getIntField(2);
      }

      public final int getInstalledOffset() {
        return _getIntField(3);
      }

      public final boolean getIsVirtualCallTarget() {
        return _getBooleanField(128);
      }

      public boolean hasSymbolName() {
        return !_pointerFieldIsNull(0);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getSymbolName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 0, null, 0, 0);
      }

      public boolean hasHostedMethodName() {
        return !_pointerFieldIsNull(1);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getHostedMethodName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 1, null, 0, 0);
      }

      public boolean hasHostedMethodUniqueName() {
        return !_pointerFieldIsNull(2);
      }
      public com.oracle.svm.shaded.org.capnproto.Text.Reader getHostedMethodUniqueName() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.Text.factory, 2, null, 0, 0);
      }

    }

  }


  public static class DynamicHubInfo {
    public static final com.oracle.svm.shaded.org.capnproto.StructSize STRUCT_SIZE = new com.oracle.svm.shaded.org.capnproto.StructSize((short)3,(short)3);
    public static final class Factory extends com.oracle.svm.shaded.org.capnproto.StructFactory<Builder, Reader> {
      public Factory() {
      }
      public final Reader constructReader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data,int pointers, int dataSize, short pointerCount, int nestingLimit) {
        return new Reader(segment,data,pointers,dataSize,pointerCount,nestingLimit);
      }
      public final Builder constructBuilder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data,int pointers, int dataSize, short pointerCount) {
        return new Builder(segment, data, pointers, dataSize, pointerCount);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructSize structSize() {
        return DynamicHubInfo.STRUCT_SIZE;
      }
      public final Reader asReader(Builder builder) {
        return builder.asReader();
      }
    }
    public static final Factory factory = new Factory();
    public static final com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder,Reader> listFactory =
      new com.oracle.svm.shaded.org.capnproto.StructList.Factory<Builder, Reader>(factory);
    public static final class Builder extends com.oracle.svm.shaded.org.capnproto.StructBuilder {
      Builder(com.oracle.svm.shaded.org.capnproto.SegmentBuilder segment, int data, int pointers,int dataSize, short pointerCount){
        super(segment, data, pointers, dataSize, pointerCount);
      }
      public final Reader asReader() {
        return new Reader(segment, data, pointers, dataSize, pointerCount, 0x7fffffff);
      }
      public final int getTypeId() {
        return _getIntField(0);
      }
      public final void setTypeId(int value) {
        _setIntField(0, value);
      }

      public final boolean getInstalled() {
        return _getBooleanField(32);
      }
      public final void setInstalled(boolean value) {
        _setBooleanField(32, value);
      }

      public final int getTypecheckId() {
        return _getIntField(2);
      }
      public final void setTypecheckId(int value) {
        _setIntField(2, value);
      }

      public final int getNumClassTypes() {
        return _getIntField(3);
      }
      public final void setNumClassTypes(int value) {
        _setIntField(3, value);
      }

      public final int getNumInterfaceTypes() {
        return _getIntField(4);
      }
      public final void setNumInterfaceTypes(int value) {
        _setIntField(4, value);
      }

      public final boolean hasTypecheckSlotValues() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getTypecheckSlotValues() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }
      public final void setTypecheckSlotValues(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initTypecheckSlotValues(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, size);
      }
      public final boolean hasLocallyDeclaredSlotsHostedMethodIndexes() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder getLocallyDeclaredSlotsHostedMethodIndexes() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }
      public final void setLocallyDeclaredSlotsHostedMethodIndexes(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader value) {
        _setPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Builder initLocallyDeclaredSlotsHostedMethodIndexes(int size) {
        return _initPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, size);
      }
      public final boolean hasDispatchTableSlotValues() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Builder> getDispatchTableSlotValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.listFactory, 2, null, 0);
      }
      public final void setDispatchTableSlotValues(com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Reader> value) {
        _setPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.listFactory, 2, value);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Builder<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Builder> initDispatchTableSlotValues(int size) {
        return _initPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.listFactory, 2, size);
      }
    }

    public static final class Reader extends com.oracle.svm.shaded.org.capnproto.StructReader {
      Reader(com.oracle.svm.shaded.org.capnproto.SegmentReader segment, int data, int pointers,int dataSize, short pointerCount, int nestingLimit){
        super(segment, data, pointers, dataSize, pointerCount, nestingLimit);
      }

      public final int getTypeId() {
        return _getIntField(0);
      }

      public final boolean getInstalled() {
        return _getBooleanField(32);
      }

      public final int getTypecheckId() {
        return _getIntField(2);
      }

      public final int getNumClassTypes() {
        return _getIntField(3);
      }

      public final int getNumInterfaceTypes() {
        return _getIntField(4);
      }

      public final boolean hasTypecheckSlotValues() {
        return !_pointerFieldIsNull(0);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getTypecheckSlotValues() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 0, null, 0);
      }

      public final boolean hasLocallyDeclaredSlotsHostedMethodIndexes() {
        return !_pointerFieldIsNull(1);
      }
      public final com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.Reader getLocallyDeclaredSlotsHostedMethodIndexes() {
        return _getPointerField(com.oracle.svm.shaded.org.capnproto.PrimitiveList.Int.factory, 1, null, 0);
      }

      public final boolean hasDispatchTableSlotValues() {
        return !_pointerFieldIsNull(2);
      }
      public final com.oracle.svm.shaded.org.capnproto.StructList.Reader<com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.Reader> getDispatchTableSlotValues() {
        return _getPointerField(com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder.DispatchSlotInfo.listFactory, 2, null, 0);
      }

    }

  }



}
