pkgname <- "stats"
source(file.path(R.home("share"), "R", "examples-header.R"))
options(warn = 1)
library('stats')

base::assign(".oldSearch", base::search(), pos = 'CheckExEnv')
cleanEx()
nameEx("AIC")
### * AIC

flush(stderr()); flush(stdout())

### Name: AIC
### Title: Akaike's An Information Criterion
### Aliases: AIC BIC
### Keywords: models

### ** Examples

lm1 <- lm(Fertility ~ . , data = swiss)
AIC(lm1)
stopifnot(all.equal(AIC(lm1),
                    AIC(logLik(lm1))))
BIC(lm1)

lm2 <- update(lm1, . ~ . -Examination)
AIC(lm1, lm2)
BIC(lm1, lm2)



cleanEx()
nameEx("ARMAacf")
### * ARMAacf

flush(stderr()); flush(stdout())

### Name: ARMAacf
### Title: Compute Theoretical ACF for an ARMA Process
### Aliases: ARMAacf
### Keywords: ts

### ** Examples

ARMAacf(c(1.0, -0.25), 1.0, lag.max = 10)

## Example from Brockwell & Davis (1991, pp.92-4)
## answer: 2^(-n) * (32/3 + 8 * n) /(32/3)
n <- 1:10
a.n <- 2^(-n) * (32/3 + 8 * n) /(32/3)
(A.n <- ARMAacf(c(1.0, -0.25), 1.0, lag.max = 10))
stopifnot(all.equal(unname(A.n), c(1, a.n)))

ARMAacf(c(1.0, -0.25), 1.0, lag.max = 10, pacf = TRUE)
zapsmall(ARMAacf(c(1.0, -0.25), lag.max = 10, pacf = TRUE))

## Cov-Matrix of length-7 sub-sample of AR(1) example:
toeplitz(ARMAacf(0.8, lag.max = 7))



cleanEx()
nameEx("ARMAtoMA")
### * ARMAtoMA

flush(stderr()); flush(stdout())

### Name: ARMAtoMA
### Title: Convert ARMA Process to Infinite MA Process
### Aliases: ARMAtoMA
### Keywords: ts

### ** Examples

ARMAtoMA(c(1.0, -0.25), 1.0, 10)
## Example from Brockwell & Davis (1991, p.92)
## answer (1 + 3*n)*2^(-n)
n <- 1:10; (1 + 3*n)*2^(-n)



cleanEx()
nameEx("Beta")
### * Beta

flush(stderr()); flush(stdout())

### Name: Beta
### Title: The Beta Distribution
### Aliases: Beta dbeta pbeta qbeta rbeta
### Keywords: distribution

### ** Examples

x <- seq(0, 1, length = 21)
dbeta(x, 1, 1)
pbeta(x, 1, 1)

if(FALSE) { # [FastR] BEGIN Test snippet disabled since abline() uses graphics package
## Visualization, including limit cases:
pl.beta <- function(a,b, asp = if(isLim) 1, ylim = if(isLim) c(0,1.1)) {
  if(isLim <- a == 0 || b == 0 || a == Inf || b == Inf) {
    eps <- 1e-10
    x <- c(0, eps, (1:7)/16, 1/2+c(-eps,0,eps), (9:15)/16, 1-eps, 1)
  } else {
    x <- seq(0, 1, length = 1025)
  }
  fx <- cbind(dbeta(x, a,b), pbeta(x, a,b), qbeta(x, a,b))
  f <- fx; f[fx == Inf] <- 1e100
  matplot(x, f, ylab="", type="l", ylim=ylim, asp=asp,
          main = sprintf("[dpq]beta(x, a=%g, b=%g)", a,b))
  abline(0,1,     col="gray", lty=3)
  abline(h = 0:1, col="gray", lty=3)
  legend("top", paste0(c("d","p","q"), "beta(x, a,b)"),
         col=1:3, lty=1:3, bty = "n")
  invisible(cbind(x, fx))
}
pl.beta(3,1)

pl.beta(2, 4)
pl.beta(3, 7)
pl.beta(3, 7, asp=1)

pl.beta(0, 0)   ## point masses at  {0, 1}

pl.beta(0, 2)   ## point mass at 0 ; the same as
pl.beta(1, Inf)

pl.beta(Inf, 2) ## point mass at 1 ; the same as
pl.beta(3, 0)

pl.beta(Inf, Inf)# point mass at 1/2
} # [FastR] END Test snippet disabled since abline() uses graphics package



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("Binomial")
### * Binomial

flush(stderr()); flush(stdout())

### Name: Binomial
### Title: The Binomial Distribution
### Aliases: Binomial dbinom pbinom qbinom rbinom
### Keywords: distribution

### ** Examples

require(graphics)
# Compute P(45 < X < 55) for X Binomial(100,0.5)
sum(dbinom(46:54, 100, 0.5))

## Using "log = TRUE" for an extended range :
n <- 2000
k <- seq(0, n, by = 20)
plot (k, dbinom(k, n, pi/10, log = TRUE), type = "l", ylab = "log density",
      main = "dbinom(*, log=TRUE) is better than  log(dbinom(*))")
lines(k, log(dbinom(k, n, pi/10)), col = "red", lwd = 2)
## extreme points are omitted since dbinom gives 0.
mtext("dbinom(k, log=TRUE)", adj = 0)
mtext("extended range", adj = 0, line = -1, font = 4)
mtext("log(dbinom(k))", col = "red", adj = 1)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("Cauchy")
### * Cauchy

flush(stderr()); flush(stdout())

### Name: Cauchy
### Title: The Cauchy Distribution
### Aliases: Cauchy dcauchy pcauchy qcauchy rcauchy
### Keywords: distribution

### ** Examples

dcauchy(-1:4)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("Chisquare")
### * Chisquare

flush(stderr()); flush(stdout())

### Name: Chisquare
### Title: The (non-central) Chi-Squared Distribution
### Aliases: Chisquare dchisq pchisq qchisq rchisq
### Keywords: distribution

### ** Examples

require(graphics)

dchisq(1, df = 1:3)
pchisq(1, df =  3)
pchisq(1, df =  3, ncp = 0:4)  # includes the above

x <- 1:10
## Chi-squared(df = 2) is a special exponential distribution
all.equal(dchisq(x, df = 2), dexp(x, 1/2))
all.equal(pchisq(x, df = 2), pexp(x, 1/2))

## non-central RNG -- df = 0 with ncp > 0:  Z0 has point mass at 0!
Z0 <- rchisq(100, df = 0, ncp = 2.)
graphics::stem(Z0)


## "analytical" test
lam <- seq(0, 100, by = .25)
p00 <- pchisq(0,      df = 0, ncp = lam)
p.0 <- pchisq(1e-300, df = 0, ncp = lam)
stopifnot(all.equal(p00, exp(-lam/2)),
          all.equal(p.0, exp(-lam/2)))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("Exponential")
### * Exponential

flush(stderr()); flush(stdout())

### Name: Exponential
### Title: The Exponential Distribution
### Aliases: Exponential dexp pexp qexp rexp
### Keywords: distribution

### ** Examples

dexp(1) - exp(-1) #-> 0

## a fast way to generate *sorted*  U[0,1]  random numbers:
rsunif <- function(n) { n1 <- n+1
   cE <- cumsum(rexp(n1)); cE[seq_len(n)]/cE[n1] }
plot(rsunif(1000), ylim=0:1, pch=".")
if(FALSE) { # [FastR] BEGIN Test snippet disabled since abline() uses graphics package
abline(0,1/(1000+1), col=adjustcolor(1, 0.5))
} # [FastR] END Test snippet disabled since abline() uses graphics package



cleanEx()
nameEx("Fdist")
### * Fdist

flush(stderr()); flush(stdout())

### Name: FDist
### Title: The F Distribution
### Aliases: FDist df pf qf rf
### Keywords: distribution

### ** Examples

## Equivalence of pt(.,nu) with pf(.^2, 1,nu):
x <- seq(0.001, 5, len = 100)
nu <- 4
stopifnot(all.equal(2*pt(x,nu) - 1, pf(x^2, 1,nu)),
          ## upper tails:
 	  all.equal(2*pt(x,     nu, lower=FALSE),
		      pf(x^2, 1,nu, lower=FALSE)))

## the density of the square of a t_m is 2*dt(x, m)/(2*x)
# check this is the same as the density of F_{1,m}
all.equal(df(x^2, 1, 5), dt(x, 5)/x)

## Identity:  qf(2*p - 1, 1, df)) == qt(p, df)^2)  for  p >= 1/2
p <- seq(1/2, .99, length = 50); df <- 10
rel.err <- function(x, y) ifelse(x == y, 0, abs(x-y)/mean(abs(c(x,y))))



cleanEx()
nameEx("GammaDist")
### * GammaDist

flush(stderr()); flush(stdout())

### Name: GammaDist
### Title: The Gamma Distribution
### Aliases: GammaDist dgamma pgamma qgamma rgamma
### Keywords: distribution

### ** Examples

-log(dgamma(1:4, shape = 1))
p <- (1:9)/10
pgamma(qgamma(p, shape = 2), shape = 2)
1 - 1/exp(qgamma(p, shape = 1))



cleanEx()
nameEx("Geometric")
### * Geometric

flush(stderr()); flush(stdout())

### Name: Geometric
### Title: The Geometric Distribution
### Aliases: Geometric dgeom pgeom qgeom rgeom
### Keywords: distribution

### ** Examples

qgeom((1:9)/10, prob = .2)
Ni <- rgeom(20, prob = 1/4); table(factor(Ni, 0:max(Ni)))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("HoltWinters")
### * HoltWinters

flush(stderr()); flush(stdout())

### Name: HoltWinters
### Title: Holt-Winters Filtering
### Aliases: HoltWinters print.HoltWinters residuals.HoltWinters
### Keywords: ts

### ** Examples

## Don't show: 
od <- options(digits = 5)
## End(Don't show)
require(graphics)

## Seasonal Holt-Winters
(m <- HoltWinters(co2))
plot(m)
plot(fitted(m))

(m <- HoltWinters(AirPassengers, seasonal = "mult"))
plot(m)

## Non-Seasonal Holt-Winters
x <- uspop + rnorm(uspop, sd = 5)
m <- HoltWinters(x, gamma = FALSE)
plot(m)

## Exponential Smoothing
m2 <- HoltWinters(x, gamma = FALSE, beta = FALSE)
lines(fitted(m2)[,1], col = 3)
## Don't show: 
options(od)
## End(Don't show)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("Hypergeometric")
### * Hypergeometric

flush(stderr()); flush(stdout())

### Name: Hypergeometric
### Title: The Hypergeometric Distribution
### Aliases: Hypergeometric dhyper phyper qhyper rhyper
### Keywords: distribution

### ** Examples

m <- 10; n <- 7; k <- 8
x <- 0:(k+1)
rbind(phyper(x, m, n, k), dhyper(x, m, n, k))
all(phyper(x, m, n, k) == cumsum(dhyper(x, m, n, k)))  # FALSE


cleanEx()
nameEx("IQR")
### * IQR

flush(stderr()); flush(stdout())

### Name: IQR
### Title: The Interquartile Range
### Aliases: IQR
### Keywords: univar robust distribution

### ** Examples

IQR(rivers)



cleanEx()
nameEx("KalmanLike")
### * KalmanLike

flush(stderr()); flush(stdout())

### Name: KalmanLike
### Title: Kalman Filtering
### Aliases: KalmanLike KalmanRun KalmanSmooth KalmanForecast makeARIMA
### Keywords: ts

### ** Examples

## an ARIMA fit
fit3 <- arima(presidents, c(3, 0, 0))
predict(fit3, 12)
## reconstruct this
pr <- KalmanForecast(12, fit3$model)
pr$pred + fit3$coef[4]
sqrt(pr$var * fit3$sigma2)
## and now do it year by year
mod <- fit3$model
for(y in 1:3) {
  pr <- KalmanForecast(4, mod, TRUE)
  print(list(pred = pr$pred + fit3$coef["intercept"], 
             se = sqrt(pr$var * fit3$sigma2)))
  mod <- attr(pr, "mod")
}



cleanEx()
nameEx("Logistic")
### * Logistic

flush(stderr()); flush(stdout())

### Name: Logistic
### Title: The Logistic Distribution
### Aliases: Logistic dlogis plogis qlogis rlogis
### Keywords: distribution

### ** Examples

var(rlogis(4000, 0, scale = 5))  # approximately (+/- 3)
pi^2/3 * 5^2



cleanEx()
nameEx("Lognormal")
### * Lognormal

flush(stderr()); flush(stdout())

### Name: Lognormal
### Title: The Log Normal Distribution
### Aliases: Lognormal dlnorm plnorm qlnorm rlnorm
### Keywords: distribution

### ** Examples

dlnorm(1) == dnorm(0)



cleanEx()
nameEx("Multinom")
### * Multinom

flush(stderr()); flush(stdout())

### Name: Multinom
### Title: The Multinomial Distribution
### Aliases: Multinomial rmultinom dmultinom
### Keywords: distribution

### ** Examples

rmultinom(10, size = 12, prob = c(0.1,0.2,0.8))

pr <- c(1,3,6,10) # normalization not necessary for generation
rmultinom(10, 20, prob = pr)

## all possible outcomes of Multinom(N = 3, K = 3)
X <- t(as.matrix(expand.grid(0:3, 0:3))); X <- X[, colSums(X) <= 3]
X <- rbind(X, 3:3 - colSums(X)); dimnames(X) <- list(letters[1:3], NULL)
X
round(apply(X, 2, function(x) dmultinom(x, prob = c(1,2,5))), 3)



cleanEx()
nameEx("NLSstAsymptotic")
### * NLSstAsymptotic

flush(stderr()); flush(stdout())

### Name: NLSstAsymptotic
### Title: Fit the Asymptotic Regression Model
### Aliases: NLSstAsymptotic NLSstAsymptotic.sortedXyData
### Keywords: manip

### ** Examples

Lob.329 <- Loblolly[ Loblolly$Seed == "329", ]
print(NLSstAsymptotic(sortedXyData(expression(age),
                                   expression(height),
                                   Lob.329)), digits = 3)



cleanEx()
nameEx("NLSstClosestX")
### * NLSstClosestX

flush(stderr()); flush(stdout())

### Name: NLSstClosestX
### Title: Inverse Interpolation
### Aliases: NLSstClosestX NLSstClosestX.sortedXyData
### Keywords: manip

### ** Examples

DNase.2 <- DNase[ DNase$Run == "2", ]
DN.srt <- sortedXyData(expression(log(conc)), expression(density), DNase.2)
NLSstClosestX(DN.srt, 1.0)



cleanEx()
nameEx("NLSstLfAsymptote")
### * NLSstLfAsymptote

flush(stderr()); flush(stdout())

### Name: NLSstLfAsymptote
### Title: Horizontal Asymptote on the Left Side
### Aliases: NLSstLfAsymptote NLSstLfAsymptote.sortedXyData
### Keywords: manip

### ** Examples

DNase.2 <- DNase[ DNase$Run == "2", ]
DN.srt <- sortedXyData( expression(log(conc)), expression(density), DNase.2 )
NLSstLfAsymptote( DN.srt )



cleanEx()
nameEx("NLSstRtAsymptote")
### * NLSstRtAsymptote

flush(stderr()); flush(stdout())

### Name: NLSstRtAsymptote
### Title: Horizontal Asymptote on the Right Side
### Aliases: NLSstRtAsymptote NLSstRtAsymptote.sortedXyData
### Keywords: manip

### ** Examples

DNase.2 <- DNase[ DNase$Run == "2", ]
DN.srt <- sortedXyData( expression(log(conc)), expression(density), DNase.2 )
NLSstRtAsymptote( DN.srt )



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("NegBinomial")
### * NegBinomial

flush(stderr()); flush(stdout())

### Name: NegBinomial
### Title: The Negative Binomial Distribution
### Aliases: NegBinomial dnbinom pnbinom qnbinom rnbinom
### Keywords: distribution

### ** Examples

require(graphics)
x <- 0:11
dnbinom(x, size = 1, prob = 1/2) * 2^(1 + x) # == 1
126 /  dnbinom(0:8, size  = 2, prob  = 1/2) #- theoretically integer


x <- 0:15
size <- (1:20)/4
persp(x, size, dnb <- outer(x, size, function(x,s) dnbinom(x, s, prob = 0.4)),
      xlab = "x", ylab = "s", zlab = "density", theta = 150)
title(tit <- "negative binomial density(x,s, pr = 0.4)  vs.  x & s")

image  (x, size, log10(dnb), main = paste("log [", tit, "]"))
contour(x, size, log10(dnb), add = TRUE)

## Alternative parametrization
x1 <- rnbinom(500, mu = 4, size = 1)
x2 <- rnbinom(500, mu = 4, size = 10)
x3 <- rnbinom(500, mu = 4, size = 100)
h1 <- hist(x1, breaks = 20, plot = FALSE)
h2 <- hist(x2, breaks = h1$breaks, plot = FALSE)
h3 <- hist(x3, breaks = h1$breaks, plot = FALSE)
barplot(rbind(h1$counts, h2$counts, h3$counts),
        beside = TRUE, col = c("red","blue","cyan"),
        names.arg = round(h1$breaks[-length(h1$breaks)]))



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("Normal")
### * Normal

flush(stderr()); flush(stdout())

### Name: Normal
### Title: The Normal Distribution
### Aliases: Normal dnorm pnorm qnorm rnorm
### Keywords: distribution

### ** Examples

require(graphics)

dnorm(0) == 1/sqrt(2*pi)
dnorm(1) == exp(-1/2)/sqrt(2*pi)
dnorm(1) == 1/sqrt(2*pi*exp(1))

## Using "log = TRUE" for an extended range :
par(mfrow = c(2,1))
plot(function(x) dnorm(x, log = TRUE), -60, 50,
     main = "log { Normal density }")
curve(log(dnorm(x)), add = TRUE, col = "red", lwd = 2)
mtext("dnorm(x, log=TRUE)", adj = 0)
mtext("log(dnorm(x))", col = "red", adj = 1)

plot(function(x) pnorm(x, log.p = TRUE), -50, 10,
     main = "log { Normal Cumulative }")
curve(log(pnorm(x)), add = TRUE, col = "red", lwd = 2)
mtext("pnorm(x, log=TRUE)", adj = 0)
mtext("log(pnorm(x))", col = "red", adj = 1)

## if you want the so-called 'error function'
erf <- function(x) 2 * pnorm(x * sqrt(2)) - 1
## (see Abramowitz and Stegun 29.2.29)
## and the so-called 'complementary error function'
erfc <- function(x) 2 * pnorm(x * sqrt(2), lower = FALSE)
## and the inverses
erfinv <- function (x) qnorm((1 + x)/2)/sqrt(2)
erfcinv <- function (x) qnorm(x/2, lower = FALSE)/sqrt(2)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("Poisson")
### * Poisson

flush(stderr()); flush(stdout())

### Name: Poisson
### Title: The Poisson Distribution
### Aliases: Poisson dpois ppois qpois rpois
### Keywords: distribution

### ** Examples

require(graphics)

-log(dpois(0:7, lambda = 1) * gamma(1+ 0:7)) # == 1
Ni <- rpois(50, lambda = 4); table(factor(Ni, 0:max(Ni)))

1 - ppois(10*(15:25), lambda = 100)  # becomes 0 (cancellation)
    ppois(10*(15:25), lambda = 100, lower.tail = FALSE)  # no cancellation

par(mfrow = c(2, 1))
x <- seq(-0.01, 5, 0.01)
plot(x, ppois(x, 1), type = "s", ylab = "F(x)", main = "Poisson(1) CDF")
plot(x, pbinom(x, 100, 0.01), type = "s", ylab = "F(x)",
     main = "Binomial(100, 0.01) CDF")

## The (limit) case  lambda = 0 :
stopifnot(identical(dpois(0,0), 1),
	  identical(ppois(0,0), 1),
	  identical(qpois(1,0), 0))



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSD")
### * SSD

flush(stderr()); flush(stdout())

### Name: SSD
### Title: SSD Matrix and Estimated Variance Matrix in Multivariate Models
### Aliases: SSD estVar
### Keywords: models multivariate

### ** Examples

# Lifted from Baron+Li:
# "Notes on the use of R for psychology experiments and questionnaires"
# Maxwell and Delaney, p. 497
reacttime <- matrix(c(
420, 420, 480, 480, 600, 780,
420, 480, 480, 360, 480, 600,
480, 480, 540, 660, 780, 780,
420, 540, 540, 480, 780, 900,
540, 660, 540, 480, 660, 720,
360, 420, 360, 360, 480, 540,
480, 480, 600, 540, 720, 840,
480, 600, 660, 540, 720, 900,
540, 600, 540, 480, 720, 780,
480, 420, 540, 540, 660, 780),
ncol = 6, byrow = TRUE,
dimnames = list(subj = 1:10,
              cond = c("deg0NA", "deg4NA", "deg8NA",
                       "deg0NP", "deg4NP", "deg8NP")))

mlmfit <- lm(reacttime ~ 1)
SSD(mlmfit)
estVar(mlmfit)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSasymp")
### * SSasymp

flush(stderr()); flush(stdout())

### Name: SSasymp
### Title: Self-Starting Nls Asymptotic Regression Model
### Aliases: SSasymp
### Keywords: models

### ** Examples

## Don't show: 
options(show.nls.convergence=FALSE)
## End(Don't show)
Lob.329 <- Loblolly[ Loblolly$Seed == "329", ]
SSasymp( Lob.329$age, 100, -8.5, -3.2 )  # response only
Asym <- 100
resp0 <- -8.5
lrc <- -3.2
SSasymp( Lob.329$age, Asym, resp0, lrc ) # response and gradient
getInitial(height ~ SSasymp( age, Asym, resp0, lrc), data = Lob.329)
## Initial values are in fact the converged values
fm1 <- nls(height ~ SSasymp( age, Asym, resp0, lrc), data = Lob.329)
summary(fm1)
## Don't show: 
require(graphics)

  xx <- seq(0, 5, len = 101)
  yy <- 5 - 4 * exp(-xx/(2*log(2)))
  par(mar = c(0, 0, 4.1, 0))
  plot(xx, yy, type = "l", axes = FALSE, ylim = c(0,6), xlim = c(-1, 5),
       xlab = "", ylab = "", lwd = 2,
       main = "Parameters in the SSasymp model")
  usr <- par("usr")
  arrows(usr[1], 0, usr[2], 0, length = 0.1, angle = 25)
  arrows(0, usr[3], 0, usr[4], length = 0.1, angle = 25)
  text(usr[2] - 0.2, 0.1, "x", adj = c(1, 0))
  text(-0.1, usr[4], "y", adj = c(1, 1))
  abline(h = 5, lty = 2, lwd = 0)
  arrows(-0.8, 2.1, -0.8, 0, length = 0.1, angle = 25)
  arrows(-0.8, 2.9, -0.8, 5, length = 0.1, angle = 25)
  text(-0.8, 2.5, expression(phi[1]), adj = c(0.5, 0.5))
  segments(-0.4, 1, 0, 1, lty = 2, lwd = 0.75)
  arrows(-0.3, 0.25, -0.3, 0, length = 0.07, angle = 25)
  arrows(-0.3, 0.75, -0.3, 1, length = 0.07, angle = 25)
  text(-0.3, 0.5, expression(phi[2]), adj = c(0.5, 0.5))
  segments(1, 3.025, 1, 4, lty = 2, lwd = 0.75)
  arrows(0.2, 3.5, 0, 3.5, length = 0.08, angle = 25)
  arrows(0.8, 3.5, 1, 3.5, length = 0.08, angle = 25)
  text(0.5, 3.5, expression(t[0.5]), adj = c(0.5, 0.5))
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSasympOff")
### * SSasympOff

flush(stderr()); flush(stdout())

### Name: SSasympOff
### Title: Self-Starting Nls Asymptotic Regression Model with an Offset
### Aliases: SSasympOff
### Keywords: models

### ** Examples

CO2.Qn1 <- CO2[CO2$Plant == "Qn1", ]
SSasympOff(CO2.Qn1$conc, 32, -4, 43)  # response only
Asym <- 32; lrc <- -4; c0 <- 43
SSasympOff(CO2.Qn1$conc, Asym, lrc, c0) # response and gradient
getInitial(uptake ~ SSasympOff(conc, Asym, lrc, c0), data = CO2.Qn1)
## Initial values are in fact the converged values
fm1 <- nls(uptake ~ SSasympOff(conc, Asym, lrc, c0), data = CO2.Qn1)
summary(fm1)
## Don't show: 
require(graphics)

  xx <- seq(0.5, 5, len = 101)
  yy <- 5 * (1 -  exp(-(xx - 0.5)/(2*log(2))))
  par(mar = c(0, 0, 4.0, 0))
  plot(xx, yy, type = "l", axes = FALSE, ylim = c(0,6), xlim = c(-1, 5),
       xlab = "", ylab = "", lwd = 2,
       main = "Parameters in the SSasympOff model")
  usr <- par("usr")
  arrows(usr[1], 0, usr[2], 0, length = 0.1, angle = 25)
  arrows(0, usr[3], 0, usr[4], length = 0.1, angle = 25)
  text(usr[2] - 0.2, 0.1, "x", adj = c(1, 0))
  text(-0.1, usr[4], "y", adj = c(1, 1))
  abline(h = 5, lty = 2, lwd = 0)
  arrows(-0.8, 2.1, -0.8, 0, length = 0.1, angle = 25)
  arrows(-0.8, 2.9, -0.8, 5, length = 0.1, angle = 25)
  text(-0.8, 2.5, expression(phi[1]), adj = c(0.5, 0.5))
  segments(0.5, 0, 0.5, 3, lty = 2, lwd = 0.75)
  text(0.5, 3.1, expression(phi[3]), adj = c(0.5, 0))
  segments(1.5, 2.525, 1.5, 3, lty = 2, lwd = 0.75)
  arrows(0.7, 2.65, 0.5, 2.65, length = 0.08, angle = 25)
  arrows(1.3, 2.65, 1.5, 2.65, length = 0.08, angle = 25)
  text(1.0, 2.65, expression(t[0.5]), adj = c(0.5, 0.5))
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSasympOrig")
### * SSasympOrig

flush(stderr()); flush(stdout())

### Name: SSasympOrig
### Title: Self-Starting Nls Asymptotic Regression Model through the Origin
### Aliases: SSasympOrig
### Keywords: models

### ** Examples
## Don't show: 
require(graphics)

  xx <- seq(0, 5, len = 101)
  yy <- 5 * (1- exp(-xx/(2*log(2))))
  par(mar = c(0, 0, 3.5, 0))
  plot(xx, yy, type = "l", axes = FALSE, ylim = c(0,6), xlim = c(-1, 5),
       xlab = "", ylab = "", lwd = 2,
       main = "Parameters in the SSasympOrig model")
  usr <- par("usr")
  arrows(usr[1], 0, usr[2], 0, length = 0.1, angle = 25)
  arrows(0, usr[3], 0, usr[4], length = 0.1, angle = 25)
  text(usr[2] - 0.2, 0.1, "x", adj = c(1, 0))
  text(-0.1, usr[4], "y", adj = c(1, 1))
  abline(h = 5, lty = 2, lwd = 0)
  arrows(-0.8, 2.1, -0.8, 0, length = 0.1, angle = 25)
  arrows(-0.8, 2.9, -0.8, 5, length = 0.1, angle = 25)
  text(-0.8, 2.5, expression(phi[1]), adj = c(0.5, 0.5))
  segments(1, 2.525, 1, 3.5, lty = 2, lwd = 0.75)
  arrows(0.2, 3.0, 0, 3.0, length = 0.08, angle = 25)
  arrows(0.8, 3.0, 1, 3.0, length = 0.08, angle = 25)
  text(0.5, 3.0, expression(t[0.5]), adj = c(0.5, 0.5))
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSbiexp")
### * SSbiexp

flush(stderr()); flush(stdout())

### Name: SSbiexp
### Title: Self-Starting Nls Biexponential model
### Aliases: SSbiexp
### Keywords: models

### ** Examples

Indo.1 <- Indometh[Indometh$Subject == 1, ]
SSbiexp( Indo.1$time, 3, 1, 0.6, -1.3 )  # response only
A1 <- 3; lrc1 <- 1; A2 <- 0.6; lrc2 <- -1.3
SSbiexp( Indo.1$time, A1, lrc1, A2, lrc2 ) # response and gradient
print(getInitial(conc ~ SSbiexp(time, A1, lrc1, A2, lrc2), data = Indo.1),
      digits = 5)
## Initial values are in fact the converged values
fm1 <- nls(conc ~ SSbiexp(time, A1, lrc1, A2, lrc2), data = Indo.1)
summary(fm1)

## Show the model components visually
  require(graphics)

  xx <- seq(0, 5, len = 101)
  y1 <- 3.5 * exp(-4*xx)
  y2 <- 1.5 * exp(-xx)
  plot(xx, y1 + y2, type = "l", lwd=2, ylim = c(-0.2,6), xlim = c(0, 5),
       main = "Components of the SSbiexp model")
  lines(xx, y1, lty = 2, col="tomato"); abline(v=0, h=0, col="gray40")
  lines(xx, y2, lty = 3, col="blue2" )
  legend("topright", c("y1+y2", "y1 = 3.5 * exp(-4*x)", "y2 = 1.5 * exp(-x)"),
         lty=1:3, col=c("black","tomato","blue2"), bty="n")
  axis(2, pos=0, at = c(3.5, 1.5), labels = c("A1","A2"), las=2)

## and how you could have got their sum via SSbiexp():
  ySS <- SSbiexp(xx, 3.5, log(4), 1.5, log(1))
  ##                      ---          ---
  stopifnot(all.equal(y1+y2, ySS, tolerance = 1e-15))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSfol")
### * SSfol

flush(stderr()); flush(stdout())

### Name: SSfol
### Title: Self-Starting Nls First-order Compartment Model
### Aliases: SSfol
### Keywords: models

### ** Examples

Theoph.1 <- Theoph[ Theoph$Subject == 1, ]
SSfol(Theoph.1$Dose, Theoph.1$Time, -2.5, 0.5, -3) # response only
lKe <- -2.5; lKa <- 0.5; lCl <- -3
SSfol(Theoph.1$Dose, Theoph.1$Time, lKe, lKa, lCl) # response and gradient
getInitial(conc ~ SSfol(Dose, Time, lKe, lKa, lCl), data = Theoph.1)
## Initial values are in fact the converged values
fm1 <- nls(conc ~ SSfol(Dose, Time, lKe, lKa, lCl), data = Theoph.1)
summary(fm1)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSfpl")
### * SSfpl

flush(stderr()); flush(stdout())

### Name: SSfpl
### Title: Self-Starting Nls Four-Parameter Logistic Model
### Aliases: SSfpl
### Keywords: models

### ** Examples

Chick.1 <- ChickWeight[ChickWeight$Chick == 1, ]
SSfpl(Chick.1$Time, 13, 368, 14, 6)  # response only
A <- 13; B <- 368; xmid <- 14; scal <- 6
SSfpl(Chick.1$Time, A, B, xmid, scal) # response and gradient
print(getInitial(weight ~ SSfpl(Time, A, B, xmid, scal), data = Chick.1),
      digits = 5)
## Initial values are in fact the converged values
fm1 <- nls(weight ~ SSfpl(Time, A, B, xmid, scal), data = Chick.1)
summary(fm1)
## Don't show: 
require(graphics)

  xx <- seq(-0.5, 5, len = 101)
  yy <- 1 + 4 / ( 1 + exp((2-xx)))
  par(mar = c(0, 0, 3.5, 0))
  plot(xx, yy, type = "l", axes = FALSE, ylim = c(0,6), xlim = c(-1, 5),
       xlab = "", ylab = "", lwd = 2,
       main = "Parameters in the SSfpl model")
  usr <- par("usr")
  arrows(usr[1], 0, usr[2], 0, length = 0.1, angle = 25)
  arrows(0, usr[3], 0, usr[4], length = 0.1, angle = 25)
  text(usr[2] - 0.2, 0.1, "x", adj = c(1, 0))
  text(-0.1, usr[4], "y", adj = c(1, 1))
  abline(h = 5, lty = 2, lwd = 0)
  arrows(-0.8, 2.1, -0.8, 0, length = 0.1, angle = 25)
  arrows(-0.8, 2.9, -0.8, 5, length = 0.1, angle = 25)
  text(-0.8, 2.5, expression(phi[1]), adj = c(0.5, 0.5))
  abline(h = 1, lty = 2, lwd = 0)
  arrows(-0.3, 0.25, -0.3, 0, length = 0.07, angle = 25)
  arrows(-0.3, 0.75, -0.3, 1, length = 0.07, angle = 25)
  text(-0.3, 0.5, expression(phi[2]), adj = c(0.5, 0.5))
  segments(2, 0, 2, 3.3, lty = 2, lwd = 0.75)
  text(2, 3.3, expression(phi[3]), adj = c(0.5, 0))
  segments(3, 1+4/(1+exp(-1)) - 0.025, 3, 2.5, lty = 2, lwd = 0.75)
  arrows(2.3, 2.7, 2.0, 2.7, length = 0.08, angle = 25)
  arrows(2.7, 2.7, 3.0, 2.7, length = 0.08, angle = 25)
  text(2.5, 2.7, expression(phi[4]), adj = c(0.5, 0.5))
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSgompertz")
### * SSgompertz

flush(stderr()); flush(stdout())

### Name: SSgompertz
### Title: Self-Starting Nls Gompertz Growth Model
### Aliases: SSgompertz
### Keywords: models

### ** Examples

DNase.1 <- subset(DNase, Run == 1)
SSgompertz(log(DNase.1$conc), 4.5, 2.3, 0.7)   # response only
Asym <- 4.5; b2 <- 2.3; b3 <- 0.7
SSgompertz(log(DNase.1$conc), Asym, b2, b3) # response and gradient
print(getInitial(density ~ SSgompertz(log(conc), Asym, b2, b3),
                 data = DNase.1), digits = 5)
## Initial values are in fact the converged values
fm1 <- nls(density ~ SSgompertz(log(conc), Asym, b2, b3),
           data = DNase.1)
summary(fm1)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSlogis")
### * SSlogis

flush(stderr()); flush(stdout())

### Name: SSlogis
### Title: Self-Starting Nls Logistic Model
### Aliases: SSlogis
### Keywords: models

### ** Examples
## Don't show: 
require(graphics)

  xx <- seq(-0.5, 5, len = 101)
  yy <- 5 / ( 1 + exp((2-xx)))
  par(mar = c(0, 0, 3.5, 0))
  plot(xx, yy, type = "l", axes = FALSE, ylim = c(0,6), xlim = c(-1, 5),
       xlab = "", ylab = "", lwd = 2,
       main = "Parameters in the SSlogis model")
  usr <- par("usr")
  arrows(usr[1], 0, usr[2], 0, length = 0.1, angle = 25)
  arrows(0, usr[3], 0, usr[4], length = 0.1, angle = 25)
  text(usr[2] - 0.2, 0.1, "x", adj = c(1, 0))
  text(-0.1, usr[4], "y", adj = c(1, 1))
  abline(h = 5, lty = 2, lwd = 0)
  arrows(-0.8, 2.1, -0.8, 0, length = 0.1, angle = 25)
  arrows(-0.8, 2.9, -0.8, 5, length = 0.1, angle = 25)
  text(-0.8, 2.5, expression(phi[1]), adj = c(0.5, 0.5))
  segments(2, 0, 2, 4.0, lty = 2, lwd = 0.75)
  text(2, 4.0, expression(phi[2]), adj = c(0.5, 0))
  segments(3, 5/(1+exp(-1)) + 0.025, 3, 4.0, lty = 2, lwd = 0.75)
  arrows(2.3, 3.8, 2.0, 3.8, length = 0.08, angle = 25)
  arrows(2.7, 3.8, 3.0, 3.8, length = 0.08, angle = 25)
  text(2.5, 3.8, expression(phi[3]), adj = c(0.5, 0.5))
## End(Don't show)


graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSmicmen")
### * SSmicmen

flush(stderr()); flush(stdout())

### Name: SSmicmen
### Title: Self-Starting Nls Michaelis-Menten Model
### Aliases: SSmicmen
### Keywords: models

### ** Examples

PurTrt <- Puromycin[ Puromycin$state == "treated", ]
SSmicmen(PurTrt$conc, 200, 0.05)  # response only
Vm <- 200; K <- 0.05
SSmicmen(PurTrt$conc, Vm, K)      # response and gradient
print(getInitial(rate ~ SSmicmen(conc, Vm, K), data = PurTrt), digits = 3)
## Initial values are in fact the converged values
fm1 <- nls(rate ~ SSmicmen(conc, Vm, K), data = PurTrt)
summary(fm1)
## Alternative call using the subset argument
fm2 <- nls(rate ~ SSmicmen(conc, Vm, K), data = Puromycin,
           subset = state == "treated")
summary(fm2)
## Don't show: 
require(graphics)

  xx <- seq(0, 5, len = 101)
  yy <- 5 * xx/(1+xx)
  par(mar = c(0, 0, 3.5, 0))
  plot(xx, yy, type = "l", axes = FALSE, ylim = c(0,6), xlim = c(-1, 5),
       xlab = "", ylab = "", lwd = 2,
       main = "Parameters in the SSmicmen model")
  usr <- par("usr")
  arrows(usr[1], 0, usr[2], 0, length = 0.1, angle = 25)
  arrows(0, usr[3], 0, usr[4], length = 0.1, angle = 25)
  text(usr[2] - 0.2, 0.1, "x", adj = c(1, 0))
  text(-0.1, usr[4], "y", adj = c(1, 1))
  abline(h = 5, lty = 2, lwd = 0)
  arrows(-0.8, 2.1, -0.8, 0, length = 0.1, angle = 25)
  arrows(-0.8, 2.9, -0.8, 5, length = 0.1, angle = 25)
  text(-0.8, 2.5, expression(phi[1]), adj = c(0.5, 0.5))
  segments(1, 0, 1, 2.7, lty = 2, lwd = 0.75)
  text(1, 2.7, expression(phi[2]), adj = c(0.5, 0))
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("SSweibull")
### * SSweibull

flush(stderr()); flush(stdout())

### Name: SSweibull
### Title: Self-Starting Nls Weibull Growth Curve Model
### Aliases: SSweibull
### Keywords: models

### ** Examples

Chick.6 <- subset(ChickWeight, (Chick == 6) & (Time > 0))
SSweibull(Chick.6$Time, 160, 115, -5.5, 2.5)   # response only
Asym <- 160; Drop <- 115; lrc <- -5.5; pwr <- 2.5
SSweibull(Chick.6$Time, Asym, Drop, lrc, pwr)  # response and gradient
getInitial(weight ~ SSweibull(Time, Asym, Drop, lrc, pwr), data = Chick.6)
## Initial values are in fact the converged values
fm1 <- nls(weight ~ SSweibull(Time, Asym, Drop, lrc, pwr), data = Chick.6)
summary(fm1)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("SignRank")
### * SignRank

flush(stderr()); flush(stdout())

### Name: SignRank
### Title: Distribution of the Wilcoxon Signed Rank Statistic
### Aliases: SignRank dsignrank psignrank qsignrank rsignrank
### Keywords: distribution

### ** Examples

require(graphics)

par(mfrow = c(2,2))
for(n in c(4:5,10,40)) {
  x <- seq(0, n*(n+1)/2, length = 501)
  plot(x, dsignrank(x, n = n), type = "l",
       main = paste0("dsignrank(x, n = ", n, ")"))
}
## Don't show: 
p <- c(1, 1, 1, 2, 2:6, 8, 10, 11, 13, 15, 17, 20, 22, 24,
       27, 29, 31, 33, 35, 36, 38, 39, 39, 40)
stopifnot(round(dsignrank(0:56, n = 10)* 2^10) == c(p, rev(p), 0),
          qsignrank((1:16)/ 16, n = 4) == c(0:2, rep(3:7, each = 2), 8:10))
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("StructTS")
### * StructTS

flush(stderr()); flush(stdout())

### Name: StructTS
### Title: Fit Structural Time Series
### Aliases: StructTS print.StructTS predict.StructTS
### Keywords: ts

### ** Examples

## see also JohnsonJohnson, Nile and AirPassengers
require(graphics)

trees <- window(treering, start = 0)
(fit <- StructTS(trees, type = "level"))
plot(trees)
lines(fitted(fit), col = "green")
tsdiag(fit)

(fit <- StructTS(log10(UKgas), type = "BSM"))
par(mfrow = c(4, 1)) # to give appropriate aspect ratio for next plot.
plot(log10(UKgas))
plot(cbind(fitted(fit), resids=resid(fit)), main = "UK gas consumption")

## keep some parameters fixed; trace optimizer:
StructTS(log10(UKgas), type = "BSM", fixed = c(0.1,0.001,NA,NA),
         optim.control = list(trace = TRUE))



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("TDist")
### * TDist

flush(stderr()); flush(stdout())

### Name: TDist
### Title: The Student t Distribution
### Aliases: TDist dt pt qt rt
### Keywords: distribution

### ** Examples

require(graphics)

1 - pt(1:5, df = 1)
qt(.975, df = c(1:10,20,50,100,1000))

tt <- seq(0, 10, len = 21)
ncp <- seq(0, 6, len = 31)
ptn <- outer(tt, ncp, function(t, d) pt(t, df = 3, ncp = d))
t.tit <- "Non-central t - Probabilities"
image(tt, ncp, ptn, zlim = c(0,1), main = t.tit)
persp(tt, ncp, ptn, zlim = 0:1, r = 2, phi = 20, theta = 200, main = t.tit,
      xlab = "t", ylab = "non-centrality parameter",
      zlab = "Pr(T <= t)")

plot(function(x) dt(x, df = 3, ncp = 2), -3, 11, ylim = c(0, 0.32),
     main = "Non-central t - Density", yaxs = "i")



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("Tukey")
### * Tukey

flush(stderr()); flush(stdout())

### Name: Tukey
### Title: The Studentized Range Distribution
### Aliases: Tukey ptukey qtukey
### Keywords: distribution

### ** Examples

if(interactive())
  curve(ptukey(x, nm = 6, df = 5), from = -1, to = 8, n = 101)
(ptt <- ptukey(0:10, 2, df =  5))
(qtt <- qtukey(.95, 2, df =  2:11))
## The precision may be not much more than about 8 digits:



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("TukeyHSD")
### * TukeyHSD

flush(stderr()); flush(stdout())

### Name: TukeyHSD
### Title: Compute Tukey Honest Significant Differences
### Aliases: TukeyHSD
### Keywords: models design

### ** Examples

require(graphics)

summary(fm1 <- aov(breaks ~ wool + tension, data = warpbreaks))
TukeyHSD(fm1, "tension", ordered = TRUE)
plot(TukeyHSD(fm1, "tension"))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("Uniform")
### * Uniform

flush(stderr()); flush(stdout())

### Name: Uniform
### Title: The Uniform Distribution
### Aliases: Uniform dunif punif qunif runif
### Keywords: distribution

### ** Examples

u <- runif(20)

## The following relations always hold :
punif(u) == u
dunif(u) == 1

var(runif(10000))  #- ~ = 1/12 = .08333



cleanEx()
nameEx("Weibull")
### * Weibull

flush(stderr()); flush(stdout())

### Name: Weibull
### Title: The Weibull Distribution
### Aliases: Weibull dweibull pweibull qweibull rweibull
### Keywords: distribution

### ** Examples

x <- c(0, rlnorm(50))
all.equal(dweibull(x, shape = 1), dexp(x))
all.equal(pweibull(x, shape = 1, scale = pi), pexp(x, rate = 1/pi))
## Cumulative hazard H():
all.equal(pweibull(x, 2.5, pi, lower.tail = FALSE, log.p = TRUE),
          -(x/pi)^2.5, tolerance = 1e-15)
all.equal(qweibull(x/11, shape = 1, scale = pi), qexp(x/11, rate = 1/pi))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("Wilcoxon")
### * Wilcoxon

flush(stderr()); flush(stdout())

### Name: Wilcoxon
### Title: Distribution of the Wilcoxon Rank Sum Statistic
### Aliases: Wilcoxon dwilcox pwilcox qwilcox rwilcox
### Keywords: distribution

### ** Examples

require(graphics)

x <- -1:(4*6 + 1)
fx <- dwilcox(x, 4, 6)
Fx <- pwilcox(x, 4, 6)

layout(rbind(1,2), widths = 1, heights = c(3,2))
plot(x, fx, type = "h", col = "violet",
     main =  "Probabilities (density) of Wilcoxon-Statist.(n=6, m=4)")
plot(x, Fx, type = "s", col = "blue",
     main =  "Distribution of Wilcoxon-Statist.(n=6, m=4)")
abline(h = 0:1, col = "gray20", lty = 2)
layout(1) # set back

N <- 200
hist(U <- rwilcox(N, m = 4,n = 6), breaks = 0:25 - 1/2,
     border = "red", col = "pink", sub = paste("N =",N))
mtext("N * f(x),  f() = true \"density\"", side = 3, col = "blue")
 lines(x, N*fx, type = "h", col = "blue", lwd = 2)
points(x, N*fx, cex = 2)

## Better is a Quantile-Quantile Plot
qqplot(U, qw <- qwilcox((1:N - 1/2)/N, m = 4, n = 6),
       main = paste("Q-Q-Plot of empirical and theoretical quantiles",
                     "Wilcoxon Statistic,  (m=4, n=6)", sep = "\n"))
n <- as.numeric(names(print(tU <- table(U))))
text(n+.2, n+.5, labels = tU, col = "red")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("acf")
### * acf

flush(stderr()); flush(stdout())

### Name: acf
### Title: Auto- and Cross- Covariance and -Correlation Function Estimation
### Aliases: acf ccf pacf pacf.default [.acf
### Keywords: ts

### ** Examples

require(graphics)

## Examples from Venables & Ripley
acf(lh)
acf(lh, type = "covariance")
pacf(lh)

acf(ldeaths)
acf(ldeaths, ci.type = "ma")
acf(ts.union(mdeaths, fdeaths))
ccf(mdeaths, fdeaths, ylab = "cross-correlation")
# (just the cross-correlations)

presidents # contains missing values
acf(presidents, na.action = na.pass)
pacf(presidents, na.action = na.pass)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("acf2AR")
### * acf2AR

flush(stderr()); flush(stdout())

### Name: acf2AR
### Title: Compute an AR Process Exactly Fitting an ACF
### Aliases: acf2AR
### Keywords: ts

### ** Examples

(Acf <- ARMAacf(c(0.6, 0.3, -0.2)))
acf2AR(Acf)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("add1")
### * add1

flush(stderr()); flush(stdout())

### Name: add1
### Title: Add or Drop All Possible Single Terms to a Model
### Aliases: add1 add1.default add1.lm add1.glm drop1 drop1.default
###   drop1.lm drop1.glm
### Keywords: models

### ** Examples

## Don't show: 
od <- options(digits = 5)
## End(Don't show)
require(graphics); require(utils)
## following example(swiss)
lm1 <- lm(Fertility ~ ., data = swiss)
add1(lm1, ~ I(Education^2) + .^2)
drop1(lm1, test = "F")  # So called 'type II' anova

## following example(glm)
## Don't show: 
example(glm, echo = FALSE)
## End(Don't show)
drop1(glm.D93, test = "Chisq")
drop1(glm.D93, test = "F")
add1(glm.D93, scope = ~outcome*treatment, test = "Rao") ## Pearson Chi-square
## Don't show: 
options(od)
## End(Don't show)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("addmargins")
### * addmargins

flush(stderr()); flush(stdout())

### Name: addmargins
### Title: Puts Arbitrary Margins on Multidimensional Tables or Arrays
### Aliases: addmargins
### Keywords: manip array

### ** Examples

Aye <- sample(c("Yes", "Si", "Oui"), 177, replace = TRUE)
Bee <- sample(c("Hum", "Buzz"), 177, replace = TRUE)
Sea <- sample(c("White", "Black", "Red", "Dead"), 177, replace = TRUE)
(A <- table(Aye, Bee, Sea))
addmargins(A)
## Don't show: 
stopifnot(is.table(addmargins(A)))
## End(Don't show)
ftable(A)
ftable(addmargins(A))

# Non-commutative functions - note differences between resulting tables:
ftable(addmargins(A, c(1, 3),
       FUN = list(Sum = sum, list(Min = min, Max = max))))
ftable(addmargins(A, c(3, 1),
       FUN = list(list(Min = min, Max = max), Sum = sum)))

# Weird function needed to return the N when computing percentages
sqsm <- function(x) sum(x)^2/100
B <- table(Sea, Bee)
round(sweep(addmargins(B, 1, list(list(All = sum, N = sqsm))), 2,
            apply(B, 2, sum)/100, "/"), 1)
round(sweep(addmargins(B, 2, list(list(All = sum, N = sqsm))), 1,
            apply(B, 1, sum)/100, "/"), 1)

# A total over Bee requires formation of the Bee-margin first:
mB <-  addmargins(B, 2, FUN = list(list(Total = sum)))
round(ftable(sweep(addmargins(mB, 1, list(list(All = sum, N = sqsm))), 2,
                   apply(mB, 2, sum)/100, "/")), 1)

## Zero.Printing table+margins:
set.seed(1)
x <- sample( 1:7, 20, replace = TRUE)
y <- sample( 1:7, 20, replace = TRUE)
tx <- addmargins( table(x, y) )
print(tx, zero.print = ".")



cleanEx()
nameEx("aggregate")
### * aggregate

flush(stderr()); flush(stdout())

### Name: aggregate
### Title: Compute Summary Statistics of Data Subsets
### Aliases: aggregate aggregate.default aggregate.data.frame
###   aggregate.formula aggregate.ts
### Keywords: category array

### ** Examples

## Compute the averages for the variables in 'state.x77', grouped
## according to the region (Northeast, South, North Central, West) that
## each state belongs to.
aggregate(state.x77, list(Region = state.region), mean)

## Compute the averages according to region and the occurrence of more
## than 130 days of frost.
aggregate(state.x77,
          list(Region = state.region,
               Cold = state.x77[,"Frost"] > 130),
          mean)
## (Note that no state in 'South' is THAT cold.)


## example with character variables and NAs
testDF <- data.frame(v1 = c(1,3,5,7,8,3,5,NA,4,5,7,9),
                     v2 = c(11,33,55,77,88,33,55,NA,44,55,77,99) )
by1 <- c("red", "blue", 1, 2, NA, "big", 1, 2, "red", 1, NA, 12)
by2 <- c("wet", "dry", 99, 95, NA, "damp", 95, 99, "red", 99, NA, NA)
aggregate(x = testDF, by = list(by1, by2), FUN = "mean")

# and if you want to treat NAs as a group
fby1 <- factor(by1, exclude = "")
fby2 <- factor(by2, exclude = "")
aggregate(x = testDF, by = list(fby1, fby2), FUN = "mean")


## Formulas, one ~ one, one ~ many, many ~ one, and many ~ many:
aggregate(weight ~ feed, data = chickwts, mean)
aggregate(breaks ~ wool + tension, data = warpbreaks, mean)
aggregate(cbind(Ozone, Temp) ~ Month, data = airquality, mean)
aggregate(cbind(ncases, ncontrols) ~ alcgp + tobgp, data = esoph, sum)

## Dot notation:
aggregate(. ~ Species, data = iris, mean)
aggregate(len ~ ., data = ToothGrowth, mean)

## Often followed by xtabs():
ag <- aggregate(len ~ ., data = ToothGrowth, mean)
xtabs(len ~ ., data = ag)


## Compute the average annual approval ratings for American presidents.
aggregate(presidents, nfrequency = 1, FUN = mean)
## Give the summer less weight.
aggregate(presidents, nfrequency = 1,
          FUN = weighted.mean, w = c(1, 1, 0.5, 1))



cleanEx()
nameEx("alias")
### * alias

flush(stderr()); flush(stdout())

### Name: alias
### Title: Find Aliases (Dependencies) in a Model
### Aliases: alias alias.formula alias.lm
### Keywords: models

### ** Examples


cleanEx()
nameEx("anova.glm")
### * anova.glm

flush(stderr()); flush(stdout())

### Name: anova.glm
### Title: Analysis of Deviance for Generalized Linear Model Fits
### Aliases: anova.glm
### Keywords: models regression

### ** Examples

## --- Continuing the Example from  '?glm':
## Don't show: 
require(utils)
example("glm", echo = FALSE)
## End(Don't show)
anova(glm.D93)
anova(glm.D93, test = "Cp")
anova(glm.D93, test = "Chisq")
glm.D93a <-
   update(glm.D93, ~treatment*outcome) # equivalent to Pearson Chi-square
anova(glm.D93, glm.D93a, test = "Rao")



cleanEx()
nameEx("anova.lm")
### * anova.lm

flush(stderr()); flush(stdout())

### Name: anova.lm
### Title: ANOVA for Linear Model Fits
### Aliases: anova.lm anova.lmlist
### Keywords: regression models

### ** Examples

## sequential table
fit <- lm(sr ~ ., data = LifeCycleSavings)
anova(fit)

## same effect via separate models
fit0 <- lm(sr ~ 1, data = LifeCycleSavings)
fit1 <- update(fit0, . ~ . + pop15)
fit2 <- update(fit1, . ~ . + pop75)
fit3 <- update(fit2, . ~ . + dpi)
fit4 <- update(fit3, . ~ . + ddpi)
anova(fit0, fit1, fit2, fit3, fit4, test = "F")

anova(fit4, fit2, fit0, test = "F") # unconventional order



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("anova.mlm")
### * anova.mlm

flush(stderr()); flush(stdout())

### Name: anova.mlm
### Title: Comparisons between Multivariate Linear Models
### Aliases: anova.mlm
### Keywords: regression models multivariate

### ** Examples

require(graphics)
utils::example(SSD) # Brings in the mlmfit and reacttime objects

mlmfit0 <- update(mlmfit, ~0)

### Traditional tests of intrasubj. contrasts
## Using MANOVA techniques on contrasts:
anova(mlmfit, mlmfit0, X = ~1)

## Assuming sphericity
anova(mlmfit, mlmfit0, X = ~1, test = "Spherical")


### tests using intra-subject 3x2 design
idata <- data.frame(deg = gl(3, 1, 6, labels = c(0, 4, 8)),
                    noise = gl(2, 3, 6, labels = c("A", "P")))

anova(mlmfit, mlmfit0, X = ~ deg + noise,
      idata = idata, test = "Spherical")
anova(mlmfit, mlmfit0, M = ~ deg + noise, X = ~ noise,
      idata = idata, test = "Spherical" )
anova(mlmfit, mlmfit0, M = ~ deg + noise, X = ~ deg,
      idata = idata, test = "Spherical" )

f <- factor(rep(1:2, 5)) # bogus, just for illustration
mlmfit2 <- update(mlmfit, ~f)
anova(mlmfit2, mlmfit, mlmfit0, X = ~1, test = "Spherical")
anova(mlmfit2, X = ~1, test = "Spherical")
# one-model form, eqiv. to previous

### There seems to be a strong interaction in these data
plot(colMeans(reacttime))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("ansari.test")
### * ansari.test

flush(stderr()); flush(stdout())

### Name: ansari.test
### Title: Ansari-Bradley Test
### Aliases: ansari.test ansari.test.default ansari.test.formula
### Keywords: htest

### ** Examples

## Hollander & Wolfe (1973, p. 86f):
## Serum iron determination using Hyland control sera
ramsay <- c(111, 107, 100, 99, 102, 106, 109, 108, 104, 99,
            101, 96, 97, 102, 107, 113, 116, 113, 110, 98)
jung.parekh <- c(107, 108, 106, 98, 105, 103, 110, 105, 104,
            100, 96, 108, 103, 104, 114, 114, 113, 108, 106, 99)
ansari.test(ramsay, jung.parekh)

ansari.test(rnorm(10), rnorm(10, 0, 2), conf.int = TRUE)

## try more points - failed in 2.4.1
ansari.test(rnorm(100), rnorm(100, 0, 2), conf.int = TRUE)



cleanEx()
nameEx("aov")
### * aov

flush(stderr()); flush(stdout())

### Name: aov
### Title: Fit an Analysis of Variance Model
### Aliases: aov print.aov print.aovlist Error
### Keywords: models regression

### ** Examples

## From Venables and Ripley (2002) p.165.

## Set orthogonal contrasts.
op <- options(contrasts = c("contr.helmert", "contr.poly"))
( npk.aov <- aov(yield ~ block + N*P*K, npk) )
coefficients(npk.aov)

## to show the effects of re-ordering terms contrast the two fits
aov(yield ~ block + N * P + K, npk)
aov(terms(yield ~ block + N * P + K, keep.order = TRUE), npk)


## as a test, not particularly sensible statistically
npk.aovE <- aov(yield ~  N*P*K + Error(block), npk)
npk.aovE
summary(npk.aovE)
options(op)  # reset to previous



base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("approxfun")
### * approxfun

flush(stderr()); flush(stdout())

### Name: approxfun
### Title: Interpolation Functions
### Aliases: approx approxfun
### Keywords: arith dplot

### ** Examples

require(graphics)

x <- 1:10
y <- rnorm(10)
par(mfrow = c(2,1))
plot(x, y, main = "approx(.) and approxfun(.)")
points(approx(x, y), col = 2, pch = "*")
points(approx(x, y, method = "constant"), col = 4, pch = "*")

f <- approxfun(x, y)
curve(f(x), 0, 11, col = "green2")
points(x, y)
is.function(fc <- approxfun(x, y, method = "const")) # TRUE
curve(fc(x), 0, 10, col = "darkblue", add = TRUE)
## different extrapolation on left and right side :
plot(approxfun(x, y, rule = 2:1), 0, 11,
     col = "tomato", add = TRUE, lty = 3, lwd = 2)

## Show treatment of 'ties' :

x <- c(2,2:4,4,4,5,5,7,7,7)
y <- c(1:6, 5:4, 3:1)
approx(x, y, xout = x)$y # warning
(ay <- approx(x, y, xout = x, ties = "ordered")$y)
stopifnot(ay == c(2,2,3,6,6,6,4,4,1,1,1))
approx(x, y, xout = x, ties = min)$y
approx(x, y, xout = x, ties = max)$y




graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("ar")
### * ar

flush(stderr()); flush(stdout())

### Name: ar
### Title: Fit Autoregressive Models to Time Series
### Aliases: ar ar.burg ar.burg.default ar.burg.mts ar.yw ar.yw.default
###   ar.yw.mts ar.mle print.ar predict.ar
### Keywords: ts

### ** Examples

ar(lh)
ar(lh, method = "burg")
ar(lh, method = "ols")
ar(lh, FALSE, 4) # fit ar(4)

(sunspot.ar <- ar(sunspot.year))
predict(sunspot.ar, n.ahead = 25)
## try the other methods too

ar(ts.union(BJsales, BJsales.lead))
## Burg is quite different here, as is OLS (see ar.ols)
ar(ts.union(BJsales, BJsales.lead), method = "burg")



cleanEx()
nameEx("ar.ols")
### * ar.ols

flush(stderr()); flush(stdout())

### Name: ar.ols
### Title: Fit Autoregressive Models to Time Series by OLS
### Aliases: ar.ols
### Keywords: ts

### ** Examples

ar(lh, method = "burg")
ar.ols(lh)
ar.ols(lh, FALSE, 4) # fit ar(4)

ar.ols(ts.union(BJsales, BJsales.lead))

x <- diff(log(EuStockMarkets))
ar.ols(x, order.max = 6, demean = FALSE, intercept = TRUE)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("arima")
### * arima

flush(stderr()); flush(stdout())

### Name: arima
### Title: ARIMA Modelling of Time Series
### Aliases: arima
### Keywords: ts

### ** Examples

arima(lh, order = c(1,0,0))
arima(lh, order = c(3,0,0))
arima(lh, order = c(1,0,1))

arima(lh, order = c(3,0,0), method = "CSS")

arima(USAccDeaths, order = c(0,1,1), seasonal = list(order = c(0,1,1)))
arima(USAccDeaths, order = c(0,1,1), seasonal = list(order = c(0,1,1)),
      method = "CSS") # drops first 13 observations.
# for a model with as few years as this, we want full ML

arima(LakeHuron, order = c(2,0,0), xreg = time(LakeHuron) - 1920)

## presidents contains NAs
## graphs in example(acf) suggest order 1 or 3
require(graphics)
(fit1 <- arima(presidents, c(1, 0, 0)))
nobs(fit1)
tsdiag(fit1)
(fit3 <- arima(presidents, c(3, 0, 0)))  # smaller AIC
tsdiag(fit3)
BIC(fit1, fit3)
## compare a whole set of models; BIC() would choose the smallest
AIC(fit1, arima(presidents, c(2,0,0)),
          arima(presidents, c(2,0,1)), # <- chosen (barely) by AIC
    fit3, arima(presidents, c(3,0,1)))

## An example of ARIMA forecasting:
predict(fit3, 3)



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("arima.sim")
### * arima.sim

flush(stderr()); flush(stdout())

### Name: arima.sim
### Title: Simulate from an ARIMA Model
### Aliases: arima.sim
### Keywords: ts

### ** Examples

require(graphics)

arima.sim(n = 63, list(ar = c(0.8897, -0.4858), ma = c(-0.2279, 0.2488)),
          sd = sqrt(0.1796))
# mildly long-tailed
arima.sim(n = 63, list(ar = c(0.8897, -0.4858), ma = c(-0.2279, 0.2488)),
          rand.gen = function(n, ...) sqrt(0.1796) * rt(n, df = 5))

# An ARIMA simulation
ts.sim <- arima.sim(list(order = c(1,1,0), ar = 0.7), n = 200)
ts.plot(ts.sim)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("arima0")
### * arima0

flush(stderr()); flush(stdout())

### Name: arima0
### Title: ARIMA Modelling of Time Series - Preliminary Version
### Aliases: arima0 print.arima0 predict.arima0
### Keywords: ts

### ** Examples

## Not run: arima0(lh, order = c(1,0,0))
arima0(lh, order = c(3,0,0))
arima0(lh, order = c(1,0,1))
predict(arima0(lh, order = c(3,0,0)), n.ahead = 12)

arima0(lh, order = c(3,0,0), method = "CSS")

# for a model with as few years as this, we want full ML
(fit <- arima0(USAccDeaths, order = c(0,1,1),
               seasonal = list(order=c(0,1,1)), delta = -1))
predict(fit, n.ahead = 6)

arima0(LakeHuron, order = c(2,0,0), xreg = time(LakeHuron)-1920)
## Not run: 
##D ## presidents contains NAs
##D ## graphs in example(acf) suggest order 1 or 3
##D (fit1 <- arima0(presidents, c(1, 0, 0), delta = -1))  # avoid warning
##D tsdiag(fit1)
##D (fit3 <- arima0(presidents, c(3, 0, 0), delta = -1))  # smaller AIC
##D tsdiag(fit3)
## End(Not run)



cleanEx()
nameEx("as.hclust")
### * as.hclust

flush(stderr()); flush(stdout())

### Name: as.hclust
### Title: Convert Objects to Class hclust
### Aliases: as.hclust as.hclust.default as.hclust.twins
### Keywords: multivariate cluster

### ** Examples

x <- matrix(rnorm(30), ncol = 3)
hc <- hclust(dist(x), method = "complete")




cleanEx()
nameEx("asOneSidedFormula")
### * asOneSidedFormula

flush(stderr()); flush(stdout())

### Name: asOneSidedFormula
### Title: Convert to One-Sided Formula
### Aliases: asOneSidedFormula
### Keywords: models

### ** Examples

asOneSidedFormula("age")
asOneSidedFormula(~ age)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ave")
### * ave

flush(stderr()); flush(stdout())

### Name: ave
### Title: Group Averages Over Level Combinations of Factors
### Aliases: ave
### Keywords: univar

### ** Examples

require(graphics)

ave(1:3)  # no grouping -> grand mean

attach(warpbreaks)
ave(breaks, wool)
ave(breaks, tension)
ave(breaks, tension, FUN = function(x) mean(x, trim = 0.1))
plot(breaks, main =
     "ave( Warpbreaks )  for   wool  x  tension  combinations")
lines(ave(breaks, wool, tension              ), type = "s", col = "blue")
lines(ave(breaks, wool, tension, FUN = median), type = "s", col = "green")
legend(40, 70, c("mean", "median"), lty = 1,
      col = c("blue","green"), bg = "gray90")
detach()



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("bandwidth")
### * bandwidth

flush(stderr()); flush(stdout())

### Name: bandwidth
### Title: Bandwidth Selectors for Kernel Density Estimation
### Aliases: bw.nrd0 bw.nrd bw.ucv bw.bcv bw.SJ
### Keywords: distribution smooth

### ** Examples

require(graphics)

plot(density(precip, n = 1000))
rug(precip)
lines(density(precip, bw = "nrd"), col = 2)
lines(density(precip, bw = "ucv"), col = 3)
lines(density(precip, bw = "bcv"), col = 4)
lines(density(precip, bw = "SJ-ste"), col = 5)
lines(density(precip, bw = "SJ-dpi"), col = 6)
legend(55, 0.035,
       legend = c("nrd0", "nrd", "ucv", "bcv", "SJ-ste", "SJ-dpi"),
       col = 1:6, lty = 1)



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("bartlett.test")
### * bartlett.test

flush(stderr()); flush(stdout())

### Name: bartlett.test
### Title: Bartlett Test of Homogeneity of Variances
### Aliases: bartlett.test bartlett.test.default bartlett.test.formula
### Keywords: htest

### ** Examples

require(graphics)

plot(count ~ spray, data = InsectSprays)
bartlett.test(InsectSprays$count, InsectSprays$spray)
bartlett.test(count ~ spray, data = InsectSprays)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("binom.test")
### * binom.test

flush(stderr()); flush(stdout())

### Name: binom.test
### Title: Exact Binomial Test
### Aliases: binom.test
### Keywords: htest

### ** Examples

## Conover (1971), p. 97f.
## Under (the assumption of) simple Mendelian inheritance, a cross
##  between plants of two particular genotypes produces progeny 1/4 of
##  which are "dwarf" and 3/4 of which are "giant", respectively.
##  In an experiment to determine if this assumption is reasonable, a
##  cross results in progeny having 243 dwarf and 682 giant plants.
##  If "giant" is taken as success, the null hypothesis is that p =
##  3/4 and the alternative that p != 3/4.
binom.test(c(682, 243), p = 3/4)
binom.test(682, 682 + 243, p = 3/4)   # The same.
## => Data are in agreement with the null hypothesis.



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("biplot.princomp")
### * biplot.princomp

flush(stderr()); flush(stdout())

### Name: biplot.princomp
### Title: Biplot for Principal Components
### Aliases: biplot.princomp biplot.prcomp
### Keywords: multivariate hplot

### ** Examples

require(graphics)
biplot(princomp(USArrests))



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("birthday")
### * birthday

flush(stderr()); flush(stdout())

### Name: birthday
### Title: Probability of coincidences
### Aliases: qbirthday pbirthday
### Keywords: distribution

### ** Examples

require(graphics)

## the standard version
qbirthday() # 23
## probability of > 2 people with the same birthday
pbirthday(23, coincident = 3)

## examples from Diaconis & Mosteller p. 858.
## 'coincidence' is that husband, wife, daughter all born on the 16th
qbirthday(classes = 30, coincident = 3) # approximately 18
qbirthday(coincident = 4)  # exact value 187
qbirthday(coincident = 10) # exact value 1181

## same 4-digit PIN number
qbirthday(classes = 10^4)

## 0.9 probability of three or more coincident birthdays
qbirthday(coincident = 3, prob = 0.9)

## Chance of 4 or more coincident birthdays in 150 people
pbirthday(150, coincident = 4)

## 100 or more coincident birthdays in 1000 people: very rare
pbirthday(1000, coincident = 100)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("box.test")
### * box.test

flush(stderr()); flush(stdout())

### Name: Box.test
### Title: Box-Pierce and Ljung-Box Tests
### Aliases: Box.test
### Keywords: ts

### ** Examples

x <- rnorm (100)
Box.test (x, lag = 1)
Box.test (x, lag = 1, type = "Ljung")



cleanEx()
nameEx("cancor")
### * cancor

flush(stderr()); flush(stdout())

### Name: cancor
### Title: Canonical Correlations
### Aliases: cancor
### Keywords: multivariate

### ** Examples


cleanEx()
nameEx("case.names")
### * case.names

flush(stderr()); flush(stdout())

### Name: case+variable.names
### Title: Case and Variable Names of Fitted Models
### Aliases: case.names case.names.lm variable.names variable.names.lm
### Keywords: regression models

### ** Examples

x <- 1:20
y <-  setNames(x + (x/4 - 2)^3 + rnorm(20, sd = 3),
               paste("O", x, sep = "."))
ww <- rep(1, 20); ww[13] <- 0
summary(lmxy <- lm(y ~ x + I(x^2)+I(x^3) + I((x-10)^2), weights = ww),
        cor = TRUE)
variable.names(lmxy)
variable.names(lmxy, full = TRUE)  # includes the last
case.names(lmxy)
case.names(lmxy, full = TRUE)      # includes the 0-weight case



cleanEx()
nameEx("chisq.test")
### * chisq.test

flush(stderr()); flush(stdout())

### Name: chisq.test
### Title: Pearson's Chi-squared Test for Count Data
### Aliases: chisq.test
### Keywords: htest distribution

### ** Examples


## From Agresti(2007) p.39
M <- as.table(rbind(c(762, 327, 468), c(484, 239, 477)))
dimnames(M) <- list(gender = c("F", "M"),
                    party = c("Democrat","Independent", "Republican"))
(Xsq <- chisq.test(M))  # Prints test summary
Xsq$observed   # observed counts (same as M)
Xsq$expected   # expected counts under the null
Xsq$residuals  # Pearson residuals
Xsq$stdres     # standardized residuals


## Effect of simulating p-values
x <- matrix(c(12, 5, 7, 7), ncol = 2)
chisq.test(x)$p.value           # 0.4233
chisq.test(x, simulate.p.value = TRUE, B = 10000)$p.value
                                # around 0.29!

## Testing for population probabilities
## Case A. Tabulated data
x <- c(A = 20, B = 15, C = 25)
chisq.test(x)
chisq.test(as.table(x))             # the same
x <- c(89,37,30,28,2)
p <- c(40,20,20,15,5)
try(
chisq.test(x, p = p)                # gives an error
)
chisq.test(x, p = p, rescale.p = TRUE)
                                # works
p <- c(0.40,0.20,0.20,0.19,0.01)
                                # Expected count in category 5
                                # is 1.86 < 5 ==> chi square approx.
chisq.test(x, p = p)            #               maybe doubtful, but is ok!
chisq.test(x, p = p, simulate.p.value = TRUE)

## Case B. Raw data
x <- trunc(5 * runif(100))
chisq.test(table(x))            # NOT 'chisq.test(x)'!



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("cmdscale")
### * cmdscale

flush(stderr()); flush(stdout())

### Name: cmdscale
### Title: Classical (Metric) Multidimensional Scaling
### Aliases: cmdscale
### Keywords: multivariate

### ** Examples

require(graphics)

loc <- cmdscale(eurodist)
x <- loc[, 1]
y <- -loc[, 2] # reflect so North is at the top
## note asp = 1, to ensure Euclidean distances are represented correctly
plot(x, y, type = "n", xlab = "", ylab = "", asp = 1, axes = FALSE,
     main = "cmdscale(eurodist)")
text(x, y, rownames(loc), cex = 0.6)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("coef")
### * coef

flush(stderr()); flush(stdout())

### Name: coef
### Title: Extract Model Coefficients
### Aliases: coef coefficients
### Keywords: regression models

### ** Examples

x <- 1:5; coef(lm(c(1:3, 7, 6) ~ x))



cleanEx()
nameEx("complete.cases")
### * complete.cases

flush(stderr()); flush(stdout())

### Name: complete.cases
### Title: Find Complete Cases
### Aliases: complete.cases
### Keywords: NA logic

### ** Examples

x <- airquality[, -1] # x is a regression design matrix
y <- airquality[,  1] # y is the corresponding response

stopifnot(complete.cases(y) != is.na(y))
ok <- complete.cases(x, y)
sum(!ok) # how many are not "ok" ?
x <- x[ok,]
y <- y[ok]



cleanEx()
nameEx("confint")
### * confint

flush(stderr()); flush(stdout())

### Name: confint
### Title: Confidence Intervals for Model Parameters
### Aliases: confint confint.default confint.lm
### Keywords: models

### ** Examples

fit <- lm(100/mpg ~ disp + hp + wt + am, data = mtcars)
confint(fit)
confint(fit, "wt")




cleanEx()
nameEx("constrOptim")
### * constrOptim

flush(stderr()); flush(stdout())

### Name: constrOptim
### Title: Linearly Constrained Optimization
### Aliases: constrOptim
### Keywords: optimize

### ** Examples


cleanEx()
nameEx("contrast")
### * contrast

flush(stderr()); flush(stdout())

### Name: contrast
### Title: (Possibly Sparse) Contrast Matrices
### Aliases: contr.helmert contr.poly contr.sum contr.treatment contr.SAS
### Keywords: design regression array

### ** Examples

(cH <- contr.helmert(4))
apply(cH, 2, sum) # column sums are 0
crossprod(cH) # diagonal -- columns are orthogonal
contr.helmert(4, contrasts = FALSE) # just the 4 x 4 identity matrix

(cT <- contr.treatment(5))
all(crossprod(cT) == diag(4)) # TRUE: even orthonormal

(cT. <- contr.SAS(5))
all(crossprod(cT.) == diag(4)) # TRUE

zapsmall(cP <- contr.poly(3)) # Linear and Quadratic
zapsmall(crossprod(cP), digits = 15) # orthonormal up to fuzz



cleanEx()
nameEx("contrasts")
### * contrasts

flush(stderr()); flush(stdout())

### Name: contrasts
### Title: Get and Set Contrast Matrices
### Aliases: contrasts contrasts<-
### Keywords: design regression

### ** Examples

utils::example(factor)
fff <- ff[, drop = TRUE]  # reduce to 5 levels.
contrasts(fff) # treatment contrasts by default
contrasts(C(fff, sum))
contrasts(fff, contrasts = FALSE) # the 5x5 identity matrix

contrasts(fff) <- contr.sum(5); contrasts(fff)  # set sum contrasts
contrasts(fff, 2) <- contr.sum(5); contrasts(fff)  # set 2 contrasts
# supply 2 contrasts, compute 2 more to make full set of 4.
contrasts(fff) <- contr.sum(5)[, 1:2]; contrasts(fff)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("convolve")
### * convolve

flush(stderr()); flush(stdout())

### Name: convolve
### Title: Convolution of Sequences via FFT
### Aliases: convolve
### Keywords: math dplot

### ** Examples

require(graphics)

x <- c(0,0,0,100,0,0,0)
y <- c(0,0,1, 2 ,1,0,0)/4
zapsmall(convolve(x, y))         #  *NOT* what you first thought.
zapsmall(convolve(x, y[3:5], type = "f")) # rather
x <- rnorm(50)
y <- rnorm(50)
# Circular convolution *has* this symmetry:
all.equal(convolve(x, y, conj = FALSE), rev(convolve(rev(y),x)))

n <- length(x <- -20:24)
y <- (x-10)^2/1000 + rnorm(x)/8

Han <- function(y) # Hanning
       convolve(y, c(1,2,1)/4, type = "filter")

plot(x, y, main = "Using  convolve(.) for Hanning filters")
lines(x[-c(1  , n)      ], Han(y), col = "red")
lines(x[-c(1:2, (n-1):n)], Han(Han(y)), lwd = 2, col = "dark blue")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("cophenetic")
### * cophenetic

flush(stderr()); flush(stdout())

### Name: cophenetic
### Title: Cophenetic Distances for a Hierarchical Clustering
### Aliases: cophenetic cophenetic.default cophenetic.dendrogram
### Keywords: cluster multivariate

### ** Examples

require(graphics)

d1 <- dist(USArrests)
hc <- hclust(d1, "ave")
d2 <- cophenetic(hc)
cor(d1, d2) # 0.7659

## Example from Sneath & Sokal, Fig. 5-29, p.279
d0 <- c(1,3.8,4.4,5.1, 4,4.2,5, 2.6,5.3, 5.4)
attributes(d0) <- list(Size = 5, diag = TRUE)
class(d0) <- "dist"
names(d0) <- letters[1:5]
d0
utils::str(upgma <- hclust(d0, method = "average"))
plot(upgma, hang = -1)
#
(d.coph <- cophenetic(upgma))
cor(d0, d.coph) # 0.9911



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("cor")
### * cor

flush(stderr()); flush(stdout())

### Name: cor
### Title: Correlation, Variance and Covariance (Matrices)
### Aliases: var cov cor cov2cor
### Keywords: univar multivariate array

### ** Examples

var(1:10)  # 9.166667

var(1:5, 1:5) # 2.5

## Two simple vectors
cor(1:10, 2:11) # == 1

## Correlation Matrix of Multivariate sample:
(Cl <- cor(longley))
## Graphical Correlation Matrix:
symnum(Cl) # highly correlated

## Spearman's rho  and  Kendall's tau
symnum(clS <- cor(longley, method = "spearman"))
symnum(clK <- cor(longley, method = "kendall"))
## How much do they differ?
i <- lower.tri(Cl)
cor(cbind(P = Cl[i], S = clS[i], K = clK[i]))


## cov2cor() scales a covariance matrix by its diagonal
##           to become the correlation matrix.
cov2cor # see the function definition {and learn ..}
stopifnot(all.equal(Cl, cov2cor(cov(longley))),
          all.equal(cor(longley, method = "kendall"),
            cov2cor(cov(longley, method = "kendall"))))

##--- Missing value treatment:
C1 <- cov(swiss)
range(eigen(C1, only.values = TRUE)$values) # 6.19        1921

## swM := "swiss" with  3 "missing"s :
swM <- swiss
colnames(swM) <- abbreviate(colnames(swiss), min=6)
swM[1,2] <- swM[7,3] <- swM[25,5] <- NA # create 3 "missing"

## Consider all 5 "use" cases :
(C. <- cov(swM)) # use="everything"  quite a few NA's in cov.matrix
try(cov(swM, use = "all")) # Error: missing obs...
C2 <- cov(swM, use = "complete")
stopifnot(identical(C2, cov(swM, use = "na.or.complete")))
range(eigen(C2, only.values = TRUE)$values) # 6.46   1930
C3 <- cov(swM, use = "pairwise")
range(eigen(C3, only.values = TRUE)$values) # 6.19   1938

## Kendall's tau doesn't change much:
symnum(Rc <- cor(swM, method = "kendall", use = "complete"))
symnum(Rp <- cor(swM, method = "kendall", use = "pairwise"))
symnum(R. <- cor(swiss, method = "kendall"))

## "pairwise" is closer componentwise,
summary(abs(c(1 - Rp/R.)))
summary(abs(c(1 - Rc/R.)))

## but "complete" is closer in Eigen space:
EV <- function(m) eigen(m, only.values=TRUE)$values
summary(abs(1 - EV(Rp)/EV(R.)) / abs(1 - EV(Rc)/EV(R.)))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("cor.test")
### * cor.test

flush(stderr()); flush(stdout())

### Name: cor.test
### Title: Test for Association/Correlation Between Paired Samples
### Aliases: cor.test cor.test.default cor.test.formula
### Keywords: htest

### ** Examples

## Hollander & Wolfe (1973), p. 187f.
## Assessment of tuna quality.  We compare the Hunter L measure of
##  lightness to the averages of consumer panel scores (recoded as
##  integer values from 1 to 6 and averaged over 80 such values) in
##  9 lots of canned tuna.

x <- c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1)
y <- c( 2.6,  3.1,  2.5,  5.0,  3.6,  4.0,  5.2,  2.8,  3.8)

##  The alternative hypothesis of interest is that the
##  Hunter L value is positively associated with the panel score.

cor.test(x, y, method = "kendall", alternative = "greater")
## => p=0.05972

cor.test(x, y, method = "kendall", alternative = "greater",
         exact = FALSE) # using large sample approximation
## => p=0.04765

## Compare this to
cor.test(x, y, method = "spearm", alternative = "g")
cor.test(x, y,                    alternative = "g")

## Formula interface.
require(graphics)
pairs(USJudgeRatings)
cor.test(~ CONT + INTG, data = USJudgeRatings)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("cov.wt")
### * cov.wt

flush(stderr()); flush(stdout())

### Name: cov.wt
### Title: Weighted Covariance Matrices
### Aliases: cov.wt
### Keywords: multivariate

### ** Examples

 (xy <- cbind(x = 1:10, y = c(1:3, 8:5, 8:10)))
 w1 <- c(0,0,0,1,1,1,1,1,0,0)
 cov.wt(xy, wt = w1) # i.e. method = "unbiased"
 cov.wt(xy, wt = w1, method = "ML", cor = TRUE)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("cpgram")
### * cpgram

flush(stderr()); flush(stdout())

### Name: cpgram
### Title: Plot Cumulative Periodogram
### Aliases: cpgram
### Keywords: ts hplot

### ** Examples

require(graphics)

par(pty = "s", mfrow = c(1,2))
cpgram(lh)
lh.ar <- ar(lh, order.max = 9)
cpgram(lh.ar$resid, main = "AR(3) fit to lh")

cpgram(ldeaths)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("cutree")
### * cutree

flush(stderr()); flush(stdout())

### Name: cutree
### Title: Cut a Tree into Groups of Data
### Aliases: cutree
### Keywords: multivariate cluster

### ** Examples

hc <- hclust(dist(USArrests))

cutree(hc, k = 1:5) #k = 1 is trivial
cutree(hc, h = 250)

## Compare the 2 and 4 grouping:
g24 <- cutree(hc, k = c(2,4))
table(grp2 = g24[,"2"], grp4 = g24[,"4"])



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("decompose")
### * decompose

flush(stderr()); flush(stdout())

### Name: decompose
### Title: Classical Seasonal Decomposition by Moving Averages
### Aliases: decompose plot.decomposed.ts
### Keywords: ts

### ** Examples

require(graphics)

m <- decompose(co2)
m$figure
plot(m)

## example taken from Kendall/Stuart
x <- c(-50, 175, 149, 214, 247, 237, 225, 329, 729, 809,
       530, 489, 540, 457, 195, 176, 337, 239, 128, 102, 232, 429, 3,
       98, 43, -141, -77, -13, 125, 361, -45, 184)
x <- ts(x, start = c(1951, 1), end = c(1958, 4), frequency = 4)
m <- decompose(x)
## seasonal figure: 6.25, 8.62, -8.84, -6.03
round(decompose(x)$figure / 10, 2)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("delete.response")
### * delete.response

flush(stderr()); flush(stdout())

### Name: delete.response
### Title: Modify Terms Objects
### Aliases: reformulate drop.terms delete.response [.terms
### Keywords: programming

### ** Examples

ff <- y ~ z + x + w
tt <- terms(ff)
tt
delete.response(tt)
drop.terms(tt, 2:3, keep.response = TRUE)
tt[-1]
tt[2:3]
reformulate(attr(tt, "term.labels"))

## keep LHS :
reformulate("x*w", ff[[2]])
fS <- surv(ft, case) ~ a + b
reformulate(c("a", "b*f"), fS[[2]])

## using non-syntactic names:
reformulate(c("`P/E`", "`% Growth`"), response = as.name("+-"))

stopifnot(identical(      ~ var, reformulate("var")),
          identical(~ a + b + c, reformulate(letters[1:3])),
          identical(  y ~ a + b, reformulate(letters[1:2], "y"))
         )



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("dendrapply")
### * dendrapply

flush(stderr()); flush(stdout())

### Name: dendrapply
### Title: Apply a Function to All Nodes of a Dendrogram
### Aliases: dendrapply
### Keywords: iteration

### ** Examples

require(graphics)

## a smallish simple dendrogram
dhc <- as.dendrogram(hc <- hclust(dist(USArrests), "ave"))
(dhc21 <- dhc[[2]][[1]])

## too simple:
dendrapply(dhc21, function(n) utils::str(attributes(n)))

## toy example to set colored leaf labels :
local({
  colLab <<- function(n) {
      if(is.leaf(n)) {
        a <- attributes(n)
        i <<- i+1
        attr(n, "nodePar") <-
            c(a$nodePar, list(lab.col = mycols[i], lab.font = i%%3))
      }
      n
  }
  mycols <- grDevices::rainbow(attr(dhc21,"members"))
  i <- 0
 })
dL <- dendrapply(dhc21, colLab)
op <- par(mfrow = 2:1)
 plot(dhc21)
 plot(dL) ## --> colored labels!
par(op)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("dendrogram")
### * dendrogram

flush(stderr()); flush(stdout())

### Name: dendrogram
### Title: General Tree Structures
### Aliases: dendrogram as.dendrogram as.dendrogram.dendrogram
###   as.dendrogram.hclust as.hclust.dendrogram cut.dendrogram
###   [[.dendrogram merge.dendrogram nobs.dendrogram plot.dendrogram
###   print.dendrogram rev.dendrogram str.dendrogram is.leaf
### Keywords: multivariate tree hplot

### ** Examples

require(graphics); require(utils)

hc <- hclust(dist(USArrests), "ave")
(dend1 <- as.dendrogram(hc)) # "print()" method
str(dend1)          # "str()" method
str(dend1, max = 2, last.str =  "'") # only the first two sub-levels
oo <- options(str.dendrogram.last = "\\") # yet another possibility
str(dend1, max = 2) # only the first two sub-levels
options(oo)  # .. resetting them

op <- par(mfrow =  c(2,2), mar = c(5,2,1,4))
plot(dend1)
## "triangle" type and show inner nodes:
plot(dend1, nodePar = list(pch = c(1,NA), cex = 0.8, lab.cex = 0.8),
      type = "t", center = TRUE)
plot(dend1, edgePar = list(col = 1:2, lty = 2:3),
     dLeaf = 1, edge.root = TRUE)
plot(dend1, nodePar = list(pch = 2:1, cex = .4*2:1, col = 2:3),
     horiz = TRUE)

## simple test for as.hclust() as the inverse of as.dendrogram():
stopifnot(identical(as.hclust(dend1)[1:4], hc[1:4]))

dend2 <- cut(dend1, h = 70)
plot(dend2$upper)
## leaves are wrong horizontally:
plot(dend2$upper, nodePar = list(pch = c(1,7), col = 2:1))
##  dend2$lower is *NOT* a dendrogram, but a list of .. :
plot(dend2$lower[[3]], nodePar = list(col = 4), horiz = TRUE, type = "tr")
## "inner" and "leaf" edges in different type & color :
plot(dend2$lower[[2]], nodePar = list(col = 1),   # non empty list
     edgePar = list(lty = 1:2, col = 2:1), edge.root = TRUE)
par(op)
d3 <- dend2$lower[[2]][[2]][[1]]
stopifnot(identical(d3, dend2$lower[[2]][[c(2,1)]]))
str(d3, last.str = "'")

## to peek at the inner structure "if you must", use '[..]' indexing :
str(d3[2][[1]]) ## or the full
str(d3[])

## merge() to join dendrograms:
(d13 <- merge(dend2$lower[[1]], dend2$lower[[3]]))
## merge() all parts back (using default 'height' instead of original one):
den.1 <- Reduce(merge, dend2$lower)
## or merge() all four parts at same height --> 4 branches (!)
d. <- merge(dend2$lower[[1]], dend2$lower[[2]], dend2$lower[[3]],
            dend2$lower[[4]])
## (with a warning) or the same using  do.call :
stopifnot(identical(d., do.call(merge, dend2$lower)))
plot(d., main = "merge(d1, d2, d3, d4)  |->  dendrogram with a 4-split")

## "Zoom" in to the first dendrogram :
plot(dend1, xlim = c(1,20), ylim = c(1,50))

nP <- list(col = 3:2, cex = c(2.0, 0.75), pch =  21:22,
           bg =  c("light blue", "pink"),
           lab.cex = 0.75, lab.col = "tomato")
plot(d3, nodePar= nP, edgePar = list(col = "gray", lwd = 2), horiz = TRUE)
addE <- function(n) {
      if(!is.leaf(n)) {
        attr(n, "edgePar") <- list(p.col = "plum")
        attr(n, "edgetext") <- paste(attr(n,"members"),"members")
      }
      n
}
d3e <- dendrapply(d3, addE)
plot(d3e, nodePar =  nP)
plot(d3e, nodePar =  nP, leaflab = "textlike")




graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("density")
### * density

flush(stderr()); flush(stdout())

### Name: density
### Title: Kernel Density Estimation
### Aliases: density density.default
### Keywords: distribution smooth

### ** Examples

require(graphics)

plot(density(c(-20, rep(0,98), 20)), xlim = c(-4, 4))  # IQR = 0

# The Old Faithful geyser data
d <- density(faithful$eruptions, bw = "sj")
d
plot(d)

plot(d, type = "n")
polygon(d, col = "wheat")

## Missing values:
x <- xx <- faithful$eruptions
x[i.out <- sample(length(x), 10)] <- NA
doR <- density(x, bw = 0.15, na.rm = TRUE)
lines(doR, col = "blue")
points(xx[i.out], rep(0.01, 10))

## Weighted observations:
fe <- sort(faithful$eruptions) # has quite a few non-unique values
## use 'counts / n' as weights:
dw <- density(unique(fe), weights = table(fe)/length(fe), bw = d$bw)
utils::str(dw) ## smaller n: only 126, but identical estimate:
stopifnot(all.equal(d[1:3], dw[1:3]))

## simulation from a density() fit:
# a kernel density fit is an equally-weighted mixture.
fit <- density(xx)
N <- 1e6
x.new <- rnorm(N, sample(xx, size = N, replace = TRUE), fit$bw)
plot(fit)
lines(density(x.new), col = "blue")


(kernels <- eval(formals(density.default)$kernel))

## show the kernels in the R parametrization
plot (density(0, bw = 1), xlab = "",
      main = "R's density() kernels with bw = 1")
for(i in 2:length(kernels))
   lines(density(0, bw = 1, kernel =  kernels[i]), col = i)
legend(1.5,.4, legend = kernels, col = seq(kernels),
       lty = 1, cex = .8, y.intersp = 1)

## show the kernels in the S parametrization
plot(density(0, from = -1.2, to = 1.2, width = 2, kernel = "gaussian"),
     type = "l", ylim = c(0, 1), xlab = "",
     main = "R's density() kernels with width = 1")
for(i in 2:length(kernels))
   lines(density(0, width = 2, kernel =  kernels[i]), col = i)
legend(0.6, 1.0, legend = kernels, col = seq(kernels), lty = 1)

##-------- Semi-advanced theoretic from here on -------------

(RKs <- cbind(sapply(kernels,
                     function(k) density(kernel = k, give.Rkern = TRUE))))
100*round(RKs["epanechnikov",]/RKs, 4) ## Efficiencies

bw <- bw.SJ(precip) ## sensible automatic choice
plot(density(precip, bw = bw),
     main = "same sd bandwidths, 7 different kernels")
for(i in 2:length(kernels))
   lines(density(precip, bw = bw, kernel = kernels[i]), col = i)

## Bandwidth Adjustment for "Exactly Equivalent Kernels"
h.f <- sapply(kernels, function(k)density(kernel = k, give.Rkern = TRUE))
(h.f <- (h.f["gaussian"] / h.f)^ .2)
## -> 1, 1.01, .995, 1.007,... close to 1 => adjustment barely visible..

plot(density(precip, bw = bw),
     main = "equivalent bandwidths, 7 different kernels")
for(i in 2:length(kernels))
   lines(density(precip, bw = bw, adjust = h.f[i], kernel = kernels[i]),
         col = i)
legend(55, 0.035, legend = kernels, col = seq(kernels), lty = 1)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("deriv")
### * deriv

flush(stderr()); flush(stdout())

### Name: deriv
### Title: Symbolic and Algorithmic Derivatives of Simple Expressions
### Aliases: D deriv deriv.default deriv.formula deriv3 deriv3.default
###   deriv3.formula
### Keywords: math nonlinear

### ** Examples

## formula argument :
dx2x <- deriv(~ x^2, "x") ; dx2x
## Not run: 
##D expression({
##D          .value <- x^2
##D          .grad <- array(0, c(length(.value), 1), list(NULL, c("x")))
##D          .grad[, "x"] <- 2 * x
##D          attr(.value, "gradient") <- .grad
##D          .value
##D })
## End(Not run)
mode(dx2x)
x <- -1:2
eval(dx2x)

## Something 'tougher':
trig.exp <- expression(sin(cos(x + y^2)))
( D.sc <- D(trig.exp, "x") )
all.equal(D(trig.exp[[1]], "x"), D.sc)

( dxy <- deriv(trig.exp, c("x", "y")) )
y <- 1
eval(dxy)
eval(D.sc)

## function returned:
deriv((y ~ sin(cos(x) * y)), c("x","y"), func = TRUE)

## function with defaulted arguments:
(fx <- deriv(y ~ b0 + b1 * 2^(-x/th), c("b0", "b1", "th"),
             function(b0, b1, th, x = 1:7){} ) )
fx(2, 3, 4)

## First derivative

D(expression(x^2), "x")
stopifnot(D(as.name("x"), "x") == 1)

## Higher derivatives
deriv3(y ~ b0 + b1 * 2^(-x/th), c("b0", "b1", "th"),
     c("b0", "b1", "th", "x") )

## Higher derivatives:
DD <- function(expr, name, order = 1) {
   if(order < 1) stop("'order' must be >= 1")
   if(order == 1) D(expr, name)
   else DD(D(expr, name), name, order - 1)
}
DD(expression(sin(x^2)), "x", 3)
## showing the limits of the internal "simplify()" :
## Not run: 
##D -sin(x^2) * (2 * x) * 2 + ((cos(x^2) * (2 * x) * (2 * x) + sin(x^2) *
##D     2) * (2 * x) + sin(x^2) * (2 * x) * 2)
## End(Not run)

## New (R 3.4.0, 2017):
D(quote(log1p(x^2)), "x") ## log1p(x) = log(1 + x)
stopifnot(identical(
       D(quote(log1p(x^2)), "x"),
       D(quote(log(1+x^2)), "x")))
D(quote(expm1(x^2)), "x") ## expm1(x) = exp(x) - 1
stopifnot(identical(
       D(quote(expm1(x^2)), "x") -> Dex1,
       D(quote(exp(x^2)-1), "x")),
       identical(Dex1, quote(exp(x^2) * (2 * x))))

D(quote(sinpi(x^2)), "x") ## sinpi(x) = sin(pi*x)
D(quote(cospi(x^2)), "x") ## cospi(x) = cos(pi*x)
D(quote(tanpi(x^2)), "x") ## tanpi(x) = tan(pi*x)

stopifnot(identical(D(quote(log2 (x^2)), "x"),
                    quote(2 * x/(x^2 * log(2)))),
          identical(D(quote(log10(x^2)), "x"),
                    quote(2 * x/(x^2 * log(10)))))




cleanEx()
nameEx("diffinv")
### * diffinv

flush(stderr()); flush(stdout())

### Name: diffinv
### Title: Discrete Integration: Inverse of Differencing
### Aliases: diffinv diffinv.default diffinv.ts
### Keywords: ts

### ** Examples

s <- 1:10
d <- diff(s)
diffinv(d, xi = 1)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("dist")
### * dist

flush(stderr()); flush(stdout())

### Name: dist
### Title: Distance Matrix Computation
### Aliases: dist print.dist format.dist labels.dist as.matrix.dist as.dist
###   as.dist.default
### Keywords: multivariate cluster

### ** Examples

require(graphics)

x <- matrix(rnorm(100), nrow = 5)
dist(x)
dist(x, diag = TRUE)
dist(x, upper = TRUE)
m <- as.matrix(dist(x))
d <- as.dist(m)
stopifnot(d == dist(x))

## Use correlations between variables "as distance"
dd <- as.dist((1 - cor(USJudgeRatings))/2)
round(1000 * dd) # (prints more nicely)
plot(hclust(dd)) # to see a dendrogram of clustered variables

## example of binary and canberra distances.
x <- c(0, 0, 1, 1, 1, 1)
y <- c(1, 0, 1, 1, 0, 1)
dist(rbind(x, y), method = "binary")
## answer 0.4 = 2/5
dist(rbind(x, y), method = "canberra")
## answer 2 * (6/5)

## To find the names
labels(eurodist)

## Examples involving "Inf" :
## 1)
x[6] <- Inf
(m2 <- rbind(x, y))
dist(m2, method = "binary")   # warning, answer 0.5 = 2/4
## These all give "Inf":
stopifnot(Inf == dist(m2, method =  "euclidean"),
          Inf == dist(m2, method =  "maximum"),
          Inf == dist(m2, method =  "manhattan"))
##  "Inf" is same as very large number:
x1 <- x; x1[6] <- 1e100
stopifnot(dist(cbind(x, y), method = "canberra") ==
    print(dist(cbind(x1, y), method = "canberra")))

## 2)
y[6] <- Inf #-> 6-th pair is excluded
dist(rbind(x, y), method = "binary"  )   # warning; 0.5
dist(rbind(x, y), method = "canberra"  ) # 3
dist(rbind(x, y), method = "maximum")    # 1
dist(rbind(x, y), method = "manhattan")  # 2.4



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("dummy.coef")
### * dummy.coef

flush(stderr()); flush(stdout())

### Name: dummy.coef
### Title: Extract Coefficients in Original Coding
### Aliases: dummy.coef dummy.coef.lm dummy.coef.aovlist
### Keywords: models

### ** Examples

options(contrasts = c("contr.helmert", "contr.poly"))
## From Venables and Ripley (2002) p.165.
npk.aov <- aov(yield ~ block + N*P*K, npk)
dummy.coef(npk.aov)

npk.aovE <- aov(yield ~  N*P*K + Error(block), npk)
dummy.coef(npk.aovE)



base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ecdf")
### * ecdf

flush(stderr()); flush(stdout())

### Name: ecdf
### Title: Empirical Cumulative Distribution Function
### Aliases: ecdf plot.ecdf print.ecdf summary.ecdf quantile.ecdf
### Keywords: dplot hplot

### ** Examples

##-- Simple didactical  ecdf  example :
x <- rnorm(12)
Fn <- ecdf(x)
Fn     # a *function*
Fn(x)  # returns the percentiles for x
tt <- seq(-2, 2, by = 0.1)
12 * Fn(tt) # Fn is a 'simple' function {with values k/12}
summary(Fn)
##--> see below for graphics
knots(Fn)  # the unique data values {12 of them if there were no ties}

y <- round(rnorm(12), 1); y[3] <- y[1]
Fn12 <- ecdf(y)
Fn12
knots(Fn12) # unique values (always less than 12!)
summary(Fn12)
summary.stepfun(Fn12)

## Advanced: What's inside the function closure?
ls(environment(Fn12))
##[1] "f"  "method"  "n"  "x"  "y"  "yleft"  "yright"
utils::ls.str(environment(Fn12))
stopifnot(all.equal(quantile(Fn12), quantile(y)))

###----------------- Plotting --------------------------
require(graphics)

op <- par(mfrow = c(3, 1), mgp = c(1.5, 0.8, 0), mar =  .1+c(3,3,2,1))

F10 <- ecdf(rnorm(10))
summary(F10)

plot(F10)
plot(F10, verticals = TRUE, do.points = FALSE)

plot(Fn12 , lwd = 2) ; mtext("lwd = 2", adj = 1)
xx <- unique(sort(c(seq(-3, 2, length = 201), knots(Fn12))))
lines(xx, Fn12(xx), col = "blue")
abline(v = knots(Fn12), lty = 2, col = "gray70")

plot(xx, Fn12(xx), type = "o", cex = .1)  #- plot.default {ugly}
plot(Fn12, col.hor = "red", add =  TRUE)  #- plot method
abline(v = knots(Fn12), lty = 2, col = "gray70")
## luxury plot
plot(Fn12, verticals = TRUE, col.points = "blue",
     col.hor = "red", col.vert = "bisque")

##-- this works too (automatic call to  ecdf(.)):
plot.ecdf(rnorm(24))
title("via  simple  plot.ecdf(x)", adj = 1)

par(op)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("eff.aovlist")
### * eff.aovlist

flush(stderr()); flush(stdout())

### Name: eff.aovlist
### Title: Compute Efficiencies of Multistratum Analysis of Variance
### Aliases: eff.aovlist
### Keywords: models

### ** Examples

## An example from Yates (1932),
## a 2^3 design in 2 blocks replicated 4 times

Block <- gl(8, 4)
A <- factor(c(0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
              0,1,0,1,0,1,0,1,0,1,0,1))
B <- factor(c(0,0,1,1,0,0,1,1,0,1,0,1,1,0,1,0,0,0,1,1,
              0,0,1,1,0,0,1,1,0,0,1,1))
C <- factor(c(0,1,1,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1,0,1,
              1,0,1,0,0,0,1,1,1,1,0,0))
Yield <- c(101, 373, 398, 291, 312, 106, 265, 450, 106, 306, 324, 449,
           272, 89, 407, 338, 87, 324, 279, 471, 323, 128, 423, 334,
           131, 103, 445, 437, 324, 361, 302, 272)
aovdat <- data.frame(Block, A, B, C, Yield)

old <- getOption("contrasts")
options(contrasts = c("contr.helmert", "contr.poly"))
(fit <- aov(Yield ~ A*B*C + Error(Block), data = aovdat))
eff.aovlist(fit)
options(contrasts = old)



base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
cleanEx()
nameEx("effects")
### * effects

flush(stderr()); flush(stdout())

### Name: effects
### Title: Effects from Fitted Model
### Aliases: effects effects.lm effects.glm
### Keywords: models regression

### ** Examples

y <- c(1:3, 7, 5)
x <- c(1:3, 6:7)
( ee <- effects(lm(y ~ x)) )
c( round(ee - effects(lm(y+10 ~ I(x-3.8))), 3) )
# just the first is different



cleanEx()
nameEx("embed")
### * embed

flush(stderr()); flush(stdout())

### Name: embed
### Title: Embedding a Time Series
### Aliases: embed
### Keywords: ts

### ** Examples

x <- 1:10
embed (x, 3)



cleanEx()
nameEx("expand.model.frame")
### * expand.model.frame

flush(stderr()); flush(stdout())

### Name: expand.model.frame
### Title: Add new variables to a model frame
### Aliases: expand.model.frame
### Keywords: manip regression

### ** Examples

model <- lm(log(Volume) ~ log(Girth) + log(Height), data = trees)
expand.model.frame(model, ~ Girth) # prints data.frame like

dd <- data.frame(x = 1:5, y = rnorm(5), z = c(1,2,NA,4,5))
model <- glm(y ~ x, data = dd, subset = 1:4, na.action = na.omit)
expand.model.frame(model, "z", na.expand = FALSE) # = default
expand.model.frame(model, "z", na.expand = TRUE)



cleanEx()
nameEx("extractAIC")
### * extractAIC

flush(stderr()); flush(stdout())

### Name: extractAIC
### Title: Extract AIC from a Fitted Model
### Aliases: extractAIC
### Keywords: models

### ** Examples


cleanEx()
nameEx("factanal")
### * factanal

flush(stderr()); flush(stdout())

### Name: factanal
### Title: Factor Analysis
### Aliases: factanal
### Keywords: multivariate

### ** Examples

# A little demonstration, v2 is just v1 with noise,
# and same for v4 vs. v3 and v6 vs. v5
# Last four cases are there to add noise
# and introduce a positive manifold (g factor)
v1 <- c(1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,4,5,6)
v2 <- c(1,2,1,1,1,1,2,1,2,1,3,4,3,3,3,4,6,5)
v3 <- c(3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,4,6)
v4 <- c(3,3,4,3,3,1,1,2,1,1,1,1,2,1,1,5,6,4)
v5 <- c(1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,6,4,5)
v6 <- c(1,1,1,2,1,3,3,3,4,3,1,1,1,2,1,6,5,4)
m1 <- cbind(v1,v2,v3,v4,v5,v6)
cor(m1)
factanal(m1, factors = 3) # varimax is the default
# The following shows the g factor as PC1

## formula interface
factanal(~v1+v2+v3+v4+v5+v6, factors = 3,
         scores = "Bartlett")$scores



cleanEx()
nameEx("factor.scope")
### * factor.scope

flush(stderr()); flush(stdout())

### Name: factor.scope
### Title: Compute Allowed Changes in Adding to or Dropping from a Formula
### Aliases: add.scope drop.scope factor.scope
### Keywords: models

### ** Examples

add.scope( ~ a + b + c + a:b,  ~ (a + b + c)^3)
# [1] "a:c" "b:c"
drop.scope( ~ a + b + c + a:b)
# [1] "c"   "a:b"



cleanEx()
nameEx("family")
### * family

flush(stderr()); flush(stdout())

### Name: family
### Title: Family Objects for Models
### Aliases: family binomial gaussian Gamma inverse.gaussian poisson quasi
###   quasibinomial quasipoisson
### Keywords: models

### ** Examples

require(utils) # for str

nf <- gaussian()  # Normal family
nf
str(nf)

gf <- Gamma()
gf
str(gf)
gf$linkinv
gf$variance(-3:4) #- == (.)^2


## quasipoisson. compare with example(glm)
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
d.AD <- data.frame(treatment, outcome, counts)
glm.qD93 <- glm(counts ~ outcome + treatment, family = quasipoisson())

## Example of user-specified link, a logit model for p^days
## See Shaffer, T.  2004. Auk 121(2): 526-540.
logexp <- function(days = 1)
{
    linkfun <- function(mu) qlogis(mu^(1/days))
    linkinv <- function(eta) plogis(eta)^days
    mu.eta <- function(eta) days * plogis(eta)^(days-1) * binomial()$mu_eta
    valideta <- function(eta) TRUE
    link <- paste0("logexp(", days, ")")
    structure(list(linkfun = linkfun, linkinv = linkinv,
                   mu.eta = mu.eta, valideta = valideta, name = link),
              class = "link-glm")
}
binomial(logexp(3))
## in practice this would be used with a vector of 'days', in
## which case use an offset of 0 in the corresponding formula
## to get the null deviance right.

## Binomial with identity link: often not a good idea.
## Not run: binomial(link = make.link("identity"))

## tests of quasi
x <- rnorm(100)
y <- rpois(100, exp(1+x))
glm(y ~ x, family = quasi(variance = "mu", link = "log"))
# which is the same as
glm(y ~ x, family = poisson)
glm(y ~ x, family = quasi(variance = "mu^2", link = "log"))
## Not run: glm(y ~ x, family = quasi(variance = "mu^3", link = "log")) # fails
y <- rbinom(100, 1, plogis(x))
# needs to set a starting value for the next fit
glm(y ~ x, family = quasi(variance = "mu(1-mu)", link = "logit"), start = c(0,1))



cleanEx()
nameEx("fft")
### * fft

flush(stderr()); flush(stdout())

### Name: fft
### Title: Fast Discrete Fourier Transform (FFT)
### Aliases: fft mvfft
### Keywords: math dplot

### ** Examples

x <- 1:4
fft(x)
fft(fft(x), inverse = TRUE)/length(x)

## Slow Discrete Fourier Transform (DFT) - e.g., for checking the formula
fft0 <- function(z, inverse=FALSE) {
  n <- length(z)
  if(n == 0) return(z)
  k <- 0:(n-1)
  ff <- (if(inverse) 1 else -1) * 2*pi * 1i * k/n
  vapply(1:n, function(h) sum(z * exp(ff*(h-1))), complex(1))
}

relD <- function(x,y) 2* abs(x - y) / abs(x + y)
n <- 2^8
z <- complex(n, rnorm(n), rnorm(n))


cleanEx()
nameEx("filter")
### * filter

flush(stderr()); flush(stdout())

### Name: filter
### Title: Linear Filtering on a Time Series
### Aliases: filter
### Keywords: ts

### ** Examples

x <- 1:100
filter(x, rep(1, 3))
filter(x, rep(1, 3), sides = 1)
filter(x, rep(1, 3), sides = 1, circular = TRUE)

filter(presidents, rep(1, 3))



cleanEx()
nameEx("fisher.test")
### * fisher.test

flush(stderr()); flush(stdout())

### Name: fisher.test
### Title: Fisher's Exact Test for Count Data
### Aliases: fisher.test
### Keywords: htest

### ** Examples

## Agresti (1990, p. 61f; 2002, p. 91) Fisher's Tea Drinker
## A British woman claimed to be able to distinguish whether milk or
##  tea was added to the cup first.  To test, she was given 8 cups of
##  tea, in four of which milk was added first.  The null hypothesis
##  is that there is no association between the true order of pouring
##  and the woman's guess, the alternative that there is a positive
##  association (that the odds ratio is greater than 1).
TeaTasting <-
matrix(c(3, 1, 1, 3),
       nrow = 2,
       dimnames = list(Guess = c("Milk", "Tea"),
                       Truth = c("Milk", "Tea")))
fisher.test(TeaTasting, alternative = "greater")
## => p = 0.2429, association could not be established

## Fisher (1962, 1970), Criminal convictions of like-sex twins
Convictions <-
matrix(c(2, 10, 15, 3),
       nrow = 2,
       dimnames =
       list(c("Dizygotic", "Monozygotic"),
            c("Convicted", "Not convicted")))
Convictions
fisher.test(Convictions, alternative = "less")
fisher.test(Convictions, conf.int = FALSE)
fisher.test(Convictions, conf.level = 0.95)$conf.int
fisher.test(Convictions, conf.level = 0.99)$conf.int

## A r x c table  Agresti (2002, p. 57) Job Satisfaction
Job <- matrix(c(1,2,1,0, 3,3,6,1, 10,10,14,9, 6,7,12,11), 4, 4,
dimnames = list(income = c("< 15k", "15-25k", "25-40k", "> 40k"),
                satisfaction = c("VeryD", "LittleD", "ModerateS", "VeryS")))
fisher.test(Job)
fisher.test(Job, simulate.p.value = TRUE, B = 1e5)



cleanEx()
nameEx("fivenum")
### * fivenum

flush(stderr()); flush(stdout())

### Name: fivenum
### Title: Tukey Five-Number Summaries
### Aliases: fivenum
### Keywords: univar robust distribution

### ** Examples

fivenum(c(rnorm(100), -1:1/0))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("fligner.test")
### * fligner.test

flush(stderr()); flush(stdout())

### Name: fligner.test
### Title: Fligner-Killeen Test of Homogeneity of Variances
### Aliases: fligner.test fligner.test.default fligner.test.formula
### Keywords: htest

### ** Examples

require(graphics)

plot(count ~ spray, data = InsectSprays)
fligner.test(InsectSprays$count, InsectSprays$spray)
fligner.test(count ~ spray, data = InsectSprays)
## Compare this to bartlett.test()



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("formula")
### * formula

flush(stderr()); flush(stdout())

### Name: formula
### Title: Model Formulae
### Aliases: formula formula.default formula.formula formula.terms
###   formula.data.frame as.formula print.formula [.formula
### Keywords: models

### ** Examples

class(fo <- y ~ x1*x2) # "formula"
fo
typeof(fo)  # R internal : "language"
terms(fo)

environment(fo)
environment(as.formula("y ~ x"))
environment(as.formula("y ~ x", env = new.env()))


## Create a formula for a model with a large number of variables:
xnam <- paste0("x", 1:25)
(fmla <- as.formula(paste("y ~ ", paste(xnam, collapse= "+"))))



cleanEx()
nameEx("formula.nls")
### * formula.nls

flush(stderr()); flush(stdout())

### Name: formula.nls
### Title: Extract Model Formula from nls Object
### Aliases: formula.nls
### Keywords: models

### ** Examples

fm1 <- nls(circumference ~ A/(1+exp((B-age)/C)), Orange,
           start = list(A = 160, B = 700, C = 350))
formula(fm1)



cleanEx()
nameEx("friedman.test")
### * friedman.test

flush(stderr()); flush(stdout())

### Name: friedman.test
### Title: Friedman Rank Sum Test
### Aliases: friedman.test friedman.test.default friedman.test.formula
### Keywords: htest

### ** Examples

## Hollander & Wolfe (1973), p. 140ff.
## Comparison of three methods ("round out", "narrow angle", and
##  "wide angle") for rounding first base.  For each of 18 players
##  and the three method, the average time of two runs from a point on
##  the first base line 35ft from home plate to a point 15ft short of
##  second base is recorded.
RoundingTimes <-
matrix(c(5.40, 5.50, 5.55,
         5.85, 5.70, 5.75,
         5.20, 5.60, 5.50,
         5.55, 5.50, 5.40,
         5.90, 5.85, 5.70,
         5.45, 5.55, 5.60,
         5.40, 5.40, 5.35,
         5.45, 5.50, 5.35,
         5.25, 5.15, 5.00,
         5.85, 5.80, 5.70,
         5.25, 5.20, 5.10,
         5.65, 5.55, 5.45,
         5.60, 5.35, 5.45,
         5.05, 5.00, 4.95,
         5.50, 5.50, 5.40,
         5.45, 5.55, 5.50,
         5.55, 5.55, 5.35,
         5.45, 5.50, 5.55,
         5.50, 5.45, 5.25,
         5.65, 5.60, 5.40,
         5.70, 5.65, 5.55,
         6.30, 6.30, 6.25),
       nrow = 22,
       byrow = TRUE,
       dimnames = list(1 : 22,
                       c("Round Out", "Narrow Angle", "Wide Angle")))
friedman.test(RoundingTimes)
## => strong evidence against the null that the methods are equivalent
##    with respect to speed

wb <- aggregate(warpbreaks$breaks,
                by = list(w = warpbreaks$wool,
                          t = warpbreaks$tension),
                FUN = mean)
wb
friedman.test(wb$x, wb$w, wb$t)
friedman.test(x ~ w | t, data = wb)



cleanEx()
nameEx("ftable")
### * ftable

flush(stderr()); flush(stdout())

### Name: ftable
### Title: Flat Contingency Tables
### Aliases: ftable ftable.default
### Keywords: category

### ** Examples

## Start with a contingency table.
ftable(Titanic, row.vars = 1:3)
ftable(Titanic, row.vars = 1:2, col.vars = "Survived")
ftable(Titanic, row.vars = 2:1, col.vars = "Survived")
## Don't show: 
. <- integer()
(f04 <- ftable(Titanic, col.vars= .))
(f10 <- ftable(Titanic, col.vars= 1, row.vars= .))
(f01 <- ftable(Titanic, col.vars= ., row.vars= 1))
(f00 <- ftable(Titanic, col.vars= ., row.vars= .))
stopifnot(
  dim(f04) == c(32,1),
  dim(f10) == c(1,4),
  dim(f01) == c(4,1),
  dim(f00) == c(1,1))
## End(Don't show)
## Start with a data frame.
x <- ftable(mtcars[c("cyl", "vs", "am", "gear")])
x
ftable(x, row.vars = c(2, 4))

## Start with expressions, use table()'s "dnn" to change labels
ftable(mtcars$cyl, mtcars$vs, mtcars$am, mtcars$gear, row.vars = c(2, 4),
       dnn = c("Cylinders", "V/S", "Transmission", "Gears"))



cleanEx()
nameEx("ftable.formula")
### * ftable.formula

flush(stderr()); flush(stdout())

### Name: ftable.formula
### Title: Formula Notation for Flat Contingency Tables
### Aliases: ftable.formula
### Keywords: category

### ** Examples

Titanic
x <- ftable(Survived ~ ., data = Titanic)
x
ftable(Sex ~ Class + Age, data = x)



cleanEx()
nameEx("getInitial")
### * getInitial

flush(stderr()); flush(stdout())

### Name: getInitial
### Title: Get Initial Parameter Estimates
### Aliases: getInitial getInitial.default getInitial.formula
###   getInitial.selfStart
### Keywords: models nonlinear manip

### ** Examples

PurTrt <- Puromycin[ Puromycin$state == "treated", ]
print(getInitial( rate ~ SSmicmen( conc, Vm, K ), PurTrt ), digits = 3)



cleanEx()
nameEx("glm")
### * glm

flush(stderr()); flush(stdout())

### Name: glm
### Title: Fitting Generalized Linear Models
### Aliases: glm glm.fit weights.glm
### Keywords: models regression

### ** Examples

## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
print(d.AD <- data.frame(treatment, outcome, counts))
glm.D93 <- glm(counts ~ outcome + treatment, family = poisson())
anova(glm.D93)


# A Gamma example, from McCullagh & Nelder (1989, pp. 300-2)
clotting <- data.frame(
    u = c(5,10,15,20,30,40,60,80,100),
    lot1 = c(118,58,42,35,27,25,21,19,18),
    lot2 = c(69,35,26,21,18,16,13,12,12))
summary(glm(lot1 ~ log(u), data = clotting, family = Gamma))
summary(glm(lot2 ~ log(u), data = clotting, family = Gamma))

## Not run: 
##D ## for an example of the use of a terms object as a formula
##D demo(glm.vr)
## End(Not run)


cleanEx()
nameEx("glm.control")
### * glm.control

flush(stderr()); flush(stdout())

### Name: glm.control
### Title: Auxiliary for Controlling GLM Fitting
### Aliases: glm.control
### Keywords: optimize models

### ** Examples


if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("hclust")
### * hclust

flush(stderr()); flush(stdout())

### Name: hclust
### Title: Hierarchical Clustering
### Aliases: hclust plot.hclust print.hclust
### Keywords: multivariate cluster

### ** Examples

require(graphics)

### Example 1: Violent crime rates by US state

hc <- hclust(dist(USArrests), "ave")
plot(hc)
plot(hc, hang = -1)

## Do the same with centroid clustering and *squared* Euclidean distance,
## cut the tree into ten clusters and reconstruct the upper part of the
## tree from the cluster centers.
hc <- hclust(dist(USArrests)^2, "cen")
memb <- cutree(hc, k = 10)
cent <- NULL
for(k in 1:10){
  cent <- rbind(cent, colMeans(USArrests[memb == k, , drop = FALSE]))
}
hc1 <- hclust(dist(cent)^2, method = "cen", members = table(memb))
opar <- par(mfrow = c(1, 2))
plot(hc,  labels = FALSE, hang = -1, main = "Original Tree")
plot(hc1, labels = FALSE, hang = -1, main = "Re-start from 10 clusters")
par(opar)

### Example 2: Straight-line distances among 10 US cities
##  Compare the results of algorithms "ward.D" and "ward.D2"

data(UScitiesD)

mds2 <- -cmdscale(UScitiesD)
plot(mds2, type="n", axes=FALSE, ann=FALSE)
text(mds2, labels=rownames(mds2), xpd = NA)

hcity.D  <- hclust(UScitiesD, "ward.D") # "wrong"
hcity.D2 <- hclust(UScitiesD, "ward.D2")
opar <- par(mfrow = c(1, 2))
plot(hcity.D,  hang=-1)
plot(hcity.D2, hang=-1)
par(opar)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("heatmap")
### * heatmap

flush(stderr()); flush(stdout())

### Name: heatmap
### Title: Draw a Heat Map
### Aliases: heatmap
### Keywords: hplot

### ** Examples

require(graphics); require(grDevices)
x  <- as.matrix(mtcars)
rc <- rainbow(nrow(x), start = 0, end = .3)
cc <- rainbow(ncol(x), start = 0, end = .3)
hv <- heatmap(x, col = cm.colors(256), scale = "column",
              RowSideColors = rc, ColSideColors = cc, margins = c(5,10),
              xlab = "specification variables", ylab =  "Car Models",
              main = "heatmap(<Mtcars data>, ..., scale = \"column\")")
utils::str(hv) # the two re-ordering index vectors

## no column dendrogram (nor reordering) at all:
heatmap(x, Colv = NA, col = cm.colors(256), scale = "column",
        RowSideColors = rc, margins = c(5,10),
        xlab = "specification variables", ylab =  "Car Models",
        main = "heatmap(<Mtcars data>, ..., scale = \"column\")")
## Don't show: 
## no row dendrogram (nor reordering) at all:
heatmap(x, Rowv = NA, col = cm.colors(256), scale = "column",
        ColSideColors = cc, margins = c(5,10),
        xlab = "xlab", ylab =  "ylab")  # no main
## End(Don't show)
## "no nothing"
heatmap(x, Rowv = NA, Colv = NA, scale = "column",
        main = "heatmap(*, NA, NA) ~= image(t(x))")

round(Ca <- cor(attitude), 2)
symnum(Ca) # simple graphic
heatmap(Ca,               symm = TRUE, margins = c(6,6)) # with reorder()
heatmap(Ca, Rowv = FALSE, symm = TRUE, margins = c(6,6)) # _NO_ reorder()
## slightly artificial with color bar, without and with ordering:
cc <- rainbow(nrow(Ca))
heatmap(Ca, Rowv = FALSE, symm = TRUE, RowSideColors = cc, ColSideColors = cc,
	margins = c(6,6))
heatmap(Ca,		symm = TRUE, RowSideColors = cc, ColSideColors = cc,
	margins = c(6,6))

## For variable clustering, rather use distance based on cor():
symnum( cU <- cor(USJudgeRatings) )

hU <- heatmap(cU, Rowv = FALSE, symm = TRUE, col = topo.colors(16),
             distfun = function(c) as.dist(1 - c), keep.dendro = TRUE)
## The Correlation matrix with same reordering:
round(100 * cU[hU[[1]], hU[[2]]])
## The column dendrogram:
utils::str(hU$Colv)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("identify.hclust")
### * identify.hclust

flush(stderr()); flush(stdout())

### Name: identify.hclust
### Title: Identify Clusters in a Dendrogram
### Aliases: identify.hclust
### Keywords: cluster iplot

### ** Examples
## Not run: 
##D require(graphics)
##D 
##D hca <- hclust(dist(USArrests))
##D plot(hca)
##D (x <- identify(hca)) ##  Terminate with 2nd mouse button !!
##D 
##D hci <- hclust(dist(iris[,1:4]))
##D plot(hci)
##D identify(hci, function(k) print(table(iris[k,5])))
##D 
##D # open a new device (one for dendrogram, one for bars):
##D dev.new() # << make that narrow (& small)
##D           # and *beside* 1st one
##D nD <- dev.cur()            # to be for the barplot
##D dev.set(dev.prev())  # old one for dendrogram
##D plot(hci)
##D ## select subtrees in dendrogram and "see" the species distribution:
##D identify(hci, function(k) barplot(table(iris[k,5]), col = 2:4), DEV.FUN = nD)
## End(Not run)


if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("influence.measures")
### * influence.measures

flush(stderr()); flush(stdout())

### Name: influence.measures
### Title: Regression Deletion Diagnostics
### Aliases: influence.measures hat hatvalues hatvalues.lm rstandard
###   rstandard.lm rstandard.glm rstudent rstudent.lm rstudent.glm dfbeta
###   dfbeta.lm dfbetas dfbetas.lm dffits covratio cooks.distance
###   cooks.distance.lm cooks.distance.glm
### Keywords: regression

### ** Examples

require(graphics)

## Analysis of the life-cycle savings data
## given in Belsley, Kuh and Welsch.
lm.SR <- lm(sr ~ pop15 + pop75 + dpi + ddpi, data = LifeCycleSavings)

inflm.SR <- influence.measures(lm.SR)
which(apply(inflm.SR$is.inf, 1, any))
# which observations 'are' influential
summary(inflm.SR) # only these
plot(rstudent(lm.SR) ~ hatvalues(lm.SR)) # recommended by some
plot(lm.SR, which = 5) # an enhanced version of that via plot(<lm>)

## The 'infl' argument is not needed, but avoids recomputation:
rs <- rstandard(lm.SR)
iflSR <- influence(lm.SR)
identical(rs, rstandard(lm.SR, infl = iflSR))
## to "see" the larger values:
1000 * round(dfbetas(lm.SR, infl = iflSR), 3)
cat("PRESS :"); (PRESS <- sum( rstandard(lm.SR, type = "predictive")^2 ))
stopifnot(all.equal(PRESS, sum( (residuals(lm.SR) / (1 - iflSR$hat))^2)))

## Show that "PRE-residuals"  ==  L.O.O. Crossvalidation (CV) errors:
X <- model.matrix(lm.SR)
y <- model.response(model.frame(lm.SR))
## Leave-one-out CV least-squares prediction errors (relatively fast)
rCV <- vapply(seq_len(nrow(X)), function(i)
              y[i] - X[i,] %*% .lm.fit(X[-i,], y[-i])$coef,
              numeric(1))
## are the same as the *faster* rstandard(*, "pred") :
stopifnot(all.equal(rCV, unname(rstandard(lm.SR, type = "predictive"))))


## Huber's data [Atkinson 1985]
xh <- c(-4:0, 10)
yh <- c(2.48, .73, -.04, -1.44, -1.32, 0)
lmH <- lm(yh ~ xh)
im <- influence.measures(lmH)
plot(xh,yh, main = "Huber's data: L.S. line and influential obs.")
abline(lmH); points(xh[im$is.inf], yh[im$is.inf], pch = 20, col = 2)

## Irwin's data [Williams 1987]
xi <- 1:5
yi <- c(0,2,14,19,30)    # number of mice responding to dose xi
mi <- rep(40, 5)         # number of mice exposed
glmI <- glm(cbind(yi, mi -yi) ~ xi, family = binomial)
signif(cooks.distance(glmI), 3)   # ~= Ci in Table 3, p.184
imI <- influence.measures(glmI)
stopifnot(all.equal(imI$infmat[,"cook.d"],
          cooks.distance(glmI)))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("integrate")
### * integrate

flush(stderr()); flush(stdout())

### Name: integrate
### Title: Integration of One-Dimensional Functions
### Aliases: integrate print.integrate
### Keywords: math utilities

### ** Examples

integrate(dnorm, -1.96, 1.96)
integrate(dnorm, -Inf, Inf)

## a slowly-convergent integral
integrand <- function(x) {1/((x+1)*sqrt(x))}
integrate(integrand, lower = 0, upper = Inf)

## don't do this if you really want the integral from 0 to Inf
integrate(integrand, lower = 0, upper = 10)
integrate(integrand, lower = 0, upper = 100000)
integrate(integrand, lower = 0, upper = 1000000, stop.on.error = FALSE)

## some functions do not handle vector input properly
f <- function(x) 2.0
try(integrate(f, 0, 1))
integrate(Vectorize(f), 0, 1)  ## correct
integrate(function(x) rep(2.0, length(x)), 0, 1)  ## correct

## integrate can fail if misused
integrate(dnorm, 0, 2)
integrate(dnorm, 0, 20)
integrate(dnorm, 0, 200)
integrate(dnorm, 0, 2000)
integrate(dnorm, 0, 20000) ## fails on many systems
integrate(dnorm, 0, Inf)   ## works
## Don't show: 
tools::assertError(
## End(Don't show)
integrate(dnorm, 0:1, 20) #-> error!
## "silently" gave  integrate(dnorm, 0, 20)  in earlier versions of R
## Don't show: 
 , verbose=TRUE)
## End(Don't show)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("interaction.plot")
### * interaction.plot

flush(stderr()); flush(stdout())

### Name: interaction.plot
### Title: Two-way Interaction Plot
### Aliases: interaction.plot
### Keywords: hplot

### ** Examples

require(graphics)

with(ToothGrowth, {
interaction.plot(dose, supp, len, fixed = TRUE)
dose <- ordered(dose)
interaction.plot(dose, supp, len, fixed = TRUE, col = 2:3, leg.bty = "o")
interaction.plot(dose, supp, len, fixed = TRUE, col = 2:3, type = "p")
})

with(OrchardSprays, {
  interaction.plot(treatment, rowpos, decrease)
  interaction.plot(rowpos, treatment, decrease, cex.axis = 0.8)
  ## order the rows by their mean effect
  rowpos <- factor(rowpos,
                   levels = sort.list(tapply(decrease, rowpos, mean)))
  interaction.plot(rowpos, treatment, decrease, col = 2:9, lty = 1)
})

with(esoph, {
  interaction.plot(agegp, alcgp, ncases/ncontrols, main = "'esoph' Data")
  interaction.plot(agegp, tobgp, ncases/ncontrols, trace.label = "tobacco",
                   fixed = TRUE, xaxt = "n")
})
## deal with NAs:
esoph[66,] # second to last age group: 65-74
esophNA <- esoph; esophNA$ncases[66] <- NA
with(esophNA, {
  interaction.plot(agegp, alcgp, ncases/ncontrols, col = 2:5)
                                # doesn't show *last* group either
  interaction.plot(agegp, alcgp, ncases/ncontrols, col = 2:5, type = "b")
  ## alternative take non-NA's  {"cheating"}
  interaction.plot(agegp, alcgp, ncases/ncontrols, col = 2:5,
                   fun = function(x) mean(x, na.rm = TRUE),
                   sub = "function(x) mean(x, na.rm=TRUE)")
})
rm(esophNA) # to clear up



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("is.empty")
### * is.empty

flush(stderr()); flush(stdout())

### Name: is.empty.model
### Title: Test if a Model's Formula is Empty
### Aliases: is.empty.model
### Keywords: models

### ** Examples

y <- rnorm(20)
is.empty.model(y ~ 0)
is.empty.model(y ~ -1)
is.empty.model(lm(y ~ 0))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("isoreg")
### * isoreg

flush(stderr()); flush(stdout())

### Name: isoreg
### Title: Isotonic / Monotone Regression
### Aliases: isoreg
### Keywords: regression smooth

### ** Examples

require(graphics)

(ir <- isoreg(c(1,0,4,3,3,5,4,2,0)))
plot(ir, plot.type = "row")

(ir3 <- isoreg(y3 <- c(1,0,4,3,3,5,4,2, 3))) # last "3", not "0"
(fi3 <- as.stepfun(ir3))
(ir4 <- isoreg(1:10, y4 <- c(5, 9, 1:2, 5:8, 3, 8)))
cat(sprintf("R^2 = %.2f\n",
            1 - sum(residuals(ir4)^2) / ((10-1)*var(y4))))

## If you are interested in the knots alone :
with(ir4, cbind(iKnots, yf[iKnots]))

## Example of unordered x[] with ties:
x <- sample((0:30)/8)
y <- exp(x)
x. <- round(x) # ties!
plot(m <- isoreg(x., y))
stopifnot(all.equal(with(m, yf[iKnots]),
                    as.vector(tapply(y, x., mean))))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("kernapply")
### * kernapply

flush(stderr()); flush(stdout())

### Name: kernapply
### Title: Apply Smoothing Kernel
### Aliases: kernapply kernapply.default kernapply.ts kernapply.tskernel
###   kernapply.vector
### Keywords: ts

### ** Examples

## see 'kernel' for examples



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("kernel")
### * kernel

flush(stderr()); flush(stdout())

### Name: kernel
### Title: Smoothing Kernel Objects
### Aliases: kernel bandwidth.kernel df.kernel is.tskernel plot.tskernel
### Keywords: ts

### ** Examples

require(graphics)

## Demonstrate a simple trading strategy for the
## financial time series German stock index DAX.
x <- EuStockMarkets[,1]
k1 <- kernel("daniell", 50)  # a long moving average
k2 <- kernel("daniell", 10)  # and a short one
plot(k1)
plot(k2)
x1 <- kernapply(x, k1)
x2 <- kernapply(x, k2)
plot(x)
lines(x1, col = "red")    # go long if the short crosses the long upwards
lines(x2, col = "green")  # and go short otherwise

## More interesting kernels
kd <- kernel("daniell", c(3, 3))
kd # note the unusual indexing
kd[-2:2]
plot(kernel("fejer", 100, r = 6))
plot(kernel("modified.daniell", c(7,5,3)))

# Reproduce example 10.4.3 from Brockwell and Davis (1991)
spectrum(sunspot.year, kernel = kernel("daniell", c(11,7,3)), log = "no")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("kmeans")
### * kmeans

flush(stderr()); flush(stdout())

### Name: kmeans
### Title: K-Means Clustering
### Aliases: kmeans print.kmeans fitted.kmeans
### Keywords: multivariate cluster

### ** Examples

require(graphics)

# a 2-dimensional example
x <- rbind(matrix(rnorm(100, sd = 0.3), ncol = 2),
           matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2))
colnames(x) <- c("x", "y")
(cl <- kmeans(x, 2))
plot(x, col = cl$cluster)
points(cl$centers, col = 1:2, pch = 8, cex = 2)

# sum of squares
ss <- function(x) sum(scale(x, scale = FALSE)^2)

## cluster centers "fitted" to each obs.:
fitted.x <- fitted(cl);  head(fitted.x)
resid.x <- x - fitted(cl)

## Equalities : ----------------------------------
cbind(cl[c("betweenss", "tot.withinss", "totss")], # the same two columns
         c(ss(fitted.x), ss(resid.x),    ss(x)))
stopifnot(all.equal(cl$ totss,        ss(x)),
	  all.equal(cl$ tot.withinss, ss(resid.x)),
	  ## these three are the same:
	  all.equal(cl$ betweenss,    ss(fitted.x)),
	  all.equal(cl$ betweenss, cl$totss - cl$tot.withinss),
	  ## and hence also
	  all.equal(ss(x), ss(fitted.x) + ss(resid.x))
	  )

kmeans(x,1)$withinss # trivial one-cluster, (its W.SS == ss(x))

## random starts do help here with too many clusters
## (and are often recommended anyway!):
(cl <- kmeans(x, 5, nstart = 25))
plot(x, col = cl$cluster)
points(cl$centers, col = 1:5, pch = 8)



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("kruskal.test")
### * kruskal.test

flush(stderr()); flush(stdout())

### Name: kruskal.test
### Title: Kruskal-Wallis Rank Sum Test
### Aliases: kruskal.test kruskal.test.default kruskal.test.formula
### Keywords: htest

### ** Examples

## Hollander & Wolfe (1973), 116.
## Mucociliary efficiency from the rate of removal of dust in normal
##  subjects, subjects with obstructive airway disease, and subjects
##  with asbestosis.
x <- c(2.9, 3.0, 2.5, 2.6, 3.2) # normal subjects
y <- c(3.8, 2.7, 4.0, 2.4)      # with obstructive airway disease
z <- c(2.8, 3.4, 3.7, 2.2, 2.0) # with asbestosis
kruskal.test(list(x, y, z))
## Equivalently,
x <- c(x, y, z)
g <- factor(rep(1:3, c(5, 4, 5)),
            labels = c("Normal subjects",
                       "Subjects with obstructive airway disease",
                       "Subjects with asbestosis"))
kruskal.test(x, g)

## Formula interface.
require(graphics)
boxplot(Ozone ~ Month, data = airquality)
kruskal.test(Ozone ~ Month, data = airquality)



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ks.test")
### * ks.test

flush(stderr()); flush(stdout())

### Name: ks.test
### Title: Kolmogorov-Smirnov Tests
### Aliases: ks.test
### Keywords: htest

### ** Examples

require(graphics)

x <- rnorm(50)
y <- runif(30)
# Do x and y come from the same distribution?
ks.test(x, y)
# Does x come from a shifted gamma distribution with shape 3 and rate 2?
ks.test(x+2, "pgamma", 3, 2) # two-sided, exact
ks.test(x+2, "pgamma", 3, 2, exact = FALSE)
ks.test(x+2, "pgamma", 3, 2, alternative = "gr")

# test if x is stochastically larger than x2
x2 <- rnorm(50, -1)
plot(ecdf(x), xlim = range(c(x, x2)))
plot(ecdf(x2), add = TRUE, lty = "dashed")
t.test(x, x2, alternative = "g")
wilcox.test(x, x2, alternative = "g")
ks.test(x, x2, alternative = "l")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ksmooth")
### * ksmooth

flush(stderr()); flush(stdout())

### Name: ksmooth
### Title: Kernel Regression Smoother
### Aliases: ksmooth
### Keywords: smooth

### ** Examples

require(graphics)

with(cars, {
    plot(speed, dist)
    lines(ksmooth(speed, dist, "normal", bandwidth = 2), col = 2)
    lines(ksmooth(speed, dist, "normal", bandwidth = 5), col = 3)
})



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("lag")
### * lag

flush(stderr()); flush(stdout())

### Name: lag
### Title: Lag a Time Series
### Aliases: lag lag.default
### Keywords: ts

### ** Examples

lag(ldeaths, 12) # starts one year earlier



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("lag.plot")
### * lag.plot

flush(stderr()); flush(stdout())

### Name: lag.plot
### Title: Time Series Lag Plots
### Aliases: lag.plot
### Keywords: hplot ts

### ** Examples

require(graphics)

lag.plot(nhtemp, 8, diag.col = "forest green")
lag.plot(nhtemp, 5, main = "Average Temperatures in New Haven")
## ask defaults to TRUE when we have more than one page:
lag.plot(nhtemp, 6, layout = c(2,1), asp = NA,
         main = "New Haven Temperatures", col.main = "blue")

## Multivariate (but non-stationary! ...)
lag.plot(freeny.x, lags = 3)

## no lines for long series :
lag.plot(sqrt(sunspots), set = c(1:4, 9:12), pch = ".", col = "gold")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("line")
### * line

flush(stderr()); flush(stdout())

### Name: line
### Title: Robust Line Fitting
### Aliases: line residuals.tukeyline
### Keywords: robust regression

### ** Examples

require(graphics)

plot(cars)
(z <- line(cars))
abline(coef(z))
## Tukey-Anscombe Plot :
plot(residuals(z) ~ fitted(z), main = deparse(z$call))



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("lm")
### * lm

flush(stderr()); flush(stdout())

### Name: lm
### Title: Fitting Linear Models
### Aliases: lm
### Keywords: regression

### ** Examples

require(graphics)

## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
lm.D90 <- lm(weight ~ group - 1) # omitting intercept
opar <- par(mfrow = c(2,2), oma = c(0, 0, 1.1, 0))
plot(lm.D9, las = 1)      # Residuals, Fitted, ...
par(opar)
## Don't show: 
## model frame :
stopifnot(identical(lm(weight ~ group, method = "model.frame"),
                    model.frame(lm.D9)))
## End(Don't show)
### less simple examples in "See Also" above



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("lm.influence")
### * lm.influence

flush(stderr()); flush(stdout())

### Name: lm.influence
### Title: Regression Diagnostics
### Aliases: lm.influence influence influence.lm influence.glm
### Keywords: regression

### ** Examples

## Analysis of the life-cycle savings data
## given in Belsley, Kuh and Welsch.
summary(lm.SR <- lm(sr ~ pop15 + pop75 + dpi + ddpi,
                    data = LifeCycleSavings),
        corr = TRUE)
utils::str(lmI <- lm.influence(lm.SR))

## For more "user level" examples, use example(influence.measures)



cleanEx()
nameEx("lm.summaries")
### * lm.summaries

flush(stderr()); flush(stdout())

### Name: lm.summaries
### Title: Accessing Linear Model Fits
### Aliases: family.lm formula.lm residuals.lm labels.lm
### Keywords: regression models

### ** Examples

## Don't show: 
utils::example("lm", echo = FALSE)
## End(Don't show)
##-- Continuing the  lm(.) example:
coef(lm.D90) # the bare coefficients

## The 2 basic regression diagnostic plots [plot.lm(.) is preferred]
plot(resid(lm.D90), fitted(lm.D90)) # Tukey-Anscombe's
abline(h = 0, lty = 2, col = "gray")

qqnorm(residuals(lm.D90))



cleanEx()
nameEx("lmfit")
### * lmfit

flush(stderr()); flush(stdout())

### Name: lm.fit
### Title: Fitter Functions for Linear Models
### Aliases: lm.fit lm.wfit .lm.fit
### Keywords: regression array

### ** Examples

require(utils)
set.seed(129)

n <- 7 ; p <- 2
X <- matrix(rnorm(n * p), n, p) # no intercept!
y <- rnorm(n)
w <- rnorm(n)^2

str(lmw <- lm.wfit(x = X, y = y, w = w))

str(lm. <- lm.fit (x = X, y = y))
## Don't show: 
  ## These are the same calculations at C level, but a parallel BLAS
  ## might not do them the same way twice, and if seems serial MKL does not.
  lm.. <- .lm.fit(X,y)
  lm.w <- .lm.fit(X*sqrt(w), y*sqrt(w))
  id <- function(x, y) all.equal(x, y, tolerance = 1e-15, scale = 1)
  stopifnot(id(unname(lm.$coef), lm..$coef),
	    id(unname(lmw$coef), lm.w$coef))
## End(Don't show)



cleanEx()
nameEx("loess")
### * loess

flush(stderr()); flush(stdout())

### Name: loess
### Title: Local Polynomial Regression Fitting
### Aliases: loess
### Keywords: smooth loess

### ** Examples

cars.lo <- loess(dist ~ speed, cars)
predict(cars.lo, data.frame(speed = seq(5, 30, 1)), se = TRUE)
# to allow extrapolation
cars.lo2 <- loess(dist ~ speed, cars,
  control = loess.control(surface = "direct"))
predict(cars.lo2, data.frame(speed = seq(5, 30, 1)), se = TRUE)



cleanEx()
nameEx("logLik")
### * logLik

flush(stderr()); flush(stdout())

### Name: logLik
### Title: Extract Log-Likelihood
### Aliases: logLik logLik.lm
### Keywords: models

### ** Examples

x <- 1:5
lmx <- lm(x ~ 1)
logLik(lmx) # using print.logLik() method
utils::str(logLik(lmx))

## lm method
(fm1 <- lm(rating ~ ., data = attitude))
logLik(fm1)
logLik(fm1, REML = TRUE)



cleanEx()
nameEx("loglin")
### * loglin

flush(stderr()); flush(stdout())

### Name: loglin
### Title: Fitting Log-Linear Models
### Aliases: loglin
### Keywords: category models

### ** Examples

## Model of joint independence of sex from hair and eye color.
fm <- loglin(HairEyeColor, list(c(1, 2), c(1, 3), c(2, 3)))
fm
1 - pchisq(fm$lrt, fm$df)
## Model with no three-factor interactions fits well.



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("lowess")
### * lowess

flush(stderr()); flush(stdout())

### Name: lowess
### Title: Scatter Plot Smoothing
### Aliases: lowess
### Keywords: smooth

### ** Examples

require(graphics)

plot(cars, main = "lowess(cars)")
lines(lowess(cars), col = 2)
lines(lowess(cars, f = .2), col = 3)
legend(5, 120, c(paste("f = ", c("2/3", ".2"))), lty = 1, col = 2:3)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("ls.diag")
### * ls.diag

flush(stderr()); flush(stdout())

### Name: ls.diag
### Title: Compute Diagnostics for 'lsfit' Regression Results
### Aliases: ls.diag
### Keywords: regression

### ** Examples


cleanEx()
nameEx("lsfit")
### * lsfit

flush(stderr()); flush(stdout())

### Name: lsfit
### Title: Find the Least Squares Fit
### Aliases: lsfit
### Keywords: regression

### ** Examples

## Don't show: 
utils::example("lm", echo = FALSE)
## End(Don't show)
##-- Using the same data as the lm(.) example:
lsD9 <- lsfit(x = unclass(gl(2, 10)), y = weight)
ls.print(lsD9)



cleanEx()
nameEx("mad")
### * mad

flush(stderr()); flush(stdout())

### Name: mad
### Title: Median Absolute Deviation
### Aliases: mad
### Keywords: univar robust

### ** Examples

mad(c(1:9))
print(mad(c(1:9),     constant = 1)) ==
      mad(c(1:8, 100), constant = 1)       # = 2 ; TRUE
x <- c(1,2,3,5,7,8)
sort(abs(x - median(x)))
c(mad(x, constant = 1),
  mad(x, constant = 1, low = TRUE),
  mad(x, constant = 1, high = TRUE))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("mahalanobis")
### * mahalanobis

flush(stderr()); flush(stdout())

### Name: mahalanobis
### Title: Mahalanobis Distance
### Aliases: mahalanobis
### Keywords: multivariate

### ** Examples

require(graphics)

ma <- cbind(1:6, 1:3)
(S <-  var(ma))
mahalanobis(c(0, 0), 1:2, S)

x <- matrix(rnorm(100*3), ncol = 3)
stopifnot(mahalanobis(x, 0, diag(ncol(x))) == rowSums(x*x))
        ##- Here, D^2 = usual squared Euclidean distances

Sx <- cov(x)
D2 <- mahalanobis(x, colMeans(x), Sx)
plot(density(D2, bw = 0.5),
     main="Squared Mahalanobis distances, n=100, p=3") ; rug(D2)
qqplot(qchisq(ppoints(100), df = 3), D2,
       main = expression("Q-Q plot of Mahalanobis" * ~D^2 *
                         " vs. quantiles of" * ~ chi[3]^2))
abline(0, 1, col = 'gray')



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("make.link")
### * make.link

flush(stderr()); flush(stdout())

### Name: make.link
### Title: Create a Link for GLM Families
### Aliases: make.link
### Keywords: models

### ** Examples

utils::str(make.link("logit"))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("makepredictcall")
### * makepredictcall

flush(stderr()); flush(stdout())

### Name: makepredictcall
### Title: Utility Function for Safe Prediction
### Aliases: makepredictcall makepredictcall.default SafePrediction
### Keywords: models

### ** Examples

require(graphics)

## using poly: this did not work in R < 1.5.0
fm <- lm(weight ~ poly(height, 2), data = women)
plot(women, xlab = "Height (in)", ylab = "Weight (lb)")
ht <- seq(57, 73, len = 200)
lines(ht, predict(fm, data.frame(height = ht)))

## see also example(cars)

## see bs and ns for spline examples.



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("manova")
### * manova

flush(stderr()); flush(stdout())

### Name: manova
### Title: Multivariate Analysis of Variance
### Aliases: manova
### Keywords: models

### ** Examples

## Set orthogonal contrasts.
op <- options(contrasts = c("contr.helmert", "contr.poly"))

## Fake a 2nd response variable
npk2 <- within(npk, foo <- rnorm(24))
( npk2.aov <- manova(cbind(yield, foo) ~ block + N*P*K, npk2) )
summary(npk2.aov)

( npk2.aovE <- manova(cbind(yield, foo) ~  N*P*K + Error(block), npk2) )
summary(npk2.aovE)



base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
cleanEx()
nameEx("mantelhaen.test")
### * mantelhaen.test

flush(stderr()); flush(stdout())

### Name: mantelhaen.test
### Title: Cochran-Mantel-Haenszel Chi-Squared Test for Count Data
### Aliases: mantelhaen.test
### Keywords: htest

### ** Examples

## Agresti (1990), pages 231--237, Penicillin and Rabbits
## Investigation of the effectiveness of immediately injected or 1.5
##  hours delayed penicillin in protecting rabbits against a lethal
##  injection with beta-hemolytic streptococci.
Rabbits <-
array(c(0, 0, 6, 5,
        3, 0, 3, 6,
        6, 2, 0, 4,
        5, 6, 1, 0,
        2, 5, 0, 0),
      dim = c(2, 2, 5),
      dimnames = list(
          Delay = c("None", "1.5h"),
          Response = c("Cured", "Died"),
          Penicillin.Level = c("1/8", "1/4", "1/2", "1", "4")))
Rabbits
## Classical Mantel-Haenszel test
mantelhaen.test(Rabbits)
## => p = 0.047, some evidence for higher cure rate of immediate
##               injection
## Exact conditional test
mantelhaen.test(Rabbits, exact = TRUE)
## => p - 0.040
## Exact conditional test for one-sided alternative of a higher
## cure rate for immediate injection
mantelhaen.test(Rabbits, exact = TRUE, alternative = "greater")
## => p = 0.020

## UC Berkeley Student Admissions
mantelhaen.test(UCBAdmissions)
## No evidence for association between admission and gender
## when adjusted for department.  However,
apply(UCBAdmissions, 3, function(x) (x[1,1]*x[2,2])/(x[1,2]*x[2,1]))
## This suggests that the assumption of homogeneous (conditional)
## odds ratios may be violated.  The traditional approach would be
## using the Woolf test for interaction:
woolf <- function(x) {
  x <- x + 1 / 2
  k <- dim(x)[3]
  or <- apply(x, 3, function(x) (x[1,1]*x[2,2])/(x[1,2]*x[2,1]))
  w <-  apply(x, 3, function(x) 1 / sum(1 / x))
  1 - pchisq(sum(w * (log(or) - weighted.mean(log(or), w)) ^ 2), k - 1)
}
woolf(UCBAdmissions)
## => p = 0.003, indicating that there is significant heterogeneity.
## (And hence the Mantel-Haenszel test cannot be used.)

## Agresti (2002), p. 287f and p. 297.
## Job Satisfaction example.
Satisfaction <-
    as.table(array(c(1, 2, 0, 0, 3, 3, 1, 2,
                     11, 17, 8, 4, 2, 3, 5, 2,
                     1, 0, 0, 0, 1, 3, 0, 1,
                     2, 5, 7, 9, 1, 1, 3, 6),
                   dim = c(4, 4, 2),
                   dimnames =
                   list(Income =
                        c("<5000", "5000-15000",
                          "15000-25000", ">25000"),
                        "Job Satisfaction" =
                        c("V_D", "L_S", "M_S", "V_S"),
                        Gender = c("Female", "Male"))))
## (Satisfaction categories abbreviated for convenience.)
ftable(. ~ Gender + Income, Satisfaction)
## Table 7.8 in Agresti (2002), p. 288.
mantelhaen.test(Satisfaction)
## See Table 7.12 in Agresti (2002), p. 297.



cleanEx()
nameEx("mauchly.test")
### * mauchly.test

flush(stderr()); flush(stdout())

### Name: mauchly.test
### Title: Mauchly's Test of Sphericity
### Aliases: mauchly.test mauchly.test.SSD mauchly.test.mlm
### Keywords: htest models multivariate

### ** Examples

utils::example(SSD) # Brings in the mlmfit and reacttime objects

### traditional test of intrasubj. contrasts
mauchly.test(mlmfit, X = ~1)

### tests using intra-subject 3x2 design
idata <- data.frame(deg = gl(3, 1, 6, labels = c(0,4,8)),
                    noise = gl(2, 3, 6, labels = c("A","P")))
mauchly.test(mlmfit, X = ~ deg + noise, idata = idata)
mauchly.test(mlmfit, M = ~ deg + noise, X = ~ noise, idata = idata)



cleanEx()
nameEx("mcnemar.test")
### * mcnemar.test

flush(stderr()); flush(stdout())

### Name: mcnemar.test
### Title: McNemar's Chi-squared Test for Count Data
### Aliases: mcnemar.test
### Keywords: htest

### ** Examples

## Agresti (1990), p. 350.
## Presidential Approval Ratings.
##  Approval of the President's performance in office in two surveys,
##  one month apart, for a random sample of 1600 voting-age Americans.
Performance <-
matrix(c(794, 86, 150, 570),
       nrow = 2,
       dimnames = list("1st Survey" = c("Approve", "Disapprove"),
                       "2nd Survey" = c("Approve", "Disapprove")))
Performance
mcnemar.test(Performance)
## => significant change (in fact, drop) in approval ratings



cleanEx()
nameEx("median")
### * median

flush(stderr()); flush(stdout())

### Name: median
### Title: Median Value
### Aliases: median median.default
### Keywords: univar robust

### ** Examples

median(1:4)                # = 2.5 [even number]
median(c(1:3, 100, 1000))  # = 3 [odd, robust]



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("medpolish")
### * medpolish

flush(stderr()); flush(stdout())

### Name: medpolish
### Title: Median Polish (Robust Twoway Decomposition) of a Matrix
### Aliases: medpolish
### Keywords: robust

### ** Examples

require(graphics)

## Deaths from sport parachuting;  from ABC of EDA, p.224:
deaths <-
    rbind(c(14,15,14),
          c( 7, 4, 7),
          c( 8, 2,10),
          c(15, 9,10),
          c( 0, 2, 0))
dimnames(deaths) <- list(c("1-24", "25-74", "75-199", "200++", "NA"),
                         paste(1973:1975))
deaths
(med.d <- medpolish(deaths))
plot(med.d)
## Check decomposition:
all(deaths ==
    med.d$overall + outer(med.d$row,med.d$col, "+") + med.d$residuals)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("model.extract")
### * model.extract

flush(stderr()); flush(stdout())

### Name: model.extract
### Title: Extract Components from a Model Frame
### Aliases: model.extract model.offset model.response model.weights
### Keywords: manip programming models

### ** Examples

a <- model.frame(cbind(ncases,ncontrols) ~ agegp + tobgp + alcgp, data = esoph)
model.extract(a, "response")
stopifnot(model.extract(a, "response") == model.response(a))

a <- model.frame(ncases/(ncases+ncontrols) ~ agegp + tobgp + alcgp,
                 data = esoph, weights = ncases+ncontrols)
model.response(a)
model.extract(a, "weights")

a <- model.frame(cbind(ncases,ncontrols) ~ agegp,
                 something = tobgp, data = esoph)
names(a)
stopifnot(model.extract(a, "something") == esoph$tobgp)



cleanEx()
nameEx("model.frame")
### * model.frame

flush(stderr()); flush(stdout())

### Name: model.frame
### Title: Extracting the Model Frame from a Formula or Fit
### Aliases: model.frame model.frame.default model.frame.lm model.frame.glm
###   model.frame.aovlist get_all_vars
### Keywords: models

### ** Examples

data.class(model.frame(dist ~ speed, data = cars))



cleanEx()
nameEx("model.matrix")
### * model.matrix

flush(stderr()); flush(stdout())

### Name: model.matrix
### Title: Construct Design Matrices
### Aliases: model.matrix model.matrix.default model.matrix.lm
### Keywords: models

### ** Examples

ff <- log(Volume) ~ log(Height) + log(Girth)
utils::str(m <- model.frame(ff, trees))
mat <- model.matrix(ff, m)

dd <- data.frame(a = gl(3,4), b = gl(4,1,12)) # balanced 2-way
options("contrasts")
model.matrix(~ a + b, dd)
model.matrix(~ a + b, dd, contrasts = list(a = "contr.sum"))
model.matrix(~ a + b, dd, contrasts = list(a = "contr.sum", b = "contr.poly"))
m.orth <- model.matrix(~a+b, dd, contrasts = list(a = "contr.helmert"))
crossprod(m.orth) # m.orth is  ALMOST  orthogonal



cleanEx()
nameEx("model.tables")
### * model.tables

flush(stderr()); flush(stdout())

### Name: model.tables
### Title: Compute Tables of Results from an Aov Model Fit
### Aliases: model.tables model.tables.aov model.tables.aovlist
### Keywords: models

### ** Examples


if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("monthplot")
### * monthplot

flush(stderr()); flush(stdout())

### Name: monthplot
### Title: Plot a Seasonal or other Subseries from a Time Series
### Aliases: monthplot monthplot.default monthplot.ts monthplot.stl
###   monthplot.StructTS
### Keywords: hplot ts

### ** Examples

require(graphics)

## The CO2 data
fit <- stl(log(co2), s.window = 20, t.window = 20)
plot(fit)
op <- par(mfrow = c(2,2))
monthplot(co2, ylab = "data", cex.axis = 0.8)
monthplot(fit, choice = "seasonal", cex.axis = 0.8)
monthplot(fit, choice = "trend", cex.axis = 0.8)
monthplot(fit, choice = "remainder", type = "h", cex.axis = 0.8)
par(op)

## The CO2 data, grouped quarterly
quarter <- (cycle(co2) - 1) %/% 3
monthplot(co2, phase = quarter)

## see also JohnsonJohnson



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("mood.test")
### * mood.test

flush(stderr()); flush(stdout())

### Name: mood.test
### Title: Mood Two-Sample Test of Scale
### Aliases: mood.test mood.test.default mood.test.formula
### Keywords: htest

### ** Examples

## Same data as for the Ansari-Bradley test:
## Serum iron determination using Hyland control sera
ramsay <- c(111, 107, 100, 99, 102, 106, 109, 108, 104, 99,
            101, 96, 97, 102, 107, 113, 116, 113, 110, 98)
jung.parekh <- c(107, 108, 106, 98, 105, 103, 110, 105, 104,
            100, 96, 108, 103, 104, 114, 114, 113, 108, 106, 99)
mood.test(ramsay, jung.parekh)
## Compare this to ansari.test(ramsay, jung.parekh)



cleanEx()
nameEx("na.action")
### * na.action

flush(stderr()); flush(stdout())

### Name: na.action
### Title: NA Action
### Aliases: na.action na.action.default
### Keywords: NA methods

### ** Examples

na.action(na.omit(c(1, NA)))



cleanEx()
nameEx("na.contiguous")
### * na.contiguous

flush(stderr()); flush(stdout())

### Name: na.contiguous
### Title: Find Longest Contiguous Stretch of non-NAs
### Aliases: na.contiguous na.contiguous.default
### Keywords: ts

### ** Examples

na.contiguous(presidents)



cleanEx()
nameEx("na.fail")
### * na.fail

flush(stderr()); flush(stdout())

### Name: na.fail
### Title: Handle Missing Values in Objects
### Aliases: na.fail na.fail.default na.omit na.omit.data.frame
###   na.omit.default na.exclude na.exclude.data.frame na.exclude.default
###   na.pass
### Keywords: NA

### ** Examples

DF <- data.frame(x = c(1, 2, 3), y = c(0, 10, NA))
na.omit(DF)
m <- as.matrix(DF)
na.omit(m)
stopifnot(all(na.omit(1:3) == 1:3))  # does not affect objects with no NA's
try(na.fail(DF))   #> Error: missing values in ...

options("na.action")



cleanEx()
nameEx("nextn")
### * nextn

flush(stderr()); flush(stdout())

### Name: nextn
### Title: Highly Composite Numbers
### Aliases: nextn
### Keywords: math

### ** Examples

nextn(1001) # 1024
table(sapply(599:630, nextn))



cleanEx()
nameEx("nlm")
### * nlm

flush(stderr()); flush(stdout())

### Name: nlm
### Title: Non-Linear Minimization
### Aliases: nlm
### Keywords: nonlinear optimize

### ** Examples

f <- function(x) sum((x-1:length(x))^2)
nlm(f, c(10,10))
nlm(f, c(10,10), print.level = 2)
utils::str(nlm(f, c(5), hessian = TRUE))

f <- function(x, a) sum((x-a)^2)
nlm(f, c(10,10), a = c(3,5))
f <- function(x, a)
{
    res <- sum((x-a)^2)
    attr(res, "gradient") <- 2*(x-a)
    res
}
nlm(f, c(10,10), a = c(3,5))

## more examples, including the use of derivatives.
## Not run: demo(nlm)



cleanEx()
nameEx("nlminb")
### * nlminb

flush(stderr()); flush(stdout())

### Name: nlminb
### Title: Optimization using PORT routines
### Aliases: nlminb
### Keywords: optimize

### ** Examples


if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("nls")
### * nls

flush(stderr()); flush(stdout())

### Name: nls
### Title: Nonlinear Least Squares
### Aliases: nls
### Keywords: nonlinear regression models

### ** Examples

## Don't show: 
od <- options(digits=5)
## End(Don't show)
require(graphics)

DNase1 <- subset(DNase, Run == 1)

## using a selfStart model
fm1DNase1 <- nls(density ~ SSlogis(log(conc), Asym, xmid, scal), DNase1)
summary(fm1DNase1)
## the coefficients only:
coef(fm1DNase1)
## including their SE, etc:
coef(summary(fm1DNase1))

## using conditional linearity
fm2DNase1 <- nls(density ~ 1/(1 + exp((xmid - log(conc))/scal)),
                 data = DNase1,
                 start = list(xmid = 0, scal = 1),
                 algorithm = "plinear")
summary(fm2DNase1)

## without conditional linearity
fm3DNase1 <- nls(density ~ Asym/(1 + exp((xmid - log(conc))/scal)),
                 data = DNase1,
                 start = list(Asym = 3, xmid = 0, scal = 1))
summary(fm3DNase1)

## using Port's nl2sol algorithm
fm4DNase1 <- nls(density ~ Asym/(1 + exp((xmid - log(conc))/scal)),
                 data = DNase1,
                 start = list(Asym = 3, xmid = 0, scal = 1),
                 algorithm = "port")
summary(fm4DNase1)

## weighted nonlinear regression
Treated <- Puromycin[Puromycin$state == "treated", ]
weighted.MM <- function(resp, conc, Vm, K)
{
    ## Purpose: exactly as white book p. 451 -- RHS for nls()
    ##  Weighted version of Michaelis-Menten model
    ## ----------------------------------------------------------
    ## Arguments: 'y', 'x' and the two parameters (see book)
    ## ----------------------------------------------------------
    ## Author: Martin Maechler, Date: 23 Mar 2001

    pred <- (Vm * conc)/(K + conc)
    (resp - pred) / sqrt(pred)
}

Pur.wt <- nls( ~ weighted.MM(rate, conc, Vm, K), data = Treated,
              start = list(Vm = 200, K = 0.1))
summary(Pur.wt)

## Passing arguments using a list that can not be coerced to a data.frame
lisTreat <- with(Treated,
                 list(conc1 = conc[1], conc.1 = conc[-1], rate = rate))

weighted.MM1 <- function(resp, conc1, conc.1, Vm, K)
{
     conc <- c(conc1, conc.1)
     pred <- (Vm * conc)/(K + conc)
    (resp - pred) / sqrt(pred)
}
Pur.wt1 <- nls( ~ weighted.MM1(rate, conc1, conc.1, Vm, K),
               data = lisTreat, start = list(Vm = 200, K = 0.1))
stopifnot(all.equal(coef(Pur.wt), coef(Pur.wt1)))

## Chambers and Hastie (1992) Statistical Models in S  (p. 537):
## If the value of the right side [of formula] has an attribute called
## 'gradient' this should be a matrix with the number of rows equal
## to the length of the response and one column for each parameter.

weighted.MM.grad <- function(resp, conc1, conc.1, Vm, K)
{
  conc <- c(conc1, conc.1)

  K.conc <- K+conc
  dy.dV <- conc/K.conc
  dy.dK <- -Vm*dy.dV/K.conc
  pred <- Vm*dy.dV
  pred.5 <- sqrt(pred)
  dev <- (resp - pred) / pred.5
  Ddev <- -0.5*(resp+pred)/(pred.5*pred)
  attr(dev, "gradient") <- Ddev * cbind(Vm = dy.dV, K = dy.dK)
  dev
}

Pur.wt.grad <- nls( ~ weighted.MM.grad(rate, conc1, conc.1, Vm, K),
                   data = lisTreat, start = list(Vm = 200, K = 0.1))

rbind(coef(Pur.wt), coef(Pur.wt1), coef(Pur.wt.grad))

## In this example, there seems no advantage to providing the gradient.
## In other cases, there might be.


## The two examples below show that you can fit a model to
## artificial data with noise but not to artificial data
## without noise.
x <- 1:10
y <- 2*x + 3                            # perfect fit
yeps <- y + rnorm(length(y), sd = 0.01) # added noise
nls(yeps ~ a + b*x, start = list(a = 0.12345, b = 0.54321))
## terminates in an error, because convergence cannot be confirmed:
try(nls(y ~ a + b*x, start = list(a = 0.12345, b = 0.54321)))

## the nls() internal cheap guess for starting values can be sufficient:

x <- -(1:100)/10
y <- 100 + 10 * exp(x / 2) + rnorm(x)/10
nlmod <- nls(y ~  Const + A * exp(B * x))

plot(x,y, main = "nls(*), data, true function and fit, n=100")
curve(100 + 10 * exp(x / 2), col = 4, add = TRUE)
lines(x, predict(nlmod), col = 2)


## Don't show: 
options(od)
## End(Don't show)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("nls.control")
### * nls.control

flush(stderr()); flush(stdout())

### Name: nls.control
### Title: Control the Iterations in nls
### Aliases: nls.control
### Keywords: nonlinear regression models

### ** Examples

nls.control(minFactor = 1/2048)



cleanEx()
nameEx("numericDeriv")
### * numericDeriv

flush(stderr()); flush(stdout())

### Name: numericDeriv
### Title: Evaluate Derivatives Numerically
### Aliases: numericDeriv
### Keywords: models

### ** Examples

## Don't show: 
od <- options(digits = 4)
## End(Don't show)
myenv <- new.env()
assign("mean", 0., envir = myenv)
assign("sd", 1., envir = myenv)
assign("x", seq(-3., 3., len = 31), envir = myenv)
numericDeriv(quote(pnorm(x, mean, sd)), c("mean", "sd"), myenv)
## Don't show: 
options(od)
## End(Don't show)



cleanEx()
nameEx("oneway.test")
### * oneway.test

flush(stderr()); flush(stdout())

### Name: oneway.test
### Title: Test for Equal Means in a One-Way Layout
### Aliases: oneway.test
### Keywords: htest

### ** Examples

## Not assuming equal variances
oneway.test(extra ~ group, data = sleep)
## Assuming equal variances
oneway.test(extra ~ group, data = sleep, var.equal = TRUE)
## which gives the same result as
anova(lm(extra ~ group, data = sleep))



cleanEx()
nameEx("optim")
### * optim

flush(stderr()); flush(stdout())

### Name: optim
### Title: General-purpose Optimization
### Aliases: optim optimHess
### Keywords: nonlinear optimize

### ** Examples


if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("optimize")
### * optimize

flush(stderr()); flush(stdout())

### Name: optimize
### Title: One Dimensional Optimization
### Aliases: optimize optimise
### Keywords: optimize

### ** Examples

require(graphics)

f <- function (x, a) (x - a)^2
xmin <- optimize(f, c(0, 1), tol = 0.0001, a = 1/3)
xmin

## See where the function is evaluated:
optimize(function(x) x^2*(print(x)-1), lower = 0, upper = 10)

## "wrong" solution with unlucky interval and piecewise constant f():
f  <- function(x) ifelse(x > -1, ifelse(x < 4, exp(-1/abs(x - 1)), 10), 10)
fp <- function(x) { print(x); f(x) }

plot(f, -2,5, ylim = 0:1, col = 2)
optimize(fp, c(-4, 20))   # doesn't see the minimum
optimize(fp, c(-7, 20))   # ok



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("order.dendrogram")
### * order.dendrogram

flush(stderr()); flush(stdout())

### Name: order.dendrogram
### Title: Ordering or Labels of the Leaves in a Dendrogram
### Aliases: order.dendrogram labels.dendrogram
### Keywords: manip

### ** Examples

set.seed(123)
x <- rnorm(10)
hc <- hclust(dist(x))
hc$order
dd <- as.dendrogram(hc)
order.dendrogram(dd) ## the same :
stopifnot(hc$order == order.dendrogram(dd))

d2 <- as.dendrogram(hclust(dist(USArrests)))
labels(d2) ## in this case the same as
stopifnot(identical(labels(d2),
   rownames(USArrests)[order.dendrogram(d2)]))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("p.adjust")
### * p.adjust

flush(stderr()); flush(stdout())

### Name: p.adjust
### Title: Adjust P-values for Multiple Comparisons
### Aliases: p.adjust p.adjust.methods
### Keywords: htest

### ** Examples

require(graphics)

set.seed(123)
x <- rnorm(50, mean = c(rep(0, 25), rep(3, 25)))
p <- 2*pnorm(sort(-abs(x)))

round(p, 3)
round(p.adjust(p), 3)
round(p.adjust(p, "BH"), 3)

## or all of them at once (dropping the "fdr" alias):
p.adjust.M <- p.adjust.methods[p.adjust.methods != "fdr"]
p.adj    <- sapply(p.adjust.M, function(meth) p.adjust(p, meth))
p.adj.60 <- sapply(p.adjust.M, function(meth) p.adjust(p, meth, n = 60))
stopifnot(identical(p.adj[,"none"], p), p.adj <= p.adj.60)
round(p.adj, 3)
## or a bit nicer:
noquote(apply(p.adj, 2, format.pval, digits = 3))


## and a graphic:
matplot(p, p.adj, ylab="p.adjust(p, meth)", type = "l", asp = 1, lty = 1:6,
        main = "P-value adjustments")
legend(0.7, 0.6, p.adjust.M, col = 1:6, lty = 1:6)

## Can work with NA's:
pN <- p; iN <- c(46, 47); pN[iN] <- NA
pN.a <- sapply(p.adjust.M, function(meth) p.adjust(pN, meth))
## The smallest 20 P-values all affected by the NA's :
round((pN.a / p.adj)[1:20, ] , 4)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("pairwise.prop.test")
### * pairwise.prop.test

flush(stderr()); flush(stdout())

### Name: pairwise.prop.test
### Title: Pairwise comparisons for proportions
### Aliases: pairwise.prop.test
### Keywords: htest

### ** Examples

smokers  <- c( 83, 90, 129, 70 )
patients <- c( 86, 93, 136, 82 )
pairwise.prop.test(smokers, patients)



cleanEx()
nameEx("pairwise.t.test")
### * pairwise.t.test

flush(stderr()); flush(stdout())

### Name: pairwise.t.test
### Title: Pairwise t tests
### Aliases: pairwise.t.test
### Keywords: htest

### ** Examples

attach(airquality)
Month <- factor(Month, labels = month.abb[5:9])
pairwise.t.test(Ozone, Month)
pairwise.t.test(Ozone, Month, p.adj = "bonf")
pairwise.t.test(Ozone, Month, pool.sd = FALSE)
detach()



cleanEx()
nameEx("pairwise.wilcox.test")
### * pairwise.wilcox.test

flush(stderr()); flush(stdout())

### Name: pairwise.wilcox.test
### Title: Pairwise Wilcoxon Rank Sum Tests
### Aliases: pairwise.wilcox.test
### Keywords: htest

### ** Examples

attach(airquality)
Month <- factor(Month, labels = month.abb[5:9])
## These give warnings because of ties :
pairwise.wilcox.test(Ozone, Month)
pairwise.wilcox.test(Ozone, Month, p.adj = "bonf")
detach()



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("plot.acf")
### * plot.acf

flush(stderr()); flush(stdout())

### Name: plot.acf
### Title: Plot Autocovariance and Autocorrelation Functions
### Aliases: plot.acf
### Keywords: hplot ts

### ** Examples

require(graphics)

z4  <- ts(matrix(rnorm(400), 100, 4), start = c(1961, 1), frequency = 12)
z7  <- ts(matrix(rnorm(700), 100, 7), start = c(1961, 1), frequency = 12)
acf(z4)
acf(z7, max.mfrow = 7)   # squeeze onto 1 page
acf(z7) # multi-page



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("plot.isoreg")
### * plot.isoreg

flush(stderr()); flush(stdout())

### Name: plot.isoreg
### Title: Plot Method for isoreg Objects
### Aliases: plot.isoreg lines.isoreg
### Keywords: hplot print

### ** Examples

require(graphics)

utils::example(isoreg) # for the examples there

plot(y3, main = "simple plot(.)  +  lines(<isoreg>)")
lines(ir3)

## 'same' plot as above, "proving" that only ranks of 'x' are important
plot(isoreg(2^(1:9), c(1,0,4,3,3,5,4,2,0)), plot.type = "row", log = "x")

plot(ir3, plot.type = "row", ylab = "y3")
plot(isoreg(y3 - 4), plot.t="r", ylab = "y3 - 4")
plot(ir4, plot.type = "ro",  ylab = "y4", xlab = "x = 1:n")

## experiment a bit with these (C-c C-j):
plot(isoreg(sample(9),  y3), plot.type = "row")
plot(isoreg(sample(9),  y3), plot.type = "col.wise")

plot(ir <- isoreg(sample(10), sample(10, replace = TRUE)),
                  plot.type = "r")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("plot.lm")
### * plot.lm

flush(stderr()); flush(stdout())

### Name: plot.lm
### Title: Plot Diagnostics for an lm Object
### Aliases: plot.lm
### Keywords: hplot regression

### ** Examples

require(graphics)

## Analysis of the life-cycle savings data
## given in Belsley, Kuh and Welsch.
lm.SR <- lm(sr ~ pop15 + pop75 + dpi + ddpi, data = LifeCycleSavings)
plot(lm.SR)

## 4 plots on 1 page;
## allow room for printing model formula in outer margin:
par(mfrow = c(2, 2), oma = c(0, 0, 2, 0))
plot(lm.SR)
plot(lm.SR, id.n = NULL)                 # no id's
plot(lm.SR, id.n = 5, labels.id = NULL)  # 5 id numbers

## Was default in R <= 2.1.x:
## Cook's distances instead of Residual-Leverage plot
plot(lm.SR, which = 1:4)

## Fit a smooth curve, where applicable:
plot(lm.SR, panel = panel.smooth)
## Gives a smoother curve
plot(lm.SR, panel = function(x, y) panel.smooth(x, y, span = 1))

par(mfrow = c(2,1))  # same oma as above
plot(lm.SR, which = 1:2, sub.caption = "Saving Rates, n=50, p=5")

## Don't show: 
## An example with *long* formula that needs abbreviation:
for(i in 1:5) assign(paste("long.var.name", i, sep = "."), runif(10))
plot(lm(long.var.name.1 ~
        long.var.name.2 + long.var.name.3 + long.var.name.4 + long.var.name.5))
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("plot.ppr")
### * plot.ppr

flush(stderr()); flush(stdout())

### Name: plot.ppr
### Title: Plot Ridge Functions for Projection Pursuit Regression Fit
### Aliases: plot.ppr
### Keywords: hplot

### ** Examples

require(graphics)

rock1 <- within(rock, { area1 <- area/10000; peri1 <- peri/10000 })
par(mfrow = c(3,2)) # maybe: , pty = "s")
rock.ppr <- ppr(log(perm) ~ area1 + peri1 + shape,
                data = rock1, nterms = 2, max.terms = 5)
plot(rock.ppr, main = "ppr(log(perm)~ ., nterms=2, max.terms=5)")
plot(update(rock.ppr, bass = 5), main = "update(..., bass = 5)")
plot(update(rock.ppr, sm.method = "gcv", gcvpen = 2),
     main = "update(..., sm.method=\"gcv\", gcvpen=2)")



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("plot.profile.nls")
### * plot.profile.nls

flush(stderr()); flush(stdout())

### Name: plot.profile.nls
### Title: Plot a profile.nls Object
### Aliases: plot.profile.nls
### Keywords: nonlinear regression models

### ** Examples

require(graphics)

# obtain the fitted object
fm1 <- nls(demand ~ SSasympOrig(Time, A, lrc), data = BOD)
# get the profile for the fitted model
pr1 <- profile(fm1, alpha = 0.05)
opar <- par(mfrow = c(2,2), oma = c(1.1, 0, 1.1, 0), las = 1)
plot(pr1, conf = c(95, 90, 80, 50)/100)
plot(pr1, conf = c(95, 90, 80, 50)/100, absVal = FALSE)
mtext("Confidence intervals based on the profile sum of squares",
      side = 3, outer = TRUE)
mtext("BOD data - confidence levels of 50%, 80%, 90% and 95%",
      side = 1, outer = TRUE)
par(opar)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("plot.stepfun")
### * plot.stepfun

flush(stderr()); flush(stdout())

### Name: plot.stepfun
### Title: Plot Step Functions
### Aliases: plot.stepfun lines.stepfun
### Keywords: hplot

### ** Examples

require(graphics)

y0 <- c(1,2,4,3)
sfun0  <- stepfun(1:3, y0, f = 0)
sfun.2 <- stepfun(1:3, y0, f = .2)
sfun1  <- stepfun(1:3, y0, right = TRUE)

tt <- seq(0, 3, by = 0.1)
op <- par(mfrow = c(2,2))
plot(sfun0); plot(sfun0, xval = tt, add = TRUE, col.hor = "bisque")
plot(sfun.2);plot(sfun.2, xval = tt, add = TRUE, col = "orange") # all colors
plot(sfun1);lines(sfun1, xval = tt, col.hor = "coral")
##-- This is  revealing :
plot(sfun0, verticals = FALSE,
     main = "stepfun(x, y0, f=f)  for f = 0, .2, 1")
for(i in 1:3)
  lines(list(sfun0, sfun.2, stepfun(1:3, y0, f = 1))[[i]], col = i)
legend(2.5, 1.9, paste("f =", c(0, 0.2, 1)), col = 1:3, lty = 1, y.intersp = 1)
par(op)

# Extend and/or restrict 'viewport':
plot(sfun0, xlim = c(0,5), ylim = c(0, 3.5),
     main = "plot(stepfun(*), xlim= . , ylim = .)")

##-- this works too (automatic call to  ecdf(.)):
plot.stepfun(rt(50, df = 3), col.vert = "gray20")



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("plot.ts")
### * plot.ts

flush(stderr()); flush(stdout())

### Name: plot.ts
### Title: Plotting Time-Series Objects
### Aliases: plot.ts lines.ts
### Keywords: hplot ts

### ** Examples

require(graphics)

## Multivariate
z <- ts(matrix(rt(200 * 8, df = 3), 200, 8),
        start = c(1961, 1), frequency = 12)
plot(z, yax.flip = TRUE)
plot(z, axes = FALSE, ann = FALSE, frame.plot = TRUE,
     mar.multi = c(0,0,0,0), oma.multi = c(1,1,5,1))
title("plot(ts(..), axes=FALSE, ann=FALSE, frame.plot=TRUE, mar..., oma...)")

z <- window(z[,1:3], end = c(1969,12))
plot(z, type = "b")    # multiple
plot(z, plot.type = "single", lty = 1:3, col = 4:2)

## A phase plot:
plot(nhtemp, lag(nhtemp, 1), cex = .8, col = "blue",
     main = "Lag plot of New Haven temperatures")

## xy.lines and xy.labels are FALSE for large series:
plot(lag(sunspots, 1), sunspots, pch = ".")

SMI <- EuStockMarkets[, "SMI"]
plot(lag(SMI,  1), SMI, pch = ".")
plot(lag(SMI, 20), SMI, pch = ".", log = "xy",
     main = "4 weeks lagged SMI stocks -- log scale", xy.lines =  TRUE)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("poisson.test")
### * poisson.test

flush(stderr()); flush(stdout())

### Name: poisson.test
### Title: Exact Poisson tests
### Aliases: poisson.test
### Keywords: htest

### ** Examples

### These are paraphrased from data sets in the ISwR package

## SMR, Welsh Nickel workers
poisson.test(137, 24.19893)

## eba1977, compare Fredericia to other three cities for ages 55-59
poisson.test(c(11, 6+8+7), c(800, 1083+1050+878))



cleanEx()
nameEx("poly")
### * poly

flush(stderr()); flush(stdout())

### Name: poly
### Title: Compute Orthogonal Polynomials
### Aliases: poly polym predict.poly makepredictcall.poly
### Keywords: math

### ** Examples

od <- options(digits = 3) # avoid too much visual clutter
(z <- poly(1:10, 3))
predict(z, seq(2, 4, 0.5))
zapsmall(poly(seq(4, 6, 0.5), 3, coefs = attr(z, "coefs")))

 zm <- zapsmall(polym (    1:4, c(1, 4:6),  degree = 3)) # or just poly():
(z1 <- zapsmall(poly(cbind(1:4, c(1, 4:6)), degree = 3)))
## they are the same :
stopifnot(all.equal(zm, z1, tol = 1e-15))
options(od)



cleanEx()
nameEx("power")
### * power

flush(stderr()); flush(stdout())

### Name: power
### Title: Create a Power Link Object
### Aliases: power
### Keywords: models

### ** Examples

power()
quasi(link = power(1/3))[c("linkfun", "linkinv")]



cleanEx()
nameEx("power.anova.test")
### * power.anova.test

flush(stderr()); flush(stdout())

### Name: power.anova.test
### Title: Power Calculations for Balanced One-Way Analysis of Variance
###   Tests
### Aliases: power.anova.test
### Keywords: htest

### ** Examples

power.anova.test(groups = 4, n = 5, between.var = 1, within.var = 3)
# Power = 0.3535594

power.anova.test(groups = 4, between.var = 1, within.var = 3,
                 power = .80)
# n = 11.92613

## Assume we have prior knowledge of the group means:
groupmeans <- c(120, 130, 140, 150)
power.anova.test(groups = length(groupmeans),
                 between.var = var(groupmeans),
                 within.var = 500, power = .90) # n = 15.18834



cleanEx()
nameEx("power.prop.test")
### * power.prop.test

flush(stderr()); flush(stdout())

### Name: power.prop.test
### Title: Power Calculations for Two-Sample Test for Proportions
### Aliases: power.prop.test
### Keywords: htest

### ** Examples

power.prop.test(n = 50, p1 = .50, p2 = .75)      ## => power = 0.740
power.prop.test(p1 = .50, p2 = .75, power = .90) ## =>     n = 76.7
power.prop.test(n = 50, p1 = .5, power = .90)    ## =>    p2 = 0.8026
power.prop.test(n = 50, p1 = .5, p2 = 0.9, power = .90, sig.level=NULL)
                                                 ## => sig.l = 0.00131
power.prop.test(p1 = .5, p2 = 0.501, sig.level=.001, power=0.90)
                                                 ## => n = 10451937



cleanEx()
nameEx("power.t.test")
### * power.t.test

flush(stderr()); flush(stdout())

### Name: power.t.test
### Title: Power calculations for one and two sample t tests
### Aliases: power.t.test
### Keywords: htest

### ** Examples

 power.t.test(n = 20, delta = 1)
 power.t.test(power = .90, delta = 1)
 power.t.test(power = .90, delta = 1, alternative = "one.sided")



cleanEx()
nameEx("pp.test")
### * pp.test

flush(stderr()); flush(stdout())

### Name: PP.test
### Title: Phillips-Perron Test for Unit Roots
### Aliases: PP.test
### Keywords: ts

### ** Examples

x <- rnorm(1000)
PP.test(x)
y <- cumsum(x) # has unit root
PP.test(y)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ppoints")
### * ppoints

flush(stderr()); flush(stdout())

### Name: ppoints
### Title: Ordinates for Probability Plotting
### Aliases: ppoints
### Keywords: dplot arith distribution

### ** Examples

ppoints(4) # the same as  ppoints(1:4)
ppoints(10)
ppoints(10, a = 1/2)

## Visualize including the fractions :
require(graphics)## Don't show: 
lNs <- loadedNamespaces()
## End(Don't show)
p.ppoints <- function(n, ..., add = FALSE, col = par("col")) {
  pn <- ppoints(n, ...)
  if(add)
      points(pn, pn, col = col)
  else {
      tit <- match.call(); tit[[1]] <- quote(ppoints)
      plot(pn,pn, main = deparse(tit), col=col,
           xlim = 0:1, ylim = 0:1, xaxs = "i", yaxs = "i")
      abline(0, 1, col = adjustcolor(1, 1/4), lty = 3)
  }
  if(!add && requireNamespace("MASS", quietly = TRUE))
    text(pn, pn, as.character(MASS::fractions(pn)),
         adj = c(0,0)-1/4, cex = 3/4, xpd = NA, col=col)
  abline(h = pn, v = pn, col = adjustcolor(col, 1/2), lty = 2, lwd = 1/2)
}

p.ppoints(4)
p.ppoints(10)
p.ppoints(10, a = 1/2)
p.ppoints(21)
p.ppoints(8) ; p.ppoints(8, a = 1/2, add=TRUE, col="tomato")
## Don't show: 
if(!any("MASS" == lNs)) unloadNamespace("MASS")
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ppr")
### * ppr

flush(stderr()); flush(stdout())

### Name: ppr
### Title: Projection Pursuit Regression
### Aliases: ppr ppr.default ppr.formula
### Keywords: regression

### ** Examples

require(graphics)

# Note: your numerical values may differ
attach(rock)
area1 <- area/10000; peri1 <- peri/10000
rock.ppr <- ppr(log(perm) ~ area1 + peri1 + shape,
                data = rock, nterms = 2, max.terms = 5)
rock.ppr
# Call:
# ppr.formula(formula = log(perm) ~ area1 + peri1 + shape, data = rock,
#     nterms = 2, max.terms = 5)
#
# Goodness of fit:
#  2 terms  3 terms  4 terms  5 terms
# 8.737806 5.289517 4.745799 4.490378

summary(rock.ppr)
# .....  (same as above)
# .....
#
# Projection direction vectors ('alpha'):
#       term 1      term 2
# area1  0.34357179  0.37071027
# peri1 -0.93781471 -0.61923542
# shape  0.04961846  0.69218595
#
# Coefficients of ridge terms:
#    term 1    term 2
# 1.6079271 0.5460971

par(mfrow = c(3,2))   # maybe: , pty = "s")
plot(rock.ppr, main = "ppr(log(perm)~ ., nterms=2, max.terms=5)")
plot(update(rock.ppr, bass = 5), main = "update(..., bass = 5)")
plot(update(rock.ppr, sm.method = "gcv", gcvpen = 2),
     main = "update(..., sm.method=\"gcv\", gcvpen=2)")
cbind(perm = rock$perm, prediction = round(exp(predict(rock.ppr)), 1))
detach()



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("prcomp")
### * prcomp

flush(stderr()); flush(stdout())

### Name: prcomp
### Title: Principal Components Analysis
### Aliases: prcomp prcomp.formula prcomp.default plot.prcomp
###   predict.prcomp print.prcomp summary.prcomp print.summary.prcomp
### Keywords: multivariate

### ** Examples

C <- chol(S <- toeplitz(.9 ^ (0:31))) # Cov.matrix and its root
all.equal(S, crossprod(C))
set.seed(17)
X <- matrix(rnorm(32000), 1000, 32)
Z <- X %*% C  ## ==>  cov(Z) ~=  C'C = S
all.equal(cov(Z), S, tol = 0.08)
pZ <- prcomp(Z, tol = 0.1)
summary(pZ) # only ~14 PCs (out of 32)
## or choose only 3 PCs more directly:
pz3 <- prcomp(Z, rank. = 3)
summary(pz3) # same numbers as the first 3 above
stopifnot(ncol(pZ$rotation) == 14, ncol(pz3$rotation) == 3,
          all.equal(pz3$sdev, pZ$sdev, tol = 1e-15)) # exactly equal typically




if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("predict.HoltWinters")
### * predict.HoltWinters

flush(stderr()); flush(stdout())

### Name: predict.HoltWinters
### Title: Prediction Function for Fitted Holt-Winters Models
### Aliases: predict.HoltWinters
### Keywords: ts

### ** Examples

require(graphics)

m <- HoltWinters(co2)
p <- predict(m, 50, prediction.interval = TRUE)
plot(m, p)



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("predict")
### * predict

flush(stderr()); flush(stdout())

### Name: predict
### Title: Model Predictions
### Aliases: predict
### Keywords: methods

### ** Examples

## Don't show: 
old <- Sys.setlocale("LC_COLLATE", "C")
## End(Don't show)
require(utils)

## All the "predict" methods found
## NB most of the methods in the standard packages are hidden.
## Output will depend on what namespaces are (or have been) loaded.
## IGNORE_RDIFF_BEGIN
for(fn in methods("predict"))
   try({
       f <- eval(substitute(getAnywhere(fn)$objs[[1]], list(fn = fn)))
       cat(fn, ":\n\t", deparse(args(f)), "\n")
       }, silent = TRUE)
## IGNORE_RDIFF_END
## Don't show: 
old <- Sys.setlocale("LC_COLLATE", old)
## End(Don't show)



cleanEx()
nameEx("predict.arima")
### * predict.arima

flush(stderr()); flush(stdout())

### Name: predict.Arima
### Title: Forecast from ARIMA fits
### Aliases: predict.Arima
### Keywords: ts

### ** Examples

od <- options(digits = 5) # avoid too much spurious accuracy
predict(arima(lh, order = c(3,0,0)), n.ahead = 12)

(fit <- arima(USAccDeaths, order = c(0,1,1),
              seasonal = list(order = c(0,1,1))))
predict(fit, n.ahead = 6)
options(od)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("predict.glm")
### * predict.glm

flush(stderr()); flush(stdout())

### Name: predict.glm
### Title: Predict Method for GLM Fits
### Aliases: predict.glm
### Keywords: models regression

### ** Examples

require(graphics)

## example from Venables and Ripley (2002, pp. 190-2.)
ldose <- rep(0:5, 2)
numdead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
sex <- factor(rep(c("M", "F"), c(6, 6)))
SF <- cbind(numdead, numalive = 20-numdead)
budworm.lg <- glm(SF ~ sex*ldose, family = binomial)
summary(budworm.lg)

plot(c(1,32), c(0,1), type = "n", xlab = "dose",
     ylab = "prob", log = "x")
text(2^ldose, numdead/20, as.character(sex))
ld <- seq(0, 5, 0.1)
lines(2^ld, predict(budworm.lg, data.frame(ldose = ld,
   sex = factor(rep("M", length(ld)), levels = levels(sex))),
   type = "response"))
lines(2^ld, predict(budworm.lg, data.frame(ldose = ld,
   sex = factor(rep("F", length(ld)), levels = levels(sex))),
   type = "response"))



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("predict.lm")
### * predict.lm

flush(stderr()); flush(stdout())

### Name: predict.lm
### Title: Predict method for Linear Model Fits
### Aliases: predict.lm
### Keywords: regression

### ** Examples

require(graphics)

## Predictions
x <- rnorm(15)
y <- x + rnorm(15)
predict(lm(y ~ x))
new <- data.frame(x = seq(-3, 3, 0.5))
predict(lm(y ~ x), new, se.fit = TRUE)
pred.w.plim <- predict(lm(y ~ x), new, interval = "prediction")
pred.w.clim <- predict(lm(y ~ x), new, interval = "confidence")
matplot(new$x, cbind(pred.w.clim, pred.w.plim[,-1]),
        lty = c(1,2,2,3,3), type = "l", ylab = "predicted y")

## Prediction intervals, special cases
##  The first three of these throw warnings
w <- 1 + x^2
fit <- lm(y ~ x)
wfit <- lm(y ~ x, weights = w)
predict(fit, interval = "prediction")
predict(wfit, interval = "prediction")
predict(wfit, new, interval = "prediction")
predict(wfit, new, interval = "prediction", weights = (new$x)^2)
predict(wfit, new, interval = "prediction", weights = ~x^2)

##-- From  aov(.) example ---- predict(.. terms)
npk.aov <- aov(yield ~ block + N*P*K, npk)
(termL <- attr(terms(npk.aov), "term.labels"))
(pt <- predict(npk.aov, type = "terms"))
pt. <- predict(npk.aov, type = "terms", terms = termL[1:4])
stopifnot(all.equal(pt[,1:4], pt.,
                    tolerance = 1e-12, check.attributes = FALSE))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("predict.loess")
### * predict.loess

flush(stderr()); flush(stdout())

### Name: predict.loess
### Title: Predict Loess Curve or Surface
### Aliases: predict.loess
### Keywords: smooth

### ** Examples

cars.lo <- loess(dist ~ speed, cars)
predict(cars.lo, data.frame(speed = seq(5, 30, 1)), se = TRUE)
# to get extrapolation
cars.lo2 <- loess(dist ~ speed, cars,
  control = loess.control(surface = "direct"))
predict(cars.lo2, data.frame(speed = seq(5, 30, 1)), se = TRUE)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("predict.nls")
### * predict.nls

flush(stderr()); flush(stdout())

### Name: predict.nls
### Title: Predicting from Nonlinear Least Squares Fits
### Aliases: predict.nls
### Keywords: nonlinear regression models

### ** Examples

## Don't show: 
od <- options(digits = 5)
## End(Don't show)
require(graphics)

fm <- nls(demand ~ SSasympOrig(Time, A, lrc), data = BOD)
predict(fm)              # fitted values at observed times
## Form data plot and smooth line for the predictions
opar <- par(las = 1)
plot(demand ~ Time, data = BOD, col = 4,
     main = "BOD data and fitted first-order curve",
     xlim = c(0,7), ylim = c(0, 20) )
tt <- seq(0, 8, length = 101)
lines(tt, predict(fm, list(Time = tt)))
par(opar)
## Don't show: 
options(od)
## End(Don't show)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("predict.smooth.spline")
### * predict.smooth.spline

flush(stderr()); flush(stdout())

### Name: predict.smooth.spline
### Title: Predict from Smoothing Spline Fit
### Aliases: predict.smooth.spline
### Keywords: smooth

### ** Examples

require(graphics)

attach(cars)
cars.spl <- smooth.spline(speed, dist, df = 6.4)
## Don't show: 
print.default(cars.spl)
## End(Don't show)

## "Proof" that the derivatives are okay, by comparing with approximation
diff.quot <- function(x, y) {
  ## Difference quotient (central differences where available)
  n <- length(x); i1 <- 1:2; i2 <- (n-1):n
  c(diff(y[i1]) / diff(x[i1]), (y[-i1] - y[-i2]) / (x[-i1] - x[-i2]),
    diff(y[i2]) / diff(x[i2]))
}

xx <- unique(sort(c(seq(0, 30, by = .2), kn <- unique(speed))))
i.kn <- match(kn, xx)   # indices of knots within xx
op <- par(mfrow = c(2,2))
plot(speed, dist, xlim = range(xx), main = "Smooth.spline & derivatives")
lines(pp <- predict(cars.spl, xx), col = "red")
points(kn, pp$y[i.kn], pch = 3, col = "dark red")
mtext("s(x)", col = "red")
for(d in 1:3){
  n <- length(pp$x)
  plot(pp$x, diff.quot(pp$x,pp$y), type = "l", xlab = "x", ylab = "",
       col = "blue", col.main = "red",
       main = paste0("s" ,paste(rep("'", d), collapse = ""), "(x)"))
  mtext("Difference quotient approx.(last)", col = "blue")
  lines(pp <- predict(cars.spl, xx, deriv = d), col = "red")
## Don't show: 
  print(pp)
## End(Don't show)
  points(kn, pp$y[i.kn], pch = 3, col = "dark red")
  abline(h = 0, lty = 3, col = "gray")
}
detach(); par(op)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("princomp")
### * princomp

flush(stderr()); flush(stdout())

### Name: princomp
### Title: Principal Components Analysis
### Aliases: princomp princomp.formula princomp.default plot.princomp
###   print.princomp predict.princomp
### Keywords: multivariate

### ** Examples

require(graphics)

## The variances of the variables in the
## USArrests data vary by orders of magnitude, so scaling is appropriate
(pc.cr <- princomp(USArrests))  # inappropriate
princomp(USArrests, cor = TRUE) # =^= prcomp(USArrests, scale=TRUE)
## Similar, but different:
## The standard deviations differ by a factor of sqrt(49/50)

summary(pc.cr <- princomp(USArrests, cor = TRUE))
loadings(pc.cr)  # note that blank entries are small but not zero
## The signs of the columns are arbitrary
plot(pc.cr) # shows a screeplot.
biplot(pc.cr)

## Formula interface
princomp(~ ., data = USArrests, cor = TRUE)

## NA-handling
USArrests[1, 2] <- NA
pc.cr <- princomp(~ Murder + Assault + UrbanPop,
                  data = USArrests, na.action = na.exclude, cor = TRUE)

## (Simple) Robust PCA:
## Classical:
(pc.cl  <- princomp(stackloss))


} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("print.power.htest")
### * print.power.htest

flush(stderr()); flush(stdout())

### Name: print.power.htest
### Title: Print Methods for Hypothesis Tests and Power Calculation Objects
### Aliases: print.htest print.power.htest
### Keywords: htest

### ** Examples

(ptt <- power.t.test(n = 20, delta = 1))
print(ptt, digits =  4) # using less digits than default
print(ptt, digits = 12) # using more  "       "     "



cleanEx()
nameEx("print.ts")
### * print.ts

flush(stderr()); flush(stdout())

### Name: print.ts
### Title: Printing and Formatting of Time-Series Objects
### Aliases: .preformat.ts print.ts
### Keywords: ts

### ** Examples

print(ts(1:10, frequency = 7, start = c(12, 2)), calendar = TRUE)

print(sunsp.1 <- window(sunspot.month, end=c(1756, 12)))
m <- .preformat.ts(sunsp.1) # a character matrix



cleanEx()
nameEx("printCoefmat")
### * printCoefmat

flush(stderr()); flush(stdout())

### Name: printCoefmat
### Title: Print Coefficient Matrices
### Aliases: printCoefmat
### Keywords: print

### ** Examples

cmat <- cbind(rnorm(3, 10), sqrt(rchisq(3, 12)))
cmat <- cbind(cmat, cmat[, 1]/cmat[, 2])
cmat <- cbind(cmat, 2*pnorm(-cmat[, 3]))
colnames(cmat) <- c("Estimate", "Std.Err", "Z value", "Pr(>z)")
printCoefmat(cmat[, 1:3])
printCoefmat(cmat)
op <- options(show.coef.Pvalues = FALSE)
printCoefmat(cmat, digits = 2)
printCoefmat(cmat, digits = 2, P.values = TRUE)
options(op) # restore



cleanEx()
nameEx("profile.nls")
### * profile.nls

flush(stderr()); flush(stdout())

### Name: profile.nls
### Title: Method for Profiling nls Objects
### Aliases: profile.nls
### Keywords: nonlinear regression models

### ** Examples

## Don't show: 
od <- options(digits = 4)
## End(Don't show)
# obtain the fitted object
fm1 <- nls(demand ~ SSasympOrig(Time, A, lrc), data = BOD)
# get the profile for the fitted model: default level is too extreme
pr1 <- profile(fm1, alpha = 0.05)
# profiled values for the two parameters
pr1$A
pr1$lrc
# see also example(plot.profile.nls)
## Don't show: 
options(od)
## End(Don't show)



cleanEx()
nameEx("proj")
### * proj

flush(stderr()); flush(stdout())

### Name: proj
### Title: Projections of Models
### Aliases: proj proj.default proj.lm proj.aov proj.aovlist
### Keywords: models

### ** Examples

N <- c(0,1,0,1,1,1,0,0,0,1,1,0,1,1,0,0,1,0,1,0,1,1,0,0)
P <- c(1,1,0,0,0,1,0,1,1,1,0,0,0,1,0,1,1,0,0,1,0,1,1,0)
K <- c(1,0,0,1,0,1,1,0,0,1,0,1,0,1,1,0,0,0,1,1,1,0,1,0)
yield <- c(49.5,62.8,46.8,57.0,59.8,58.5,55.5,56.0,62.8,55.8,69.5,
55.0, 62.0,48.8,45.5,44.2,52.0,51.5,49.8,48.8,57.2,59.0,53.2,56.0)

npk <- data.frame(block = gl(6,4), N = factor(N), P = factor(P),
                  K = factor(K), yield = yield)
npk.aov <- aov(yield ~ block + N*P*K, npk)
proj(npk.aov)

## as a test, not particularly sensible
options(contrasts = c("contr.helmert", "contr.treatment"))
npk.aovE <- aov(yield ~  N*P*K + Error(block), npk)
proj(npk.aovE)



base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
cleanEx()
nameEx("prop.test")
### * prop.test

flush(stderr()); flush(stdout())

### Name: prop.test
### Title: Test of Equal or Given Proportions
### Aliases: prop.test
### Keywords: htest

### ** Examples

heads <- rbinom(1, size = 100, prob = .5)
prop.test(heads, 100)          # continuity correction TRUE by default
prop.test(heads, 100, correct = FALSE)

## Data from Fleiss (1981), p. 139.
## H0: The null hypothesis is that the four populations from which
##     the patients were drawn have the same true proportion of smokers.
## A:  The alternative is that this proportion is different in at
##     least one of the populations.

smokers  <- c( 83, 90, 129, 70 )
patients <- c( 86, 93, 136, 82 )
prop.test(smokers, patients)



cleanEx()
nameEx("prop.trend.test")
### * prop.trend.test

flush(stderr()); flush(stdout())

### Name: prop.trend.test
### Title: Test for trend in proportions
### Aliases: prop.trend.test
### Keywords: htest

### ** Examples

smokers  <- c( 83, 90, 129, 70 )
patients <- c( 86, 93, 136, 82 )
prop.test(smokers, patients)
prop.trend.test(smokers, patients)
prop.trend.test(smokers, patients, c(0,0,0,1))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("qqnorm")
### * qqnorm

flush(stderr()); flush(stdout())

### Name: qqnorm
### Title: Quantile-Quantile Plots
### Aliases: qqnorm qqnorm.default qqplot qqline
### Keywords: hplot distribution

### ** Examples

require(graphics)

y <- rt(200, df = 5)
qqnorm(y); qqline(y, col = 2)
qqplot(y, rt(300, df = 5))

qqnorm(precip, ylab = "Precipitation [in/yr] for 70 US cities")

## "QQ-Chisquare" : --------------------------
y <- rchisq(500, df = 3)
## Q-Q plot for Chi^2 data against true theoretical distribution:
qqplot(qchisq(ppoints(500), df = 3), y,
       main = expression("Q-Q plot for" ~~ {chi^2}[nu == 3]))
qqline(y, distribution = function(p) qchisq(p, df = 3),
       prob = c(0.1, 0.6), col = 2)
mtext("qqline(*, dist = qchisq(., df=3), prob = c(0.1, 0.6))")



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("quade.test")
### * quade.test

flush(stderr()); flush(stdout())

### Name: quade.test
### Title: Quade Test
### Aliases: quade.test quade.test.default quade.test.formula
### Keywords: htest

### ** Examples

## Conover (1999, p. 375f):
## Numbers of five brands of a new hand lotion sold in seven stores
## during one week.
y <- matrix(c( 5,  4,  7, 10, 12,
               1,  3,  1,  0,  2,
              16, 12, 22, 22, 35,
               5,  4,  3,  5,  4,
              10,  9,  7, 13, 10,
              19, 18, 28, 37, 58,
              10,  7,  6,  8,  7),
            nrow = 7, byrow = TRUE,
            dimnames =
            list(Store = as.character(1:7),
                 Brand = LETTERS[1:5]))
y
quade.test(y)



cleanEx()
nameEx("quantile")
### * quantile

flush(stderr()); flush(stdout())

### Name: quantile
### Title: Sample Quantiles
### Aliases: quantile quantile.default
### Keywords: univar

### ** Examples

quantile(x <- rnorm(1001)) # Extremes & Quartiles by default
quantile(x,  probs = c(0.1, 0.5, 1, 2, 5, 10, 50, NA)/100)

### Compare different types
quantAll <- function(x, prob, ...)
  t(vapply(1:9, function(typ) quantile(x, prob=prob, type = typ, ...), quantile(x, prob, type=1)))
p <- c(0.1, 0.5, 1, 2, 5, 10, 50)/100
signif(quantAll(x, p), 4)
## for complex numbers:
z <- complex(re=x, im = -10*x)
signif(quantAll(z, p), 4)



cleanEx()
nameEx("r2dtable")
### * r2dtable

flush(stderr()); flush(stdout())

### Name: r2dtable
### Title: Random 2-way Tables with Given Marginals
### Aliases: r2dtable
### Keywords: distribution

### ** Examples

## Fisher's Tea Drinker data.
TeaTasting <-
matrix(c(3, 1, 1, 3),
       nrow = 2,
       dimnames = list(Guess = c("Milk", "Tea"),
                       Truth = c("Milk", "Tea")))
## Simulate permutation test for independence based on the maximum
## Pearson residuals (rather than their sum).
rowTotals <- rowSums(TeaTasting)
colTotals <- colSums(TeaTasting)
nOfCases <- sum(rowTotals)
expected <- outer(rowTotals, colTotals, "*") / nOfCases
maxSqResid <- function(x) max((x - expected) ^ 2 / expected)
simMaxSqResid <-
    sapply(r2dtable(1000, rowTotals, colTotals), maxSqResid)
sum(simMaxSqResid >= maxSqResid(TeaTasting)) / 1000
## Fisher's exact test gives p = 0.4857 ...



cleanEx()
nameEx("rWishart")
### * rWishart

flush(stderr()); flush(stdout())

### Name: rWishart
### Title: Random Wishart Distributed Matrices
### Aliases: rWishart
### Keywords: multivariate

### ** Examples

## Artificial
S <- toeplitz((10:1)/10)
set.seed(11)
R <- rWishart(1000, 20, S)
dim(R)  #  10 10  1000
mR <- apply(R, 1:2, mean)  # ~= E[ Wish(S, 20) ] = 20 * S
stopifnot(all.equal(mR, 20*S, tolerance = .009))

## See Details, the variance is
Va <- 20*(S^2 + tcrossprod(diag(S)))
vR <- apply(R, 1:2, var)
stopifnot(all.equal(vR, Va, tolerance = 1/16))



cleanEx()
nameEx("read.ftable")
### * read.ftable

flush(stderr()); flush(stdout())

### Name: read.ftable
### Title: Manipulate Flat Contingency Tables
### Aliases: read.ftable write.ftable format.ftable print.ftable
### Keywords: category

### ** Examples

## Agresti (1990), page 157, Table 5.8.
## Not in ftable standard format, but o.k.
file <- tempfile()
cat("             Intercourse\n",
    "Race  Gender     Yes  No\n",
    "White Male        43 134\n",
    "      Female      26 149\n",
    "Black Male        29  23\n",
    "      Female      22  36\n",
    file = file)
ft1 <- read.ftable(file)
ft1
unlink(file)

## Agresti (1990), page 297, Table 8.16.
## Almost o.k., but misses the name of the row variable.
file <- tempfile()
cat("                      \"Tonsil Size\"\n",
    "            \"Not Enl.\" \"Enl.\" \"Greatly Enl.\"\n",
    "Noncarriers       497     560           269\n",
    "Carriers           19      29            24\n",
    file = file)
ft <- read.ftable(file, skip = 2,
                  row.var.names = "Status",
                  col.vars = list("Tonsil Size" =
                      c("Not Enl.", "Enl.", "Greatly Enl.")))
ft
unlink(file)

ft22 <- ftable(Titanic, row.vars = 2:1, col.vars = 4:3)
write.ftable(ft22, quote = FALSE)
write.ftable(ft22, quote = FALSE, method="row.compact")
write.ftable(ft22, quote = FALSE, method="col.compact")
write.ftable(ft22, quote = FALSE, method="compact")
## Don't show: 
 op <- options(warn = 2) # no warnings allowed
 stopifnot(dim(format(ft)) == 4:5,
	   dim(format(ftable(UCBAdmissions))) == c(6,9))
 meths <- c("non.compact", "row.compact", "col.compact", "compact")
 dimform <-
    function(ft) sapply(meths, function(M) dim(format(ft, method = M)))
 m.eq    <- function(M,m) all.equal(unname(M), m, tolerance = 0)
 ## All format(..) w/o warnings:
 stopifnot(m.eq(print(dimform(ft22)),
		rbind(11:10, rep(7:6, each = 2))),
	   m.eq(print(dimform(ftable(Titanic, row.vars = integer()))),
		rbind(rep(6:5,2), 33)))
 options(op)
## End(Don't show)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("rect.hclust")
### * rect.hclust

flush(stderr()); flush(stdout())

### Name: rect.hclust
### Title: Draw Rectangles Around Hierarchical Clusters
### Aliases: rect.hclust
### Keywords: aplot cluster

### ** Examples

require(graphics)

hca <- hclust(dist(USArrests))
plot(hca)
rect.hclust(hca, k = 3, border = "red")
x <- rect.hclust(hca, h = 50, which = c(2,7), border = 3:4)
x



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("relevel")
### * relevel

flush(stderr()); flush(stdout())

### Name: relevel
### Title: Reorder Levels of Factor
### Aliases: relevel relevel.default relevel.factor relevel.ordered
### Keywords: utilities models

### ** Examples

warpbreaks$tension <- relevel(warpbreaks$tension, ref = "M")
summary(lm(breaks ~ wool + tension, data = warpbreaks))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("reorder.dendrogram")
### * reorder.dendrogram

flush(stderr()); flush(stdout())

### Name: reorder.dendrogram
### Title: Reorder a Dendrogram
### Aliases: reorder.dendrogram
### Keywords: manip

### ** Examples

require(graphics)

set.seed(123)
x <- rnorm(10)
hc <- hclust(dist(x))
dd <- as.dendrogram(hc)
dd.reorder <- reorder(dd, 10:1)
plot(dd, main = "random dendrogram 'dd'")

op <- par(mfcol = 1:2)
plot(dd.reorder, main = "reorder(dd, 10:1)")
plot(reorder(dd, 10:1, agglo.FUN = mean), main = "reorder(dd, 10:1, mean)")
par(op)



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("reorder.factor")
### * reorder.factor

flush(stderr()); flush(stdout())

### Name: reorder.default
### Title: Reorder Levels of a Factor
### Aliases: reorder reorder.default
### Keywords: utilities

### ** Examples

require(graphics)

bymedian <- with(InsectSprays, reorder(spray, count, median))
boxplot(count ~ bymedian, data = InsectSprays,
        xlab = "Type of spray", ylab = "Insect count",
        main = "InsectSprays data", varwidth = TRUE,
        col = "lightgray")



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("replications")
### * replications

flush(stderr()); flush(stdout())

### Name: replications
### Title: Number of Replications of Terms
### Aliases: replications
### Keywords: models

### ** Examples

## From Venables and Ripley (2002) p.165.
N <- c(0,1,0,1,1,1,0,0,0,1,1,0,1,1,0,0,1,0,1,0,1,1,0,0)
P <- c(1,1,0,0,0,1,0,1,1,1,0,0,0,1,0,1,1,0,0,1,0,1,1,0)
K <- c(1,0,0,1,0,1,1,0,0,1,0,1,0,1,1,0,0,0,1,1,1,0,1,0)
yield <- c(49.5,62.8,46.8,57.0,59.8,58.5,55.5,56.0,62.8,55.8,69.5,
55.0, 62.0,48.8,45.5,44.2,52.0,51.5,49.8,48.8,57.2,59.0,53.2,56.0)

npk <- data.frame(block = gl(6,4), N = factor(N), P = factor(P),
                  K = factor(K), yield = yield)
replications(~ . - yield, npk)



cleanEx()
nameEx("reshape")
### * reshape

flush(stderr()); flush(stdout())

### Name: reshape
### Title: Reshape Grouped Data
### Aliases: reshape
### Keywords: manip

### ** Examples

summary(Indometh)
wide <- reshape(Indometh, v.names = "conc", idvar = "Subject",
                timevar = "time", direction = "wide")
wide

reshape(wide, direction = "long")
reshape(wide, idvar = "Subject", varying = list(2:12),
        v.names = "conc", direction = "long")

## times need not be numeric
df <- data.frame(id = rep(1:4, rep(2,4)),
                 visit = I(rep(c("Before","After"), 4)),
                 x = rnorm(4), y = runif(4))
df
reshape(df, timevar = "visit", idvar = "id", direction = "wide")
## warns that y is really varying
reshape(df, timevar = "visit", idvar = "id", direction = "wide", v.names = "x")


##  unbalanced 'long' data leads to NA fill in 'wide' form
df2 <- df[1:7, ]
df2
reshape(df2, timevar = "visit", idvar = "id", direction = "wide")

## Alternative regular expressions for guessing names
df3 <- data.frame(id = 1:4, age = c(40,50,60,50), dose1 = c(1,2,1,2),
                  dose2 = c(2,1,2,1), dose4 = c(3,3,3,3))
reshape(df3, direction = "long", varying = 3:5, sep = "")


## an example that isn't longitudinal data
state.x77 <- as.data.frame(state.x77)
long <- reshape(state.x77, idvar = "state", ids = row.names(state.x77),
                times = names(state.x77), timevar = "Characteristic",
                varying = list(names(state.x77)), direction = "long")

reshape(long, direction = "wide")

reshape(long, direction = "wide", new.row.names = unique(long$state))

## multiple id variables
df3 <- data.frame(school = rep(1:3, each = 4), class = rep(9:10, 6),
                  time = rep(c(1,1,2,2), 3), score = rnorm(12))
wide <- reshape(df3, idvar = c("school","class"), direction = "wide")
wide
## transform back
reshape(wide)




if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("runmed")
### * runmed

flush(stderr()); flush(stdout())

### Name: runmed
### Title: Running Medians - Robust Scatter Plot Smoothing
### Aliases: runmed
### Keywords: smooth robust

### ** Examples

require(graphics)

utils::example(nhtemp)
myNHT <- as.vector(nhtemp)
myNHT[20] <- 2 * nhtemp[20]
plot(myNHT, type = "b", ylim = c(48, 60), main = "Running Medians Example")
lines(runmed(myNHT, 7), col = "red")

## special: multiple y values for one x
plot(cars, main = "'cars' data and runmed(dist, 3)")
lines(cars, col = "light gray", type = "c")
with(cars, lines(speed, runmed(dist, k = 3), col = 2))

## nice quadratic with a few outliers
y <- ys <- (-20:20)^2
y [c(1,10,21,41)] <- c(150, 30, 400, 450)
all(y == runmed(y, 1)) # 1-neighbourhood <==> interpolation
plot(y) ## lines(y, lwd = .1, col = "light gray")
lines(lowess(seq(y), y, f = 0.3), col = "brown")
lines(runmed(y, 7), lwd = 2, col = "blue")
lines(runmed(y, 11), lwd = 2, col = "red")

## Lowess is not robust
y <- ys ; y[21] <- 6666 ; x <- seq(y)
col <- c("black", "brown","blue")
plot(y, col = col[1])
lines(lowess(x, y, f = 0.3), col = col[2])
lines(runmed(y, 7),      lwd = 2, col = col[3])
legend(length(y),max(y), c("data", "lowess(y, f = 0.3)", "runmed(y, 7)"),
       xjust = 1, col = col, lty = c(0, 1, 1), pch = c(1,NA,NA))



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("scatter.smooth")
### * scatter.smooth

flush(stderr()); flush(stdout())

### Name: scatter.smooth
### Title: Scatter Plot with Smooth Curve Fitted by Loess
### Aliases: scatter.smooth loess.smooth
### Keywords: smooth

### ** Examples

require(graphics)

with(cars, scatter.smooth(speed, dist))
## or with dotted thick smoothed line results :
with(cars, scatter.smooth(speed, dist, lpars =
                    list(col = "red", lwd = 3, lty = 3)))



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("screeplot")
### * screeplot

flush(stderr()); flush(stdout())

### Name: screeplot
### Title: Screeplots
### Aliases: screeplot screeplot.default
### Keywords: multivariate

### ** Examples

require(graphics)

## The variances of the variables in the
## USArrests data vary by orders of magnitude, so scaling is appropriate
(pc.cr <- princomp(USArrests, cor = TRUE))  # inappropriate
screeplot(pc.cr)

fit <- princomp(covmat = Harman74.cor)
screeplot(fit)
screeplot(fit, npcs = 24, type = "lines")



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("sd")
### * sd

flush(stderr()); flush(stdout())

### Name: sd
### Title: Standard Deviation
### Aliases: sd
### Keywords: univar

### ** Examples

sd(1:2) ^ 2



cleanEx()
nameEx("se.contrast")
### * se.contrast

flush(stderr()); flush(stdout())

### Name: se.contrast
### Title: Standard Errors for Contrasts in Model Terms
### Aliases: se.contrast se.contrast.aov se.contrast.aovlist
### Keywords: models

### ** Examples

## From Venables and Ripley (2002) p.165.
N <- c(0,1,0,1,1,1,0,0,0,1,1,0,1,1,0,0,1,0,1,0,1,1,0,0)
P <- c(1,1,0,0,0,1,0,1,1,1,0,0,0,1,0,1,1,0,0,1,0,1,1,0)
K <- c(1,0,0,1,0,1,1,0,0,1,0,1,0,1,1,0,0,0,1,1,1,0,1,0)
yield <- c(49.5,62.8,46.8,57.0,59.8,58.5,55.5,56.0,62.8,55.8,69.5,
55.0, 62.0,48.8,45.5,44.2,52.0,51.5,49.8,48.8,57.2,59.0,53.2,56.0)

npk <- data.frame(block = gl(6,4), N = factor(N), P = factor(P),
                  K = factor(K), yield = yield)
## Set suitable contrasts.
options(contrasts = c("contr.helmert", "contr.poly"))
npk.aov1 <- aov(yield ~ block + N + K, data = npk)
se.contrast(npk.aov1, list(N == "0", N == "1"), data = npk)
# or via a matrix
cont <- matrix(c(-1,1), 2, 1, dimnames = list(NULL, "N"))
se.contrast(npk.aov1, cont[N, , drop = FALSE]/12, data = npk)

## test a multi-stratum model
npk.aov2 <- aov(yield ~ N + K + Error(block/(N + K)), data = npk)
se.contrast(npk.aov2, list(N == "0", N == "1"))


## an example looking at an interaction contrast
## Dataset from R.E. Kirk (1995)
## 'Experimental Design: procedures for the behavioral sciences'
score <- c(12, 8,10, 6, 8, 4,10,12, 8, 6,10,14, 9, 7, 9, 5,11,12,
            7,13, 9, 9, 5,11, 8, 7, 3, 8,12,10,13,14,19, 9,16,14)
A <- gl(2, 18, labels = c("a1", "a2"))
B <- rep(gl(3, 6, labels = c("b1", "b2", "b3")), 2)
fit <- aov(score ~ A*B)
cont <- c(1, -1)[A] * c(1, -1, 0)[B]
sum(cont)       # 0
sum(cont*score) # value of the contrast
se.contrast(fit, as.matrix(cont))
(t.stat <- sum(cont*score)/se.contrast(fit, as.matrix(cont)))
summary(fit, split = list(B = 1:2), expand.split = TRUE)
## t.stat^2 is the F value on the A:B: C1 line (with Helmert contrasts)
## Now look at all three interaction contrasts
cont <- c(1, -1)[A] * cbind(c(1, -1, 0), c(1, 0, -1), c(0, 1, -1))[B,]
se.contrast(fit, cont)  # same, due to balance.
rm(A, B, score)


## multi-stratum example where efficiencies play a role
utils::example(eff.aovlist)
fit <- aov(Yield ~ A + B * C + Error(Block), data = aovdat)
cont1 <- c(-1, 1)[A]/32  # Helmert contrasts
cont2 <- c(-1, 1)[B] * c(-1, 1)[C]/32
cont <- cbind(A = cont1, BC = cont2)
colSums(cont*Yield) # values of the contrasts
se.contrast(fit, as.matrix(cont))


base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
cleanEx()
nameEx("selfStart")
### * selfStart

flush(stderr()); flush(stdout())

### Name: selfStart
### Title: Construct Self-starting Nonlinear Models
### Aliases: selfStart selfStart.default selfStart.formula
### Keywords: models

### ** Examples

## self-starting logistic model

SSlogis <- selfStart(~ Asym/(1 + exp((xmid - x)/scal)),
  function(mCall, data, LHS)
  {
    xy <- sortedXyData(mCall[["x"]], LHS, data)
    if(nrow(xy) < 4) {
      stop("Too few distinct x values to fit a logistic")
    }
    z <- xy[["y"]]
    if (min(z) <= 0) { z <- z + 0.05 * max(z) } # avoid zeroes
    z <- z/(1.05 * max(z))              # scale to within unit height
    xy[["z"]] <- log(z/(1 - z))         # logit transformation
    aux <- coef(lm(x ~ z, xy))
    parameters(xy) <- list(xmid = aux[1], scal = aux[2])
    pars <- as.vector(coef(nls(y ~ 1/(1 + exp((xmid - x)/scal)),
                             data = xy, algorithm = "plinear")))
    setNames(c(pars[3], pars[1], pars[2]),
             mCall[c("Asym", "xmid", "scal")])
  }, c("Asym", "xmid", "scal"))

# 'first.order.log.model' is a function object defining a first order
# compartment model
# 'first.order.log.initial' is a function object which calculates initial
# values for the parameters in 'first.order.log.model'

# self-starting first order compartment model
## Not run: 
##D SSfol <- selfStart(first.order.log.model, first.order.log.initial)
## End(Not run)

## Explore the self-starting models already available in R's  "stats":
pos.st <- which("package:stats" == search())
mSS <- apropos("^SS..", where = TRUE, ignore.case = FALSE)
(mSS <- unname(mSS[names(mSS) == pos.st]))
fSS <- sapply(mSS, get, pos = pos.st, mode = "function")
all(sapply(fSS, inherits, "selfStart"))  # -> TRUE

## Show the argument list of each self-starting function:
str(fSS, give.attr = FALSE)



cleanEx()
nameEx("setNames")
### * setNames

flush(stderr()); flush(stdout())

### Name: setNames
### Title: Set the Names in an Object
### Aliases: setNames
### Keywords: list

### ** Examples

setNames( 1:3, c("foo", "bar", "baz") )
# this is just a short form of
tmp <- 1:3
names(tmp) <-  c("foo", "bar", "baz")
tmp

## special case of character vector, using default
setNames(nm = c("First", "2nd"))



cleanEx()
nameEx("shapiro.test")
### * shapiro.test

flush(stderr()); flush(stdout())

### Name: shapiro.test
### Title: Shapiro-Wilk Normality Test
### Aliases: shapiro.test
### Keywords: htest

### ** Examples

shapiro.test(rnorm(100, mean = 5, sd = 3))
shapiro.test(runif(100, min = 2, max = 4))



cleanEx()
nameEx("sigma")
### * sigma

flush(stderr()); flush(stdout())

### Name: sigma
### Title: Extract Residual Standard Deviation 'Sigma'
### Aliases: sigma sigma.default sigma.mlm
### Keywords: models

### ** Examples

## -- lm() ------------------------------
lm1 <- lm(Fertility ~ . , data = swiss)
sigma(lm1) # ~= 7.165  = "Residual standard error"  printed from summary(lm1)
stopifnot(all.equal(sigma(lm1), summary(lm1)$sigma, tol=1e-15))

## -- nls() -----------------------------
DNase1 <- subset(DNase, Run == 1)
fm.DN1 <- nls(density ~ SSlogis(log(conc), Asym, xmid, scal), DNase1)
sigma(fm.DN1) # ~= 0.01919  as from summary(..)
stopifnot(all.equal(sigma(fm.DN1), summary(fm.DN1)$sigma, tol=1e-15))

## -- glm() -----------------------------
## -- a) Binomial -- Example from MASS
ldose <- rep(0:5, 2)
numdead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
sex <- factor(rep(c("M", "F"), c(6, 6)))
SF <- cbind(numdead, numalive = 20-numdead)
sigma(budworm.lg <- glm(SF ~ sex*ldose, family = binomial))

## -- b) Poisson -- from ?glm :
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
sigma(glm.D93 <- glm(counts ~ outcome + treatment, family = poisson()))
## (currently) *differs* from
summary(glm.D93)$dispersion # == 1
## and the *Quasi*poisson's dispersion
sigma(glm.qD93 <- update(glm.D93, family = quasipoisson()))
sigma (glm.qD93)^2 # 1.282285 is close, but not the same
summary(glm.qD93)$dispersion # == 1.2933

## -- Multivariate lm() "mlm" -----------
utils::example("SSD", echo=FALSE)
sigma(mlmfit) # is the same as {but more efficient than}
sqrt(diag(estVar(mlmfit)))
## Don't show: 
stopifnot(all.equal(sigma(mlmfit), sqrt(diag(estVar(mlmfit)))))
## End(Don't show)



cleanEx()
nameEx("simulate")
### * simulate

flush(stderr()); flush(stdout())

### Name: simulate
### Title: Simulate Responses
### Aliases: simulate
### Keywords: models datagen

### ** Examples

x <- 1:5
mod1 <- lm(c(1:3, 7, 6) ~ x)
S1 <- simulate(mod1, nsim = 4)
## repeat the simulation:
.Random.seed <- attr(S1, "seed")
identical(S1, simulate(mod1, nsim = 4))

S2 <- simulate(mod1, nsim = 200, seed = 101)
rowMeans(S2) # should be about the same as
fitted(mod1)

## repeat identically:
(sseed <- attr(S2, "seed")) # seed; RNGkind as attribute
stopifnot(identical(S2, simulate(mod1, nsim = 200, seed = sseed)))

## To be sure about the proper RNGkind, e.g., after
RNGversion("2.7.0")
## first set the RNG kind, then simulate
do.call(RNGkind, attr(sseed, "kind"))
identical(S2, simulate(mod1, nsim = 200, seed = sseed))

## Binomial GLM examples
yb1 <- matrix(c(4, 4, 5, 7, 8, 6, 6, 5, 3, 2), ncol = 2)
modb1 <- glm(yb1 ~ x, family = binomial)
S3 <- simulate(modb1, nsim = 4)
# each column of S3 is a two-column matrix.

x2 <- sort(runif(100))
yb2 <- rbinom(100, prob = plogis(2*(x2-1)), size = 1)
yb2 <- factor(1 + yb2, labels = c("failure", "success"))
modb2 <- glm(yb2 ~ x2, family = binomial)
S4 <- simulate(modb2, nsim = 4)
# each column of S4 is a factor



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("smooth")
### * smooth

flush(stderr()); flush(stdout())

### Name: smooth
### Title: Tukey's (Running Median) Smoothing
### Aliases: smooth
### Keywords: robust smooth

### ** Examples

require(graphics)

## see also   demo(smooth) !

x1 <- c(4, 1, 3, 6, 6, 4, 1, 6, 2, 4, 2) # very artificial
(x3R <- smooth(x1, "3R")) # 2 iterations of "3"
smooth(x3R, kind = "S")

sm.3RS <- function(x, ...)
   smooth(smooth(x, "3R", ...), "S", ...)

y <- c(1, 1, 19:1)
plot(y, main = "misbehaviour of \"3RSR\"", col.main = 3)
lines(sm.3RS(y))
lines(smooth(y))
lines(smooth(y, "3RSR"), col = 3, lwd = 2)  # the horror

x <- c(8:10, 10, 0, 0, 9, 9)
plot(x, main = "breakdown of  3R  and  S  and hence  3RSS")
matlines(cbind(smooth(x, "3R"), smooth(x, "S"), smooth(x, "3RSS"), smooth(x)))

presidents[is.na(presidents)] <- 0 # silly
summary(sm3 <- smooth(presidents, "3R"))
summary(sm2 <- smooth(presidents,"3RSS"))
summary(sm  <- smooth(presidents))

all.equal(c(sm2), c(smooth(smooth(sm3, "S"), "S")))  # 3RSS  === 3R S S
all.equal(c(sm),  c(smooth(smooth(sm3, "S"), "3R"))) # 3RS3R === 3R S 3R

plot(presidents, main = "smooth(presidents0, *) :  3R and default 3RS3R")
lines(sm3, col = 3, lwd = 1.5)
lines(sm, col = 2, lwd = 1.25)



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("smooth.spline")
### * smooth.spline

flush(stderr()); flush(stdout())

### Name: smooth.spline
### Title: Fit a Smoothing Spline
### Aliases: smooth.spline .nknots.smspl
### Keywords: smooth

### ** Examples

require(graphics)
plot(dist ~ speed, data = cars, main = "data(cars)  &  smoothing splines")
cars.spl <- with(cars, smooth.spline(speed, dist))
cars.spl
## This example has duplicate points, so avoid cv = TRUE
## Don't show: 
  stopifnot(cars.spl $ w == table(cars$speed)) # weights = multiplicities
  utils::str(cars.spl, digits = 5, vec.len = 6)
  cars.spl$fit
## End(Don't show)
lines(cars.spl, col = "blue")
ss10 <- smooth.spline(cars[,"speed"], cars[,"dist"], df = 10)
lines(ss10, lty = 2, col = "red")
legend(5,120,c(paste("default [C.V.] => df =",round(cars.spl$df,1)),
               "s( * , df = 10)"), col = c("blue","red"), lty = 1:2,
       bg = 'bisque')


## Residual (Tukey Anscombe) plot:
plot(residuals(cars.spl) ~ fitted(cars.spl))
abline(h = 0, col = "gray")

## consistency check:
stopifnot(all.equal(cars$dist,
                    fitted(cars.spl) + residuals(cars.spl)))

## Visualize the behavior of  .nknots.smspl()
nKnots <- Vectorize(.nknots.smspl) ; c.. <- adjustcolor("gray20",.5)
curve(nKnots, 1, 250, n=250)
abline(0,1, lty=2, col=c..); text(90,90,"y = x", col=c.., adj=-.25)
abline(h=100,lty=2); abline(v=200, lty=2)

n <- c(1:799, seq(800, 3490, by=10), seq(3500, 10000, by = 50))
plot(n, nKnots(n), type="l", main = "Vectorize(.nknots.smspl) (n)")
abline(0,1, lty=2, col=c..); text(180,180,"y = x", col=c..)
n0 <- c(50, 200, 800, 3200); c0 <- adjustcolor("blue3", .5)
lines(n0, nKnots(n0), type="h", col=c0)
axis(1, at=n0, line=-2, col.ticks=c0, col=NA, col.axis=c0)
axis(4, at=.nknots.smspl(10000), line=-.5, col=c..,col.axis=c.., las=1)

##-- artificial example
y18 <- c(1:3, 5, 4, 7:3, 2*(2:5), rep(10, 4))
xx  <- seq(1, length(y18), len = 201)
(s2   <- smooth.spline(y18)) # GCV
(s02  <- smooth.spline(y18, spar = 0.2))
(s02. <- smooth.spline(y18, spar = 0.2, cv = NA))
plot(y18, main = deparse(s2$call), col.main = 2)
lines(s2, col = "gray"); lines(predict(s2, xx), col = 2)
lines(predict(s02, xx), col = 3); mtext(deparse(s02$call), col = 3)

## Specifying 'lambda' instead of usual spar :
(s2. <- smooth.spline(y18, lambda = s2$lambda, tol = s2$tol))

## Don't show: 
nD <- c("spar", "ratio", "iparms", "call"); nn <- setdiff(names(s2), nD)
stopifnot(all.equal(s2[nn], s2.[nn], tol = 7e-7), # seen 6.86e-8
          all.equal(predict(s02 , xx),
		    predict(s02., xx), tol = 1e-15))
## End(Don't show)


} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("smoothEnds")
### * smoothEnds

flush(stderr()); flush(stdout())

### Name: smoothEnds
### Title: End Points Smoothing (for Running Medians)
### Aliases: smoothEnds
### Keywords: smooth robust

### ** Examples

require(graphics)

y <- ys <- (-20:20)^2
y [c(1,10,21,41)] <-  c(100, 30, 400, 470)
s7k <- runmed(y, 7, endrule = "keep")
s7. <- runmed(y, 7, endrule = "const")
s7m <- runmed(y, 7)
col3 <- c("midnightblue","blue","steelblue")
plot(y, main = "Running Medians -- runmed(*, k=7, end.rule = X)")
lines(ys, col = "light gray")
matlines(cbind(s7k, s7.,s7m), lwd = 1.5, lty = 1, col = col3)
legend(1, 470, paste("endrule", c("keep","constant","median"), sep = " = "),
       col = col3, lwd = 1.5, lty = 1)

stopifnot(identical(s7m, smoothEnds(s7k, 7)))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("sortedXyData")
### * sortedXyData

flush(stderr()); flush(stdout())

### Name: sortedXyData
### Title: Create a 'sortedXyData' Object
### Aliases: sortedXyData sortedXyData.default
### Keywords: manip

### ** Examples

DNase.2 <- DNase[ DNase$Run == "2", ]
sortedXyData( expression(log(conc)), expression(density), DNase.2 )



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("spec.ar")
### * spec.ar

flush(stderr()); flush(stdout())

### Name: spec.ar
### Title: Estimate Spectral Density of a Time Series from AR Fit
### Aliases: spec.ar
### Keywords: ts

### ** Examples

require(graphics)

spec.ar(lh)

spec.ar(ldeaths)
spec.ar(ldeaths, method = "burg")

spec.ar(log(lynx))
spec.ar(log(lynx), method = "burg", add = TRUE, col = "purple")
spec.ar(log(lynx), method = "mle", add = TRUE, col = "forest green")
spec.ar(log(lynx), method = "ols", add = TRUE, col = "blue")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("spec.pgram")
### * spec.pgram

flush(stderr()); flush(stdout())

### Name: spec.pgram
### Title: Estimate Spectral Density of a Time Series by a Smoothed
###   Periodogram
### Aliases: spec.pgram
### Keywords: ts

### ** Examples

require(graphics)

## Examples from Venables & Ripley
spectrum(ldeaths)
spectrum(ldeaths, spans = c(3,5))
spectrum(ldeaths, spans = c(5,7))
spectrum(mdeaths, spans = c(3,3))
spectrum(fdeaths, spans = c(3,3))

## bivariate example
mfdeaths.spc <- spec.pgram(ts.union(mdeaths, fdeaths), spans = c(3,3))
# plots marginal spectra: now plot coherency and phase
plot(mfdeaths.spc, plot.type = "coherency")
plot(mfdeaths.spc, plot.type = "phase")

## now impose a lack of alignment
mfdeaths.spc <- spec.pgram(ts.intersect(mdeaths, lag(fdeaths, 4)),
   spans = c(3,3), plot = FALSE)
plot(mfdeaths.spc, plot.type = "coherency")
plot(mfdeaths.spc, plot.type = "phase")

stocks.spc <- spectrum(EuStockMarkets, kernel("daniell", c(30,50)),
                       plot = FALSE)
plot(stocks.spc, plot.type = "marginal") # the default type
plot(stocks.spc, plot.type = "coherency")
plot(stocks.spc, plot.type = "phase")

sales.spc <- spectrum(ts.union(BJsales, BJsales.lead),
                      kernel("modified.daniell", c(5,7)))
plot(sales.spc, plot.type = "coherency")
plot(sales.spc, plot.type = "phase")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("spectrum")
### * spectrum

flush(stderr()); flush(stdout())

### Name: spectrum
### Title: Spectral Density Estimation
### Aliases: spectrum spec
### Keywords: ts

### ** Examples

require(graphics)

## Examples from Venables & Ripley
## spec.pgram
par(mfrow = c(2,2))
spectrum(lh)
spectrum(lh, spans = 3)
spectrum(lh, spans = c(3,3))
spectrum(lh, spans = c(3,5))

spectrum(ldeaths)
spectrum(ldeaths, spans = c(3,3))
spectrum(ldeaths, spans = c(3,5))
spectrum(ldeaths, spans = c(5,7))
spectrum(ldeaths, spans = c(5,7), log = "dB", ci = 0.8)

# for multivariate examples see the help for spec.pgram

## spec.ar
spectrum(lh, method = "ar")
spectrum(ldeaths, method = "ar")



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("splinefun")
### * splinefun

flush(stderr()); flush(stdout())

### Name: splinefun
### Title: Interpolating Splines
### Aliases: spline splinefun splinefunH
### Keywords: math dplot

### ** Examples

require(graphics)

op <- par(mfrow = c(2,1), mgp = c(2,.8,0), mar = 0.1+c(3,3,3,1))
n <- 9
x <- 1:n
y <- rnorm(n)
plot(x, y, main = paste("spline[fun](.) through", n, "points"))
lines(spline(x, y))
lines(spline(x, y, n = 201), col = 2)

y <- (x-6)^2
plot(x, y, main = "spline(.) -- 3 methods")
lines(spline(x, y, n = 201), col = 2)
lines(spline(x, y, n = 201, method = "natural"), col = 3)
lines(spline(x, y, n = 201, method = "periodic"), col = 4)
legend(6, 25, c("fmm","natural","periodic"), col = 2:4, lty = 1)

y <- sin((x-0.5)*pi)
f <- splinefun(x, y)
ls(envir = environment(f))
splinecoef <- get("z", envir = environment(f))
curve(f(x), 1, 10, col = "green", lwd = 1.5)
points(splinecoef, col = "purple", cex = 2)
curve(f(x, deriv = 1), 1, 10, col = 2, lwd = 1.5)
curve(f(x, deriv = 2), 1, 10, col = 2, lwd = 1.5, n = 401)
curve(f(x, deriv = 3), 1, 10, col = 2, lwd = 1.5, n = 401)
par(op)

## Manual spline evaluation --- demo the coefficients :
.x <- splinecoef$x
u <- seq(3, 6, by = 0.25)
(ii <- findInterval(u, .x))
dx <- u - .x[ii]
f.u <- with(splinecoef,
            y[ii] + dx*(b[ii] + dx*(c[ii] + dx* d[ii])))
stopifnot(all.equal(f(u), f.u))

## An example with ties (non-unique  x values):
set.seed(1); x <- round(rnorm(30), 1); y <- sin(pi * x) + rnorm(30)/10
plot(x, y, main = "spline(x,y)  when x has ties")
lines(spline(x, y, n = 201), col = 2)
## visualizes the non-unique ones:
tx <- table(x); mx <- as.numeric(names(tx[tx > 1]))
ry <- matrix(unlist(tapply(y, match(x, mx), range, simplify = FALSE)),
             ncol = 2, byrow = TRUE)
segments(mx, ry[, 1], mx, ry[, 2], col = "blue", lwd = 2)

## An example of monotone interpolation
n <- 20
set.seed(11)
x. <- sort(runif(n)) ; y. <- cumsum(abs(rnorm(n)))
plot(x., y.)
curve(splinefun(x., y.)(x), add = TRUE, col = 2, n = 1001)
curve(splinefun(x., y., method = "monoH.FC")(x), add = TRUE, col = 3, n = 1001)
curve(splinefun(x., y., method = "hyman")   (x), add = TRUE, col = 4, n = 1001)
legend("topleft",
       paste0("splinefun( \"", c("fmm", "monoH.FC", "hyman"), "\" )"),
       col = 2:4, lty = 1, bty = "n")

## and one from Fritsch and Carlson (1980), Dougherty et al (1989)
x. <- c(7.09, 8.09, 8.19, 8.7, 9.2, 10, 12, 15, 20)
f <- c(0, 2.76429e-5, 4.37498e-2, 0.169183, 0.469428, 0.943740,
       0.998636, 0.999919, 0.999994)
s0 <- splinefun(x., f)
s1 <- splinefun(x., f, method = "monoH.FC")
s2 <- splinefun(x., f, method = "hyman")
plot(x., f, ylim = c(-0.2, 1.2))
curve(s0(x), add = TRUE, col = 2, n = 1001) -> m0
curve(s1(x), add = TRUE, col = 3, n = 1001)
curve(s2(x), add = TRUE, col = 4, n = 1001)
legend("right",
       paste0("splinefun( \"", c("fmm", "monoH.FC", "hyman"), "\" )"),
       col = 2:4, lty = 1, bty = "n")

## they seem identical, but are not quite:
xx <- m0$x
plot(xx, s1(xx) - s2(xx), type = "l",  col = 2, lwd = 2,
     main = "Difference   monoH.FC - hyman"); abline(h = 0, lty = 3)

x <- xx[xx < 10.2] ## full range: x <- xx .. does not show enough
ccol <- adjustcolor(2:4, 0.8)
matplot(x, cbind(s0(x, deriv = 2), s1(x, deriv = 2), s2(x, deriv = 2))^2,
        lwd = 2, col = ccol, type = "l", ylab = quote({{f*second}(x)}^2),
        main = expression({{f*second}(x)}^2 ~" for the three 'splines'"))
legend("topright",
       paste0("splinefun( \"", c("fmm", "monoH.FC", "hyman"), "\" )"),
       lwd = 2, col  =  ccol, lty = 1:3, bty = "n")
## --> "hyman" has slightly smaller  Integral f''(x)^2 dx  than "FC",
## here, and both are 'much worse' than the regular fmm spline.



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("stat.anova")
### * stat.anova

flush(stderr()); flush(stdout())

### Name: stat.anova
### Title: GLM Anova Statistics
### Aliases: stat.anova
### Keywords: regression models

### ** Examples

##-- Continued from '?glm':
## Don't show: 
utils::example("glm", echo = FALSE)
## End(Don't show)
print(ag <- anova(glm.D93))
stat.anova(ag$table, test = "Cp",
           scale = sum(resid(glm.D93, "pearson")^2)/4,
           df.scale = 4, n = 9)



cleanEx()
nameEx("step")
### * step

flush(stderr()); flush(stdout())

### Name: step
### Title: Choose a model by AIC in a Stepwise Algorithm
### Aliases: step
### Keywords: models

### ** Examples


cleanEx()
nameEx("stepfun")
### * stepfun

flush(stderr()); flush(stdout())

### Name: stepfun
### Title: Step Functions - Creation and Class
### Aliases: stepfun is.stepfun as.stepfun print.stepfun summary.stepfun
###   knots
### Keywords: dplot

### ** Examples

y0 <- c(1., 2., 4., 3.)
sfun0  <- stepfun(1:3, y0, f = 0)
sfun.2 <- stepfun(1:3, y0, f = 0.2)
sfun1  <- stepfun(1:3, y0, f = 1)
sfun1c <- stepfun(1:3, y0, right = TRUE) # hence f=1
sfun0
summary(sfun0)
summary(sfun.2)

## look at the internal structure:
unclass(sfun0)
ls(envir = environment(sfun0))

x0 <- seq(0.5, 3.5, by = 0.25)
rbind(x = x0, f.f0 = sfun0(x0), f.f02 = sfun.2(x0),
      f.f1 = sfun1(x0), f.f1c = sfun1c(x0))
## Identities :
stopifnot(identical(y0[-1], sfun0 (1:3)), # right = FALSE
          identical(y0[-4], sfun1c(1:3))) # right = TRUE



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("stl")
### * stl

flush(stderr()); flush(stdout())

### Name: stl
### Title: Seasonal Decomposition of Time Series by Loess
### Aliases: stl
### Keywords: ts

### ** Examples

require(graphics)

plot(stl(nottem, "per"))
plot(stl(nottem, s.window = 7, t.window = 50, t.jump = 1))

plot(stllc <- stl(log(co2), s.window = 21))
summary(stllc)
## linear trend, strict period.
plot(stl(log(co2), s.window = "per", t.window = 1000))

## Two STL plotted side by side :
        stmd <- stl(mdeaths, s.window = "per") # non-robust
summary(stmR <- stl(mdeaths, s.window = "per", robust = TRUE))
op <- par(mar = c(0, 4, 0, 3), oma = c(5, 0, 4, 0), mfcol = c(4, 2))
plot(stmd, set.pars = NULL, labels  =  NULL,
     main = "stl(mdeaths, s.w = \"per\",  robust = FALSE / TRUE )")
plot(stmR, set.pars = NULL)
# mark the 'outliers' :
(iO <- which(stmR $ weights  < 1e-8)) # 10 were considered outliers
sts <- stmR$time.series
points(time(sts)[iO], 0.8* sts[,"remainder"][iO], pch = 4, col = "red")
par(op)   # reset



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("summary.aov")
### * summary.aov

flush(stderr()); flush(stdout())

### Name: summary.aov
### Title: Summarize an Analysis of Variance Model
### Aliases: summary.aov summary.aovlist print.summary.aov
###   print.summary.aovlist
### Keywords: models regression

### ** Examples

## For a simple example see example(aov)

# Cochran and Cox (1957, p.164)
# 3x3 factorial with ordered factors, each is average of 12.
CC <- data.frame(
    y = c(449, 413, 326, 409, 358, 291, 341, 278, 312)/12,
    P = ordered(gl(3, 3)), N = ordered(gl(3, 1, 9))
)
CC.aov <- aov(y ~ N * P, data = CC , weights = rep(12, 9))
summary(CC.aov)

# Split both main effects into linear and quadratic parts.
summary(CC.aov, split = list(N = list(L = 1, Q = 2),
                             P = list(L = 1, Q = 2)))

# Split only the interaction
summary(CC.aov, split = list("N:P" = list(L.L = 1, Q = 2:4)))

# split on just one var
summary(CC.aov, split = list(P = list(lin = 1, quad = 2)))
summary(CC.aov, split = list(P = list(lin = 1, quad = 2)),
        expand.split = FALSE)


cleanEx()
nameEx("summary.glm")
### * summary.glm

flush(stderr()); flush(stdout())

### Name: summary.glm
### Title: Summarizing Generalized Linear Model Fits
### Aliases: summary.glm print.summary.glm
### Keywords: models regression

### ** Examples

## For examples see example(glm)



cleanEx()
nameEx("summary.lm")
### * summary.lm

flush(stderr()); flush(stdout())

### Name: summary.lm
### Title: Summarizing Linear Model Fits
### Aliases: summary.lm summary.mlm print.summary.lm
### Keywords: regression models

### ** Examples

## Don't show: 
utils::example("lm", echo = FALSE)
## End(Don't show)
##-- Continuing the  lm(.) example:
coef(lm.D90)  # the bare coefficients
sld90 <- summary(lm.D90 <- lm(weight ~ group -1))  # omitting intercept
sld90
coef(sld90)  # much more

## model with *aliased* coefficient:
lm.D9. <- lm(weight ~ group + I(group != "Ctl"))
Sm.D9. <- summary(lm.D9.)
Sm.D9. #  shows the NA NA NA NA  line
stopifnot(length(cc <- coef(lm.D9.)) == 3, is.na(cc[3]),
          dim(coef(Sm.D9.)) == c(2,4), Sm.D9.$df == c(2, 18, 3))



cleanEx()
nameEx("summary.manova")
### * summary.manova

flush(stderr()); flush(stdout())

### Name: summary.manova
### Title: Summary Method for Multivariate Analysis of Variance
### Aliases: summary.manova print.summary.manova
### Keywords: models

### ** Examples


cleanEx()
nameEx("summary.princomp")
### * summary.princomp

flush(stderr()); flush(stdout())

### Name: summary.princomp
### Title: Summary method for Principal Components Analysis
### Aliases: summary.princomp print.summary.princomp
### Keywords: multivariate

### ** Examples

summary(pc.cr <- princomp(USArrests, cor = TRUE))
## The signs of the loading columns are arbitrary
print(summary(princomp(USArrests, cor = TRUE),
              loadings = TRUE, cutoff = 0.2), digits = 2)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("supsmu")
### * supsmu

flush(stderr()); flush(stdout())

### Name: supsmu
### Title: Friedman's SuperSmoother
### Aliases: supsmu
### Keywords: smooth

### ** Examples

require(graphics)

with(cars, {
    plot(speed, dist)
    lines(supsmu(speed, dist))
    lines(supsmu(speed, dist, bass = 7), lty = 2)
    })



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("symnum")
### * symnum

flush(stderr()); flush(stdout())

### Name: symnum
### Title: Symbolic Number Coding
### Aliases: symnum
### Keywords: utilities character

### ** Examples

ii <- setNames(0:8, 0:8)
symnum(ii, cut =  2*(0:4), sym = c(".", "-", "+", "$"))
symnum(ii, cut =  2*(0:4), sym = c(".", "-", "+", "$"), show.max = TRUE)

symnum(1:12 %% 3 == 0)  # --> "|" = TRUE, "." = FALSE  for logical

## Pascal's Triangle modulo 2 -- odd and even numbers:
N <- 38
pascal <- t(sapply(0:N, function(n) round(choose(n, 0:N - (N-n)%/%2))))
rownames(pascal) <- rep("", 1+N) # <-- to improve "graphic"
symnum(pascal %% 2, symbols = c(" ", "A"), numeric = FALSE)

##-- Symbolic correlation matrices:
symnum(cor(attitude), diag = FALSE)
symnum(cor(attitude), abbr. = NULL)
symnum(cor(attitude), abbr. = FALSE)
symnum(cor(attitude), abbr. = 2)

symnum(cor(rbind(1, rnorm(25), rnorm(25)^2)))
symnum(cor(matrix(rexp(30, 1), 5, 18))) # <<-- PATTERN ! --
symnum(cm1 <- cor(matrix(rnorm(90) ,  5, 18))) # < White Noise SMALL n
symnum(cm1, diag = FALSE)
symnum(cm2 <- cor(matrix(rnorm(900), 50, 18))) # < White Noise "BIG" n
symnum(cm2, lower = FALSE)

## NA's:
Cm <- cor(matrix(rnorm(60),  10, 6)); Cm[c(3,6), 2] <- NA
symnum(Cm, show.max = NULL)

## Graphical P-values (aka "significance stars"):
pval <- rev(sort(c(outer(1:6, 10^-(1:3)))))
symp <- symnum(pval, corr = FALSE,
               cutpoints = c(0,  .001,.01,.05, .1, 1),
               symbols = c("***","**","*","."," "))
noquote(cbind(P.val = format(pval), Signif = symp))



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("t.test")
### * t.test

flush(stderr()); flush(stdout())

### Name: t.test
### Title: Student's t-Test
### Aliases: t.test t.test.default t.test.formula
### Keywords: htest

### ** Examples

require(graphics)

t.test(1:10, y = c(7:20))      # P = .00001855
t.test(1:10, y = c(7:20, 200)) # P = .1245    -- NOT significant anymore

## Classical example: Student's sleep data
plot(extra ~ group, data = sleep)
## Traditional interface
with(sleep, t.test(extra[group == 1], extra[group == 2]))
## Formula interface
t.test(extra ~ group, data = sleep)



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("termplot")
### * termplot

flush(stderr()); flush(stdout())

### Name: termplot
### Title: Plot Regression Terms
### Aliases: termplot
### Keywords: hplot regression

### ** Examples

require(graphics)

had.splines <- "package:splines" %in% search()
if(!had.splines) rs <- require(splines)
x <- 1:100
z <- factor(rep(LETTERS[1:4], 25))
y <- rnorm(100, sin(x/10)+as.numeric(z))
model <- glm(y ~ ns(x, 6) + z)

par(mfrow = c(2,2)) ## 2 x 2 plots for same model :
termplot(model, main = paste("termplot( ", deparse(model$call)," ...)"))
termplot(model, rug = TRUE)
termplot(model, partial.resid = TRUE, se = TRUE, main = TRUE)
termplot(model, partial.resid = TRUE, smooth = panel.smooth, span.smth = 1/4)
if(!had.splines && rs) detach("package:splines")



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("terms.object")
### * terms.object

flush(stderr()); flush(stdout())

### Name: terms.object
### Title: Description of Terms Objects
### Aliases: terms.object
### Keywords: models

### ** Examples

## use of specials (as used for gam() in packages mgcv and gam)
(tf <- terms(y ~ x + x:z + s(x), specials = "s"))
## Note that the "factors" attribute has variables as row names
## and term labels as column names, both as character vectors.
attr(tf, "specials")    # index 's' variable(s)
rownames(attr(tf, "factors"))[attr(tf, "specials")$s]

## we can keep the order by
terms(y ~ x + x:z + s(x), specials = "s", keep.order = TRUE)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("time")
### * time

flush(stderr()); flush(stdout())

### Name: time
### Title: Sampling Times of Time Series
### Aliases: time cycle frequency deltat time.default
### Keywords: ts

### ** Examples

require(graphics)

cycle(presidents)
# a simple series plot
plot(as.vector(time(presidents)), as.vector(presidents), type = "l")



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("toeplitz")
### * toeplitz

flush(stderr()); flush(stdout())

### Name: toeplitz
### Title: Form Symmetric Toeplitz Matrix
### Aliases: toeplitz
### Keywords: ts

### ** Examples

x <- 1:5
toeplitz (x)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ts")
### * ts

flush(stderr()); flush(stdout())

### Name: ts
### Title: Time-Series Objects
### Aliases: ts as.ts as.ts.default is.ts Ops.ts cbind.ts is.mts [.ts t.ts
### Keywords: ts

### ** Examples

require(graphics)

ts(1:10, frequency = 4, start = c(1959, 2)) # 2nd Quarter of 1959
print( ts(1:10, frequency = 7, start = c(12, 2)), calendar = TRUE)
# print.ts(.)
## Using July 1954 as start date:
gnp <- ts(cumsum(1 + round(rnorm(100), 2)),
          start = c(1954, 7), frequency = 12)
plot(gnp) # using 'plot.ts' for time-series plot

## Multivariate
z <- ts(matrix(rnorm(300), 100, 3), start = c(1961, 1), frequency = 12)
class(z)
head(z) # as "matrix"
plot(z)
plot(z, plot.type = "single", lty = 1:3)

## A phase plot:
plot(nhtemp, lag(nhtemp, 1), cex = .8, col = "blue",
     main = "Lag plot of New Haven temperatures")



} # [FastR] END Test snippet disabled due to graphics package use
if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("ts.plot")
### * ts.plot

flush(stderr()); flush(stdout())

### Name: ts.plot
### Title: Plot Multiple Time Series
### Aliases: ts.plot
### Keywords: ts

### ** Examples

require(graphics)

ts.plot(ldeaths, mdeaths, fdeaths,
        gpars=list(xlab="year", ylab="deaths", lty=c(1:3)))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("ts.union")
### * ts.union

flush(stderr()); flush(stdout())

### Name: ts.union
### Title: Bind Two or More Time Series
### Aliases: ts.union ts.intersect
### Keywords: ts

### ** Examples

ts.union(mdeaths, fdeaths)
cbind(mdeaths, fdeaths) # same as the previous line
ts.intersect(window(mdeaths, 1976), window(fdeaths, 1974, 1978))

sales1 <- ts.union(BJsales, lead = BJsales.lead)
ts.intersect(sales1, lead3 = lag(BJsales.lead, -3))



cleanEx()
nameEx("tsdiag")
### * tsdiag

flush(stderr()); flush(stdout())

### Name: tsdiag
### Title: Diagnostic Plots for Time-Series Fits
### Aliases: tsdiag tsdiag.arima0 tsdiag.Arima tsdiag.StructTS
### Keywords: ts

### ** Examples



cleanEx()
nameEx("uniroot")
### * uniroot

flush(stderr()); flush(stdout())

### Name: uniroot
### Title: One Dimensional Root (Zero) Finding
### Aliases: uniroot
### Keywords: optimize

### ** Examples

##--- uniroot() with new interval extension + checking features: --------------

f1 <- function(x) (121 - x^2)/(x^2+1)
f2 <- function(x) exp(-x)*(x - 12)

try(uniroot(f1, c(0,10)))
try(uniroot(f2, c(0, 2)))
##--> error: f() .. end points not of opposite sign

## where as  'extendInt="yes"'  simply first enlarges the search interval:
u1 <- uniroot(f1, c(0,10),extendInt="yes", trace=1)
u2 <- uniroot(f2, c(0,2), extendInt="yes", trace=2)
stopifnot(all.equal(u1$root, 11, tolerance = 1e-5),
          all.equal(u2$root, 12, tolerance = 6e-6))

## The *danger* of interval extension:
## No way to find a zero of a positive function, but
## numerically, f(-|M|) becomes zero :
u3 <- uniroot(exp, c(0,2), extendInt="yes", trace=TRUE)

## Nonsense example (must give an error):
tools::assertCondition( uniroot(function(x) 1, 0:1, extendInt="yes"),
                       "error", verbose=TRUE)

## Convergence checking :
sinc <- function(x) ifelse(x == 0, 1, sin(x)/x)
curve(sinc, -6,18); abline(h=0,v=0, lty=3, col=adjustcolor("gray", 0.8))
## Don't show: 
tools::assertWarning(
## End(Don't show)
uniroot(sinc, c(0,5), extendInt="yes", maxiter=4) #-> "just" a warning
## Don't show: 
 , verbose=TRUE)
## End(Don't show)

## now with  check.conv=TRUE, must signal a convergence error :
## Don't show: 
tools::assertError(
## End(Don't show)
uniroot(sinc, c(0,5), extendInt="yes", maxiter=4, check.conv=TRUE)
## Don't show: 
 , verbose=TRUE)
## End(Don't show)

### Weibull cumulative hazard (example origin, Ravi Varadhan):
cumhaz <- function(t, a, b) b * (t/b)^a
froot <- function(x, u, a, b) cumhaz(x, a, b) - u

n <- 1000
u <- -log(runif(n))
a <- 1/2
b <- 1
## Find failure times
ru <- sapply(u, function(x)
   uniroot(froot, u=x, a=a, b=b, interval= c(1.e-14, 1e04),
           extendInt="yes")$root)
ru2 <- sapply(u, function(x)
   uniroot(froot, u=x, a=a, b=b, interval= c(0.01,  10),
           extendInt="yes")$root)
stopifnot(all.equal(ru, ru2, tolerance = 6e-6))

r1 <- uniroot(froot, u= 0.99, a=a, b=b, interval= c(0.01, 10),
             extendInt="up")
stopifnot(all.equal(0.99, cumhaz(r1$root, a=a, b=b)))

## An error if 'extendInt' assumes "wrong zero-crossing direction":
## Don't show: 
tools::assertError(
## End(Don't show)
uniroot(froot, u= 0.99, a=a, b=b, interval= c(0.1, 10), extendInt="down")
## Don't show: 
 , verbose=TRUE)
## End(Don't show)



cleanEx()
nameEx("update")
### * update

flush(stderr()); flush(stdout())

### Name: update
### Title: Update and Re-fit a Model Call
### Aliases: update update.default getCall getCall.default
### Keywords: models

### ** Examples

oldcon <- options(contrasts = c("contr.treatment", "contr.poly"))
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl", "Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
lm.D9
summary(lm.D90 <- update(lm.D9, . ~ . - 1))
options(contrasts = c("contr.helmert", "contr.poly"))
update(lm.D9)
getCall(lm.D90)  # "through the origin"

options(oldcon)



base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
cleanEx()
nameEx("update.formula")
### * update.formula

flush(stderr()); flush(stdout())

### Name: update.formula
### Title: Model Updating
### Aliases: update.formula
### Keywords: models

### ** Examples

update(y ~ x,    ~ . + x2) #> y ~ x + x2
update(y ~ x, log(.) ~ . ) #> log(y) ~ x
update(. ~ u+v, res  ~ . ) #> res ~ u + v



cleanEx()
nameEx("var.test")
### * var.test

flush(stderr()); flush(stdout())

### Name: var.test
### Title: F Test to Compare Two Variances
### Aliases: var.test var.test.default var.test.formula
### Keywords: htest

### ** Examples

x <- rnorm(50, mean = 0, sd = 2)
y <- rnorm(30, mean = 1, sd = 1)
var.test(x, y)                  # Do x and y have the same variance?
var.test(lm(x ~ 1), lm(y ~ 1))  # The same.



cleanEx()
nameEx("varimax")
### * varimax

flush(stderr()); flush(stdout())

### Name: varimax
### Title: Rotation Methods for Factor Analysis
### Aliases: promax varimax
### Keywords: multivariate

### ** Examples

## varimax with normalize = TRUE is the default
fa <- factanal( ~., 2, data = swiss)
varimax(loadings(fa), normalize = FALSE)
promax(loadings(fa))



cleanEx()
nameEx("weighted.mean")
### * weighted.mean

flush(stderr()); flush(stdout())

### Name: weighted.mean
### Title: Weighted Arithmetic Mean
### Aliases: weighted.mean weighted.mean.default
### Keywords: univar

### ** Examples

## GPA from Siegel 1994
wt <- c(5,  5,  4,  1)/15
x <- c(3.7,3.3,3.5,2.8)
xm <- weighted.mean(x, wt)



cleanEx()
nameEx("weighted.residuals")
### * weighted.residuals

flush(stderr()); flush(stdout())

### Name: weighted.residuals
### Title: Compute Weighted Residuals
### Aliases: weighted.residuals
### Keywords: regression

### ** Examples

## following on from example(lm)
## Don't show: 
utils::example("lm", echo = FALSE)
## End(Don't show)
all.equal(weighted.residuals(lm.D9),
          residuals(lm.D9))
x <- 1:10
w <- 0:9
y <- rnorm(x)
weighted.residuals(lmxy <- lm(y ~ x, weights = w))
weighted.residuals(lmxy, drop0 = FALSE)



if(FALSE) { # [FastR] BEGIN Test snippet disabled due to graphics package use
cleanEx()
nameEx("wilcox.test")
### * wilcox.test

flush(stderr()); flush(stdout())

### Name: wilcox.test
### Title: Wilcoxon Rank Sum and Signed Rank Tests
### Aliases: wilcox.test wilcox.test.default wilcox.test.formula
### Keywords: htest

### ** Examples

require(graphics)
## One-sample test.
## Hollander & Wolfe (1973), 29f.
## Hamilton depression scale factor measurements in 9 patients with
##  mixed anxiety and depression, taken at the first (x) and second
##  (y) visit after initiation of a therapy (administration of a
##  tranquilizer).
x <- c(1.83,  0.50,  1.62,  2.48, 1.68, 1.88, 1.55, 3.06, 1.30)
y <- c(0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29)
wilcox.test(x, y, paired = TRUE, alternative = "greater")
wilcox.test(y - x, alternative = "less")    # The same.
wilcox.test(y - x, alternative = "less",
            exact = FALSE, correct = FALSE) # H&W large sample
                                            # approximation

## Two-sample test.
## Hollander & Wolfe (1973), 69f.
## Permeability constants of the human chorioamnion (a placental
##  membrane) at term (x) and between 12 to 26 weeks gestational
##  age (y).  The alternative of interest is greater permeability
##  of the human chorioamnion for the term pregnancy.
x <- c(0.80, 0.83, 1.89, 1.04, 1.45, 1.38, 1.91, 1.64, 0.73, 1.46)
y <- c(1.15, 0.88, 0.90, 0.74, 1.21)
wilcox.test(x, y, alternative = "g")        # greater
wilcox.test(x, y, alternative = "greater",
            exact = FALSE, correct = FALSE) # H&W large sample
                                            # approximation

wilcox.test(rnorm(10), rnorm(10, 2), conf.int = TRUE)

## Formula interface.
boxplot(Ozone ~ Month, data = airquality)
wilcox.test(Ozone ~ Month, data = airquality,
            subset = Month %in% c(5, 8))



} # [FastR] END Test snippet disabled due to graphics package use
cleanEx()
nameEx("window")
### * window

flush(stderr()); flush(stdout())

### Name: window
### Title: Time Windows
### Aliases: window window.default window.ts window<- window<-.ts
### Keywords: ts

### ** Examples

window(presidents, 1960, c(1969,4)) # values in the 1960's
window(presidents, deltat = 1)  # All Qtr1s
window(presidents, start = c(1945,3), deltat = 1)  # All Qtr3s
window(presidents, 1944, c(1979,2), extend = TRUE)

pres <- window(presidents, 1945, c(1949,4)) # values in the 1940's
window(pres, 1945.25, 1945.50) <- c(60, 70)
window(pres, 1944, 1944.75) <- 0 # will generate a warning
window(pres, c(1945,4), c(1949,4), frequency = 1) <- 85:89
pres



cleanEx()
nameEx("xtabs")
### * xtabs

flush(stderr()); flush(stdout())

### Name: xtabs
### Title: Cross Tabulation
### Aliases: xtabs print.xtabs
### Keywords: category

### ** Examples

## 'esoph' has the frequencies of cases and controls for all levels of
## the variables 'agegp', 'alcgp', and 'tobgp'.
xtabs(cbind(ncases, ncontrols) ~ ., data = esoph)
## Output is not really helpful ... flat tables are better:
ftable(xtabs(cbind(ncases, ncontrols) ~ ., data = esoph))
## In particular if we have fewer factors ...
ftable(xtabs(cbind(ncases, ncontrols) ~ agegp, data = esoph))

## This is already a contingency table in array form.
DF <- as.data.frame(UCBAdmissions)
## Now 'DF' is a data frame with a grid of the factors and the counts
## in variable 'Freq'.
DF
## Nice for taking margins ...
xtabs(Freq ~ Gender + Admit, DF)
## And for testing independence ...
summary(xtabs(Freq ~ ., DF))

## with NA's
DN <- DF; DN[cbind(6:9, c(1:2,4,1))] <- NA; DN
tools::assertError(# 'na.fail' should fail :
     xtabs(Freq ~ Gender + Admit, DN, na.action=na.fail))
xtabs(Freq ~ Gender + Admit, DN)
xtabs(Freq ~ Gender + Admit, DN, na.action = na.pass)
## The Female:Rejected combination has NA 'Freq' (and NA prints 'invisibly' as "")
xtabs(Freq ~ Gender + Admit, DN, addNA = TRUE) # ==> count NAs

## Create a nice display for the warp break data.
warpbreaks$replicate <- rep_len(1:9, 54)
ftable(xtabs(breaks ~ wool + tension + replicate, data = warpbreaks))

### ---- Sparse Examples ----




cleanEx()
nameEx("zC")
### * zC

flush(stderr()); flush(stdout())

### Name: C
### Title: Sets Contrasts for a Factor
### Aliases: C
### Keywords: models

### ** Examples

## reset contrasts to defaults
options(contrasts = c("contr.treatment", "contr.poly"))
tens <- with(warpbreaks, C(tension, poly, 1))
## tension SHOULD be an ordered factor, but as it is not we can use
aov(breaks ~ wool + tens + tension, data = warpbreaks)

## show the use of ...  The default contrast is contr.treatment here
summary(lm(breaks ~ wool + C(tension, base = 2), data = warpbreaks))


# following on from help(esoph)
model3 <- glm(cbind(ncases, ncontrols) ~ agegp + C(tobgp, , 1) +
     C(alcgp, , 1), data = esoph, family = binomial())
summary(model3)



base::options(contrasts = c(unordered = "contr.treatment",ordered = "contr.poly"))
### * <FOOTER>
###
options(digits = 7L)
base::cat("Time elapsed: ", proc.time() - base::get("ptime", pos = 'CheckExEnv'),"\n")
#grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
