% Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
% DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
%
% This code is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License version 3 only, as
% published by the Free Software Foundation.
%
% This code is distributed in the hope that it will be useful, but WITHOUT
% ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
% FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
% version 3 for more details (a copy is included in the LICENSE file that
% accompanied this code).
%
% You should have received a copy of the GNU General Public License version
% 3 along with this work; if not, write to the Free Software Foundation,
% Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
%
% Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
% or visit www.oracle.com if you need additional information or have any
% questions.

% Initial version generated by roxygen2
\name{export}
\alias{export}
\title{Explicitly exports a polyglot symbol. Exporting a symbol with a NULL value will remove the
symbol from the polyglot object.
The exported symbol value can either be a polyglot object (e.g. a native
object from another language) to support interoperability between languages,
or a R object.}
\usage{
export(symbolName, value)
}
\arguments{
\item{symbolName}{character string. The name with which the symbol should be exported into the polyglot
scope.}

\item{value}{The value to export for}
}
\description{
Explicitly exports a polyglot symbol. Exporting a symbol with a NULL value will remove the
symbol from the polyglot object.
The exported symbol value can either be a polyglot object (e.g. a native
object from another language) to support interoperability between languages,
or a R object.
}
\examples{
export('foo', 'foo')
export('foo', new.env())
}
\seealso{
\code{\link{import}}
}
