% Copyright (c) 2019, Oracle and/or its affiliates. All rights reserved.
% DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
%
% This code is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License version 3 only, as
% published by the Free Software Foundation.
%
% This code is distributed in the hope that it will be useful, but WITHOUT
% ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
% FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
% version 3 for more details (a copy is included in the LICENSE file that
% accompanied this code).
%
% You should have received a copy of the GNU General Public License version
% 3 along with this work; if not, write to the Free Software Foundation,
% Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
%
% Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
% or visit www.oracle.com if you need additional information or have any
% questions.

% Initial version generated by roxygen2
\name{fastr.useDebugMakevars}
\alias{fastr.useDebugMakevars}
\title{Activates/deactivates a special 'etc/Makevars.site' file facilitating the debugging of native code.}
\usage{
fastr.useDebugMakevars(use)
}
\arguments{
\item{use}{ a boolean value. If TRUE, a special 'Makevars.site' file is created in '$R_HOME/etc'. If FALSE, that file is removed. }
}
\description{
When debugging native code, some compiler optimizations should be disabled for better experience during the debugging.
For example, the function inlining optimization should be disabled so that the user can see the original call hierarchies.
Consult the 'etc/Makevars.site.debug' file for details.
}
\examples{
fastr.useDebugMakevars(TRUE)
}
\seealso{
\code{\link{fastr.setToolchain}}
}
