% Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
% DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
%
% This code is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License version 3 only, as
% published by the Free Software Foundation.
%
% This code is distributed in the hope that it will be useful, but WITHOUT
% ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
% FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
% version 3 for more details (a copy is included in the LICENSE file that
% accompanied this code).
%
% You should have received a copy of the GNU General Public License version
% 3 along with this work; if not, write to the Free Software Foundation,
% Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
%
% Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
% or visit www.oracle.com if you need additional information or have any
% questions.

% Initial version generated by roxygen2
\name{java.type}
\alias{java.type}
\title{Access to a java type given by the fully qualified java class name. The class must be available on FastR`s interop classpath.}
\usage{
java.type(className, silent = FALSE)
}
\arguments{
\item{silent}{logical, default FALSE. Determines whether errors should be reported or not.}

\item{class}{a fully qualified java class name}
}
\value{
An polyglot value representing a java type. Otherwise either NULL if silent is set to TRUE, or error in case the class name could not be determined.
}
\description{
Access to a java type given by the fully qualified java class name. The class must be available on FastR`s interop classpath.
}
\examples{
java.type('java.util.ArrayList')
java.type('java.util.ArrayList')$class
new(java.type('java.util.ArrayList'))$getClass()
}
\seealso{
\code{\link{java.addClasspathEntry}}
}
