% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastRCluster.R
\name{fastr}
\alias{fastr}
\title{Runs given code in the FastR engine.}
\usage{
fastr(cl, code)
}
\arguments{
\item{cl}{FastR cluster object. Use \code{\link{makeFastRCluster}()} to get one.}

\item{code}{The code that will be run on the FastR node. It will not be evaluated in the current session.}
}
\value{
The result of evaluating the code
}
\description{
This is a convenient wrapper around \code{clusterApply} that runs
the given code on the first node in the cluster.
}
\examples{
\donttest{
fastrNode <- makeFastRCluster()
fastr(fastrNode, R.version)
parallel::stopCluster(fastrNode)
}
}
