% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastRCluster.R
\name{mockServices}
\alias{mockServices}
\title{Allows to override functions that access external services.}
\usage{
mockServices(newPsockClusterFactory = parallel::makePSOCKcluster,
  newRunSystemCommand = base::system2,
  newDownloadFile = utils::download.file,
  validateGraalVMInstallation = T)
}
\arguments{
\item{newPsockClusterFactory}{Replacement for parallel::makePSOCKcluster.}

\item{newRunSystemCommand}{Replacement for base::sytem2.}

\item{newDownloadFile}{Replacement for utils::download.file.}

\item{validateGraalVMInstallation}{Turns on/off the validation of GraalVM home directory.}
}
\value{
invisible NULL
}
\description{
This is unexported function intended for the purposes of testing this package.
}
\examples{
# to avoid downloading GraalVM when testing the function installFastR
fastRCluster:::mockServices(newDownloadFile = function(file,target)
    file.copy('local/copy/of/graalvm.tar.gz', target))
}
