% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{snapshot.named}
\alias{snapshot.named}
\title{Take a snapshot of provided values and name the values as specified in the arguments.}
\usage{
snapshot.named(...)
}
\description{
This function has two modes, (1) record, and (2) check.
Depending on the result of function 'refcmpEnv$is_reference_run', the mode is (1) if TRUE is returned or (2) otherwise.
}
\details{
When in the first mode 'record', function 'snapshot.named' serializes the values of the specified variables into a file together with the names of the variables. It also increases the ID of the snapshot automatically.

When in the second mode 'check', function 'snapshot.named' deserializes values of a previously taken snapshot and compares the values of the provided variables to the deserialized values by matching names.

I contrast to function 'snapshot', this function does not try to automatically determine the name of a value.
It uses the names as provided in the arguments.
}
\examples{
snapshot.named(a = 10 + 20, b = 30, c = function() print("hello"))
}
