/*
 * Copyright (c) 2016, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 3 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.truffle.r.runtime.nodes;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.r.runtime.RDeparse;

/**
 * This is the base interface for all nodes in the tree of elements that make up an R closure.
 * Implementations of this interface do not necessarily need to be Truffle nodes, and some Truffle
 * nodes synthesize RSyntaxElements in order to simulate the R-level structure of code. (e.g., an
 * "if" node may return a synthetic lookup of "if" as the call's left hand side)
 */
public interface RSyntaxElement {

    SourceSection getSourceSection();

    /**
     * This is a special version of {@link #getSourceSection} that does not try to
     * {@link RDeparse#ensureSourceSection(RSyntaxNode) deparse} {@link SourceSection}s that are
     * {@link RSyntaxNode#INTERNAL internal}.
     */
    SourceSection getLazySourceSection();

    void setSourceSection(SourceSection source);

    default DynamicObject getAttributes() {
        return null;
    }
}
