/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright (c) 2014, Purdue University
 * Copyright (c) 2014, 2018, Oracle and/or its affiliates
 *
 * All rights reserved.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

// Checkstyle: stop line length check
public class TestBuiltin_Arg extends TestBase {

    @Test
    public void testArg1() {
        assertEval("argv <- list(1+2i);Arg(argv[[1]]);");
    }

    @Test
    public void testArg2() {
        assertEval("argv <- list(c(1554.86976865791+337.57296578684i, 1953.0195914094+434.16395869265i, 2020.8001333202+267.40279521531i, 12019.4947666225+397.6223289386i, 40989.2104557418+1079.1450107273i, 59779.5384921205+1460.5074297272i, 40703.4141691824+1049.8100128697i, 12234.4562968499+469.0052365648i, 2311.58538965355+142.56529231224i, 2158.93441543181+94.80017111005i, 2768.79882180339+256.05759156168i, 3234.20673958634+282.64174433659i, 2796.76248579155+64.23534085425i, 2030.22757739534-164.56566766766i, 1522.09271008314-273.51503749101i, 1109.23177636373-215.24298332377i, 714.154122222449-75.284630456206i, 509.684427096512-24.577531288476i, 628.214718823948+42.431050163574i, 1053.2295477549+190.4802567974i, 1388.73708931304+133.04405268816i, 1213.97041311196-135.67196064028i, 790.469479873384-232.737914916798i, 503.424076694357-99.275737105817i, 430.214847703846+45.250156289826i, 640.795334515383+121.961327286573i, 794.927869993865+100.643091831764i, 554.394621183915-15.753680159958i, 286.476583987294-104.634488576316i, 232.82067569803-92.469328935268i, 229.472155078088-54.85406188579i, 253.438957119958-65.123390974834i, 285.141954428461-79.653095359009i, 257.168942241366-34.332533775171i, 214.215071612655+18.001149572355i, 199.882436088191+0i));Arg(argv[[1]]);");
    }

    @Test
    public void testArg3() {
        assertEval("argv <- list(c(-12.561836573133-726.935211685406i, -19.15961591777-1315.40822424617i, -666.84872452586-2013.90899841237i, -5775.9038598237-11495.8986046958i, -19052.0606820086-36788.5714510618i, -27954.209922899-52600.8398855356i, -19930.6456597181-35739.3494902644i, -7168.9170917163-10787.9325286278i, -2331.00733468417-1545.77448035635i, -1953.77845230855-212.90200115993i, -1953.60071030304+1420.43983282655i, -1700.4015174326+2765.31423009739i, -862.10275212019+2693.95914108523i, 163.24691179114+1837.1971341258i, 824.29498680332+1155.03126302727i, 939.495937605926+679.549172893055i, 686.101881005818+305.166761591578i, 460.339323160381-14.067413050801i, 533.688543397269-293.997358985575i, 773.041200043657-698.096300485637i, 716.84959340189-1127.39175172066i, 226.23728166311-1110.40349894929i, -203.687633095422-740.924670781257i, -271.865544904439-437.858153233594i, -316.769706633022-279.671035520361i, -624.842102639273-228.211019456587i, -806.31350008813-164.912647906911i, -506.559675826232+24.376187336594i, -142.784303570554+217.087547410547i, -44.704338624059+260.225831716256i, 10.565037460572+219.942519605707i, 143.643627814428+218.823069474359i, 232.58540850813+214.905815487636i, 223.286482103748+175.139821578561i, 185.008902762186+116.519845434485i, 171.150234739785-0i));Arg(argv[[1]]);");
    }

    @Test
    public void testArg4() {
        assertEval("argv <- list(logical(0));Arg(argv[[1]]);");
    }

    @Test
    public void testArg5() {
        assertEval("argv <- list(structure(numeric(0), .Dim = c(0L, 0L)));Arg(argv[[1]]);");
    }

    @Test
    public void testArg6() {
        assertEval("argv <- list(FALSE);Arg(argv[[1]]);");
    }

    @Test
    public void testArg8() {
        assertEval("argv <- list(-1);do.call('Arg', argv)");
    }
}
