/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright (c) 2014, Purdue University
 * Copyright (c) 2014, 2018, Oracle and/or its affiliates
 *
 * All rights reserved.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

// Checkstyle: stop line length check
public class TestBuiltin_dput extends TestBase {

    @Test
    public void testdput1() {
        assertEval("argv <- list(logical(0), structure(1L, class = c('terminal', 'connection')), 69); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput2() {
        assertEval("argv <- list(structure(1, .Dim = 1L), structure(1L, class = c('terminal', 'connection')), 95); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput3() {
        assertEval("argv <- list(character(0), structure(1L, class = c('terminal', 'connection')), 69); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput4() {
        assertEval("argv <- list(structure(numeric(0), .Dim = c(0L, 0L)), structure(1L, class = c('terminal', 'connection')), 69); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput5() {
        assertEval("argv <- list(NULL, structure(1L, class = c('terminal', 'connection')), 69); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput6() {
        assertEval("argv <- list(structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = structure('integer(0)', .Names = 'c0')), structure(1L, class = c('terminal', 'connection')), 69); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput7() {
        assertEval("argv <- list(FALSE, structure(1L, class = c('terminal', 'connection')), 69); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput8() {
        assertEval("argv <- list(c(0.00508571428571428, 0.876285714285715), structure(1L, class = c('terminal', 'connection')), 69); .Internal(dput(argv[[1]], argv[[2]], argv[[3]]))");
    }

    @Test
    public void testdput() {
        assertEval("x <- structure(list(A = c(1L, 1L), B = structure(c(1L, 1L), .Label = c('G', 'D'), class = 'factor'), C = structure(c(1L, 1L), .Label = c('G', 'D'), class = 'factor')), .Names = c('A', 'B', 'C'), row.names = 1:2, class = 'data.frame'); dput(x)");
    }
}
