/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 3 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

public class TestBuiltin_postoenv extends TestBase {
    @Test
    public void testPosToEnv() {
        assertEval("list(pos.to.env(1), attr(pos.to.env(2), 'name'))");
        assertEval("{ foo <- function(x) pos.to.env(x); list(foo(1), attr(foo(2), 'name')); }");
        assertEval("{ foo <- function(x) pos.to.env(x); bar <- function(barvar) foo(barvar); ls(bar(-1)); }");
    }

    @Test
    public void testPosToEnvValidation() {
        assertEval("pos.to.env(0)");
        assertEval("pos.to.env(1000)");
        assertEval("pos.to.env(-3)");
        assertEval("pos.to.env('hello')");
        assertEval("pos.to.env(-1)");
    }
}
