/*
 * Copyright (c) 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.graal.compiler.core.test;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.junit.Test;

// Regression test for JDK-8220643 (GR-14583)
public class SwitchTest extends GraalCompilerTest {
    public static boolean test1(int arg) {
        switch (arg) {
            case -2139290527:
            case -1466249004:
            case -1063407861:
            case 125135499:
            case 425995464:
            case 786490581:
            case 1180611932:
            case 1790655921:
            case 1970660086:
                return true;
            default:
                return false;
        }
    }

    @Test
    public void run1() throws Throwable {
        ResolvedJavaMethod method = getResolvedJavaMethod("test1");
        Result compiled = executeActual(method, null, -2139290527);
        assertEquals(new Result(true, null), compiled);
    }
}
