---
layout: docs
toc_group: native-image
link_title: Workshops and Labs
permalink: /reference-manual/native-image/workshops/
---

# Interactive Labs and Workshops

## Interactive Labs

Consider running interactive workshops in Oracle Cloud Infrastructure to get some practical experience. 
The interactive cloud platform provides you with a temporary account for the time you run a lab with required cloud resources (a virtual machine, Oracle Linux, storage, and so on).
This means you can try Native Image without downloading any additional software to your computer.

Go to [Luna Labs](https://luna.oracle.com/) and search for "Native Image". 
The following labs are available:

- [GraalVM Native Image Quick Start](https://luna.oracle.com/lab/47dafec8-4095-4fba-8313-dad43a64dee4): This lab is for developers new to Native Image who are keen to start building cloud native Java applications.
- [GraalVM, Reflection and Native Image](https://luna.oracle.com/lab/5fde71fb-8044-4c82-aa1c-3f2e5771caed): This lab shows how to preconfigure the `native-image` builder when reflection is used, and make your Java application compatible with ahead-of-time compilation using Native Image.
- [GraalVM Native Image, Spring and Containerisation](https://luna.oracle.com/lab/fdfd090d-e52c-4481-a8de-dccecdca7d68): This lab shows you how to package a Spring Boot application into a native executable; containerise it; shrink the footprint even more by creating small a Distroless container Image.
- [Optimize Cloud Native Java Apps with Oracle GraalVM PGO](https://luna.oracle.com/lab/3f0b7c86-6105-4b7a-9a3b-eb73b251a1aa): This lab shows how to run a Java Microbenchmark Harness (JMH) benchmark as a native executable, built with GraalVM Native Image, and then optimize it for higher throughput using Profile-Guided Optimization (PGO).
- [OCI MySQL, Vault, Micronaut, GraalVM Native Image](https://luna.oracle.com/lab/a78388fd-c15f-48b4-96aa-5e4716ae236c): In this lab, you will learn how to build a portable cloud-native Java application with Micronaut, GraalVM Native Image and MySQL Database service, and Secrets in Vault on Oracle Cloud Infrastructure.
- [GraalVM Native Build Tools, for Maven](https://luna.oracle.com/lab/e5af592b-3365-45ce-b964-6fd409e5c76f): This lab shows you how to use the GraalVM Native Build Tools to easily build a native executable of your application using Maven. It is aimed at developers with the knowledge of Java.
- [Build Cloud Native Java Applications with Micronaut and GraalVM Native Image](https://luna.oracle.com/lab/e329af0f-504e-4eb0-8804-2dd6b10076c9): The workshop features several labs that walk you through the steps to get going with Micronaut, GraalVM, and Oracle Cloud Infrastructure services.
- [GraalVM Native Image Bootcamp](https://luna.oracle.com/lab/d642bb4a-0340-4dab-a4cf-c5ef35795884): This workshop covers how GraalVM Native Image works, what it can do, when to use it, and how to tune and debug applications. You will also look at containerisation options and deployment to cloud platforms including Oracle Cloud Infrastructure.

## Workshops

Have a look at [GraalVM Workshops and Tutorials collection on GitHub](https://github.com/graalvm/workshops). There you can find the workshops intended to work on your own device (laptop, server). Each workshop begins with prerequisites that you need to have installed. 

This repository is continually updated with new workshops. Check-in regularly to keep up to date.
