---
layout: docs
toc_group: reference-manual
link_title: Reference Manuals
permalink: /reference-manual/
redirect_from: /docs/reference-manual/
---

# Reference Manuals

Here you will find the in-depth documentation for technologies offered by GraalVM.
These manuals are aimed at software engineers and developers who already work with GraalVM, or are considering it as an environment for their workloads.

* Learn more about [GraalVM as a Java Virtual Machine](java/README.md) and its optimizing just-in-time compiler, [Graal Compiler](java/compiler.md).
* Developers interested in embedding other languages into Java, proceed to [Embedding Languages](embedding/embed-languages.md).
* Developers interested in building interpreters for programming languages which then run on GraalVM, continue to the [Truffle language implementation framework documentation](../../truffle/docs/README.md).
* To learn more about security considerations in GraalVM, check the [Security Guide](../security/security-guide.md).

If you are mostly interested in a specific language runtime on GraalVM, see the following:
* [Espresso](java-on-truffle/README.md)
* [GraalJS](https://github.com/oracle/graaljs/blob/master/docs/user/README.md)
* [GraalPy](https://www.graalvm.org/python/docs/)
* [GraalWasm](https://www.graalvm.org/webassembly/docs/)
* [LLVM Languages](llvm/README.md)
* [TruffleRuby](https://github.com/oracle/truffleruby/blob/master/doc/user/README.md)