/*
 * Copyright (c) 2021, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.graalvm.nativebridge.processor.test.common;

import org.graalvm.nativebridge.ForeignObject;
import org.graalvm.nativebridge.GenerateHotSpotToNativeBridge;
import org.graalvm.nativebridge.GenerateHotSpotToNativeFactory;
import org.graalvm.nativebridge.GenerateNativeToHotSpotBridge;
import org.graalvm.nativebridge.GenerateNativeToNativeBridge;
import org.graalvm.nativebridge.GenerateNativeToNativeFactory;
import org.graalvm.nativebridge.GenerateProcessToProcessBridge;
import org.graalvm.nativebridge.GenerateProcessToProcessFactory;
import org.graalvm.nativebridge.processor.test.ExpectError;
import org.graalvm.nativebridge.processor.test.LocalService;
import org.graalvm.nativebridge.processor.test.Service;

@ExpectError("Marshallers config must have a non-private static `getInstance()` method returning `MarshallerConfig`.%n" +
                "The `getInstance` method is used by the generated a code to look up marshallers.%n" +
                "To fix this add `static MarshallerConfig getInstance() { return INSTANCE;}` into `MarshallerConfigProvider`.")
@GenerateHotSpotToNativeFactory(marshallers = InvalidMarshallerConfig1Test.MarshallerConfigProvider.class, initialService = InvalidMarshallerConfig1Service.class)
@GenerateNativeToNativeFactory(marshallers = InvalidMarshallerConfig1Test.MarshallerConfigProvider.class, initialService = InvalidMarshallerConfig1Service.class)
@GenerateProcessToProcessFactory(marshallers = InvalidMarshallerConfig1Test.MarshallerConfigProvider.class, initialService = InvalidMarshallerConfig1Service.class, services = {
                InvalidMarshallerConfig1Service.class
})
abstract class InvalidMarshallerConfig1Test implements Service, ForeignObject {

    static final class MarshallerConfigProvider {
    }
}

@GenerateHotSpotToNativeBridge(factory = InvalidMarshallerConfig1Test.class, implementation = LocalService.class)
@GenerateNativeToNativeBridge(factory = InvalidMarshallerConfig1Test.class, implementation = LocalService.class)
@GenerateNativeToHotSpotBridge(factory = InvalidMarshallerConfig1Test.class)
@GenerateProcessToProcessBridge(factory = InvalidMarshallerConfig1Test.class, implementation = LocalService.class)
abstract class InvalidMarshallerConfig1Service implements ForeignObject, Service {

}
