/*
 * Copyright (c) 2019, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

#include <string.h>
#include <Foundation/Foundation.h>

void operatingSystemVersion(NSOperatingSystemVersion* osv) {
    *osv = [[NSProcessInfo processInfo] operatingSystemVersion];
}

static char *systemVersionPlatformImpl(NSString *path) {
   NSString *nsVerStr = NULL;
   NSDictionary *version = [NSDictionary dictionaryWithContentsOfFile : path];

   if (version != NULL) {
       nsVerStr = [version objectForKey : @"ProductVersion"];
       return strdup([nsVerStr UTF8String]);
   }
   return NULL;
}

char *systemVersionPlatform(void) {
    return systemVersionPlatformImpl(@"/System/Library/CoreServices/.SystemVersionPlatform.plist");
}

char *systemVersionPlatformFallback(void) {
    return systemVersionPlatformImpl(@"/System/Library/CoreServices/SystemVersion.plist");
}

// Adapted from JLI's java_md_macosx.c

static void dummyTimer(CFRunLoopTimerRef timer, void *info) {}

void parkRunLoop() {
    // RunLoop needs at least one source, and 1e20 is pretty far into the future
    CFRunLoopTimerRef t = CFRunLoopTimerCreate(kCFAllocatorDefault, 1.0e20, 0.0, 0, 0, dummyTimer, NULL);
    CFRunLoopAddTimer(CFRunLoopGetCurrent(), t, kCFRunLoopDefaultMode);
    CFRelease(t);

    // Park this thread in the main run loop.
    CFRunLoopRun();
}

void terminateRunLoop() {
    CFRunLoopStop(CFRunLoopGetMain());
}
